/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.db.rdf.syntax.generic;

import edu.stanford.db.rdf.syntax.generic.DumpConsumer;
import edu.stanford.db.xml.util.ErrorStore;
import edu.stanford.db.xml.util.GenericParser;
import edu.stanford.db.xml.util.QName;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Enumeration;
import org.w3c.rdf.model.Literal;
import org.w3c.rdf.model.ModelException;
import org.w3c.rdf.model.NodeFactory;
import org.w3c.rdf.model.RDFNode;
import org.w3c.rdf.model.Resource;
import org.w3c.rdf.model.Statement;
import org.w3c.rdf.syntax.RDFConsumer;
import org.w3c.rdf.syntax.RDFParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * Exception performing whole class analysis ignored.
 */
public class GenericXML2RDF
extends GenericParser
implements RDFParser {
    public static final String REVISION = "Generic RDF/XML parser v0.3 2000-10-31";
    protected NodeFactory nodeFactory;
    protected RDFConsumer consumer;

    public GenericXML2RDF() {
    }

    public GenericXML2RDF(boolean bl) {
        super(bl);
    }

    protected static void _main(String string, RDFParser rDFParser) throws IOException, MalformedURLException {
        InputSource inputSource = GenericParser.getInputSource((String)string);
        DumpConsumer dumpConsumer = new DumpConsumer();
        ErrorStore errorStore = new ErrorStore();
        rDFParser.setErrorHandler((ErrorHandler)errorStore);
        try {
            rDFParser.parse(inputSource, (RDFConsumer)dumpConsumer);
        }
        catch (SAXException sAXException) {
            System.err.println("Error during parsing: " + sAXException.getMessage());
            Exception exception = sAXException.getException() != null ? sAXException.getException() : sAXException;
            exception.printStackTrace(System.err);
        }
        String string2 = errorStore.errors();
        if (string2 != null && string2.length() > 0) {
            System.err.println("Errors during parsing:\n" + string2);
        }
    }

    protected Literal createLiteral(String string) throws ModelException {
        return this.nodeFactory.createLiteral(GenericParser.create((String)string));
    }

    protected Literal createLiteral(String string, boolean bl) throws ModelException {
        return this.nodeFactory.createLiteral(GenericParser.create((String)string));
    }

    protected Resource createResource(QName qName) throws ModelException {
        return this.createResource(qName.getNamespace(), qName.getLocalName());
    }

    protected Resource createResource(String string) throws ModelException {
        Enumeration enumeration = this.getNamespaces();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string.startsWith(string2)) continue;
            return this.createResource(string2, string.substring(string2.length()));
        }
        return this.nodeFactory.createResource(GenericParser.create((String)string));
    }

    protected Resource createResource(String string, String string2) throws ModelException {
        Resource resource = this.nodeFactory.createResource(GenericParser.create((String)string), GenericParser.create((String)string2));
        return resource;
    }

    protected Statement createStatement(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        Statement statement = this.nodeFactory.createStatement(resource, resource2, rDFNode);
        this.consumer.addStatement(statement);
        return statement;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.err.println("Usage: java [-Dorg.xml.sax.parser=<classname>] GenericXML2RDF [ URI | filename ]");
            System.err.println("This is revision Generic RDF/XML parser v0.3 2000-10-31");
            System.exit(1);
        }
        GenericXML2RDF genericXML2RDF = new GenericXML2RDF();
        GenericXML2RDF._main((String)stringArray[0], (RDFParser)genericXML2RDF);
        Enumeration enumeration = genericXML2RDF.getNamespaces();
        while (enumeration.hasMoreElements()) {
            System.out.println("Namespaces used: " + enumeration.nextElement());
        }
    }

    public void parse(InputSource inputSource, RDFConsumer rDFConsumer) throws SAXException {
        this.source = inputSource;
        this.consumer = rDFConsumer;
        try {
            this.nodeFactory = rDFConsumer.getNodeFactory();
            rDFConsumer.startModel();
            XMLReader xMLReader = this.createXMLReader();
            xMLReader.setEntityResolver((EntityResolver)this);
            xMLReader.setContentHandler((ContentHandler)this);
            xMLReader.setErrorHandler(this.errorHandler != null ? this.errorHandler : this);
            xMLReader.parse(inputSource);
            rDFConsumer.endModel();
        }
        catch (Exception exception) {
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            throw new SAXException("Fatal error", exception);
        }
    }
}

