/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.db.rdf.model.i;

import edu.stanford.db.rdf.model.i.FindIndex;
import edu.stanford.db.rdf.model.i.Registry;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.w3c.rdf.digest.Digest;
import org.w3c.rdf.digest.DigestException;
import org.w3c.rdf.digest.Digestable;
import org.w3c.rdf.digest.RDFDigestUtil;
import org.w3c.rdf.model.Model;
import org.w3c.rdf.model.ModelException;
import org.w3c.rdf.model.NodeFactory;
import org.w3c.rdf.model.RDFNode;
import org.w3c.rdf.model.Resource;
import org.w3c.rdf.model.Statement;

public class ModelImpl
implements Model,
Digestable,
Digest {
    static NodeFactory DEFAULT_NODE_FACTORY = new Registry();
    NodeFactory nodeFactory = DEFAULT_NODE_FACTORY;
    boolean shared = false;
    byte[] digest;
    ModelImpl myClone = null;
    String uri;
    Hashtable triples;
    private FindIndex _findIndex;
    public static final int SPO_INDEX = 1;
    public static final int OP_INDEX = 2;
    public static final int P_INDEX = 4;
    public static final int ALL_INDEX = 7;

    public ModelImpl() {
        this.triples = new Hashtable();
        this._findIndex = new FindIndex(this.nodeFactory, 7);
    }

    protected ModelImpl(String string, Hashtable hashtable, FindIndex findIndex, boolean bl) {
        this.uri = string;
        this.triples = hashtable;
        this.shared = bl;
        this._findIndex = findIndex;
    }

    public ModelImpl(NodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
        this.triples = new Hashtable();
        this._findIndex = new FindIndex(this.nodeFactory, 7);
    }

    public void add(Resource resource, Resource resource2, String string) throws ModelException {
        this.add(this.nodeFactory.createStatement(resource, resource2, this.nodeFactory.createLiteral(string)));
    }

    public void add(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        this.add(this.nodeFactory.createStatement(resource, resource2, rDFNode));
    }

    public void add(Statement statement) throws ModelException {
        this.makePrivate();
        this.triples.put(statement, statement);
        if (this.validLookup()) {
            this._findIndex.addLookup(statement);
        }
        this.updateDigest(statement);
    }

    public Object clone() {
        return this.duplicate();
    }

    public boolean contains(Statement statement) {
        return this.triples.containsKey(statement);
    }

    public Model create() {
        return new ModelImpl();
    }

    public Model duplicate() {
        if (this.myClone == null || !this.myClone.shared) {
            this.myClone = new ModelImpl(this.uri, this.triples, this._findIndex, true);
            return this.myClone;
        }
        return this.myClone.duplicate();
    }

    public Enumeration elements() {
        return this.triples.elements();
    }

    public Model find(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        ModelImpl modelImpl = new ModelImpl();
        if (this.triples.size() == 0) {
            return modelImpl;
        }
        if (resource == null && resource2 == null && rDFNode == null) {
            return this.duplicate();
        }
        boolean bl = this.validLookup() ^ true;
        Iterator iterator = bl ? this.triples.values().iterator() : this._findIndex.multiget(resource, resource2, rDFNode);
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            if (bl) {
                this._findIndex.addLookup(statement);
            }
            if (!this.matchStatement(statement, resource, resource2, rDFNode)) continue;
            modelImpl.add(statement);
        }
        return modelImpl;
    }

    public Digest getDigest() {
        return this;
    }

    public String getDigestAlgorithm() {
        return RDFDigestUtil.getDigestAlgorithm();
    }

    public byte[] getDigestBytes() throws DigestException {
        try {
            if (this.digest == null) {
                this.digest = RDFDigestUtil.computeModelDigest((Model)this).getDigestBytes();
            }
            byte[] byArray = new byte[this.digest.length];
            System.arraycopy(this.digest, 0, byArray, 0, this.digest.length);
            return byArray;
        }
        catch (ModelException modelException) {
            throw new DigestException(modelException.toString());
        }
    }

    public String getLabel() throws ModelException {
        return this.getURI();
    }

    public String getLocalName() throws ModelException {
        return this.getURI();
    }

    public String getNamespace() {
        return null;
    }

    public NodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public String getSourceURI() {
        return this.uri;
    }

    public String getURI() throws ModelException {
        if (this.isEmpty()) {
            return this.nodeFactory.createUniqueResource().toString();
        }
        try {
            return RDFDigestUtil.modelDigestToURI(this.getDigest());
        }
        catch (DigestException digestException) {
            throw new ModelException("Could not obtain model digest: " + digestException);
        }
    }

    public boolean isEmpty() {
        return this.triples.isEmpty();
    }

    public boolean isMutable() {
        return true;
    }

    void makePrivate() {
        if (this.myClone != null && this.myClone.shared) {
            this.myClone.makePrivate();
            this.myClone = null;
        }
        if (this.shared) {
            this.triples = (Hashtable)this.triples.clone();
            this._findIndex = new FindIndex(this.nodeFactory, this._findIndex.getUsedIndexes());
            this.shared = false;
        }
    }

    boolean matchStatement(Statement statement, Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        if (resource != null && !statement.subject().equals(resource)) {
            return false;
        }
        if (resource2 != null && !statement.predicate().equals(resource2)) {
            return false;
        }
        return rDFNode == null || statement.object().equals(rDFNode);
    }

    public void remove(Statement statement) throws ModelException {
        this.makePrivate();
        this.triples.remove(statement);
        if (this.validLookup()) {
            this._findIndex.removeLookup(statement);
        }
        this.updateDigest(statement);
    }

    public void setSourceURI(String string) {
        this.uri = string;
    }

    public int size() {
        return this.triples.size();
    }

    public String toString() {
        return "Model[" + this.getSourceURI() + " of size " + this.size() + "]";
    }

    void updateDigest(Statement statement) throws ModelException {
        this.digest = null;
    }

    boolean validLookup() {
        return this._findIndex.size() > 0;
    }
}

