/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.db.rdf.model.i;

import edu.stanford.db.rdf.model.i.FindIndex;
import edu.stanford.db.rdf.model.i.ResourceImpl;
import edu.stanford.db.rdf.model.i.StatementImpl;
import edu.stanford.db.xml.util.QName;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.w3c.rdf.model.ModelException;
import org.w3c.rdf.model.NodeFactory;
import org.w3c.rdf.model.RDFNode;
import org.w3c.rdf.model.Resource;
import org.w3c.rdf.model.Statement;

public class FindIndex {
    protected boolean DEBUG = false;
    Comparator spoComparator = new SPOComparator(this);
    Comparator opComparator = new OPComparator(this);
    Comparator pComparator = new PComparator(this);
    ResourceImpl MAX_RES;
    TreeMap spoIdx;
    TreeMap pIdx;
    TreeMap opIdx;
    int useIdx;

    public FindIndex(NodeFactory nodeFactory, int n) {
        this.useIdx = n;
        this.MAX_RES = new ResourceImpl();
        this.MAX_RES.qname = new QName("<MAX>", null);
        if ((n & 1) != 0) {
            this.spoIdx = new TreeMap(new SPOComparator(this));
        }
        if ((n & 4) != 0) {
            this.pIdx = new TreeMap(new PComparator(this));
        }
        if ((n & 2) != 0) {
            this.opIdx = new TreeMap(new OPComparator(this));
        }
    }

    public void addLookup(Statement statement) {
        this.put((Map)this.spoIdx, statement);
        this.put((Map)this.opIdx, statement);
        this.put((Map)this.pIdx, statement);
    }

    int compareNodes(RDFNode rDFNode, RDFNode rDFNode2) {
        int n;
        if (rDFNode == null || rDFNode2 == this.MAX_RES) {
            return -1;
        }
        if (rDFNode2 == null || rDFNode == this.MAX_RES) {
            return 1;
        }
        int n2 = rDFNode.hashCode();
        if (n2 < (n = rDFNode2.hashCode())) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return 0;
    }

    Iterator get(SortedMap sortedMap, Statement statement) throws ModelException {
        return new PrefixIterator(this, statement, sortedMap);
    }

    public int getUsedIndexes() {
        return this.useIdx;
    }

    RDFNode limitNode(RDFNode rDFNode) {
        return rDFNode == null ? this.MAX_RES : rDFNode;
    }

    Resource limitResource(Resource resource) {
        return resource == null ? this.MAX_RES : resource;
    }

    public Iterator multiget(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        StatementImpl statementImpl = new StatementImpl();
        statementImpl.s = resource;
        statementImpl.p = resource2;
        statementImpl.o = rDFNode;
        if (this.DEBUG) {
            System.err.println("FIND FOR " + statementImpl + ":");
        }
        if (resource == null) {
            if (rDFNode == null) {
                if (this.DEBUG) {
                    System.err.println("USING p");
                }
                return this.get((SortedMap)this.pIdx, (Statement)statementImpl);
            }
            return this.get((SortedMap)this.opIdx, (Statement)statementImpl);
        }
        if (resource2 == null) {
            statementImpl.o = null;
        }
        if (this.DEBUG) {
            System.err.println("USING spo");
        }
        return this.get((SortedMap)this.spoIdx, (Statement)statementImpl);
    }

    void put(Map map, Statement statement) {
        Object v = map.get(statement);
        if (v == null) {
            map.put(statement, statement);
        } else if (v instanceof Statement) {
            HashSet<Object> hashSet = new HashSet<Object>();
            hashSet.add(v);
            hashSet.add(statement);
            map.put(statement, hashSet);
        } else {
            ((Set)v).add(statement);
        }
    }

    void remove(Map map, Statement statement) {
        Object v = map.get(statement);
        if (v == null) {
            return;
        }
        if (v instanceof Statement) {
            map.remove(statement);
        } else {
            Set set = (Set)v;
            set.remove(statement);
            if (set.size() == 0) {
                map.remove(statement);
            }
        }
    }

    public void removeLookup(Statement statement) {
        this.remove((Map)this.spoIdx, statement);
        this.remove((Map)this.opIdx, statement);
        this.remove((Map)this.pIdx, statement);
    }

    public int size() {
        return this.spoIdx.size();
    }
}

