/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.TimeZone;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;

public class SimpleTimeZone
extends TimeZone {
    private int startMonth;
    private int startDay;
    private int startDayOfWeek;
    private int startTime;
    private int startTimeMode;
    private int endMonth;
    private int endDay;
    private int endDayOfWeek;
    private int endTime;
    private int endTimeMode;
    private int startYear;
    private int rawOffset;
    private boolean useDaylight = false;
    private static final int millisPerHour = 3600000;
    private static final int millisPerDay = 86400000;
    private final byte[] monthLength = staticMonthLength;
    private static final byte[] staticMonthLength = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final byte[] staticLeapMonthLength = new byte[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static GregorianCalendar internalCal = null;
    private int startMode;
    private int endMode;
    private int dstSavings;
    private static final int DOM_MODE = 1;
    private static final int DOW_IN_MONTH_MODE = 2;
    private static final int DOW_GE_DOM_MODE = 3;
    private static final int DOW_LE_DOM_MODE = 4;
    static final int WALL_TIME = 0;
    static final int STANDARD_TIME = 1;
    static final int UTC_TIME = 2;
    static final long serialVersionUID = -403250971215465050L;
    static final int currentSerialVersion = 2;
    private int serialVersionOnStream = 2;

    public SimpleTimeZone(int rawOffset, String ID) {
        this.rawOffset = rawOffset;
        this.setID(ID);
        this.dstSavings = 3600000;
    }

    public SimpleTimeZone(int rawOffset, String ID, int startMonth, int startDay, int startDayOfWeek, int startTime, int endMonth, int endDay, int endDayOfWeek, int endTime) {
        this(rawOffset, ID, startMonth, startDay, startDayOfWeek, startTime, 0, endMonth, endDay, endDayOfWeek, endTime, 0, 3600000);
    }

    public SimpleTimeZone(int rawOffset, String ID, int startMonth, int startDay, int startDayOfWeek, int startTime, int endMonth, int endDay, int endDayOfWeek, int endTime, int dstSavings) {
        this(rawOffset, ID, startMonth, startDay, startDayOfWeek, startTime, 0, endMonth, endDay, endDayOfWeek, endTime, 0, dstSavings);
    }

    SimpleTimeZone(int rawOffset, String ID, int startMonth, int startDay, int startDayOfWeek, int startTime, int startTimeMode, int endMonth, int endDay, int endDayOfWeek, int endTime, int endTimeMode, int dstSavings) {
        this.setID(ID);
        this.rawOffset = rawOffset;
        this.startMonth = startMonth;
        this.startDay = startDay;
        this.startDayOfWeek = startDayOfWeek;
        this.startTime = startTime;
        this.startTimeMode = startTimeMode;
        this.endMonth = endMonth;
        this.endDay = endDay;
        this.endDayOfWeek = endDayOfWeek;
        this.endTime = endTime;
        this.endTimeMode = endTimeMode;
        this.dstSavings = dstSavings;
        this.decodeRules();
        if (dstSavings <= 0) {
            throw new IllegalArgumentException("Illegal DST savings");
        }
    }

    SimpleTimeZone(String ID, int[] data, int i) {
        this.setID(ID);
        this.rawOffset = data[i + 1] * 1000;
        if (data[i] == 0) {
            this.dstSavings = 3600000;
        } else {
            this.startMonth = data[i + 2];
            this.startDay = data[i + 3];
            this.startDayOfWeek = data[i + 4];
            this.startTime = data[i + 5] * 60000;
            this.startTimeMode = data[i + 6];
            this.endMonth = data[i + 7];
            this.endDay = data[i + 8];
            this.endDayOfWeek = data[i + 9];
            this.endTime = data[i + 10] * 60000;
            this.endTimeMode = data[i + 11];
            this.dstSavings = data[i + 12] * 60000;
            this.decodeRules();
            if (this.dstSavings <= 0) {
                throw new IllegalArgumentException("Illegal DST savings");
            }
        }
    }

    public void setStartYear(int year) {
        this.startYear = year;
    }

    public void setStartRule(int month, int dayOfWeekInMonth, int dayOfWeek, int time) {
        this.startMonth = month;
        this.startDay = dayOfWeekInMonth;
        this.startDayOfWeek = dayOfWeek;
        this.startTime = time;
        this.startTimeMode = 0;
        this.decodeStartRule();
    }

    public void setStartRule(int month, int dayOfMonth, int time) {
        this.setStartRule(month, dayOfMonth, 0, time);
    }

    public void setStartRule(int month, int dayOfMonth, int dayOfWeek, int time, boolean after) {
        if (after) {
            this.setStartRule(month, dayOfMonth, -dayOfWeek, time);
        } else {
            this.setStartRule(month, -dayOfMonth, -dayOfWeek, time);
        }
    }

    public void setEndRule(int month, int dayOfWeekInMonth, int dayOfWeek, int time) {
        this.endMonth = month;
        this.endDay = dayOfWeekInMonth;
        this.endDayOfWeek = dayOfWeek;
        this.endTime = time;
        this.endTimeMode = 0;
        this.decodeEndRule();
    }

    public void setEndRule(int month, int dayOfMonth, int time) {
        this.setEndRule(month, dayOfMonth, 0, time);
    }

    public void setEndRule(int month, int dayOfMonth, int dayOfWeek, int time, boolean after) {
        if (after) {
            this.setEndRule(month, dayOfMonth, -dayOfWeek, time);
        } else {
            this.setEndRule(month, -dayOfMonth, -dayOfWeek, time);
        }
    }

    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis) {
        int prevMonthLength;
        byte monthLength;
        if (month < 0 || month > 11) {
            throw new IllegalArgumentException("Illegal month " + month);
        }
        if (internalCal == null) {
            internalCal = new GregorianCalendar(0, 0, 0);
        }
        if (era == 1 && internalCal.isLeapYear(year)) {
            monthLength = staticLeapMonthLength[month];
            prevMonthLength = month > 1 ? staticLeapMonthLength[month - 1] : 31;
        } else {
            monthLength = staticMonthLength[month];
            prevMonthLength = month > 1 ? staticMonthLength[month - 1] : 31;
        }
        return this.getOffset(era, year, month, day, dayOfWeek, millis, monthLength, prevMonthLength);
    }

    int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis, int monthLength, int prevMonthLength) {
        if (era != 1 && era != 0) {
            throw new IllegalArgumentException("Illegal era " + era);
        }
        if (month < 0 || month > 11) {
            throw new IllegalArgumentException("Illegal month " + month);
        }
        if (day < 1 || day > monthLength) {
            throw new IllegalArgumentException("Illegal day " + day);
        }
        if (dayOfWeek < 1 || dayOfWeek > 7) {
            throw new IllegalArgumentException("Illegal day of week " + dayOfWeek);
        }
        if (millis < 0 || millis >= 86400000) {
            throw new IllegalArgumentException("Illegal millis " + millis);
        }
        if (monthLength < 28 || monthLength > 31) {
            throw new IllegalArgumentException("Illegal month length " + monthLength);
        }
        if (prevMonthLength < 28 || prevMonthLength > 31) {
            throw new IllegalArgumentException("Illegal previous month length " + prevMonthLength);
        }
        int result = this.rawOffset;
        if (!this.useDaylight || year < this.startYear || era != 1) {
            return result;
        }
        boolean southern = this.startMonth > this.endMonth;
        int startCompare = SimpleTimeZone.compareToRule(month, monthLength, prevMonthLength, day, dayOfWeek, millis, this.startTimeMode == 2 ? -this.rawOffset : 0, this.startMode, this.startMonth, this.startDayOfWeek, this.startDay, this.startTime);
        int endCompare = 0;
        if (southern != startCompare >= 0) {
            endCompare = SimpleTimeZone.compareToRule(month, monthLength, prevMonthLength, day, dayOfWeek, millis, this.endTimeMode == 0 ? this.dstSavings : (this.endTimeMode == 2 ? -this.rawOffset : 0), this.endMode, this.endMonth, this.endDayOfWeek, this.endDay, this.endTime);
        }
        if (!southern && startCompare >= 0 && endCompare < 0 || southern && (startCompare >= 0 || endCompare < 0)) {
            result += this.dstSavings;
        }
        return result;
    }

    private static int compareToRule(int month, int monthLen, int prevMonthLen, int dayOfMonth, int dayOfWeek, int millis, int millisDelta, int ruleMode, int ruleMonth, int ruleDayOfWeek, int ruleDay, int ruleMillis) {
        millis += millisDelta;
        while (millis >= 86400000) {
            millis -= 86400000;
            dayOfWeek = 1 + dayOfWeek % 7;
            if (++dayOfMonth <= monthLen) continue;
            dayOfMonth = 1;
            ++month;
        }
        while (millis < 0) {
            millis += 86400000;
            dayOfWeek = 1 + (dayOfWeek + 5) % 7;
            if (--dayOfMonth >= 1) continue;
            dayOfMonth = prevMonthLen;
            --month;
        }
        if (month < ruleMonth) {
            return -1;
        }
        if (month > ruleMonth) {
            return 1;
        }
        int ruleDayOfMonth = 0;
        switch (ruleMode) {
            case 1: {
                ruleDayOfMonth = ruleDay;
                break;
            }
            case 2: {
                if (ruleDay > 0) {
                    ruleDayOfMonth = 1 + (ruleDay - 1) * 7 + (7 + ruleDayOfWeek - (dayOfWeek - dayOfMonth + 1)) % 7;
                    break;
                }
                ruleDayOfMonth = monthLen + (ruleDay + 1) * 7 - (7 + (dayOfWeek + monthLen - dayOfMonth) - ruleDayOfWeek) % 7;
                break;
            }
            case 3: {
                ruleDayOfMonth = ruleDay + (49 + ruleDayOfWeek - ruleDay - dayOfWeek + dayOfMonth) % 7;
                break;
            }
            case 4: {
                ruleDayOfMonth = ruleDay - (49 - ruleDayOfWeek + ruleDay + dayOfWeek - dayOfMonth) % 7;
            }
        }
        if (dayOfMonth < ruleDayOfMonth) {
            return -1;
        }
        if (dayOfMonth > ruleDayOfMonth) {
            return 1;
        }
        if (millis < ruleMillis) {
            return -1;
        }
        if (millis > ruleMillis) {
            return 1;
        }
        return 0;
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public void setRawOffset(int offsetMillis) {
        this.rawOffset = offsetMillis;
    }

    public void setDSTSavings(int millisSavedDuringDST) {
        if (millisSavedDuringDST <= 0) {
            throw new IllegalArgumentException("Illegal DST savings");
        }
        this.dstSavings = millisSavedDuringDST;
    }

    public int getDSTSavings() {
        return this.dstSavings;
    }

    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    public boolean inDaylightTime(Date date) {
        GregorianCalendar gc = new GregorianCalendar(this);
        gc.setTime(date);
        return gc.inDaylightTime();
    }

    public Object clone() {
        return super.clone();
    }

    public synchronized int hashCode() {
        return this.startMonth ^ this.startDay ^ this.startDayOfWeek ^ this.startTime ^ this.endMonth ^ this.endDay ^ this.endDayOfWeek ^ this.endTime ^ this.rawOffset;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone that = (SimpleTimeZone)obj;
        return this.getID().equals(that.getID()) && this.hasSameRules(that);
    }

    public boolean hasSameRules(TimeZone other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone that = (SimpleTimeZone)other;
        return this.rawOffset == that.rawOffset && this.useDaylight == that.useDaylight && (!this.useDaylight || this.dstSavings == that.dstSavings && this.startMode == that.startMode && this.startMonth == that.startMonth && this.startDay == that.startDay && this.startDayOfWeek == that.startDayOfWeek && this.startTime == that.startTime && this.startTimeMode == that.startTimeMode && this.endMode == that.endMode && this.endMonth == that.endMonth && this.endDay == that.endDay && this.endDayOfWeek == that.endDayOfWeek && this.endTime == that.endTime && this.endTimeMode == that.endTimeMode && this.startYear == that.startYear);
    }

    public String toString() {
        return this.getClass().getName() + "[id=" + this.getID() + ",offset=" + this.rawOffset + ",dstSavings=" + this.dstSavings + ",useDaylight=" + this.useDaylight + ",startYear=" + this.startYear + ",startMode=" + this.startMode + ",startMonth=" + this.startMonth + ",startDay=" + this.startDay + ",startDayOfWeek=" + this.startDayOfWeek + ",startTime=" + this.startTime + ",startTimeMode=" + this.startTimeMode + ",endMode=" + this.endMode + ",endMonth=" + this.endMonth + ",endDay=" + this.endDay + ",endDayOfWeek=" + this.endDayOfWeek + ",endTime=" + this.endTime + ",endTimeMode=" + this.endTimeMode + ']';
    }

    private void decodeRules() {
        this.decodeStartRule();
        this.decodeEndRule();
    }

    private void decodeStartRule() {
        boolean bl = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.startDay != 0) {
            if (this.startMonth < 0 || this.startMonth > 11) {
                throw new IllegalArgumentException("Illegal start month " + this.startMonth);
            }
            if (this.startTime < 0 || this.startTime >= 86400000) {
                throw new IllegalArgumentException("Illegal start time " + this.startTime);
            }
            if (this.startDayOfWeek == 0) {
                this.startMode = 1;
            } else {
                if (this.startDayOfWeek > 0) {
                    this.startMode = 2;
                } else {
                    this.startDayOfWeek = -this.startDayOfWeek;
                    if (this.startDay > 0) {
                        this.startMode = 3;
                    } else {
                        this.startDay = -this.startDay;
                        this.startMode = 4;
                    }
                }
                if (this.startDayOfWeek > 7) {
                    throw new IllegalArgumentException("Illegal start day of week " + this.startDayOfWeek);
                }
            }
            if (this.startMode == 2) {
                if (this.startDay < -5 || this.startDay > 5) {
                    throw new IllegalArgumentException("Illegal start day of week in month " + this.startDay);
                }
            } else if (this.startDay < 1 || this.startDay > staticMonthLength[this.startMonth]) {
                throw new IllegalArgumentException("Illegal start day " + this.startDay);
            }
        }
    }

    private void decodeEndRule() {
        boolean bl = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.endDay != 0) {
            if (this.endMonth < 0 || this.endMonth > 11) {
                throw new IllegalArgumentException("Illegal end month " + this.endMonth);
            }
            if (this.endTime < 0 || this.endTime >= 86400000) {
                throw new IllegalArgumentException("Illegal end time " + this.endTime);
            }
            if (this.endDayOfWeek == 0) {
                this.endMode = 1;
            } else {
                if (this.endDayOfWeek > 0) {
                    this.endMode = 2;
                } else {
                    this.endDayOfWeek = -this.endDayOfWeek;
                    if (this.endDay > 0) {
                        this.endMode = 3;
                    } else {
                        this.endDay = -this.endDay;
                        this.endMode = 4;
                    }
                }
                if (this.endDayOfWeek > 7) {
                    throw new IllegalArgumentException("Illegal end day of week " + this.endDayOfWeek);
                }
            }
            if (this.endMode == 2) {
                if (this.endDay < -5 || this.endDay > 5) {
                    throw new IllegalArgumentException("Illegal end day of week in month " + this.endDay);
                }
            } else if (this.endDay < 1 || this.endDay > staticMonthLength[this.endMonth]) {
                throw new IllegalArgumentException("Illegal end day " + this.endDay);
            }
        }
    }

    private void makeRulesCompatible() {
        switch (this.startMode) {
            case 1: {
                this.startDay = 1 + this.startDay / 7;
                this.startDayOfWeek = 1;
                break;
            }
            case 3: {
                if (this.startDay == 1) break;
                this.startDay = 1 + this.startDay / 7;
                break;
            }
            case 4: {
                this.startDay = this.startDay >= 30 ? -1 : 1 + this.startDay / 7;
            }
        }
        switch (this.endMode) {
            case 1: {
                this.endDay = 1 + this.endDay / 7;
                this.endDayOfWeek = 1;
                break;
            }
            case 3: {
                if (this.endDay == 1) break;
                this.endDay = 1 + this.endDay / 7;
                break;
            }
            case 4: {
                this.endDay = this.endDay >= 30 ? -1 : 1 + this.endDay / 7;
            }
        }
        switch (this.startTimeMode) {
            case 2: {
                this.startTime += this.rawOffset;
            }
        }
        while (this.startTime < 0) {
            this.startTime += 86400000;
            this.startDayOfWeek = 1 + (this.startDayOfWeek + 5) % 7;
        }
        while (this.startTime >= 86400000) {
            this.startTime -= 86400000;
            this.startDayOfWeek = 1 + this.startDayOfWeek % 7;
        }
        switch (this.endTimeMode) {
            case 2: {
                this.endTime += this.rawOffset + this.dstSavings;
                break;
            }
            case 1: {
                this.endTime += this.dstSavings;
            }
        }
        while (this.endTime < 0) {
            this.endTime += 86400000;
            this.endDayOfWeek = 1 + (this.endDayOfWeek + 5) % 7;
        }
        while (this.endTime >= 86400000) {
            this.endTime -= 86400000;
            this.endDayOfWeek = 1 + this.endDayOfWeek % 7;
        }
    }

    private byte[] packRules() {
        byte[] rules = new byte[]{(byte)this.startDay, (byte)this.startDayOfWeek, (byte)this.endDay, (byte)this.endDayOfWeek, (byte)this.startTimeMode, (byte)this.endTimeMode};
        return rules;
    }

    private void unpackRules(byte[] rules) {
        this.startDay = rules[0];
        this.startDayOfWeek = rules[1];
        this.endDay = rules[2];
        this.endDayOfWeek = rules[3];
        if (rules.length >= 6) {
            this.startTimeMode = rules[4];
            this.endTimeMode = rules[5];
        }
    }

    private int[] packTimes() {
        int[] times = new int[]{this.startTime, this.endTime};
        return times;
    }

    private void unpackTimes(int[] times) {
        this.startTime = times[0];
        this.endTime = times[1];
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        byte[] rules = this.packRules();
        int[] times = this.packTimes();
        this.makeRulesCompatible();
        stream.defaultWriteObject();
        stream.writeInt(rules.length);
        stream.write(rules);
        stream.writeObject(times);
        this.unpackRules(rules);
        this.unpackTimes(times);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            if (this.startDayOfWeek == 0) {
                this.startDayOfWeek = 1;
            }
            if (this.endDayOfWeek == 0) {
                this.endDayOfWeek = 1;
            }
            this.endMode = 2;
            this.startMode = 2;
            this.dstSavings = 3600000;
        } else {
            int length = stream.readInt();
            byte[] rules = new byte[length];
            stream.readFully(rules);
            this.unpackRules(rules);
        }
        if (this.serialVersionOnStream >= 2) {
            int[] times = (int[])stream.readObject();
            this.unpackTimes(times);
        }
        this.serialVersionOnStream = 2;
    }
}

