/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICULocaleData;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DateFormatSymbols;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.SimpleTimeZone;
import com.ibm.icu.util.TimeZone;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;

public class SimpleDateFormat
extends DateFormat {
    static final long serialVersionUID = 4774881970558875024L;
    static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;
    private String pattern;
    private DateFormatSymbols formatData;
    private Date defaultCenturyStart;
    private transient int defaultCenturyStartYear;
    private static final int millisPerHour = 3600000;
    private static final int millisPerMinute = 60000;
    private static final String GMT_PLUS = "GMT+";
    private static final String GMT_MINUS = "GMT-";
    private static final String GMT = "GMT";
    private static Hashtable cachedLocaleData = new Hashtable(3);
    private static final int[] PATTERN_INDEX_TO_CALENDAR_FIELD = new int[]{0, 1, 2, 5, 11, 11, 12, 13, 14, 7, 6, 8, 3, 4, 9, 10, 10, 15};
    private static final int[] PATTERN_INDEX_TO_DATE_FORMAT_FIELD = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};

    public SimpleDateFormat() {
        this(3, 3, Locale.getDefault());
    }

    public SimpleDateFormat(String pattern) {
        this(pattern, Locale.getDefault());
    }

    public SimpleDateFormat(String pattern, Locale loc) {
        this.pattern = pattern;
        this.formatData = new DateFormatSymbols(loc);
        this.initialize(loc);
    }

    public SimpleDateFormat(String pattern, DateFormatSymbols formatData) {
        this.pattern = pattern;
        this.formatData = (DateFormatSymbols)formatData.clone();
        this.initialize(Locale.getDefault());
    }

    SimpleDateFormat(int timeStyle, int dateStyle, Locale loc) {
        String[] dateTimePatterns = (String[])cachedLocaleData.get(loc);
        if (dateTimePatterns == null) {
            ResourceBundle r = ICULocaleData.getLocaleElements(loc);
            dateTimePatterns = r.getStringArray("DateTimePatterns");
            cachedLocaleData.put(loc, dateTimePatterns);
        }
        this.formatData = new DateFormatSymbols(loc);
        if (timeStyle >= 0 && dateStyle >= 0) {
            Object[] dateTimeArgs = new Object[]{dateTimePatterns[timeStyle], dateTimePatterns[dateStyle + 4]};
            this.pattern = MessageFormat.format(dateTimePatterns[8], dateTimeArgs);
        } else if (timeStyle >= 0) {
            this.pattern = dateTimePatterns[timeStyle];
        } else if (dateStyle >= 0) {
            this.pattern = dateTimePatterns[dateStyle + 4];
        } else {
            throw new IllegalArgumentException("No date or time style specified");
        }
        this.initialize(loc);
    }

    private void initialize(Locale loc) {
        this.calendar = Calendar.getInstance(TimeZone.getDefault(), loc);
        this.numberFormat = NumberFormat.getInstance(loc);
        this.numberFormat.setGroupingUsed(false);
        if (this.numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)this.numberFormat).setDecimalSeparatorAlwaysShown(false);
        }
        this.numberFormat.setParseIntegerOnly(true);
        this.numberFormat.setMinimumFractionDigits(0);
        this.initializeDefaultCentury();
    }

    private void initializeDefaultCentury() {
        this.calendar.setTime(new Date());
        this.calendar.add(1, -80);
        this.parseAmbiguousDatesAsAfter(this.calendar.getTime());
    }

    private void parseAmbiguousDatesAsAfter(Date startDate) {
        this.defaultCenturyStart = startDate;
        this.calendar.setTime(startDate);
        this.defaultCenturyStartYear = this.calendar.get(1);
    }

    public void set2DigitYearStart(Date startDate) {
        this.parseAmbiguousDatesAsAfter(startDate);
    }

    public Date get2DigitYearStart() {
        return this.defaultCenturyStart;
    }

    public StringBuffer format(Calendar cal, StringBuffer toAppendTo, FieldPosition pos) {
        pos.setBeginIndex(0);
        pos.setEndIndex(0);
        boolean inQuote = false;
        char prevCh = '\u0000';
        int count = 0;
        int i = 0;
        while (i < this.pattern.length()) {
            char ch = this.pattern.charAt(i);
            if (ch != prevCh && count > 0) {
                toAppendTo.append(this.subFormat(prevCh, count, toAppendTo.length(), pos, this.formatData, cal));
                count = 0;
            }
            if (ch == '\'') {
                if (i + 1 < this.pattern.length() && this.pattern.charAt(i + 1) == '\'') {
                    toAppendTo.append('\'');
                    ++i;
                } else {
                    inQuote = !inQuote;
                }
            } else if (!inQuote && (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) {
                prevCh = ch;
                ++count;
            } else {
                toAppendTo.append(ch);
            }
            ++i;
        }
        if (count > 0) {
            toAppendTo.append(this.subFormat(prevCh, count, toAppendTo.length(), pos, this.formatData, cal));
        }
        return toAppendTo;
    }

    protected String subFormat(char ch, int count, int beginOffset, FieldPosition pos, DateFormatSymbols formatData, Calendar cal) throws IllegalArgumentException {
        int patternCharIndex = -1;
        int maxIntCount = Integer.MAX_VALUE;
        String current = "";
        if (ch == 'u') {
            return this.zeroPaddingNumber(cal.get(19), 1, maxIntCount);
        }
        patternCharIndex = "GyMdkHmsSEDFwWahKz".indexOf(ch);
        if (patternCharIndex == -1) {
            throw new IllegalArgumentException("Illegal pattern character '" + ch + "'");
        }
        int field = PATTERN_INDEX_TO_CALENDAR_FIELD[patternCharIndex];
        int value = cal.get(field);
        switch (patternCharIndex) {
            case 0: {
                current = formatData.eras[value];
                break;
            }
            case 1: {
                if (count == 2) {
                    current = this.zeroPaddingNumber(value, 2, 2);
                    break;
                }
                current = this.zeroPaddingNumber(value, count, maxIntCount);
                break;
            }
            case 2: {
                if (count >= 4) {
                    current = formatData.months[value];
                    break;
                }
                if (count == 3) {
                    current = formatData.shortMonths[value];
                    break;
                }
                current = this.zeroPaddingNumber(value + 1, count, maxIntCount);
                break;
            }
            case 4: {
                if (value == 0) {
                    current = this.zeroPaddingNumber(cal.getMaximum(11) + 1, count, maxIntCount);
                    break;
                }
                current = this.zeroPaddingNumber(value, count, maxIntCount);
                break;
            }
            case 9: {
                if (count >= 4) {
                    current = formatData.weekdays[value];
                    break;
                }
                current = formatData.shortWeekdays[value];
                break;
            }
            case 14: {
                current = formatData.ampms[value];
                break;
            }
            case 15: {
                if (value == 0) {
                    current = this.zeroPaddingNumber(cal.getLeastMaximum(10) + 1, count, maxIntCount);
                    break;
                }
                current = this.zeroPaddingNumber(value, count, maxIntCount);
                break;
            }
            case 17: {
                int zoneIndex = formatData.getZoneIndex(cal.getTimeZone().getID());
                if (zoneIndex == -1) {
                    StringBuffer zoneString = new StringBuffer();
                    value = cal.get(15) + cal.get(16);
                    if (value < 0) {
                        zoneString.append(GMT_MINUS);
                        value = -value;
                    } else {
                        zoneString.append(GMT_PLUS);
                    }
                    zoneString.append(this.zeroPaddingNumber(value / 3600000, 2, 2));
                    zoneString.append(':');
                    zoneString.append(this.zeroPaddingNumber(value % 3600000 / 60000, 2, 2));
                    current = zoneString.toString();
                    break;
                }
                if (cal.get(16) != 0) {
                    if (count >= 4) {
                        current = formatData.zoneStrings[zoneIndex][3];
                        break;
                    }
                    current = formatData.zoneStrings[zoneIndex][4];
                    break;
                }
                if (count >= 4) {
                    current = formatData.zoneStrings[zoneIndex][1];
                    break;
                }
                current = formatData.zoneStrings[zoneIndex][2];
                break;
            }
            default: {
                current = this.zeroPaddingNumber(value, count, maxIntCount);
            }
        }
        if (pos.getField() == PATTERN_INDEX_TO_DATE_FORMAT_FIELD[patternCharIndex] && pos.getBeginIndex() == 0 && pos.getEndIndex() == 0) {
            pos.setBeginIndex(beginOffset);
            pos.setEndIndex(beginOffset + current.length());
        }
        return current;
    }

    protected String zeroPaddingNumber(long value, int minDigits, int maxDigits) {
        this.numberFormat.setMinimumIntegerDigits(minDigits);
        this.numberFormat.setMaximumIntegerDigits(maxDigits);
        return this.numberFormat.format(value);
    }

    public void parse(String text, Calendar cal, ParsePosition pos) {
        int start;
        int oldStart = start = pos.getIndex();
        boolean[] ambiguousYear = new boolean[]{false};
        boolean inQuote = false;
        char prevCh = '\u0000';
        int count = 0;
        int interQuoteCount = 1;
        int i = 0;
        while (i < this.pattern.length()) {
            char ch = this.pattern.charAt(i);
            if (inQuote) {
                if (ch == '\'') {
                    inQuote = false;
                    if (count == 0) {
                        if (start >= text.length() || ch != text.charAt(start)) {
                            pos.setIndex(oldStart);
                            pos.setErrorIndex(start);
                            return;
                        }
                        ++start;
                    }
                    count = 0;
                    interQuoteCount = 0;
                } else {
                    if (start >= text.length() || ch != text.charAt(start)) {
                        pos.setIndex(oldStart);
                        pos.setErrorIndex(start);
                        return;
                    }
                    ++count;
                    ++start;
                }
            } else {
                int startOffset;
                if (ch == '\'') {
                    inQuote = true;
                    if (count > 0) {
                        startOffset = start;
                        if ((start = this.subParse(text, start, prevCh, count, false, ambiguousYear, cal)) < 0) {
                            pos.setErrorIndex(startOffset);
                            pos.setIndex(oldStart);
                            return;
                        }
                        count = 0;
                    }
                    if (interQuoteCount == 0) {
                        startOffset = start;
                        if (start >= text.length() || ch != text.charAt(start)) {
                            pos.setErrorIndex(startOffset);
                            pos.setIndex(oldStart);
                            return;
                        }
                        ++start;
                        count = 1;
                    }
                } else if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                    if (ch != prevCh && count > 0) {
                        startOffset = start;
                        if ((start = this.subParse(text, start, prevCh, count, true, ambiguousYear, cal)) < 0) {
                            pos.setErrorIndex(startOffset);
                            pos.setIndex(oldStart);
                            return;
                        }
                        prevCh = ch;
                        count = 1;
                    } else {
                        if (ch != prevCh) {
                            prevCh = ch;
                        }
                        ++count;
                    }
                } else if (count > 0) {
                    startOffset = start;
                    if ((start = this.subParse(text, start, prevCh, count, false, ambiguousYear, cal)) < 0) {
                        pos.setErrorIndex(startOffset);
                        pos.setIndex(oldStart);
                        return;
                    }
                    if (start >= text.length() || ch != text.charAt(start)) {
                        pos.setErrorIndex(start);
                        pos.setIndex(oldStart);
                        return;
                    }
                    ++start;
                    count = 0;
                    prevCh = '\u0000';
                } else {
                    if (start >= text.length() || ch != text.charAt(start)) {
                        pos.setErrorIndex(start);
                        pos.setIndex(oldStart);
                        return;
                    }
                    ++start;
                }
                ++interQuoteCount;
            }
            ++i;
        }
        if (count > 0) {
            int startOffset = start;
            if ((start = this.subParse(text, start, prevCh, count, false, ambiguousYear, cal)) < 0) {
                pos.setIndex(oldStart);
                pos.setErrorIndex(startOffset);
                return;
            }
        }
        pos.setIndex(start);
        try {
            Calendar copy;
            Date parsedDate;
            if (ambiguousYear[0] && (parsedDate = (copy = (Calendar)cal.clone()).getTime()).before(this.defaultCenturyStart)) {
                cal.set(1, this.defaultCenturyStartYear + 100);
            }
        }
        catch (IllegalArgumentException e) {
            pos.setErrorIndex(start);
            pos.setIndex(oldStart);
        }
    }

    protected int matchString(String text, int start, int field, String[] data, Calendar cal) {
        int i = 0;
        int count = data.length;
        if (field == 7) {
            i = 1;
        }
        int bestMatchLength = 0;
        int bestMatch = -1;
        while (i < count) {
            int length = data[i].length();
            if (length > bestMatchLength && text.regionMatches(true, start, data[i], 0, length)) {
                bestMatch = i;
                bestMatchLength = length;
            }
            ++i;
        }
        if (bestMatch >= 0) {
            cal.set(field, bestMatch);
            return start + bestMatchLength;
        }
        return -start;
    }

    private int matchZoneString(String text, int start, int zoneIndex) {
        int j = 1;
        while (j <= 4) {
            if (text.regionMatches(true, start, this.formatData.zoneStrings[zoneIndex][j], 0, this.formatData.zoneStrings[zoneIndex][j].length())) break;
            ++j;
        }
        return j > 4 ? -1 : j;
    }

    private int subParseZoneString(String text, int start, Calendar cal) {
        int zoneIndex = this.formatData.getZoneIndex(this.getTimeZone().getID());
        TimeZone tz = null;
        int j = 0;
        int i = 0;
        if (zoneIndex != -1 && (j = this.matchZoneString(text, start, zoneIndex)) > 0) {
            tz = TimeZone.getTimeZone(this.formatData.zoneStrings[zoneIndex][0]);
            i = zoneIndex;
        }
        if (tz == null && (zoneIndex = this.formatData.getZoneIndex(TimeZone.getDefault().getID())) != -1 && (j = this.matchZoneString(text, start, zoneIndex)) > 0) {
            tz = TimeZone.getTimeZone(this.formatData.zoneStrings[zoneIndex][0]);
            i = zoneIndex;
        }
        if (tz == null) {
            i = 0;
            while (i < this.formatData.zoneStrings.length) {
                j = this.matchZoneString(text, start, i);
                if (j > 0) {
                    tz = TimeZone.getTimeZone(this.formatData.zoneStrings[i][0]);
                    break;
                }
                ++i;
            }
        }
        if (tz != null) {
            cal.set(15, tz.getRawOffset());
            cal.set(16, j >= 3 ? ((SimpleTimeZone)tz).getDSTSavings() : 0);
            return start + this.formatData.zoneStrings[i][j].length();
        }
        return 0;
    }

    protected int subParse(String text, int start, char ch, int count, boolean obeyCount, boolean[] ambiguousYear, Calendar cal) {
        Number number = null;
        int value = 0;
        ParsePosition pos = new ParsePosition(0);
        int patternCharIndex = -1;
        if (ch == 'u') {
            pos.setIndex(start);
            while (true) {
                if (pos.getIndex() >= text.length()) {
                    return -start;
                }
                char c = text.charAt(pos.getIndex());
                if (c != ' ' && c != '\t') break;
                pos.setIndex(pos.getIndex() + 1);
            }
            if (obeyCount) {
                if (start + count > text.length()) {
                    return -start;
                }
                number = this.numberFormat.parse(text.substring(0, start + count), pos);
            } else {
                number = this.numberFormat.parse(text, pos);
            }
            if (number == null) {
                return -start;
            }
            value = number.intValue();
            cal.set(19, value);
            return pos.getIndex();
        }
        patternCharIndex = "GyMdkHmsSEDFwWahKz".indexOf(ch);
        if (patternCharIndex == -1) {
            return -start;
        }
        int field = PATTERN_INDEX_TO_CALENDAR_FIELD[patternCharIndex];
        while (true) {
            if (start >= text.length()) {
                return -start;
            }
            int c = UTF16.charAt(text, start);
            if (!UCharacter.isUWhiteSpace(c)) break;
            start += UTF16.getCharCount(c);
        }
        pos.setIndex(start);
        if (patternCharIndex == 4 || patternCharIndex == 15 || patternCharIndex == 2 && count <= 2 || patternCharIndex == 1) {
            if (obeyCount) {
                if (start + count > text.length()) {
                    return -start;
                }
                number = this.numberFormat.parse(text.substring(0, start + count), pos);
            } else {
                number = this.numberFormat.parse(text, pos);
            }
            if (number == null) {
                return -start;
            }
            value = number.intValue();
        }
        switch (patternCharIndex) {
            case 0: {
                return this.matchString(text, start, 0, this.formatData.eras, cal);
            }
            case 1: {
                if (count == 2 && pos.getIndex() - start == 2 && Character.isDigit(text.charAt(start)) && Character.isDigit(text.charAt(start + 1))) {
                    int ambiguousTwoDigitYear = this.defaultCenturyStartYear % 100;
                    ambiguousYear[0] = value == ambiguousTwoDigitYear;
                    value += this.defaultCenturyStartYear / 100 * 100 + (value < ambiguousTwoDigitYear ? 100 : 0);
                }
                cal.set(1, value);
                return pos.getIndex();
            }
            case 2: {
                if (count <= 2) {
                    cal.set(2, value - 1);
                    return pos.getIndex();
                }
                int newStart = 0;
                newStart = this.matchString(text, start, 2, this.formatData.months, cal);
                if (newStart > 0) {
                    return newStart;
                }
                return this.matchString(text, start, 2, this.formatData.shortMonths, cal);
            }
            case 4: {
                if (value == cal.getMaximum(11) + 1) {
                    value = 0;
                }
                cal.set(11, value);
                return pos.getIndex();
            }
            case 9: {
                int newStart = 0;
                newStart = this.matchString(text, start, 7, this.formatData.weekdays, cal);
                if (newStart > 0) {
                    return newStart;
                }
                return this.matchString(text, start, 7, this.formatData.shortWeekdays, cal);
            }
            case 14: {
                return this.matchString(text, start, 9, this.formatData.ampms, cal);
            }
            case 15: {
                if (value == cal.getLeastMaximum(10) + 1) {
                    value = 0;
                }
                cal.set(10, value);
                return pos.getIndex();
            }
            case 17: {
                int offset;
                int sign = 0;
                if (text.length() - start >= GMT.length() && text.regionMatches(true, start, GMT, 0, GMT.length())) {
                    cal.set(16, 0);
                    pos.setIndex(start + GMT.length());
                    try {
                        if (text.charAt(pos.getIndex()) == '+') {
                            sign = 1;
                        } else if (text.charAt(pos.getIndex()) == '-') {
                            sign = -1;
                        }
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        // empty catch block
                    }
                    if (sign == 0) {
                        cal.set(15, 0);
                        return pos.getIndex();
                    }
                    pos.setIndex(pos.getIndex() + 1);
                    Number tzNumber = this.numberFormat.parse(text, pos);
                    if (tzNumber == null) {
                        return -start;
                    }
                    if (text.charAt(pos.getIndex()) == ':') {
                        offset = tzNumber.intValue() * 60;
                        pos.setIndex(pos.getIndex() + 1);
                        tzNumber = this.numberFormat.parse(text, pos);
                        if (tzNumber == null) {
                            return -start;
                        }
                        offset += tzNumber.intValue();
                    } else {
                        offset = tzNumber.intValue();
                        offset = offset < 24 ? (offset *= 60) : offset % 100 + offset / 100 * 60;
                    }
                } else {
                    int i = this.subParseZoneString(text, start, cal);
                    if (i != 0) {
                        return i;
                    }
                    DecimalFormat fmt = new DecimalFormat("+####;-####");
                    fmt.setParseIntegerOnly(true);
                    Number tzNumber = fmt.parse(text, pos);
                    if (tzNumber == null) {
                        return -start;
                    }
                    offset = tzNumber.intValue();
                    sign = 1;
                    if (offset < 0) {
                        sign = -1;
                        offset = -offset;
                    }
                    offset = offset < 24 ? (offset *= 60) : offset % 100 + offset / 100 * 60;
                }
                if (sign != 0) {
                    offset *= 60000 * sign;
                    if (cal.getTimeZone().useDaylightTime()) {
                        cal.set(16, 3600000);
                        offset -= 3600000;
                    }
                    cal.set(15, offset);
                    return pos.getIndex();
                }
                return -start;
            }
        }
        if (obeyCount) {
            if (start + count > text.length()) {
                return -start;
            }
            number = this.numberFormat.parse(text.substring(0, start + count), pos);
        } else {
            number = this.numberFormat.parse(text, pos);
        }
        if (number != null) {
            cal.set(field, number.intValue());
            return pos.getIndex();
        }
        return -start;
    }

    private String translatePattern(String pattern, String from, String to) {
        StringBuffer result = new StringBuffer();
        boolean inQuote = false;
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            if (inQuote) {
                if (c == '\'') {
                    inQuote = false;
                }
            } else if (c == '\'') {
                inQuote = true;
            } else if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                int ci = from.indexOf(c);
                if (ci == -1) {
                    throw new IllegalArgumentException("Illegal pattern  character '" + c + "'");
                }
                c = to.charAt(ci);
            }
            result.append(c);
            ++i;
        }
        if (inQuote) {
            throw new IllegalArgumentException("Unfinished quote in pattern");
        }
        return result.toString();
    }

    public String toPattern() {
        return this.pattern;
    }

    public String toLocalizedPattern() {
        return this.translatePattern(this.pattern, "GyMdkHmsSEDFwWahKz", this.formatData.localPatternChars);
    }

    public void applyPattern(String pattern) {
        this.pattern = pattern;
    }

    public void applyLocalizedPattern(String pattern) {
        this.pattern = this.translatePattern(pattern, this.formatData.localPatternChars, "GyMdkHmsSEDFwWahKz");
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return (DateFormatSymbols)this.formatData.clone();
    }

    public void setDateFormatSymbols(DateFormatSymbols newFormatSymbols) {
        this.formatData = (DateFormatSymbols)newFormatSymbols.clone();
    }

    protected DateFormatSymbols getSymbols() {
        return this.formatData;
    }

    public Object clone() {
        SimpleDateFormat other = (SimpleDateFormat)super.clone();
        other.formatData = (DateFormatSymbols)this.formatData.clone();
        return other;
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        SimpleDateFormat that = (SimpleDateFormat)obj;
        return this.pattern.equals(that.pattern) && this.formatData.equals(that.formatData);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.initializeDefaultCentury();
        } else {
            this.parseAmbiguousDatesAsAfter(this.defaultCenturyStart);
        }
        this.serialVersionOnStream = 1;
    }
}

