/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICUDebug;
import com.ibm.icu.impl.NormalizerImpl;
import com.ibm.icu.impl.UCharacterProperty;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.UTF16;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

public final class CollationElementIterator {
    public static final int NULLORDER = -1;
    public static final int IGNORABLE = 0;
    boolean m_isCodePointHiragana_;
    int m_FCDStart_;
    int m_CEBufferOffset_;
    int m_CEBufferSize_;
    private boolean m_isForwards_;
    private CharacterIterator m_source_;
    private int m_bufferOffset_;
    private StringBuffer m_buffer_;
    private int m_FCDLimit_;
    private RuleBasedCollator m_collator_;
    private boolean m_isHiragana4_;
    private int[] m_CEBuffer_;
    private static final int CE_BUFFER_INIT_SIZE_ = 512;
    private Backup m_utilSpecialBackUp_;
    private Backup m_utilSpecialEntryBackUp_;
    private Backup m_utilSpecialDiscontiguousBackUp_;
    private StringCharacterIterator m_srcUtilIter_;
    private StringBuffer m_utilStringBuffer_;
    private StringBuffer m_utilSkippedBuffer_;
    private CollationElementIterator m_utilColEIter_;
    private static final int FULL_ZERO_COMBINING_CLASS_FAST_LIMIT_ = 192;
    private static final int LEAD_ZERO_COMBINING_CLASS_FAST_LIMIT_ = 768;
    private static final int LAST_BYTE_MASK_ = 255;
    private static final int SECOND_LAST_BYTE_SHIFT_ = 8;
    static final int CE_NOT_FOUND_ = -268435456;
    private static final int CE_EXPANSION_ = -251658240;
    private static final int CE_CONTRACTION_ = -234881024;
    private static final int CE_THAI_ = -218103808;
    private static final int CE_NO_MORE_CES_ = 65793;
    private static final int CE_NO_MORE_CES_PRIMARY_ = 65536;
    private static final int CE_NO_MORE_CES_SECONDARY_ = 256;
    private static final int CE_NO_MORE_CES_TERTIARY_ = 1;
    private static final int CE_NOT_FOUND_TAG_ = 0;
    static final int CE_EXPANSION_TAG_ = 1;
    static final int CE_CONTRACTION_TAG_ = 2;
    private static final int CE_THAI_TAG_ = 3;
    private static final int CE_CHARSET_TAG_ = 4;
    private static final int CE_HANGUL_SYLLABLE_TAG_ = 6;
    private static final int CE_LEAD_SURROGATE_TAG_ = 7;
    private static final int CE_TRAIL_SURROGATE_TAG_ = 8;
    private static final int CE_CJK_IMPLICIT_TAG_ = 9;
    private static final int CE_IMPLICIT_TAG_ = 10;
    private static final int CE_SPEC_PROC_TAG_ = 11;
    private static final int CE_LONG_PRIMARY_TAG_ = 12;
    private static final int CE_CE_TAGS_COUNT = 13;
    private static final int CE_BYTE_COMMON_ = 5;
    private static final int HANGUL_SBASE_ = 44032;
    private static final int HANGUL_LBASE_ = 4352;
    private static final int HANGUL_VBASE_ = 4449;
    private static final int HANGUL_TBASE_ = 4519;
    private static final int HANGUL_VCOUNT_ = 21;
    private static final int HANGUL_TCOUNT_ = 28;
    private static final int CJK_BASE_ = 19968;
    private static final int CJK_LIMIT_ = 40960;
    private static final int CJK_COMPAT_USED_BASE_ = 64014;
    private static final int CJK_COMPAT_USED_LIMIT_ = 64048;
    private static final int CJK_A_BASE_ = 13312;
    private static final int CJK_A_LIMIT_ = 19904;
    private static final int CJK_B_BASE_ = 131072;
    private static final int CJK_B_LIMIT_ = 173792;
    private static final int NON_CJK_OFFSET_ = 0x110000;

    public int getOffset() {
        if (this.m_bufferOffset_ != -1) {
            if (this.m_isForwards_) {
                return this.m_FCDLimit_;
            }
            return this.m_FCDStart_;
        }
        return this.m_source_.getIndex();
    }

    public int getMaxExpansion(int ce) {
        int start = 0;
        int limit = this.m_collator_.m_expansionEndCE_.length;
        long unsignedce = (long)ce & 0xFFFFFFFFL;
        while (start < limit - 1) {
            int mid = start + (limit - start >> 1);
            long midce = (long)this.m_collator_.m_expansionEndCE_[mid] & 0xFFFFFFFFL;
            if (unsignedce <= midce) {
                limit = mid;
                continue;
            }
            start = mid;
        }
        int result = 1;
        if (this.m_collator_.m_expansionEndCE_[start] == ce) {
            result = this.m_collator_.m_expansionEndCEMaxSize_[start];
        } else if (limit < this.m_collator_.m_expansionEndCE_.length && this.m_collator_.m_expansionEndCE_[limit] == ce) {
            result = this.m_collator_.m_expansionEndCEMaxSize_[limit];
        } else if ((ce & 0xFFFF) == 192) {
            result = 2;
        }
        return result;
    }

    public void reset() {
        this.m_source_.setIndex(this.m_source_.getBeginIndex());
        this.updateInternalState();
    }

    public int next() {
        char ch;
        this.m_isForwards_ = true;
        if (this.m_CEBufferSize_ > 0) {
            if (this.m_CEBufferOffset_ < this.m_CEBufferSize_) {
                return this.m_CEBuffer_[this.m_CEBufferOffset_++];
            }
            this.m_CEBufferSize_ = 0;
            this.m_CEBufferOffset_ = 0;
        }
        if ((ch = this.nextChar()) == '\uffff') {
            return -1;
        }
        if (this.m_collator_.m_isHiragana4_) {
            this.m_isCodePointHiragana_ = ch >= '\u3040' && ch <= '\u309e' && (ch <= '\u3094' || ch >= '\u309d');
        }
        int result = -1;
        if (ch <= '\u00ff') {
            result = this.m_collator_.m_trie_.getLatin1LinearValue(ch);
            if (RuleBasedCollator.isSpecial(result)) {
                result = this.nextSpecial(this.m_collator_, result, ch);
            }
        } else {
            result = this.m_collator_.m_trie_.getLeadValue(ch);
            if (RuleBasedCollator.isSpecial(result)) {
                result = this.nextSpecial(this.m_collator_, result, ch);
            }
            if (result == -268435456) {
                result = RuleBasedCollator.UCA_.m_trie_.getLeadValue(ch);
                if (RuleBasedCollator.isSpecial(result)) {
                    result = this.nextSpecial(RuleBasedCollator.UCA_, result, ch);
                }
            }
        }
        return result;
    }

    public int previous() {
        char ch;
        if (this.m_source_.getIndex() <= 0 && this.m_isForwards_) {
            this.m_source_.setIndex(this.m_source_.getEndIndex());
            this.updateInternalState();
        }
        this.m_isForwards_ = false;
        int result = -1;
        if (this.m_CEBufferSize_ > 0) {
            if (this.m_CEBufferOffset_ > 0) {
                return this.m_CEBuffer_[--this.m_CEBufferOffset_];
            }
            this.m_CEBufferSize_ = 0;
            this.m_CEBufferOffset_ = 0;
        }
        if ((ch = this.previousChar()) == '\uffff') {
            return -1;
        }
        if (this.m_collator_.m_isHiragana4_) {
            boolean bl = this.m_isCodePointHiragana_ = ch >= '\u3040' && ch <= '\u309f';
        }
        if (this.m_collator_.isContractionEnd(ch) && !this.isBackwardsStart()) {
            result = this.previousSpecial(this.m_collator_, -234881024, ch);
        } else if (ch <= '\u00ff') {
            result = this.m_collator_.m_trie_.getLatin1LinearValue(ch);
            if (RuleBasedCollator.isSpecial(result)) {
                result = this.previousSpecial(this.m_collator_, result, ch);
            }
        } else {
            if (this.m_bufferOffset_ < 0 && this.m_source_.getIndex() != 0) {
                result = CollationElementIterator.isThaiPreVowel(this.m_source_.previous()) ? -218103808 : this.m_collator_.m_trie_.getLeadValue(ch);
                this.m_source_.next();
            } else {
                result = this.m_collator_.m_trie_.getLeadValue(ch);
            }
            if (RuleBasedCollator.isSpecial(result)) {
                result = this.previousSpecial(this.m_collator_, result, ch);
            }
            if (result == -268435456 && RuleBasedCollator.isSpecial(result = !this.isBackwardsStart() && this.m_collator_.isContractionEnd(ch) ? -234881024 : RuleBasedCollator.UCA_.m_trie_.getLeadValue(ch))) {
                result = this.previousSpecial(RuleBasedCollator.UCA_, result, ch);
            }
        }
        return result;
    }

    public static final int primaryOrder(int ce) {
        return (ce & 0xFFFF0000) >>> 16;
    }

    public static final int secondaryOrder(int ce) {
        return (ce & 0xFF00) >> 8;
    }

    public static final int tertiaryOrder(int ce) {
        return ce & 0xFF;
    }

    /*
     * Unable to fully structure code
     */
    public void setOffset(int offset) {
        block4: {
            this.m_source_.setIndex(offset);
            ch = this.m_source_.current();
            if (!this.m_collator_.isUnsafe(ch)) break block4;
            if (!UTF16.isTrailSurrogate(ch)) ** GOTO lbl13
            prevch = this.m_source_.previous();
            if (UTF16.isLeadSurrogate(prevch)) break block4;
            this.m_source_.setIndex(offset);
            break block4;
            while (this.m_collator_.isUnsafe(ch)) {
                ch = this.m_source_.previous();
lbl13:
                // 2 sources

                if (this.m_source_.getIndex() > 0) continue;
            }
            this.updateInternalState();
            prevoffset = 0;
            while (this.m_source_.getIndex() <= offset) {
                prevoffset = this.m_source_.getIndex();
                this.next();
            }
            this.m_source_.setIndex(prevoffset);
        }
        this.updateInternalState();
    }

    public void setText(String source) {
        this.m_srcUtilIter_.setText(source);
        this.m_source_ = this.m_srcUtilIter_;
        this.updateInternalState();
    }

    public void setText(CharacterIterator source) {
        this.m_source_ = source;
        this.m_source_.setIndex(this.m_source_.getBeginIndex());
        this.updateInternalState();
    }

    public boolean equals(Object that) {
        if (that == this) {
            return true;
        }
        if (that instanceof CollationElementIterator) {
            CollationElementIterator thatceiter = (CollationElementIterator)that;
            if (this.m_collator_.equals(thatceiter.m_collator_) && this.m_source_.equals(thatceiter.m_source_)) {
                return true;
            }
        }
        return false;
    }

    CollationElementIterator(String source, RuleBasedCollator collator) {
        this.m_srcUtilIter_ = new StringCharacterIterator(source);
        this.m_utilStringBuffer_ = new StringBuffer();
        this.m_source_ = this.m_srcUtilIter_;
        this.m_collator_ = collator;
        this.m_CEBuffer_ = new int[512];
        this.m_buffer_ = new StringBuffer();
        this.m_utilSpecialBackUp_ = new Backup();
        this.updateInternalState();
    }

    CollationElementIterator(CharacterIterator source, RuleBasedCollator collator) {
        this.m_srcUtilIter_ = new StringCharacterIterator("");
        this.m_utilStringBuffer_ = new StringBuffer();
        this.m_source_ = source;
        this.m_collator_ = collator;
        this.m_CEBuffer_ = new int[512];
        this.m_buffer_ = new StringBuffer();
        this.m_utilSpecialBackUp_ = new Backup();
        this.updateInternalState();
    }

    void setCollator(RuleBasedCollator collator) {
        this.m_collator_ = collator;
        this.updateInternalState();
    }

    void setExactOffset(int offset) {
        this.m_source_.setIndex(offset);
        this.updateInternalState();
    }

    boolean isInBuffer() {
        return this.m_bufferOffset_ > 0;
    }

    static final boolean isThaiPreVowel(char ch) {
        return ch >= '\u0e40' && ch <= '\u0e44' || ch >= '\u0ec0' && ch <= '\u0ec4';
    }

    void setText(CharacterIterator source, int offset) {
        this.m_source_ = source;
        this.m_source_.setIndex(offset);
        this.updateInternalState();
    }

    private void updateInternalState() {
        this.m_isCodePointHiragana_ = false;
        this.m_buffer_.setLength(0);
        this.m_bufferOffset_ = -1;
        this.m_CEBufferOffset_ = 0;
        this.m_CEBufferSize_ = 0;
        this.m_FCDLimit_ = -1;
        this.m_FCDStart_ = this.m_source_.getEndIndex();
        this.m_isHiragana4_ = this.m_collator_.m_isHiragana4_;
        this.m_isForwards_ = true;
    }

    private void backupInternalState(Backup backup) {
        backup.m_offset_ = this.m_source_.getIndex();
        backup.m_FCDLimit_ = this.m_FCDLimit_;
        backup.m_FCDStart_ = this.m_FCDStart_;
        backup.m_isCodePointHiragana_ = this.m_isCodePointHiragana_;
        backup.m_bufferOffset_ = this.m_bufferOffset_;
        backup.m_buffer_.setLength(0);
        if (this.m_bufferOffset_ >= 0) {
            if (ICUDebug.isJDK14OrHigher) {
                backup.m_buffer_.append((Object)this.m_buffer_);
            } else {
                backup.m_buffer_.append(this.m_buffer_.toString());
            }
        }
    }

    private void updateInternalState(Backup backup) {
        this.m_source_.setIndex(backup.m_offset_);
        this.m_isCodePointHiragana_ = backup.m_isCodePointHiragana_;
        this.m_bufferOffset_ = backup.m_bufferOffset_;
        this.m_FCDLimit_ = backup.m_FCDLimit_;
        this.m_FCDStart_ = backup.m_FCDStart_;
        this.m_buffer_.setLength(0);
        if (this.m_bufferOffset_ >= 0) {
            this.m_buffer_.append(backup.m_buffer_.toString());
        }
    }

    private int getCombiningClass(char ch) {
        if (ch >= '\u0300' && this.m_collator_.isUnsafe(ch)) {
            return NormalizerImpl.getCombiningClass(ch);
        }
        return 0;
    }

    private void normalize() {
        int size = this.m_FCDLimit_ - this.m_FCDStart_;
        this.m_buffer_.setLength(0);
        this.m_source_.setIndex(this.m_FCDStart_);
        int i = 0;
        while (i < size) {
            this.m_buffer_.append(this.m_source_.current());
            this.m_source_.next();
            ++i;
        }
        String decomp = Normalizer.decompose(this.m_buffer_.toString(), false);
        this.m_buffer_.setLength(0);
        this.m_buffer_.append(decomp);
        this.m_bufferOffset_ = 0;
    }

    private boolean FCDCheck(char ch, int offset) {
        int prevTrailCC;
        boolean result = true;
        this.m_FCDStart_ = offset;
        this.m_source_.setIndex(offset);
        char fcd = NormalizerImpl.getFCD16(ch);
        if (fcd != '\u0000' && UTF16.isLeadSurrogate(ch)) {
            ch = this.m_source_.next();
            fcd = UTF16.isTrailSurrogate(ch) ? NormalizerImpl.getFCD16FromSurrogatePair(fcd, ch) : (char)'\u0000';
        }
        if ((prevTrailCC = fcd & 0xFF) != 0) {
            while ((ch = this.m_source_.next()) != '\uffff') {
                int leadCC;
                fcd = NormalizerImpl.getFCD16(ch);
                if (fcd != '\u0000' && UTF16.isLeadSurrogate(ch)) {
                    ch = this.m_source_.next();
                    fcd = UTF16.isTrailSurrogate(ch) ? NormalizerImpl.getFCD16FromSurrogatePair(fcd, ch) : (char)'\u0000';
                }
                if ((leadCC = fcd >>> 8) == 0) break;
                if (leadCC < prevTrailCC) {
                    result = false;
                }
                prevTrailCC = fcd & 0xFF;
            }
        }
        this.m_FCDLimit_ = this.m_source_.getIndex();
        this.m_source_.setIndex(this.m_FCDStart_);
        this.m_source_.next();
        return result;
    }

    private char nextChar() {
        char next;
        if (this.m_bufferOffset_ >= 0) {
            if (this.m_bufferOffset_ >= this.m_buffer_.length()) {
                this.m_source_.setIndex(this.m_FCDLimit_);
                this.m_bufferOffset_ = -1;
                this.m_buffer_.setLength(0);
                return this.nextChar();
            }
            return this.m_buffer_.charAt(this.m_bufferOffset_++);
        }
        char result = this.m_source_.current();
        int startoffset = this.m_source_.getIndex();
        if (result < '\u00c0' || this.m_collator_.getDecomposition() == 16 || this.m_bufferOffset_ >= 0 || this.m_FCDLimit_ > startoffset) {
            this.m_source_.next();
            return result;
        }
        if (result < '\u0300' && ((next = this.m_source_.next()) == '\uffff' || next <= '\u0300')) {
            return result;
        }
        if (!this.FCDCheck(result, startoffset)) {
            this.normalize();
            result = this.m_buffer_.charAt(0);
            this.m_bufferOffset_ = 1;
        }
        return result;
    }

    private void normalizeBackwards() {
        this.normalize();
        this.m_bufferOffset_ = this.m_buffer_.length();
    }

    private boolean FCDCheckBackwards(char ch, int offset) {
        boolean result = true;
        char fcd = '\u0000';
        this.m_FCDLimit_ = offset + 1;
        this.m_source_.setIndex(offset);
        if (!UTF16.isSurrogate(ch)) {
            fcd = NormalizerImpl.getFCD16(ch);
        } else if (UTF16.isTrailSurrogate(ch) && this.m_FCDLimit_ > 0) {
            char trailch = ch;
            ch = this.m_source_.previous();
            if (UTF16.isLeadSurrogate(ch)) {
                fcd = NormalizerImpl.getFCD16(ch);
                if (fcd != '\u0000') {
                    fcd = NormalizerImpl.getFCD16FromSurrogatePair(fcd, trailch);
                }
            } else {
                fcd = '\u0000';
            }
        }
        int leadCC = fcd >>> 8;
        while (leadCC != 0) {
            offset = this.m_source_.getIndex();
            if (offset == 0) break;
            ch = this.m_source_.previous();
            if (!UTF16.isSurrogate(ch)) {
                fcd = NormalizerImpl.getFCD16(ch);
            } else if (UTF16.isTrailSurrogate(ch) && this.m_source_.getIndex() > 0) {
                char trail = ch;
                ch = this.m_source_.previous();
                if (UTF16.isLeadSurrogate(ch)) {
                    fcd = NormalizerImpl.getFCD16(ch);
                }
                if (fcd != '\u0000') {
                    fcd = NormalizerImpl.getFCD16FromSurrogatePair(fcd, trail);
                }
            } else {
                fcd = '\u0000';
            }
            int prevTrailCC = fcd & 0xFF;
            if (leadCC < prevTrailCC) {
                result = false;
            }
            leadCC = fcd >>> 8;
        }
        this.m_FCDStart_ = fcd == '\u0000' ? offset : this.m_source_.getIndex();
        this.m_source_.setIndex(this.m_FCDLimit_);
        return result;
    }

    private char previousChar() {
        if (this.m_bufferOffset_ >= 0) {
            --this.m_bufferOffset_;
            if (this.m_bufferOffset_ >= 0) {
                return this.m_buffer_.charAt(this.m_bufferOffset_);
            }
            this.m_buffer_.setLength(0);
            if (this.m_FCDStart_ == this.m_source_.getBeginIndex()) {
                this.m_FCDStart_ = -1;
                this.m_source_.setIndex(this.m_source_.getBeginIndex());
                return '\uffff';
            }
            this.m_FCDLimit_ = this.m_FCDStart_;
            this.m_source_.setIndex(this.m_FCDStart_);
            return this.previousChar();
        }
        char result = this.m_source_.previous();
        int startoffset = this.m_source_.getIndex();
        if (result < '\u0300' || this.m_collator_.getDecomposition() == 16 || this.m_FCDStart_ <= startoffset || this.m_source_.getIndex() == 0) {
            return result;
        }
        char ch = this.m_source_.previous();
        if (ch < '\u00c0') {
            this.m_source_.next();
            return result;
        }
        if (!this.FCDCheckBackwards(result, startoffset)) {
            this.normalizeBackwards();
            --this.m_bufferOffset_;
            result = this.m_buffer_.charAt(this.m_bufferOffset_);
        } else {
            this.m_source_.setIndex(startoffset);
        }
        return result;
    }

    private final boolean isBackwardsStart() {
        return this.m_bufferOffset_ < 0 && this.m_source_.getIndex() == 0 || this.m_bufferOffset_ == 0 && this.m_FCDStart_ <= 0;
    }

    private final boolean isEnd() {
        if (this.m_bufferOffset_ >= 0) {
            if (this.m_bufferOffset_ != this.m_buffer_.length()) {
                return false;
            }
            return this.m_FCDLimit_ == this.m_source_.getEndIndex();
        }
        return this.m_source_.getEndIndex() == this.m_source_.getIndex();
    }

    private final int nextSurrogate(RuleBasedCollator collator, int ce, char trail) {
        if (!UTF16.isTrailSurrogate(trail)) {
            this.updateInternalState(this.m_utilSpecialBackUp_);
            return 0;
        }
        int result = collator.m_trie_.getTrailValue(ce, trail);
        if (result == -268435456) {
            this.updateInternalState(this.m_utilSpecialBackUp_);
        }
        return result;
    }

    private int getExpansionOffset(RuleBasedCollator collator, int ce) {
        return ((ce & 0xFFFFF0) >> 4) - collator.m_expansionOffset_;
    }

    private int nextThai(RuleBasedCollator collator, int ce, char ch) {
        if (this.m_bufferOffset_ != -1 || this.isEnd()) {
            return collator.m_expansion_[this.getExpansionOffset(collator, ce)];
        }
        this.m_buffer_.append(this.nextChar());
        this.m_buffer_.append(ch);
        this.m_FCDLimit_ = this.m_source_.getIndex();
        this.m_FCDStart_ = this.m_FCDLimit_ - 2;
        this.m_bufferOffset_ = 0;
        return 0;
    }

    private int getContractionOffset(RuleBasedCollator collator, int ce) {
        return (ce & 0xFFFFFF) - collator.m_contractionOffset_;
    }

    private boolean isSpecialPrefixTag(int ce) {
        return RuleBasedCollator.isSpecial(ce) && RuleBasedCollator.getTag(ce) == 11;
    }

    private int nextSpecialPrefix(RuleBasedCollator collator, int ce, Backup entrybackup) {
        this.backupInternalState(this.m_utilSpecialBackUp_);
        this.updateInternalState(entrybackup);
        this.previousChar();
        while (true) {
            int entryoffset;
            int offset = entryoffset = this.getContractionOffset(collator, ce);
            if (this.isBackwardsStart()) {
                ce = collator.m_contractionCE_[offset];
                break;
            }
            char previous = this.previousChar();
            while (previous > collator.m_contractionIndex_[offset]) {
                ++offset;
            }
            if (previous == collator.m_contractionIndex_[offset]) {
                ce = collator.m_contractionCE_[offset];
            } else {
                int isZeroCE = collator.m_trie_.getLeadValue(previous);
                if (isZeroCE == 0) continue;
                if (UTF16.isSurrogate(previous)) {
                    if (this.isBackwardsStart()) continue;
                    char lead = this.previousChar();
                    if (UTF16.isLeadSurrogate(lead)) {
                        int finalCE;
                        isZeroCE = collator.m_trie_.getLeadValue(lead);
                        if (RuleBasedCollator.getTag(isZeroCE) == 5 && (finalCE = collator.m_trie_.getTrailValue(isZeroCE, previous)) == 0) {
                            continue;
                        }
                    } else {
                        this.nextChar();
                        continue;
                    }
                    this.nextChar();
                }
                ce = collator.m_contractionCE_[entryoffset];
            }
            if (!this.isSpecialPrefixTag(ce)) break;
        }
        if (ce != -268435456) {
            this.updateInternalState(this.m_utilSpecialBackUp_);
        } else {
            this.updateInternalState(entrybackup);
        }
        return ce;
    }

    private boolean isContractionTag(int ce) {
        return RuleBasedCollator.isSpecial(ce) && RuleBasedCollator.getTag(ce) == 2;
    }

    private void setDiscontiguous(StringBuffer skipped) {
        if (this.m_bufferOffset_ >= 0) {
            this.m_buffer_.replace(0, this.m_bufferOffset_, skipped.toString());
        } else {
            this.m_FCDLimit_ = this.m_source_.getIndex();
            this.m_buffer_.setLength(0);
            this.m_buffer_.append(skipped.toString());
        }
        this.m_bufferOffset_ = 0;
    }

    private char currentChar() {
        if (this.m_bufferOffset_ < 0) {
            char result = this.m_source_.previous();
            this.m_source_.next();
            return result;
        }
        return this.m_buffer_.charAt(this.m_bufferOffset_ - 1);
    }

    private int nextDiscontiguous(RuleBasedCollator collator, int entryoffset) {
        block9: {
            int ce;
            int offset = entryoffset;
            boolean multicontraction = false;
            if (this.m_utilSkippedBuffer_ == null) {
                this.m_utilSkippedBuffer_ = new StringBuffer();
            } else {
                this.m_utilSkippedBuffer_.setLength(0);
            }
            char ch = this.currentChar();
            this.m_utilSkippedBuffer_.append(this.currentChar());
            if (this.m_utilSpecialDiscontiguousBackUp_ == null) {
                this.m_utilSpecialDiscontiguousBackUp_ = new Backup();
            }
            this.backupInternalState(this.m_utilSpecialDiscontiguousBackUp_);
            char nextch = ch;
            while (true) {
                ch = nextch;
                nextch = this.nextChar();
                if (nextch == '\uffff' || this.getCombiningClass(nextch) == 0) {
                    if (multicontraction) {
                        if (nextch != '\uffff') {
                            this.previousChar();
                        }
                        this.setDiscontiguous(this.m_utilSkippedBuffer_);
                        return collator.m_contractionCE_[offset];
                    }
                    break block9;
                }
                ++offset;
                while (nextch > collator.m_contractionIndex_[offset]) {
                    ++offset;
                }
                ce = -268435456;
                if (nextch != collator.m_contractionIndex_[offset] || this.getCombiningClass(nextch) == this.getCombiningClass(ch)) {
                    this.m_utilSkippedBuffer_.append(nextch);
                    continue;
                }
                ce = collator.m_contractionCE_[offset];
                if (ce == -268435456) break block9;
                if (!this.isContractionTag(ce)) break;
                offset = this.getContractionOffset(collator, ce);
                if (collator.m_contractionCE_[offset] == -268435456) continue;
                multicontraction = true;
                this.backupInternalState(this.m_utilSpecialDiscontiguousBackUp_);
            }
            this.setDiscontiguous(this.m_utilSkippedBuffer_);
            return ce;
        }
        this.updateInternalState(this.m_utilSpecialDiscontiguousBackUp_);
        this.previousChar();
        return collator.m_contractionCE_[entryoffset];
    }

    private int nextContraction(RuleBasedCollator collator, int ce) {
        this.backupInternalState(this.m_utilSpecialBackUp_);
        int entryce = -268435456;
        while (true) {
            int entryoffset;
            int offset = entryoffset = this.getContractionOffset(collator, ce);
            if (this.isEnd()) {
                ce = collator.m_contractionCE_[offset];
                if (ce != -268435456) break;
                ce = entryce;
                this.updateInternalState(this.m_utilSpecialBackUp_);
                break;
            }
            byte maxCC = (byte)(collator.m_contractionIndex_[offset] & 0xFF);
            byte allSame = (byte)(collator.m_contractionIndex_[offset] >> 8);
            char ch = this.nextChar();
            ++offset;
            while (ch > collator.m_contractionIndex_[offset]) {
                ++offset;
            }
            if (ch == collator.m_contractionIndex_[offset]) {
                ce = collator.m_contractionCE_[offset];
            } else {
                byte sCC;
                int isZeroCE = collator.m_trie_.getLeadValue(ch);
                if (isZeroCE == 0) continue;
                if (UTF16.isLeadSurrogate(ch)) {
                    if (this.isEnd()) continue;
                    this.backupInternalState(this.m_utilSpecialBackUp_);
                    char trail = this.nextChar();
                    if (UTF16.isTrailSurrogate(trail)) {
                        int finalCE;
                        if (RuleBasedCollator.getTag(isZeroCE) == 5 && (finalCE = collator.m_trie_.getTrailValue(isZeroCE, trail)) == 0) {
                            continue;
                        }
                    } else {
                        this.updateInternalState(this.m_utilSpecialBackUp_);
                        continue;
                    }
                    this.updateInternalState(this.m_utilSpecialBackUp_);
                }
                if (maxCC == 0 || (sCC = (byte)this.getCombiningClass(ch)) == 0 || sCC > maxCC || allSame != 0 && sCC == maxCC || this.isEnd()) {
                    this.previousChar();
                    ce = collator.m_contractionCE_[entryoffset];
                } else {
                    char nextch = this.nextChar();
                    if (nextch != '\uffff') {
                        this.previousChar();
                    }
                    if (this.getCombiningClass(nextch) == 0) {
                        this.previousChar();
                        ce = collator.m_contractionCE_[entryoffset];
                    } else {
                        ce = this.nextDiscontiguous(collator, entryoffset);
                    }
                }
            }
            if (ce == -268435456) {
                this.updateInternalState(this.m_utilSpecialBackUp_);
                ce = entryce;
                break;
            }
            if (!this.isContractionTag(ce)) break;
            if (collator.m_contractionCE_[entryoffset] == -268435456) continue;
            entryce = collator.m_contractionCE_[entryoffset];
            this.backupInternalState(this.m_utilSpecialBackUp_);
            if (this.m_utilSpecialBackUp_.m_bufferOffset_ >= 0) {
                --this.m_utilSpecialBackUp_.m_bufferOffset_;
                continue;
            }
            --this.m_utilSpecialBackUp_.m_offset_;
        }
        return ce;
    }

    private int nextLongPrimary(int ce) {
        this.m_CEBuffer_[1] = (ce & 0xFF) << 24 | 0xC0;
        this.m_CEBufferOffset_ = 1;
        this.m_CEBufferSize_ = 2;
        this.m_CEBuffer_[0] = (ce & 0xFFFF00) << 8 | 0x500 | 5;
        return this.m_CEBuffer_[0];
    }

    private int getExpansionCount(int ce) {
        return ce & 0xF;
    }

    private int nextExpansion(RuleBasedCollator collator, int ce) {
        int offset = this.getExpansionOffset(collator, ce);
        this.m_CEBufferSize_ = this.getExpansionCount(ce);
        this.m_CEBufferOffset_ = 1;
        this.m_CEBuffer_[0] = collator.m_expansion_[offset];
        if (this.m_CEBufferSize_ != 0) {
            int i = 1;
            while (i < this.m_CEBufferSize_) {
                this.m_CEBuffer_[i] = collator.m_expansion_[offset + i];
                ++i;
            }
        } else {
            this.m_CEBufferSize_ = 1;
            while (collator.m_expansion_[offset] != 0) {
                this.m_CEBuffer_[this.m_CEBufferSize_++] = collator.m_expansion_[++offset];
            }
        }
        return this.m_CEBuffer_[0];
    }

    private int nextImplicit(int codepoint) {
        if (!UCharacter.isLegal(codepoint)) {
            return 0;
        }
        int result = CollationElementIterator.getImplicitPrimary(codepoint);
        this.m_CEBuffer_[0] = result & 0xFFFF0000 | 0x505;
        this.m_CEBuffer_[1] = (result & 0xFFFF) << 16 | 0xC0;
        this.m_CEBufferOffset_ = 1;
        this.m_CEBufferSize_ = 2;
        return this.m_CEBuffer_[0];
    }

    private int nextSurrogate(char ch) {
        char nextch = this.nextChar();
        if (nextch != '\uffff' && UTF16.isTrailSurrogate(nextch)) {
            int codepoint = UCharacterProperty.getRawSupplementary(ch, nextch);
            return this.nextImplicit(codepoint);
        }
        if (nextch != '\uffff') {
            this.previousChar();
        }
        return 0;
    }

    private int nextHangul(RuleBasedCollator collator, char ch) {
        char L = (char)(ch - 44032);
        char T = (char)(L % 28);
        L = (char)(L / 28);
        char V = (char)(L % 21);
        L = (char)(L / 21);
        L = (char)(L + 4352);
        V = (char)(V + 4449);
        T = (char)(T + 4519);
        this.m_CEBufferSize_ = 0;
        if (!collator.m_isJamoSpecial_) {
            this.m_CEBuffer_[this.m_CEBufferSize_++] = collator.m_trie_.getLeadValue(L);
            this.m_CEBuffer_[this.m_CEBufferSize_++] = collator.m_trie_.getLeadValue(V);
            if (T != '\u11a7') {
                this.m_CEBuffer_[this.m_CEBufferSize_++] = collator.m_trie_.getLeadValue(T);
            }
            this.m_CEBufferOffset_ = 1;
            return this.m_CEBuffer_[0];
        }
        this.m_buffer_.append(L);
        this.m_buffer_.append(V);
        if (T != '\u11a7') {
            this.m_buffer_.append(T);
        }
        this.m_FCDLimit_ = this.m_source_.getIndex();
        this.m_FCDStart_ = this.m_FCDLimit_ - 1;
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int nextSpecial(RuleBasedCollator collator, int ce, char ch) {
        Backup entrybackup;
        block31: {
            int n;
            block30: {
                int n2;
                block29: {
                    int n4;
                    block28: {
                        int n5;
                        block27: {
                            int n6;
                            block26: {
                                int n7;
                                block25: {
                                    int n8;
                                    block24: {
                                        int n9;
                                        block23: {
                                            int n10;
                                            block22: {
                                                int codepoint = ch;
                                                entrybackup = this.m_utilSpecialEntryBackUp_;
                                                if (entrybackup != null) {
                                                    this.m_utilSpecialEntryBackUp_ = null;
                                                } else {
                                                    entrybackup = new Backup();
                                                }
                                                this.backupInternalState(entrybackup);
                                                try {
                                                    do {
                                                        switch (RuleBasedCollator.getTag(ce)) {
                                                            case 0: {
                                                                int n11 = ce;
                                                                Object var17_8 = null;
                                                                this.m_utilSpecialEntryBackUp_ = entrybackup;
                                                                return n11;
                                                            }
                                                            case 5: {
                                                                if (this.isEnd()) {
                                                                    n10 = 0;
                                                                    break block22;
                                                                } else {
                                                                    this.backupInternalState(this.m_utilSpecialBackUp_);
                                                                    char trail = this.nextChar();
                                                                    ce = this.nextSurrogate(collator, ce, trail);
                                                                    codepoint = UCharacterProperty.getRawSupplementary((char)ch, trail);
                                                                    break;
                                                                }
                                                            }
                                                            case 3: {
                                                                ce = this.nextThai(collator, ce, (char)ch);
                                                                break;
                                                            }
                                                            case 11: {
                                                                ce = this.nextSpecialPrefix(collator, ce, entrybackup);
                                                                break;
                                                            }
                                                            case 2: {
                                                                ce = this.nextContraction(collator, ce);
                                                                break;
                                                            }
                                                            case 12: {
                                                                n9 = this.nextLongPrimary(ce);
                                                                break block23;
                                                            }
                                                            case 1: {
                                                                n8 = this.nextExpansion(collator, ce);
                                                                break block24;
                                                            }
                                                            case 9: {
                                                                n7 = this.nextImplicit(codepoint);
                                                                break block25;
                                                            }
                                                            case 10: {
                                                                n6 = this.nextImplicit(codepoint);
                                                                break block26;
                                                            }
                                                            case 8: {
                                                                n5 = 0;
                                                                break block27;
                                                            }
                                                            case 7: {
                                                                n4 = this.nextSurrogate((char)ch);
                                                                break block28;
                                                            }
                                                            case 6: {
                                                                n2 = this.nextHangul(collator, (char)ch);
                                                                break block29;
                                                            }
                                                            case 4: {
                                                                n = -268435456;
                                                                break block30;
                                                            }
                                                            default: {
                                                                ce = 0;
                                                            }
                                                        }
                                                    } while (RuleBasedCollator.isSpecial(ce));
                                                    break block31;
                                                }
                                                catch (Throwable throwable) {
                                                    Object var17_19 = null;
                                                    this.m_utilSpecialEntryBackUp_ = entrybackup;
                                                    throw throwable;
                                                }
                                            }
                                            Object var17_9 = null;
                                            this.m_utilSpecialEntryBackUp_ = entrybackup;
                                            return n10;
                                        }
                                        Object var17_10 = null;
                                        this.m_utilSpecialEntryBackUp_ = entrybackup;
                                        return n9;
                                    }
                                    Object var17_11 = null;
                                    this.m_utilSpecialEntryBackUp_ = entrybackup;
                                    return n8;
                                }
                                Object var17_12 = null;
                                this.m_utilSpecialEntryBackUp_ = entrybackup;
                                return n7;
                            }
                            Object var17_13 = null;
                            this.m_utilSpecialEntryBackUp_ = entrybackup;
                            return n6;
                        }
                        Object var17_14 = null;
                        this.m_utilSpecialEntryBackUp_ = entrybackup;
                        return n5;
                    }
                    Object var17_15 = null;
                    this.m_utilSpecialEntryBackUp_ = entrybackup;
                    return n4;
                }
                Object var17_16 = null;
                this.m_utilSpecialEntryBackUp_ = entrybackup;
                return n2;
            }
            Object var17_17 = null;
            this.m_utilSpecialEntryBackUp_ = entrybackup;
            return n;
        }
        Object var17_18 = null;
        this.m_utilSpecialEntryBackUp_ = entrybackup;
        return ce;
    }

    private int previousThai(RuleBasedCollator collator, int ce, char ch) {
        if (this.m_bufferOffset_ >= 0 || this.m_source_.getIndex() == 0) {
            return collator.m_expansion_[this.getExpansionOffset(collator, ce)];
        }
        char prevch = this.previousChar();
        if (!CollationElementIterator.isThaiPreVowel(prevch)) {
            if (prevch != '\uffff') {
                this.nextChar();
            }
            return collator.m_expansion_[this.getExpansionOffset(collator, ce)];
        }
        this.m_buffer_.append(ch);
        this.m_buffer_.append(prevch);
        this.m_bufferOffset_ = 2;
        if (this.m_source_.getIndex() == 0) {
            this.m_FCDStart_ = 0;
            this.m_FCDLimit_ = 2;
        } else {
            this.m_FCDStart_ = this.m_source_.getIndex();
            this.m_FCDLimit_ = this.m_FCDStart_ + 2;
        }
        return 0;
    }

    private int previousSpecialPrefix(RuleBasedCollator collator, int ce) {
        this.backupInternalState(this.m_utilSpecialBackUp_);
        while (true) {
            int offset;
            int entryoffset = offset = this.getContractionOffset(collator, ce);
            if (this.isBackwardsStart()) {
                ce = collator.m_contractionCE_[offset];
                break;
            }
            char prevch = this.previousChar();
            while (prevch > collator.m_contractionIndex_[offset]) {
                ++offset;
            }
            if (prevch == collator.m_contractionIndex_[offset]) {
                ce = collator.m_contractionCE_[offset];
            } else {
                int isZeroCE = collator.m_trie_.getLeadValue(prevch);
                if (isZeroCE == 0) continue;
                if (UTF16.isTrailSurrogate(prevch) || UTF16.isLeadSurrogate(prevch)) {
                    if (this.isBackwardsStart()) continue;
                    char lead = this.previousChar();
                    if (UTF16.isLeadSurrogate(lead)) {
                        int finalCE;
                        isZeroCE = collator.m_trie_.getLeadValue(lead);
                        if (RuleBasedCollator.getTag(isZeroCE) == 5 && (finalCE = collator.m_trie_.getTrailValue(isZeroCE & 0xFFFFFF, prevch)) == 0) {
                            continue;
                        }
                    } else {
                        this.nextChar();
                        continue;
                    }
                    this.nextChar();
                }
                ce = collator.m_contractionCE_[entryoffset];
            }
            if (!this.isSpecialPrefixTag(ce)) break;
        }
        this.updateInternalState(this.m_utilSpecialBackUp_);
        return ce;
    }

    private int previousContraction(RuleBasedCollator collator, int ce, char ch) {
        this.m_utilStringBuffer_.setLength(0);
        while (collator.isUnsafe(ch)) {
            this.m_utilStringBuffer_.insert(0, ch);
            ch = this.previousChar();
            if (this.isBackwardsStart()) break;
        }
        this.m_utilStringBuffer_.insert(0, ch);
        int originaldecomp = collator.getDecomposition();
        collator.setDecomposition(16);
        if (this.m_utilColEIter_ == null) {
            this.m_utilColEIter_ = new CollationElementIterator(this.m_utilStringBuffer_.toString(), collator);
        } else {
            this.m_utilColEIter_.m_collator_ = collator;
            this.m_utilColEIter_.setText(this.m_utilStringBuffer_.toString());
        }
        ce = this.m_utilColEIter_.next();
        this.m_CEBufferSize_ = 0;
        while (ce != -1) {
            if (this.m_CEBufferSize_ == this.m_CEBuffer_.length) {
                try {
                    int[] tempbuffer = new int[this.m_CEBuffer_.length + 50];
                    System.arraycopy(this.m_CEBuffer_, 0, tempbuffer, 0, this.m_CEBuffer_.length);
                    this.m_CEBuffer_ = tempbuffer;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return -1;
                }
            }
            this.m_CEBuffer_[this.m_CEBufferSize_++] = ce;
            ce = this.m_utilColEIter_.next();
        }
        collator.setDecomposition(originaldecomp);
        this.m_CEBufferOffset_ = this.m_CEBufferSize_ - 1;
        return this.m_CEBuffer_[this.m_CEBufferOffset_];
    }

    private int previousLongPrimary(int ce) {
        this.m_CEBufferSize_ = 0;
        this.m_CEBuffer_[this.m_CEBufferSize_++] = (ce & 0xFFFF00) << 8 | 0x500 | 5;
        this.m_CEBuffer_[this.m_CEBufferSize_++] = (ce & 0xFF) << 24 | 0xC0;
        this.m_CEBufferOffset_ = this.m_CEBufferSize_ - 1;
        return this.m_CEBuffer_[this.m_CEBufferOffset_];
    }

    /*
     * Unable to fully structure code
     */
    private int previousExpansion(RuleBasedCollator collator, int ce) {
        block2: {
            offset = this.getExpansionOffset(collator, ce);
            this.m_CEBufferSize_ = this.getExpansionCount(ce);
            if (this.m_CEBufferSize_ == 0) ** GOTO lbl12
            i = 0;
            while (i < this.m_CEBufferSize_) {
                this.m_CEBuffer_[i] = collator.m_expansion_[offset + i];
                ++i;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                this.m_CEBuffer_[this.m_CEBufferSize_] = collator.m_expansion_[offset + this.m_CEBufferSize_];
                ++this.m_CEBufferSize_;
lbl12:
                // 2 sources

                ** while (collator.m_expansion_[offset + this.m_CEBufferSize_] != 0)
            }
        }
        this.m_CEBufferOffset_ = this.m_CEBufferSize_ - 1;
        return this.m_CEBuffer_[this.m_CEBufferOffset_];
    }

    private int previousHangul(RuleBasedCollator collator, char ch) {
        char L = (char)(ch - 44032);
        char T = (char)(L % 28);
        L = (char)(L / 28);
        char V = (char)(L % 21);
        L = (char)(L / 21);
        L = (char)(L + 4352);
        V = (char)(V + 4449);
        T = (char)(T + 4519);
        this.m_CEBufferSize_ = 0;
        if (!collator.m_isJamoSpecial_) {
            this.m_CEBuffer_[this.m_CEBufferSize_++] = collator.m_trie_.getLeadValue(L);
            this.m_CEBuffer_[this.m_CEBufferSize_++] = collator.m_trie_.getLeadValue(V);
            if (T != '\u11a7') {
                this.m_CEBuffer_[this.m_CEBufferSize_++] = collator.m_trie_.getLeadValue(T);
            }
            this.m_CEBufferOffset_ = this.m_CEBufferSize_ - 1;
            return this.m_CEBuffer_[this.m_CEBufferOffset_];
        }
        this.m_buffer_.append(L);
        this.m_buffer_.append(V);
        if (T != '\u11a7') {
            this.m_buffer_.append(T);
        }
        this.m_FCDStart_ = this.m_source_.getIndex();
        this.m_FCDLimit_ = this.m_FCDStart_ + 1;
        return 0;
    }

    private int previousImplicit(int codepoint) {
        if (!UCharacter.isLegal(codepoint)) {
            return 0;
        }
        int result = CollationElementIterator.getImplicitPrimary(codepoint);
        this.m_CEBufferSize_ = 2;
        this.m_CEBufferOffset_ = 1;
        this.m_CEBuffer_[0] = result & 0xFFFF0000 | 0x505;
        this.m_CEBuffer_[1] = (result & 0xFFFF) << 16 | 0xC0;
        return this.m_CEBuffer_[1];
    }

    private int previousSurrogate(char ch) {
        if (this.isBackwardsStart()) {
            return 0;
        }
        char prevch = this.previousChar();
        if (UTF16.isLeadSurrogate(prevch)) {
            return this.previousImplicit(UCharacterProperty.getRawSupplementary(prevch, ch));
        }
        if (prevch != '\uffff') {
            this.nextChar();
        }
        return 0;
    }

    private int previousSpecial(RuleBasedCollator collator, int ce, char ch) {
        do {
            switch (RuleBasedCollator.getTag(ce)) {
                case 0: {
                    return ce;
                }
                case 5: {
                    return 0;
                }
                case 3: {
                    ce = this.previousThai(collator, ce, ch);
                    break;
                }
                case 11: {
                    ce = this.previousSpecialPrefix(collator, ce);
                    break;
                }
                case 2: {
                    if (this.isBackwardsStart()) {
                        ce = collator.m_contractionCE_[this.getContractionOffset(collator, ce)];
                        break;
                    }
                    return this.previousContraction(collator, ce, ch);
                }
                case 12: {
                    return this.previousLongPrimary(ce);
                }
                case 1: {
                    return this.previousExpansion(collator, ce);
                }
                case 6: {
                    return this.previousHangul(collator, ch);
                }
                case 7: {
                    return 0;
                }
                case 8: {
                    return this.previousSurrogate(ch);
                }
                case 9: {
                    return this.previousImplicit(ch);
                }
                case 10: {
                    return this.previousImplicit(ch);
                }
                case 4: {
                    return -268435456;
                }
                default: {
                    ce = 0;
                }
            }
        } while (RuleBasedCollator.isSpecial(ce));
        return ce;
    }

    private static final int getImplicitPrimary(int cp) {
        int last0 = (cp = CollationElementIterator.swapCJK(cp)) - RuleBasedCollator.IMPLICIT_4BYTE_BOUNDARY_;
        if (last0 < 0) {
            int last1 = cp / 126;
            last0 = cp % 126;
            int last2 = last1 / 253;
            return RuleBasedCollator.IMPLICIT_BASE_3BYTE_ + (last2 << 24) + ((last1 %= 253) << 16) + (last0 * RuleBasedCollator.LAST_MULTIPLIER_ << 8);
        }
        int last1 = last0 / 12;
        int last2 = last1 / 253;
        int last3 = last2 / 253;
        return RuleBasedCollator.IMPLICIT_BASE_4BYTE_ + (last3 << 24) + ((last2 %= 253) << 16) + ((last1 %= 253) << 8) + (last0 %= 12) * RuleBasedCollator.LAST2_MULTIPLIER_;
    }

    private static final int swapCJK(int cp) {
        if (cp >= 19968) {
            if (cp < 40960) {
                return cp - 19968;
            }
            if (cp < 64014) {
                return cp + 0x110000;
            }
            if (cp < 64048) {
                return cp - 64014 + 20992;
            }
            if (cp < 131072) {
                return cp + 0x110000;
            }
            if (cp < 173792) {
                return cp;
            }
            return cp + 0x110000;
        }
        if (cp < 13312) {
            return cp + 0x110000;
        }
        if (cp < 19904) {
            return cp - 13312 + 20992 + 34;
        }
        return cp + 0x110000;
    }

    private static final class Backup {
        protected int m_FCDLimit_;
        protected int m_FCDStart_;
        protected boolean m_isCodePointHiragana_;
        protected int m_bufferOffset_;
        protected int m_offset_;
        protected StringBuffer m_buffer_ = new StringBuffer();

        protected Backup() {
        }
    }
}

