/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.iterator.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.ResourceUtils;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;

public class TestResourceUtils
extends TestCase {
    public static final String NS = "http://jena.hp.com/test#";

    public TestResourceUtils(String string) {
        super(string);
    }

    public void testMaximalLowerElements() {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("http://jena.hp.com/test#a");
        Resource resource2 = model.createResource("http://jena.hp.com/test#b");
        Resource resource3 = model.createResource("http://jena.hp.com/test#c");
        Resource resource4 = model.createResource("http://jena.hp.com/test#d");
        resource2.addProperty(RDFS.subClassOf, resource);
        resource3.addProperty(RDFS.subClassOf, resource);
        resource4.addProperty(RDFS.subClassOf, resource3);
        resource4.addProperty(RDFS.subClassOf, resource);
        List<Object> list = Arrays.asList(resource, resource2, resource3, resource4);
        List<Object> list2 = Arrays.asList(resource2, resource3, resource4);
        List<Object> list3 = Arrays.asList(resource3, resource4);
        TestResourceUtils.assertEquals("Wrong number of remaining resources", 1, ResourceUtils.maximalLowerElements(list, RDFS.subClassOf, true).size());
        TestResourceUtils.assertEquals("Result should be a", resource, ResourceUtils.maximalLowerElements(list, RDFS.subClassOf, true).iterator().next());
        TestResourceUtils.assertEquals("Wrong number of remaining resources", 2, ResourceUtils.maximalLowerElements(list2, RDFS.subClassOf, true).size());
        TestResourceUtils.assertEquals("Wrong number of remaining resources", 1, ResourceUtils.maximalLowerElements(list3, RDFS.subClassOf, true).size());
        TestResourceUtils.assertEquals("Result should be a", resource3, ResourceUtils.maximalLowerElements(list3, RDFS.subClassOf, true).iterator().next());
    }

    public void testRenameResource() {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("http://jena.hp.com/test#a");
        Resource resource2 = model.createResource("http://jena.hp.com/test#b");
        Resource resource3 = model.createResource("http://jena.hp.com/test#c");
        Resource resource4 = model.createResource("http://jena.hp.com/test#d");
        Property property = model.createProperty(NS, "p");
        Property property2 = model.createProperty(NS, "q");
        resource.addProperty(property, resource2);
        resource.addProperty(property2, resource3);
        resource4.addProperty(property, resource);
        resource4.addProperty(property, resource2);
        Resource resource5 = ResourceUtils.renameResource(resource, "http://jena.hp.com/test#e");
        TestResourceUtils.assertTrue("should be no properties of a", !resource.listProperties().hasNext());
        TestResourceUtils.assertEquals("uri of a", "http://jena.hp.com/test#a", resource.getURI());
        TestResourceUtils.assertEquals("uri of e", "http://jena.hp.com/test#e", resource5.getURI());
        TestResourceUtils.assertTrue("d should not have p a", !resource4.hasProperty(property, resource));
        TestResourceUtils.assertTrue("d should have p e", resource4.hasProperty(property, resource5));
        TestResourceUtils.assertTrue("e should have p b", resource5.hasProperty(property, resource2));
        TestResourceUtils.assertTrue("e should have q c", resource5.hasProperty(property2, resource3));
        TestResourceUtils.assertTrue("d p b should be unchanged", resource4.hasProperty(property, resource2));
        Resource resource6 = ResourceUtils.renameResource(resource5, null);
        TestResourceUtils.assertTrue("should be no properties of e", !resource5.listProperties().hasNext());
        TestResourceUtils.assertEquals("uri of e", "http://jena.hp.com/test#e", resource5.getURI());
        TestResourceUtils.assertTrue("anon", resource6.isAnon());
        TestResourceUtils.assertTrue("d should not have p e", !resource4.hasProperty(property, resource5));
        TestResourceUtils.assertTrue("d should have p anon", resource4.hasProperty(property, resource6));
        TestResourceUtils.assertTrue("anon should have p b", resource6.hasProperty(property, resource2));
        TestResourceUtils.assertTrue("anon should have q c", resource6.hasProperty(property2, resource3));
        TestResourceUtils.assertTrue("d p b should be unchanged", resource4.hasProperty(property, resource2));
        Resource resource7 = model.createResource("http://jena.hp.com/test#f");
        resource7.addProperty(property, resource7);
        Resource resource8 = ResourceUtils.renameResource(resource7, "http://jena.hp.com/test#f1");
        TestResourceUtils.assertFalse("Should be no f statements", model.listStatements(resource7, null, (RDFNode)null).hasNext());
        TestResourceUtils.assertTrue("f1 has p f1", resource8.hasProperty(property, resource8));
    }
}

