/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.test;

import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.shared.PrefixMapping;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractTestPrefixMapping
extends GraphTestBase {
    static final String crispURI = "http://crisp.nosuch.net/";
    static final String ropeURI = "scheme:rope/string#";
    static final String butterURI = "ftp://ftp.nowhere.at.all/cream#";
    static final String[] badNames = new String[]{"<hello>", "foo:bar", "with a space", "-argument"};
    static final String[] dontChange = new String[]{"", "http://www.somedomain.something/whatever#", "crispy:cabbage", "cris:isOnInfiniteEarths", "rop:tangled/web", "roped:abseiling"};
    static final String[][] expansions = new String[][]{{"crisp:pathPart", "http://crisp.nosuch.net/pathPart"}, {"rope:partPath", "scheme:rope/string#partPath"}, {"crisp:path:part", "http://crisp.nosuch.net/path:part"}};

    public AbstractTestPrefixMapping(String string) {
        super(string);
    }

    protected abstract PrefixMapping getMapping();

    public void testCheckNames() {
        PrefixMapping prefixMapping = this.getMapping();
        for (int i = 0; i < badNames.length; ++i) {
            String string = badNames[i];
            try {
                prefixMapping.setNsPrefix(string, crispURI);
                AbstractTestPrefixMapping.fail("'" + string + "' is an illegal prefix and should be trapped");
                continue;
            }
            catch (PrefixMapping.IllegalPrefixException illegalPrefixException) {
                // empty catch block
            }
        }
    }

    public void testPrefixMappingMapping() {
        String string = "ftp://ftp.nowhere.not/";
        AbstractTestPrefixMapping.assertDiffer("crisp and toast must differ", crispURI, string);
        PrefixMapping prefixMapping = this.getMapping();
        AbstractTestPrefixMapping.assertEquals("crisp should be unset", null, prefixMapping.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals("toast should be unset", null, prefixMapping.getNsPrefixURI("toast"));
        AbstractTestPrefixMapping.assertEquals("butter should be unset", null, prefixMapping.getNsPrefixURI("butter"));
        prefixMapping.setNsPrefix("crisp", crispURI);
        AbstractTestPrefixMapping.assertEquals("crisp should be set", crispURI, prefixMapping.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals("toast should still be unset", null, prefixMapping.getNsPrefixURI("toast"));
        AbstractTestPrefixMapping.assertEquals("butter should still be unset", null, prefixMapping.getNsPrefixURI("butter"));
        prefixMapping.setNsPrefix("toast", string);
        AbstractTestPrefixMapping.assertEquals("crisp should be set", crispURI, prefixMapping.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals("toast should be set", string, prefixMapping.getNsPrefixURI("toast"));
        AbstractTestPrefixMapping.assertEquals("butter should still be unset", null, prefixMapping.getNsPrefixURI("butter"));
    }

    public void testReversePrefixMapping() {
        PrefixMapping prefixMapping = this.getMapping();
        String string = "http://jena.hpl.hp.com/A#";
        String string2 = "http://jena.hpl.hp.com/";
        String string3 = "http://jena.hpl.hp.com/Csharp/";
        String string4 = "aa";
        String string5 = "bb";
        prefixMapping.setNsPrefix(string4, string).setNsPrefix(string5, string2);
        AbstractTestPrefixMapping.assertEquals(null, prefixMapping.getNsURIPrefix(string3));
        AbstractTestPrefixMapping.assertEquals(string4, prefixMapping.getNsURIPrefix(string));
        AbstractTestPrefixMapping.assertEquals(string5, prefixMapping.getNsURIPrefix(string2));
    }

    public void testPrefixMappingMap() {
        PrefixMapping prefixMapping = this.getCrispyRope();
        Map map = prefixMapping.getNsPrefixMap();
        AbstractTestPrefixMapping.assertEquals("map should have two elements", 2, map.size());
        AbstractTestPrefixMapping.assertEquals((Object)crispURI, map.get("crisp"));
        AbstractTestPrefixMapping.assertEquals((Object)ropeURI, map.get("rope"));
    }

    public void testPrefixMappingSecret() {
        PrefixMapping prefixMapping = this.getCrispyRope();
        Map map = prefixMapping.getNsPrefixMap();
        map.put("crisp", "with/onions");
        map.put("sandwich", "with/cheese");
        AbstractTestPrefixMapping.assertEquals(crispURI, prefixMapping.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals(ropeURI, prefixMapping.getNsPrefixURI("rope"));
        AbstractTestPrefixMapping.assertEquals(null, prefixMapping.getNsPrefixURI("sandwich"));
    }

    private PrefixMapping getCrispyRope() {
        PrefixMapping prefixMapping = this.getMapping();
        prefixMapping.setNsPrefix("crisp", crispURI);
        prefixMapping.setNsPrefix("rope", ropeURI);
        return prefixMapping;
    }

    public void testExpandPrefix() {
        int n;
        PrefixMapping prefixMapping = this.getMapping();
        prefixMapping.setNsPrefix("crisp", crispURI);
        prefixMapping.setNsPrefix("rope", ropeURI);
        for (n = 0; n < dontChange.length; ++n) {
            AbstractTestPrefixMapping.assertEquals("should be unchanged", dontChange[n], prefixMapping.expandPrefix(dontChange[n]));
        }
        for (n = 0; n < expansions.length; ++n) {
            AbstractTestPrefixMapping.assertEquals("should expand correctly", expansions[n][1], prefixMapping.expandPrefix(expansions[n][0]));
        }
    }

    public void testUseEasyPrefix() {
        AbstractTestPrefixMapping.testUseEasyPrefix("prefix mapping impl", this.getMapping());
    }

    public static void testUseEasyPrefix(String string, PrefixMapping prefixMapping) {
        prefixMapping.setNsPrefix("crisp", crispURI);
        prefixMapping.setNsPrefix("butter", butterURI);
        AbstractTestPrefixMapping.assertEquals(string, "", prefixMapping.usePrefix(""));
        AbstractTestPrefixMapping.assertEquals(string, ropeURI, prefixMapping.usePrefix(ropeURI));
        AbstractTestPrefixMapping.assertEquals(string, "crisp:tail", prefixMapping.usePrefix("http://crisp.nosuch.net/tail"));
        AbstractTestPrefixMapping.assertEquals(string, "butter:here:we:are", prefixMapping.usePrefix("ftp://ftp.nowhere.at.all/cream#here:we:are"));
    }

    public void testAddOtherPrefixMapping() {
        PrefixMapping prefixMapping;
        PrefixMapping prefixMapping2 = this.getMapping();
        AbstractTestPrefixMapping.assertFalse("must have two diffferent maps", prefixMapping2 == (prefixMapping = this.getMapping()));
        prefixMapping2.setNsPrefix("crisp", crispURI);
        prefixMapping2.setNsPrefix("rope", ropeURI);
        prefixMapping.setNsPrefix("butter", butterURI);
        AbstractTestPrefixMapping.assertEquals(null, prefixMapping.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals(null, prefixMapping.getNsPrefixURI("rope"));
        prefixMapping.setNsPrefixes(prefixMapping2);
        this.checkContainsMapping(prefixMapping);
    }

    private void checkContainsMapping(PrefixMapping prefixMapping) {
        AbstractTestPrefixMapping.assertEquals(crispURI, prefixMapping.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals(ropeURI, prefixMapping.getNsPrefixURI("rope"));
        AbstractTestPrefixMapping.assertEquals(butterURI, prefixMapping.getNsPrefixURI("butter"));
    }

    public void testAddMap() {
        PrefixMapping prefixMapping = this.getMapping();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("crisp", crispURI);
        hashMap.put("rope", ropeURI);
        prefixMapping.setNsPrefix("butter", butterURI);
        prefixMapping.setNsPrefixes(hashMap);
        this.checkContainsMapping(prefixMapping);
    }

    public void testSameURI() {
        PrefixMapping prefixMapping = this.getMapping();
        prefixMapping.setNsPrefix("crisp", crispURI);
        prefixMapping.setNsPrefix("sharp", crispURI);
        AbstractTestPrefixMapping.assertEquals(null, prefixMapping.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals(crispURI, prefixMapping.getNsPrefixURI("sharp"));
    }

    public void testSameURIMaply() {
        PrefixMapping prefixMapping = this.getMapping();
        PrefixMapping prefixMapping2 = this.getMapping();
        prefixMapping.setNsPrefix("crisp", crispURI);
        prefixMapping2.setNsPrefix("sharp", crispURI);
        prefixMapping.setNsPrefixes(prefixMapping2);
        AbstractTestPrefixMapping.assertEquals(crispURI, prefixMapping.getNsPrefixURI("sharp"));
        AbstractTestPrefixMapping.assertEquals(null, prefixMapping.getNsPrefixURI("crisp"));
    }

    public void testReturnsSelf() {
        PrefixMapping prefixMapping = this.getMapping();
        AbstractTestPrefixMapping.assertSame(prefixMapping, prefixMapping.setNsPrefix("crisp", crispURI));
        AbstractTestPrefixMapping.assertSame(prefixMapping, prefixMapping.setNsPrefixes(prefixMapping));
        AbstractTestPrefixMapping.assertSame(prefixMapping, prefixMapping.setNsPrefixes(new HashMap()));
    }

    public void testLock() {
        PrefixMapping prefixMapping = this.getMapping();
        AbstractTestPrefixMapping.assertSame(prefixMapping, prefixMapping.lock());
        try {
            prefixMapping.setNsPrefix("crisp", crispURI);
            AbstractTestPrefixMapping.fail("mapping should be frozen");
        }
        catch (PrefixMapping.JenaLockedException jenaLockedException) {
            // empty catch block
        }
        try {
            prefixMapping.setNsPrefixes(prefixMapping);
            AbstractTestPrefixMapping.fail("mapping should be frozen");
        }
        catch (PrefixMapping.JenaLockedException jenaLockedException) {
            // empty catch block
        }
        try {
            prefixMapping.setNsPrefixes(new HashMap());
            AbstractTestPrefixMapping.fail("mapping should be frozen");
        }
        catch (PrefixMapping.JenaLockedException jenaLockedException) {
            // empty catch block
        }
    }
}

