/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.impl;

import com.hp.hpl.jena.shared.PrefixMapping;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.xerces.util.XMLChar;

public class PrefixMappingImpl
implements PrefixMapping {
    private Map map = new HashMap();
    private boolean locked;

    public PrefixMapping lock() {
        this.locked = true;
        return this;
    }

    public PrefixMapping setNsPrefix(String string, String string2) {
        this.checkUnlocked();
        this.checkLegal(string);
        if (!string.equals("")) {
            this.removeExisting(string2);
        }
        this.checkProper(string2);
        this.map.put(string, string2);
        return this;
    }

    protected void checkUnlocked() {
        if (this.locked) {
            throw new PrefixMapping.JenaLockedException(this);
        }
    }

    private void checkProper(String string) {
    }

    public static boolean isNiceURI(String string) {
        if (string.equals("")) {
            return false;
        }
        char c = string.charAt(string.length() - 1);
        return c == '/' || c == '#';
    }

    private void removeExisting(String string) {
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!entry.getValue().equals(string)) continue;
            this.map.remove(entry.getKey());
            return;
        }
    }

    public PrefixMapping setNsPrefixes(PrefixMapping prefixMapping) {
        return this.setNsPrefixes(prefixMapping.getNsPrefixMap());
    }

    public PrefixMapping setNsPrefixes(Map map) {
        this.checkUnlocked();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.setNsPrefix((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    private void checkLegal(String string) {
        if (string.length() > 0 && !XMLChar.isValidNCName(string)) {
            throw new PrefixMapping.IllegalPrefixException(string);
        }
    }

    public String getNsPrefixURI(String string) {
        return (String)this.map.get(string);
    }

    public Map getNsPrefixMap() {
        return new HashMap(this.map);
    }

    public String getNsURIPrefix(String string) {
        Map.Entry entry = this.findMapping(string, false);
        return entry == null ? null : (String)entry.getKey();
    }

    public String expandPrefix(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return string;
        }
        String string2 = string.substring(0, n);
        String string3 = (String)this.map.get(string2);
        return string3 == null ? string : string3 + string.substring(n + 1);
    }

    public String toString() {
        return "pm:" + this.map;
    }

    public String usePrefix(String string) {
        Map.Entry entry = this.findMapping(string, true);
        return entry == null ? string : entry.getKey() + ":" + string.substring(((String)entry.getValue()).length());
    }

    private Map.Entry findMapping(String string, boolean bl) {
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getValue();
            if (!string.startsWith(string2) || !bl && string2.length() != string.length()) continue;
            return entry;
        }
        return null;
    }
}

