/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl.oldCode;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.FinderUtil;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BackwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.impl.BBRuleContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.RuleStore;
import com.hp.hpl.jena.reasoner.rulesys.impl.TempNodeCache;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.BRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.TopGoalIterator;
import com.hp.hpl.jena.util.OneToManyMap;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class BasicBackwardRuleInfGraph
extends BaseInfGraph
implements BackwardRuleInfGraphI {
    protected List rules;
    protected OneToManyMap derivations;
    protected FGraph fschema;
    protected FGraph fdeductions;
    protected Finder dataFind;
    protected BRuleEngine engine;
    protected BBRuleContext context;
    protected TempNodeCache tempNodecache;
    int nRulesTriggered = 0;
    long nRulesFired = 0L;
    long nRulesThreshold = 500000L;
    boolean traceOn = false;
    public static final long DEFAULT_RULES_THRESHOLD = 500000L;
    static Logger logger = Logger.getLogger(class$com$hp$hpl$jena$reasoner$rulesys$impl$oldCode$BasicBackwardRuleInfGraph == null ? (class$com$hp$hpl$jena$reasoner$rulesys$impl$oldCode$BasicBackwardRuleInfGraph = BasicBackwardRuleInfGraph.class$("com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.BasicBackwardRuleInfGraph")) : class$com$hp$hpl$jena$reasoner$rulesys$impl$oldCode$BasicBackwardRuleInfGraph);
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$rulesys$impl$oldCode$BasicBackwardRuleInfGraph;

    public BasicBackwardRuleInfGraph(Reasoner reasoner, RuleStore ruleStore, Graph graph, Graph graph2) {
        super(graph, reasoner);
        if (graph2 != null) {
            this.fschema = new FGraph(graph2);
        }
        this.rules = ruleStore.getAllRules();
        this.engine = new BRuleEngine(this, ruleStore);
        this.tempNodecache = new TempNodeCache(this);
    }

    public Graph getSchemaGraph() {
        return this.fschema.getGraph();
    }

    public void prepare() {
        if (!this.isPrepared) {
            this.fdeductions = new FGraph(new GraphMem());
            this.extractAxioms();
            this.dataFind = this.fdata;
            if (this.fdeductions != null) {
                this.dataFind = FinderUtil.cascade(this.dataFind, this.fdeductions);
            }
            if (this.fschema != null) {
                this.dataFind = FinderUtil.cascade(this.dataFind, this.fschema);
            }
            this.context = new BBRuleContext(this);
        }
        this.isPrepared = true;
    }

    public void rebind(Graph graph) {
        this.fdata = new FGraph(graph);
        this.engine.reset();
        this.isPrepared = false;
    }

    public void rebind() {
        this.engine.reset();
        this.isPrepared = false;
    }

    public ExtendedIterator findWithContinuation(TriplePattern triplePattern, Finder finder) {
        this.checkOpen();
        if (!this.isPrepared) {
            this.prepare();
        }
        ExtendedIterator extendedIterator = null;
        extendedIterator = finder == null ? WrappedIterator.create(new TopGoalIterator(this.engine, triplePattern)) : WrappedIterator.create(new TopGoalIterator(this.engine, triplePattern)).andThen(finder.find(triplePattern));
        return extendedIterator.filterDrop(Functor.acceptFilter);
    }

    public ExtendedIterator find(Node node, Node node2, Node node3) {
        return this.findWithContinuation(new TriplePattern(node, node2, node3), null);
    }

    public ExtendedIterator find(TriplePattern triplePattern) {
        return this.findWithContinuation(triplePattern, null);
    }

    public void reset() {
        this.engine.reset();
        this.isPrepared = false;
    }

    public synchronized void performAdd(Triple triple) {
        this.fdata.getGraph().add(triple);
        this.reset();
    }

    public void performDelete(Triple triple) {
        this.fdata.getGraph().delete(triple);
        this.reset();
    }

    public void setDerivationLogging(boolean bl) {
        this.recordDerivations = bl;
        this.derivations = bl ? new OneToManyMap() : null;
    }

    public Iterator getDerivation(Triple triple) {
        if (this.derivations == null) {
            return new NullIterator();
        }
        return this.derivations.getAll(triple);
    }

    public void setRuleThreshold(long l) {
        this.nRulesThreshold = l;
    }

    public void setTraceOn(boolean bl) {
        this.traceOn = bl;
        this.engine.setTraceOn(bl);
    }

    public boolean isTraceOn() {
        return this.traceOn;
    }

    public void dump() {
        this.engine.dump();
    }

    public void logDerivation(Triple triple, Object object) {
        this.derivations.put(triple, object);
    }

    public ExtendedIterator findDataMatches(TriplePattern triplePattern) {
        return this.dataFind.find(triplePattern);
    }

    public boolean processBuiltin(ClauseEntry clauseEntry, Rule rule, BindingEnvironment bindingEnvironment) {
        if (clauseEntry instanceof Functor) {
            this.context.setEnv(bindingEnvironment);
            this.context.setRule(rule);
            return ((Functor)clauseEntry).evalAsBodyClause(this.context);
        }
        throw new ReasonerException("Illegal builtin predicate: " + clauseEntry + " in rule " + rule);
    }

    public void silentAdd(Triple triple) {
        this.fdeductions.getGraph().add(triple);
    }

    public Node getTemp(Node node, Node node2, Node node3) {
        return this.tempNodecache.getTemp(node, node2, node3);
    }

    protected void extractAxioms() {
        Graph graph = this.fdeductions.getGraph();
        Iterator iterator = this.rules.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            if (rule.bodyLength() != 0) continue;
            for (int i = 0; i < rule.headLength(); ++i) {
                ClauseEntry clauseEntry = rule.getHeadElement(i);
                if (!(clauseEntry instanceof TriplePattern)) continue;
                graph.add(((TriplePattern)clauseEntry).asTriple());
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

