/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BackwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.util.iterator.ClosableIterator;

public class BBRuleContext
implements RuleContext {
    protected BindingEnvironment env;
    protected Rule rule;
    protected BackwardRuleInfGraphI graph;

    public BBRuleContext(BackwardRuleInfGraphI backwardRuleInfGraphI) {
        this.graph = backwardRuleInfGraphI;
    }

    public boolean contains(Node node, Node node2, Node node3) {
        ClosableIterator closableIterator = this.find(node, node2, node3);
        boolean bl = closableIterator.hasNext();
        closableIterator.close();
        return bl;
    }

    public boolean contains(Triple triple) {
        return this.contains(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public ClosableIterator find(Node node, Node node2, Node node3) {
        return this.graph.findDataMatches(new TriplePattern(node, node2, node3));
    }

    public BindingEnvironment getEnv() {
        return this.env;
    }

    public void setEnv(BindingEnvironment bindingEnvironment) {
        this.env = bindingEnvironment;
    }

    public InfGraph getGraph() {
        return this.graph;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public void silentAdd(Triple triple) {
        this.graph.silentAdd(triple);
    }

    public void add(Triple triple) {
        this.graph.silentAdd(triple);
    }

    public void remove(Triple triple) {
        this.graph.delete(triple);
    }

    public Node getTemp(Node node, Node node2, Node node3) {
        return this.graph.getTemp(node, node2, node3);
    }
}

