/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.BuiltinRegistry;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.util.PrintUtil;
import com.hp.hpl.jena.util.Tokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class Rule
implements ClauseEntry {
    protected ClauseEntry[] body;
    protected ClauseEntry[] head;
    protected String name;
    protected int numVars = -1;
    protected boolean isBackward = false;
    static Logger logger = Logger.getLogger(class$com$hp$hpl$jena$reasoner$rulesys$Rule == null ? (class$com$hp$hpl$jena$reasoner$rulesys$Rule = Rule.class$("com.hp.hpl.jena.reasoner.rulesys.Rule")) : class$com$hp$hpl$jena$reasoner$rulesys$Rule);
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$rulesys$Rule;

    public Rule(List list, List list2) {
        this(null, list, list2);
    }

    public Rule(String string, List list, List list2) {
        this.name = string;
        this.head = list.toArray(new ClauseEntry[list.size()]);
        this.body = list2.toArray(new ClauseEntry[list2.size()]);
    }

    public Rule(String string, ClauseEntry[] clauseEntryArray, ClauseEntry[] clauseEntryArray2) {
        this.name = string;
        this.head = clauseEntryArray;
        this.body = clauseEntryArray2;
    }

    public int bodyLength() {
        return this.body.length;
    }

    public ClauseEntry getBodyElement(int n) {
        return this.body[n];
    }

    public ClauseEntry[] getBody() {
        return this.body;
    }

    public int headLength() {
        return this.head.length;
    }

    public ClauseEntry getHeadElement(int n) {
        return this.head[n];
    }

    public ClauseEntry[] getHead() {
        return this.head;
    }

    public boolean isBackward() {
        return this.isBackward;
    }

    public void setBackward(boolean bl) {
        this.isBackward = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setNumVars(int n) {
        this.numVars = n;
    }

    public int getNumVars() {
        if (this.numVars == -1) {
            int n = this.findVars(this.body, -1);
            n = this.findVars(this.head, n);
            this.numVars = n + 1;
        }
        return this.numVars;
    }

    private int findVars(Object[] objectArray, int n) {
        int n2 = n;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            n2 = object instanceof TriplePattern ? this.findVars((TriplePattern)object, n2) : this.findVars((Functor)object, n2);
        }
        return n2;
    }

    private int findVars(TriplePattern triplePattern, int n) {
        int n2 = n;
        n2 = this.maxVarIndex(triplePattern.getSubject(), n2);
        n2 = this.maxVarIndex(triplePattern.getPredicate(), n2);
        Node node = triplePattern.getObject();
        if (node instanceof Node_RuleVariable) {
            n2 = this.maxVarIndex(node, n2);
        } else if (Functor.isFunctor(node)) {
            n2 = this.findVars((Functor)node.getLiteral().getValue(), n2);
        }
        return n2;
    }

    private int findVars(Functor functor, int n) {
        int n2 = n;
        Node[] nodeArray = functor.getArgs();
        for (int i = 0; i < nodeArray.length; ++i) {
            if (!nodeArray[i].isVariable()) continue;
            n2 = this.maxVarIndex(nodeArray[i], n2);
        }
        return n2;
    }

    private int maxVarIndex(Node node, int n) {
        int n2;
        if (node instanceof Node_RuleVariable && (n2 = ((Node_RuleVariable)node).index) > n) {
            return n2;
        }
        return n;
    }

    public Rule instantiate(BindingEnvironment bindingEnvironment) {
        HashMap hashMap = new HashMap();
        return new Rule(this.name, this.cloneClauseArray(this.head, hashMap, bindingEnvironment), this.cloneClauseArray(this.body, hashMap, bindingEnvironment));
    }

    public Rule cloneRule() {
        if (this.getNumVars() > 0) {
            HashMap hashMap = new HashMap();
            return new Rule(this.name, this.cloneClauseArray(this.head, hashMap, null), this.cloneClauseArray(this.body, hashMap, null));
        }
        return this;
    }

    private ClauseEntry[] cloneClauseArray(ClauseEntry[] clauseEntryArray, Map map, BindingEnvironment bindingEnvironment) {
        ClauseEntry[] clauseEntryArray2 = new ClauseEntry[clauseEntryArray.length];
        for (int i = 0; i < clauseEntryArray.length; ++i) {
            clauseEntryArray2[i] = this.cloneClause(clauseEntryArray[i], map, bindingEnvironment);
        }
        return clauseEntryArray2;
    }

    private ClauseEntry cloneClause(ClauseEntry clauseEntry, Map map, BindingEnvironment bindingEnvironment) {
        if (clauseEntry instanceof TriplePattern) {
            TriplePattern triplePattern = (TriplePattern)clauseEntry;
            return new TriplePattern(this.cloneNode(triplePattern.getSubject(), map, bindingEnvironment), this.cloneNode(triplePattern.getPredicate(), map, bindingEnvironment), this.cloneNode(triplePattern.getObject(), map, bindingEnvironment));
        }
        return this.cloneFunctor((Functor)clauseEntry, map, bindingEnvironment);
    }

    private Functor cloneFunctor(Functor functor, Map map, BindingEnvironment bindingEnvironment) {
        Node[] nodeArray = functor.getArgs();
        Node[] nodeArray2 = new Node[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            nodeArray2[i] = this.cloneNode(nodeArray[i], map, bindingEnvironment);
        }
        Functor functor2 = new Functor(functor.getName(), nodeArray2);
        functor2.setImplementor(functor.getImplementor());
        return functor2;
    }

    private Node cloneNode(Node node, Map map, BindingEnvironment bindingEnvironment) {
        Node node2;
        Node node3 = node2 = bindingEnvironment == null ? node : bindingEnvironment.getGroundVersion(node);
        if (node2 instanceof Node_RuleVariable) {
            Node_RuleVariable node_RuleVariable = (Node_RuleVariable)node2;
            Node node4 = (Node)map.get(node_RuleVariable);
            if (node4 == null) {
                node4 = ((Node_RuleVariable)node2).cloneNode();
                map.put(node_RuleVariable, node4);
            }
            return node4;
        }
        if (Functor.isFunctor(node2)) {
            Functor functor = (Functor)node2.getLiteral().getValue();
            return Functor.makeFunctorNode(this.cloneFunctor(functor, map, bindingEnvironment));
        }
        return node2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        if (this.name != null) {
            stringBuffer.append(this.name);
            stringBuffer.append(": ");
        }
        if (this.isBackward) {
            int n;
            for (n = 0; n < this.head.length; ++n) {
                stringBuffer.append(PrintUtil.print(this.head[n]));
                stringBuffer.append(" ");
            }
            stringBuffer.append("<- ");
            for (n = 0; n < this.body.length; ++n) {
                stringBuffer.append(PrintUtil.print(this.body[n]));
                stringBuffer.append(" ");
            }
        } else {
            int n;
            for (n = 0; n < this.body.length; ++n) {
                stringBuffer.append(PrintUtil.print(this.body[n]));
                stringBuffer.append(" ");
            }
            stringBuffer.append("-> ");
            for (n = 0; n < this.head.length; ++n) {
                stringBuffer.append(PrintUtil.print(this.head[n]));
                stringBuffer.append(" ");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toShortString() {
        if (this.name != null) {
            return this.name;
        }
        return this.toString();
    }

    public static Rule parseRule(String string) throws ParserException {
        Parser parser = new Parser(string);
        return parser.parseRule();
    }

    public static List parseRules(String string) throws ParserException {
        Parser parser = new Parser(string);
        boolean bl = false;
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        while (!bl) {
            try {
                parser.peekToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                bl = true;
                break;
            }
            Rule rule = parser.parseRule();
            arrayList.add(rule);
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        int n;
        if (!(object instanceof Rule)) {
            return false;
        }
        Rule rule = (Rule)object;
        if (rule.head.length != this.head.length) {
            return false;
        }
        if (rule.body.length != this.body.length) {
            return false;
        }
        for (n = 0; n < this.body.length; ++n) {
            if (this.body[n].sameAs(rule.body[n])) continue;
            return false;
        }
        for (n = 0; n < this.head.length; ++n) {
            if (this.head[n].sameAs(rule.head[n])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.body.length; ++n) {
            n2 = n2 << 1 ^ this.body[n].hashCode();
        }
        for (n = 0; n < this.head.length; ++n) {
            n2 = n2 << 1 ^ this.head[n].hashCode();
        }
        return n2;
    }

    public boolean sameAs(Object object) {
        return this.equals(object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ParserException
    extends RuntimeException {
        public ParserException(String string, Parser parser) {
            super(ParserException.constructMessage(string, parser));
        }

        private static String constructMessage(String string, Parser parser) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append("\nAt '");
            stringBuffer.append(parser.recentTokens());
            stringBuffer.append("'");
            return stringBuffer.toString();
        }
    }

    static class Parser {
        private Tokenizer stream;
        private String lookahead;
        protected List priorTokens = new ArrayList();
        private static final int maxPriors = 20;
        private Map varMap;

        Parser(String string) {
            this.stream = new Tokenizer(string, "()[], \t\n\r", "'", true);
            this.lookahead = null;
        }

        String nextToken() {
            if (this.lookahead != null) {
                String string = this.lookahead;
                this.lookahead = null;
                return string;
            }
            String string = this.stream.nextToken();
            while (this.isSeparator(string)) {
                string = this.stream.nextToken();
            }
            this.priorTokens.add(0, string);
            if (this.priorTokens.size() > 20) {
                this.priorTokens.remove(this.priorTokens.size() - 1);
            }
            return string;
        }

        public String recentTokens() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = this.priorTokens.size() - 1; i >= 0; --i) {
                stringBuffer.append(this.priorTokens.get(i));
                stringBuffer.append(" ");
            }
            return stringBuffer.toString();
        }

        String peekToken() {
            if (this.lookahead == null) {
                this.lookahead = this.nextToken();
            }
            return this.lookahead;
        }

        void pushback(String string) {
            this.lookahead = string;
        }

        boolean isSeparator(String string) {
            if (string.length() == 1) {
                char c = string.charAt(0);
                return c == ',' || Character.isWhitespace(c);
            }
            return false;
        }

        boolean isSyntax(String string) {
            if (string.length() == 1) {
                char c = string.charAt(0);
                return c == '(' || c == ')' || c == '[' || c == ']';
            }
            return false;
        }

        Node_RuleVariable getNodeVar(String string) {
            Node_RuleVariable node_RuleVariable = (Node_RuleVariable)this.varMap.get(string);
            if (node_RuleVariable == null) {
                node_RuleVariable = new Node_RuleVariable(string, this.varMap.size());
                this.varMap.put(string, node_RuleVariable);
            }
            return node_RuleVariable;
        }

        Node parseNode(String string) {
            if (string.startsWith("?")) {
                return this.getNodeVar(string);
            }
            if (string.equals("*") || string.equals("_")) {
                throw new ParserException("Wildcard variables no longer supported", this);
            }
            if (string.indexOf(58) != -1) {
                String string2;
                String string3 = PrintUtil.expandQname(string);
                if (!(string3 != string || (string2 = string.substring(0, string.indexOf(58))).equals("http") || string2.equals("urn") || string2.equals("ftp"))) {
                    throw new ParserException("Unrecognized qname prefix (" + string2 + ") in rule", this);
                }
                return Node.createURI(string3);
            }
            if (this.peekToken().equals("(")) {
                Functor functor = new Functor(string, this.parseNodeList(), BuiltinRegistry.theRegistry);
                LiteralLabel literalLabel = new LiteralLabel(functor, null, Functor.FunctorDatatype.theFunctorDatatype);
                return new Node_Literal(literalLabel);
            }
            if (string.equals("'")) {
                String string4 = this.nextToken();
                this.nextToken();
                return Node.createLiteral(string4, "", false);
            }
            if (Character.isDigit(string.charAt(0))) {
                return this.parseNumber(string);
            }
            return Node.createURI(string);
        }

        Node parseNumber(String string) {
            if (Character.isDigit(string.charAt(0))) {
                if (string.indexOf(".") != -1) {
                    if (XSDDatatype.XSDfloat.isValid(string)) {
                        return Node.createLiteral(string, "", XSDDatatype.XSDfloat);
                    }
                } else if (XSDDatatype.XSDint.isValid(string)) {
                    return Node.createLiteral(string, "", XSDDatatype.XSDint);
                }
            }
            return Node.createLiteral(string, "", false);
        }

        List parseNodeList() {
            String string = this.nextToken();
            if (!string.equals("(")) {
                throw new ParserException("Expected '(' at start of clause, found " + string, this);
            }
            string = this.nextToken();
            ArrayList<Node> arrayList = new ArrayList<Node>();
            while (!this.isSyntax(string)) {
                arrayList.add(this.parseNode(string));
                string = this.nextToken();
            }
            if (!string.equals(")")) {
                throw new ParserException("Expected ')' at end of clause, found " + string, this);
            }
            return arrayList;
        }

        Object parseClause() {
            List list;
            String string = this.peekToken();
            if (string.equals("(")) {
                List list2 = this.parseNodeList();
                if (list2.size() != 3) {
                    throw new ParserException("Triple with " + list2.size() + " nodes!", this);
                }
                return new TriplePattern((Node)list2.get(0), (Node)list2.get(1), (Node)list2.get(2));
            }
            if (string.equals("[")) {
                this.nextToken();
                return this.doParseRule(true);
            }
            String string2 = this.nextToken();
            Functor functor = new Functor(string2, list = this.parseNodeList(), BuiltinRegistry.theRegistry);
            if (functor.getImplementor() == null) {
                logger.warn("Rule references unimplemented functor: " + string2);
            }
            return functor;
        }

        Rule parseRule() {
            return this.doParseRule(false);
        }

        private Rule doParseRule(boolean bl) {
            try {
                if (this.peekToken().equals("[")) {
                    this.nextToken();
                }
                String string = null;
                String string2 = this.peekToken();
                if (string2.endsWith(":")) {
                    string = string2.substring(0, string2.length() - 1);
                    this.nextToken();
                }
                if (!bl) {
                    this.varMap = new HashMap();
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                string2 = this.peekToken();
                while (!string2.equals("->") && !string2.equals("<-")) {
                    arrayList.add(this.parseClause());
                    string2 = this.peekToken();
                }
                boolean bl2 = string2.equals("<-");
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                string2 = this.nextToken();
                string2 = this.peekToken();
                while (!string2.equals(".") && !string2.equals("]")) {
                    arrayList2.add(this.parseClause());
                    string2 = this.peekToken();
                }
                this.nextToken();
                Rule rule = null;
                rule = bl2 ? new Rule(string, arrayList, arrayList2) : new Rule(string, arrayList2, arrayList);
                rule.numVars = this.varMap.keySet().size();
                rule.isBackward = bl2;
                return rule;
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new ParserException("Malformed rule", this);
            }
        }
    }
}

