/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;

public class OWLRuleReasonerFactory
implements ReasonerFactory {
    private static ReasonerFactory theInstance = new OWLRuleReasonerFactory();
    public static final String URI = "http://jena.hpl.hp.com/2003/OWLRuleReasoner";
    protected Model capabilities;

    public static ReasonerFactory theInstance() {
        return theInstance;
    }

    public Reasoner create(Resource resource) {
        OWLRuleReasoner oWLRuleReasoner = new OWLRuleReasoner();
        if (resource != null) {
            Boolean bl;
            Boolean bl2 = Util.checkBinaryPredicate(ReasonerVocabulary.PROPderivationLogging, resource);
            if (bl2 != null) {
                oWLRuleReasoner.setDerivationLogging(bl2);
            }
            if ((bl = Util.checkBinaryPredicate(ReasonerVocabulary.PROPtraceOn, resource)) != null) {
                oWLRuleReasoner.setTraceOn(bl);
            }
        }
        return oWLRuleReasoner;
    }

    public Model getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = ModelFactory.createDefaultModel();
            Resource resource = this.capabilities.createResource(this.getURI());
            resource.addProperty(ReasonerVocabulary.nameP, "OWL Rule Reasoner").addProperty(ReasonerVocabulary.descriptionP, "Experimental OWL reasoner.\nPure forward chaining so all entailments are immediate calculated\nCan separate tbox and abox data if desired to reuse tbox caching or mix them.").addProperty(ReasonerVocabulary.supportsP, RDFS.subClassOf).addProperty(ReasonerVocabulary.supportsP, RDFS.subPropertyOf).addProperty(ReasonerVocabulary.supportsP, RDFS.member).addProperty(ReasonerVocabulary.supportsP, RDFS.range).addProperty(ReasonerVocabulary.supportsP, RDFS.domain).addProperty(ReasonerVocabulary.versionP, "0.1");
        }
        return this.capabilities;
    }

    public String getURI() {
        return URI;
    }
}

