/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.IllegalParameterException;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.LPBackwardRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPRuleStore;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.List;

public class LPBackwardRuleReasoner
implements Reasoner {
    protected ReasonerFactory factory;
    protected List rules;
    protected LPRuleStore ruleStore;
    protected Graph schemaGraph;
    protected boolean recordDerivations = false;
    boolean traceOn = false;

    public LPBackwardRuleReasoner(List list) {
        this.rules = list;
        this.ruleStore = new LPRuleStore(list);
    }

    public LPBackwardRuleReasoner(List list, ReasonerFactory reasonerFactory) {
        this.rules = list;
        this.factory = reasonerFactory;
        this.ruleStore = new LPRuleStore(list);
    }

    protected LPBackwardRuleReasoner(LPBackwardRuleReasoner lPBackwardRuleReasoner, Graph graph) {
        this.rules = lPBackwardRuleReasoner.rules;
        this.ruleStore = lPBackwardRuleReasoner.ruleStore;
        this.schemaGraph = graph;
        this.factory = lPBackwardRuleReasoner.factory;
    }

    public Model getCapabilities() {
        if (this.factory != null) {
            return this.factory.getCapabilities();
        }
        return null;
    }

    public void addDescription(Model model, Resource resource) {
    }

    public synchronized void tablePredicate(Node node) {
        this.ruleStore.tablePredicate(node);
    }

    public boolean supportsProperty(Property property) {
        if (this.factory == null) {
            return false;
        }
        Model model = this.factory.getCapabilities();
        Resource resource = model.getResource(this.factory.getURI());
        return model.contains(resource, ReasonerVocabulary.supportsP, property);
    }

    public Reasoner bindSchema(Graph graph) throws ReasonerException {
        return new LPBackwardRuleReasoner(this, graph);
    }

    public Reasoner bindSchema(Model model) throws ReasonerException {
        return new LPBackwardRuleReasoner(this, model.getGraph());
    }

    public InfGraph bind(Graph graph) throws ReasonerException {
        LPBackwardRuleInfGraph lPBackwardRuleInfGraph = new LPBackwardRuleInfGraph(this, this.ruleStore, graph, this.schemaGraph);
        lPBackwardRuleInfGraph.setDerivationLogging(this.recordDerivations);
        return lPBackwardRuleInfGraph;
    }

    public List getRules() {
        return this.rules;
    }

    public void setDerivationLogging(boolean bl) {
        this.recordDerivations = bl;
    }

    public void setTraceOn(boolean bl) {
        this.traceOn = bl;
    }

    public void setParameter(Property property, Object object) {
        throw new IllegalParameterException(property.toString());
    }
}

