/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.IllegalParameterException;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.List;

public class BasicForwardRuleReasoner
implements Reasoner {
    protected ReasonerFactory factory;
    protected List rules;
    protected InfGraph schemaGraph;
    protected boolean recordDerivations = false;
    boolean traceOn = false;

    public BasicForwardRuleReasoner(List list) {
        this.rules = list;
    }

    public BasicForwardRuleReasoner(List list, ReasonerFactory reasonerFactory) {
        this.rules = list;
        this.factory = reasonerFactory;
    }

    private BasicForwardRuleReasoner(List list, InfGraph infGraph, ReasonerFactory reasonerFactory) {
        this.rules = list;
        this.schemaGraph = infGraph;
        this.factory = reasonerFactory;
    }

    public Model getCapabilities() {
        if (this.factory != null) {
            return this.factory.getCapabilities();
        }
        return null;
    }

    public void addDescription(Model model, Resource resource) {
    }

    public boolean supportsProperty(Property property) {
        if (this.factory == null) {
            return false;
        }
        Model model = this.factory.getCapabilities();
        Resource resource = model.getResource(this.factory.getURI());
        return model.contains(resource, ReasonerVocabulary.supportsP, property);
    }

    public Reasoner bindSchema(Graph graph) throws ReasonerException {
        BasicForwardRuleInfGraph basicForwardRuleInfGraph = new BasicForwardRuleInfGraph(this, this.rules, null, graph);
        return new BasicForwardRuleReasoner(this.rules, basicForwardRuleInfGraph, this.factory);
    }

    public Reasoner bindSchema(Model model) throws ReasonerException {
        BasicForwardRuleInfGraph basicForwardRuleInfGraph = new BasicForwardRuleInfGraph(this, this.rules, null, model.getGraph());
        return new BasicForwardRuleReasoner(this.rules, basicForwardRuleInfGraph, this.factory);
    }

    public InfGraph bind(Graph graph) throws ReasonerException {
        BasicForwardRuleInfGraph basicForwardRuleInfGraph = new BasicForwardRuleInfGraph(this, this.rules, this.schemaGraph);
        basicForwardRuleInfGraph.setDerivationLogging(this.recordDerivations);
        basicForwardRuleInfGraph.setTraceOn(this.traceOn);
        basicForwardRuleInfGraph.rebind(graph);
        return basicForwardRuleInfGraph;
    }

    public List getRules() {
        return this.rules;
    }

    public void setDerivationLogging(boolean bl) {
        this.recordDerivations = bl;
    }

    public void setTraceOn(boolean bl) {
        this.traceOn = bl;
    }

    public void setParameter(Property property, Object object) {
        if (property.equals(ReasonerVocabulary.PROPderivationLogging)) {
            this.recordDerivations = Util.convertBooleanPredicateArg(property, object);
        } else if (property.equals(ReasonerVocabulary.PROPtraceOn)) {
            this.traceOn = Util.convertBooleanPredicateArg(property, object);
        } else {
            throw new IllegalParameterException("Don't recognize configuration parameter " + property + " for rule-based reasoner");
        }
    }
}

