/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryEngine;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.ResultBinding;
import java.util.Set;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class QueryTestsMisc
extends TestSuite {
    static final String testSetName = "RDQL - Query - Other";
    public static String baseURI = "http://rdql/";

    public static TestSuite suite() {
        return new QueryTestsMisc(testSetName);
    }

    private QueryTestsMisc(String string) {
        super(string);
        try {
            this.addTest(new TestQueryTriplesMerge());
            this.addTest(new TestQueryGetTriples());
            this.addTest(new TestQueryGetTriples2());
        }
        catch (Exception exception) {
            System.err.println("Problems making RDQL test");
            exception.printStackTrace(System.err);
            return;
        }
    }

    static class TestQueryGetTriples2
    extends TestQueryTriples {
        TestQueryGetTriples2() {
            super("TestQueryGetTriples2");
        }

        protected void runTest() throws Throwable {
            Model model = ModelFactory.createDefaultModel();
            String string = "SELECT * WHERE (<" + this.r.getURI() + "> ?p ?v)";
            Query query = new Query(string);
            query.setSource(this.model);
            QueryEngine queryEngine = new QueryEngine(query);
            QueryResults queryResults = queryEngine.exec();
            int n = 0;
            while (queryResults.hasNext()) {
                ResultBinding resultBinding = (ResultBinding)queryResults.next();
                Set set = resultBinding.getTriples();
                TestQueryGetTriples2.assertTrue(this.getName() + ": getTriples2(loop " + ++n + ")", resultBinding.getTriples().size() == 1);
            }
            queryResults.close();
        }
    }

    static class TestQueryGetTriples
    extends TestQueryTriples {
        TestQueryGetTriples() {
            super("TestQueryGetTriples");
        }

        protected void runTest() throws Throwable {
            Model model = ModelFactory.createDefaultModel();
            String string = "SELECT * WHERE (<" + this.r.getURI() + "> ?p ?v)";
            Query query = new Query(string);
            query.setSource(this.model);
            QueryEngine queryEngine = new QueryEngine(query);
            QueryResults queryResults = queryEngine.exec();
            int n = 0;
            while (queryResults.hasNext()) {
                ResultBinding resultBinding = (ResultBinding)queryResults.next();
                TestQueryGetTriples.assertTrue(this.getName() + ": getTriples(loop " + ++n + ")", resultBinding.getTriples().size() == 1);
            }
            queryResults.close();
        }
    }

    static class TestQueryTriplesMerge
    extends TestQueryTriples {
        TestQueryTriplesMerge() {
            super("TestQueryTriplesMerge");
        }

        protected void runTest() throws Throwable {
            Model model = ModelFactory.createDefaultModel();
            String string = "SELECT * WHERE (<" + this.r.getURI() + "> ?p ?v)";
            Query query = new Query(string);
            query.setSource(this.model);
            QueryEngine queryEngine = new QueryEngine(query);
            QueryResults queryResults = queryEngine.exec();
            while (queryResults.hasNext()) {
                ResultBinding resultBinding = (ResultBinding)queryResults.next();
                resultBinding.mergeTriples(model);
            }
            queryResults.close();
            TestQueryTriplesMerge.assertTrue(this.getName() + ": merged rsults not the same as target model", this.model.isIsomorphicWith(model));
        }
    }

    static abstract class TestQueryTriples
    extends TestCase {
        Model model = ModelFactory.createDefaultModel();
        Resource r = this.model.createResource(baseURI + "r");

        TestQueryTriples(String string) {
            super(string);
            this.r.addProperty(this.model.createProperty(baseURI + "p1"), "v1");
            this.r.addProperty(this.model.createProperty(baseURI + "p2"), "v2");
        }
    }
}

