/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.parser;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdql.EvalFailureException;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryPrintUtils;
import com.hp.hpl.jena.rdql.ResultBinding;
import com.hp.hpl.jena.rdql.Settable;
import com.hp.hpl.jena.rdql.Value;
import com.hp.hpl.jena.rdql.ValueException;
import com.hp.hpl.jena.rdql.parser.Expr;
import com.hp.hpl.jena.rdql.parser.Q_URI;
import com.hp.hpl.jena.rdql.parser.RDQLParser;
import com.hp.hpl.jena.rdql.parser.SimpleNode;
import java.io.PrintWriter;

public class ParsedLiteral
extends SimpleNode
implements Value,
Expr,
Settable {
    static Model model = ModelFactory.createDefaultModel();
    protected boolean isSet = false;
    protected boolean isInt = false;
    protected boolean isBoolean = false;
    protected boolean isDouble = false;
    protected boolean isURI = false;
    protected boolean isString = false;
    protected boolean isRDFResource = false;
    protected boolean isRDFLiteral = false;
    protected long valInt;
    protected boolean valBoolean;
    protected double valDouble;
    protected String valString;
    protected String valURI;
    protected Literal valRDFLiteral;
    protected Resource valRDFResource;

    ParsedLiteral(int n) {
        super(n);
    }

    ParsedLiteral(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    public ParsedLiteral() {
        super(-1);
        this.unset();
    }

    public ParsedLiteral(Value value) {
        super(-1);
        if (value.isBoolean()) {
            this.setBoolean(value.getBoolean());
            return;
        }
        if (value.isInt()) {
            this.setInt(value.getInt());
            return;
        }
        if (value.isDouble()) {
            this.setDouble(value.getDouble());
            return;
        }
        if (value.isURI()) {
            this.setURI(value.getURI());
            return;
        }
        if (value.isRDFLiteral()) {
            this.setRDFLiteral(value.getRDFLiteral());
            return;
        }
        if (value.isRDFResource()) {
            this.setRDFResource(value.getRDFResource());
            return;
        }
        if (value.isString()) {
            this.setString(value.getString());
            return;
        }
    }

    protected void unset() {
        this.isSet = false;
        if (this.isString) {
            this.valString = null;
        }
        if (this.isURI) {
            this.valURI = null;
        }
        if (this.isRDFResource) {
            this.valRDFResource = null;
        }
        if (this.isRDFLiteral) {
            this.valRDFLiteral = null;
        }
        this.isInt = false;
        this.isBoolean = false;
        this.isDouble = false;
        this.isURI = false;
        this.isString = false;
    }

    public Value eval(Query query, ResultBinding resultBinding) {
        if (!this.isSet) {
            throw new EvalFailureException("Literal value not set");
        }
        return this;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public boolean isNumber() {
        return this.isSet && (this.isInt || this.isDouble);
    }

    public boolean isInt() {
        return this.isSet && this.isInt;
    }

    public boolean isDouble() {
        return this.isSet && this.isDouble;
    }

    public boolean isBoolean() {
        return this.isSet && this.isBoolean;
    }

    public boolean isString() {
        return this.isSet && this.isString;
    }

    public boolean isURI() {
        return this.isSet && this.isURI;
    }

    public boolean isRDFResource() {
        return this.isSet && this.isRDFResource;
    }

    public boolean isRDFLiteral() {
        return this.isSet && this.isRDFLiteral;
    }

    public void setInt(long l) {
        this.unset();
        this.isSet = true;
        this.isInt = true;
        this.valInt = l;
    }

    public void setDouble(double d) {
        this.unset();
        this.isSet = true;
        this.isDouble = true;
        this.valDouble = d;
    }

    public void setBoolean(boolean bl) {
        this.unset();
        this.isSet = true;
        this.isBoolean = true;
        this.valBoolean = bl;
    }

    public void setString(String string) {
        this.unset();
        this.isSet = true;
        this.isString = true;
        this.valString = string;
    }

    public void setURI(String string) {
        this.unset();
        this.isSet = true;
        this.isURI = true;
        this.isString = true;
        this.valURI = string;
        this.valString = string;
    }

    public void setRDFLiteral(Literal literal) {
        this.unset();
        this.isSet = true;
        this.isString = true;
        this.isRDFLiteral = true;
        this.valString = literal.getLexicalForm();
        this.valRDFLiteral = literal;
    }

    public void setRDFResource(Resource resource) {
        this.unset();
        this.isSet = true;
        this.isURI = true;
        this.isRDFResource = true;
        this.valURI = ((Object)resource).toString();
        this.valRDFResource = resource;
    }

    public long getInt() {
        if (!this.isSet || !this.isInt) {
            throw new ValueException("Not an int: " + this);
        }
        return this.valInt;
    }

    public double getDouble() {
        if (!this.isSet || !this.isDouble && !this.isInt) {
            throw new ValueException("Not a double: " + this);
        }
        if (this.isInt) {
            return this.valInt;
        }
        return this.valDouble;
    }

    public boolean getBoolean() {
        if (!this.isSet || !this.isBoolean) {
            throw new ValueException("Not a boolean: " + this);
        }
        return this.valBoolean;
    }

    public String getString() {
        if (!this.isSet || !this.isString) {
            throw new ValueException("Not a string: " + this);
        }
        return this.valString;
    }

    public String getURI() {
        if (!this.isSet || !this.isURI) {
            throw new ValueException("Not a URI: " + this);
        }
        return this.valURI;
    }

    public Literal getRDFLiteral() {
        if (!this.isSet || !this.isRDFLiteral) {
            throw new ValueException("Not a Literal: " + this);
        }
        return this.valRDFLiteral;
    }

    public Resource getRDFResource() {
        if (!this.isSet || !this.isRDFResource) {
            throw new ValueException("Not a Resource: " + this);
        }
        return this.valRDFResource;
    }

    public String asQuotedString() {
        if (!this.isSet) {
            return "literal:unset";
        }
        if (this.isInt) {
            return Long.toString(this.valInt);
        }
        if (this.isDouble) {
            return Double.toString(this.valDouble);
        }
        if (this.isBoolean) {
            return this.valBoolean ? "true" : "false";
        }
        if (this.isRDFLiteral) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('\"').append(this.valRDFLiteral.toString()).append('\"');
            if (!this.valRDFLiteral.getLanguage().equals("")) {
                stringBuffer.append('@').append(this.valRDFLiteral.getLanguage());
            }
            if (this.valRDFLiteral.getDatatypeURI() != null) {
                stringBuffer.append("^^<").append(this.valRDFLiteral.getDatatypeURI()).append(">");
            }
            return stringBuffer.toString();
        }
        if (this.isRDFResource) {
            return "<" + ((Object)this.valRDFResource).toString() + ">";
        }
        if (this.isURI) {
            return "<" + this.valURI + ">";
        }
        if (this.isString) {
            return "\"" + this.valString + "\"";
        }
        return "literal:unknown";
    }

    public String asUnquotedString() {
        if (!this.isSet) {
            return "literal:unset";
        }
        if (this.isInt) {
            return Long.toString(this.valInt);
        }
        if (this.isDouble) {
            return Double.toString(this.valDouble);
        }
        if (this.isBoolean) {
            return this.valBoolean ? "true" : "false";
        }
        if (this.isRDFLiteral) {
            return this.valRDFLiteral.toString();
        }
        if (this.isRDFResource) {
            return ((Object)this.valRDFResource).toString();
        }
        if (this.isURI) {
            return this.valURI;
        }
        if (this.isString) {
            return this.valString;
        }
        return "literal:unknown";
    }

    public String asInfixString() {
        return this.asQuotedString();
    }

    public String asPrefixString() {
        if (!this.isSet) {
            return "literal:unset";
        }
        if (this.isInt) {
            return "int:" + Long.toString(this.valInt);
        }
        if (this.isDouble) {
            return "double:" + Double.toString(this.valDouble);
        }
        if (this.isBoolean) {
            return "boolean:" + (this.valBoolean ? "true" : "false");
        }
        if (this.isRDFLiteral) {
            return "RDF:\"" + this.valRDFLiteral.toString() + "\"";
        }
        if (this.isRDFResource) {
            return "RDF:<" + ((Object)this.valRDFResource).toString() + ">";
        }
        if (this.isURI) {
            return "URI:" + this.valURI;
        }
        if (this.isString) {
            return "string:" + this.valString;
        }
        return "literal:unknown";
    }

    public void print(PrintWriter printWriter, int n) {
        QueryPrintUtils.indent(printWriter, n);
        printWriter.println(this.asPrefixString());
    }

    public String valueString() {
        return this.asUnquotedString();
    }

    public String toString() {
        return this.asUnquotedString();
    }

    public static ParsedLiteral makeString(String string) {
        ParsedLiteral parsedLiteral = new ParsedLiteral(0);
        parsedLiteral.setString(string);
        return parsedLiteral;
    }

    public static Q_URI makeURI(String string) {
        return Q_URI.makeURI(string);
    }
}

