/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql;

import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdql.EvalFailureException;
import com.hp.hpl.jena.rdql.QSys;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryEngineExt;
import com.hp.hpl.jena.rdql.QueryException;
import com.hp.hpl.jena.rdql.RDQL_InternalErrorException;
import com.hp.hpl.jena.rdql.ResultBinding;
import com.hp.hpl.jena.rdql.Slot;
import com.hp.hpl.jena.rdql.Value;
import com.hp.hpl.jena.shared.JenaException;
import java.util.Iterator;

class TriplePattern {
    static final boolean DEBUG = false;
    boolean initialized = false;
    Slot subjectSlot;
    Resource fixed_s;
    Slot predicateSlot;
    Property fixed_p;
    Slot objectSlot;
    RDFNode fixed_o;
    QueryEngineExt queryEngine = null;
    static Model groundingModel = new ModelMem();

    public TriplePattern(Slot slot, Slot slot2, Slot slot3) {
        this.subjectSlot = slot;
        this.fixed_s = null;
        this.predicateSlot = slot2;
        this.fixed_p = null;
        this.objectSlot = slot3;
        this.fixed_o = null;
        this.initialized = false;
    }

    public boolean isGround() {
        return !this.subjectSlot.isVar() && !this.predicateSlot.isVar() && !this.objectSlot.isVar();
    }

    public Statement asStatement(ResultBinding resultBinding) {
        this.init(groundingModel);
        Resource resource = this.fixed_s;
        Property property = this.fixed_p;
        RDFNode rDFNode = this.fixed_o;
        try {
            Object object;
            if (resource == null && this.subjectSlot.isVar()) {
                object = resultBinding.get(this.subjectSlot.getVarName());
                if (object == null) {
                    return null;
                }
                if (object instanceof Resource) {
                    resource = (Resource)object;
                } else {
                    if (object instanceof Value) {
                        throw new RDQL_InternalErrorException("TriplePattern.substitute: Value bound to variable");
                    }
                    throw new RDQL_InternalErrorException("TriplePattern.substitute: variable bound to: " + object.getClass().getName());
                }
            }
            if (property == null && this.predicateSlot.isVar()) {
                object = resultBinding.get(this.predicateSlot.getVarName());
                if (object == null) {
                    return null;
                }
                if (object instanceof Property) {
                    property = (Property)object;
                } else if (object instanceof Resource) {
                    property = resource.getModel().createProperty(((Resource)object).getURI());
                } else {
                    if (object instanceof Value) {
                        throw new RDQL_InternalErrorException("TriplePattern.asStatment: value bound to variable");
                    }
                    throw new RDQL_InternalErrorException("TriplePattern.asStatment: variable bound to: " + object.getClass().getName());
                }
            }
            if (rDFNode == null && this.objectSlot.isVar()) {
                object = resultBinding.get(this.objectSlot.getVarName());
                if (object == null) {
                    return null;
                }
                if (object instanceof RDFNode) {
                    rDFNode = (RDFNode)object;
                } else {
                    if (object instanceof Value) {
                        throw new RDQL_InternalErrorException("TriplePattern.asStatment: value bound to variable");
                    }
                    throw new RDQL_InternalErrorException("TriplePattern.asStatment: variable bound to: " + object.getClass().getName());
                }
            }
            return resource.getModel().createStatement(resource, property, rDFNode);
        }
        catch (JenaException jenaException) {
            QSys.unhandledException(jenaException, "TriplePattern", "asStatment");
            return null;
        }
    }

    private void init(Model model) {
        if (this.initialized) {
            return;
        }
        try {
            if (this.subjectSlot.isValue()) {
                if (!this.subjectSlot.getValue().isURI()) {
                    throw new QueryException("TriplePattern: subject is not a URI");
                }
                this.fixed_s = model.createResource(this.subjectSlot.getValue().getURI());
            }
            if (this.subjectSlot.isResource()) {
                this.fixed_s = this.subjectSlot.getResource();
            }
            if (this.subjectSlot.isProperty()) {
                this.fixed_s = this.subjectSlot.getProperty();
            }
            if (this.predicateSlot.isValue()) {
                if (!this.predicateSlot.getValue().isURI()) {
                    throw new QueryException("TriplePattern: property is not a URI");
                }
                this.fixed_p = model.createProperty(this.predicateSlot.getValue().getURI());
            }
            if (this.predicateSlot.isProperty()) {
                this.fixed_p = this.predicateSlot.getProperty();
            }
            if (this.predicateSlot.isResource()) {
                this.fixed_p = this.resourceToProperty(model, this.predicateSlot.getResource());
            }
            if (this.objectSlot.isValue()) {
                this.fixed_o = this.valueToRDFNode(model, this.objectSlot.getValue());
            } else if (this.objectSlot.isProperty()) {
                this.fixed_o = this.objectSlot.getProperty();
            } else if (this.objectSlot.isResource()) {
                this.fixed_o = this.objectSlot.getResource();
            } else if (this.objectSlot.isLiteral()) {
                this.fixed_o = this.objectSlot.getLiteral();
            }
            this.initialized = true;
        }
        catch (JenaException jenaException) {
            QSys.unhandledException(jenaException, "TriplePattern", "init");
        }
    }

    public Iterator match(QueryEngineExt queryEngineExt, Model model, ResultBinding resultBinding) {
        this.queryEngine = queryEngineExt;
        if (!this.initialized) {
            this.init(model);
        }
        try {
            Object object;
            Object object2;
            Object object3;
            Resource resource = this.fixed_s;
            if (resource == null && resultBinding != null && this.subjectSlot.isVar() && (object3 = resultBinding.get(this.subjectSlot.getVarName())) != null) {
                if (object3 instanceof Resource) {
                    resource = (Resource)object3;
                } else {
                    if (object3 instanceof RDFNode) {
                        throw new EvalFailureException();
                    }
                    if (object3 instanceof Value) {
                        object2 = (Value)object3;
                        if (!object2.isURI()) {
                            throw new EvalFailureException();
                        }
                        resource = model.createResource(object2.getURI());
                    } else {
                        throw new RDQL_InternalErrorException("TriplePattern.match: Subject: Unexpected class in ResultBinding: " + object3.getClass().getName());
                    }
                }
            }
            if ((object3 = this.fixed_p) == null && resultBinding != null && this.predicateSlot.isVar() && (object2 = resultBinding.get(this.predicateSlot.getVarName())) != null) {
                if (object2 instanceof Property) {
                    object3 = (Property)object2;
                } else if (object2 instanceof Resource) {
                    object3 = this.resourceToProperty(model, (Resource)object2);
                    if (object3 == null) {
                        Query.logger.warn("TriplePattern: Attempt to match an anonymous resource with a property");
                        return null;
                    }
                } else {
                    if (object2 instanceof RDFNode) {
                        throw new RDQL_InternalErrorException("TriplePattern.match: Property: Unexpected RDFNode in ResultBinding: " + ((Object)((RDFNode)object2)).toString() + " (" + object2.getClass().getName() + ")");
                    }
                    if (object2 instanceof Value) {
                        object = (Value)object2;
                        if (!object.isURI()) {
                            throw new EvalFailureException();
                        }
                        object3 = model.createProperty(object.getURI());
                    }
                }
            }
            if ((object2 = this.fixed_o) == null && resultBinding != null && this.objectSlot.isVar() && (object = resultBinding.get(this.objectSlot.getVarName())) != null) {
                if (object instanceof RDFNode) {
                    object2 = (RDFNode)object;
                } else if (object instanceof Value) {
                    object2 = this.valueToRDFNode(model, (Value)object);
                } else {
                    throw new RDQL_InternalErrorException("TriplePattern.match: Object: Unexpected class in ResultBinding: " + object.getClass().getName());
                }
            }
            return new BindingIterator(model, resource, (Property)object3, (RDFNode)object2, resultBinding);
        }
        catch (EvalFailureException evalFailureException) {
            return null;
        }
        catch (JenaException jenaException) {
            QSys.unhandledException(jenaException, "TriplePattern", "match");
            return null;
        }
    }

    private RDFNode valueToRDFNode(Model model, Value value) {
        if (value.isRDFLiteral()) {
            return value.getRDFLiteral();
        }
        if (value.isRDFResource()) {
            return value.getRDFResource();
        }
        if (value.isURI()) {
            return model.createResource(value.getURI());
        }
        if (value.isInt()) {
            return model.createLiteral(value.getInt());
        }
        if (value.isDouble()) {
            return model.createLiteral(value.getDouble());
        }
        if (value.isBoolean()) {
            return model.createLiteral(value.getBoolean());
        }
        if (value.isString()) {
            return model.createLiteral(value.getString());
        }
        throw new QueryException("TriplePattern.valueToRDFNode: Unsupported value type: " + value);
    }

    private Property resourceToProperty(Model model, Resource resource) throws EvalFailureException {
        try {
            String string = resource.getURI();
            if (string == null || string.equals("")) {
                return null;
            }
            return model.createProperty(string);
        }
        catch (JenaException jenaException) {
            return null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this.subjectSlot.toString());
        stringBuffer.append(", ");
        stringBuffer.append(this.predicateSlot.toString());
        stringBuffer.append(", ");
        stringBuffer.append(this.objectSlot.toString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    class BindingIterator
    implements Iterator {
        StmtIterator sIter;
        Resource s;
        Property p;
        RDFNode o;
        ResultBinding currentBinding;
        Object current;
        boolean finished = false;

        BindingIterator(Model model, Resource resource, Property property, RDFNode rDFNode, ResultBinding resultBinding) {
            this.s = resource;
            this.p = property;
            this.o = rDFNode;
            this.currentBinding = resultBinding;
            try {
                this.sIter = model.listStatements(this.s, this.p, this.o);
            }
            catch (JenaException jenaException) {
                QSys.unhandledException(jenaException, "TriplePattern.BindingIterator(JenaException)", "BindingIterator");
            }
            catch (Throwable throwable) {
                QSys.unhandledException(throwable, "TriplePattern.BindingIterator(Throwable)", "BindingIterator");
            }
        }

        public boolean hasNext() {
            if (TriplePattern.this.queryEngine.queryStop) {
                this.finished = true;
                if (this.sIter != null) {
                    try {
                        this.sIter.close();
                    }
                    catch (JenaException jenaException) {
                        QSys.unhandledException(jenaException, "BindingIterator", "hasNext");
                    }
                    this.sIter = null;
                    return false;
                }
            }
            if (this.finished) {
                return false;
            }
            if (this.current == null) {
                this.current = this.process();
                String string = this.current != null ? ((ResultBinding)this.current).toString() : "<<null>>";
                Query.logger.debug("(" + Thread.currentThread().getName() + ") BindingIterator.next: " + string);
            }
            return this.current != null;
        }

        public Object next() {
            if (this.hasNext()) {
                String string = this.current != null ? ((ResultBinding)this.current).toString() : "<<null>>";
                Query.logger.debug("(" + Thread.currentThread().getName() + ") BindingIterator.next: " + string);
                Object object = this.current;
                this.current = null;
                return object;
            }
            return null;
        }

        private Object process() {
            try {
                RDFNode rDFNode;
                Property property;
                Resource resource;
                String string;
                String string2;
                String string3;
                Object object;
                block16: {
                    while (true) {
                        if (!this.sIter.hasNext()) {
                            this.finished = true;
                            this.sIter.close();
                            this.sIter = null;
                            object = Thread.currentThread().getName();
                            Query.logger.debug("(" + (String)object + ") sIter close");
                            return null;
                        }
                        object = this.sIter.nextStatement();
                        string3 = null;
                        string2 = null;
                        string = null;
                        resource = object.getSubject();
                        property = object.getPredicate();
                        rDFNode = object.getObject();
                        if (this.s == null) {
                            string3 = TriplePattern.this.subjectSlot.getVarName();
                        }
                        if (this.p == null) {
                            string2 = TriplePattern.this.predicateSlot.getVarName();
                            if (string3 != null && string3.equals(string2)) {
                                if (!property.equals(resource)) {
                                    Query.logger.debug("Triple binding clash: subject/predicate");
                                    continue;
                                }
                                string2 = null;
                            }
                        }
                        if (this.o != null) break block16;
                        string = TriplePattern.this.objectSlot.getVarName();
                        if (string3 != null && string3.equals(string)) {
                            if (!(rDFNode instanceof Resource) || !((Object)((Resource)rDFNode)).equals(resource)) {
                                Query.logger.debug("Triple binding clash: subject/object");
                                continue;
                            }
                            string = null;
                        }
                        if (string2 == null || !string2.equals(string)) break block16;
                        if (rDFNode instanceof Resource && ((Object)((Resource)rDFNode)).equals(property)) break;
                        Query.logger.debug("Triple binding clash: predicate/object");
                    }
                    string = null;
                }
                if (string3 == null && string2 == null && string == null) {
                    return this.currentBinding;
                }
                ResultBinding resultBinding = new ResultBinding(this.currentBinding);
                if (string3 != null) {
                    resultBinding.add(string3, resource);
                }
                if (string2 != null) {
                    resultBinding.add(string2, property);
                }
                if (string != null) {
                    resultBinding.add(string, rDFNode);
                }
                if (resultBinding.size() == 0) {
                    throw new RDQL_InternalErrorException("TriplePattern.BindingIterator: Environemnt is still empty");
                }
                resultBinding.addTriple((Statement)object);
                return resultBinding;
            }
            catch (JenaException jenaException) {
                QSys.unhandledException(jenaException, "TriplePattern.BindingIterator(JenaException)", "next");
            }
            catch (Throwable throwable) {
                QSys.unhandledException(throwable, "TriplePattern.BindingIterator(Throwable)", "next");
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException("BindingIterator.remove");
        }
    }
}

