/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdql.Constraint;
import com.hp.hpl.jena.rdql.QSys;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryException;
import com.hp.hpl.jena.rdql.QueryExecution;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.QueryResultsStream;
import com.hp.hpl.jena.rdql.RDQL_InternalErrorException;
import com.hp.hpl.jena.rdql.ResultBinding;
import com.hp.hpl.jena.rdql.Slot;
import com.hp.hpl.jena.rdql.TriplePattern;
import com.hp.hpl.jena.rdql.parser.ParsedLiteral;
import com.hp.hpl.jena.rdql.parser.Q_Var;
import com.hp.hpl.jena.util.ModelLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class QueryEngineExt
implements QueryExecution {
    Query query;
    Set results;
    static final int bufferCapacity = 5;
    Object endOfPipeMarker = new Object();
    volatile boolean queryStop = false;
    boolean queryInitialised = false;
    static int queryCount = 0;
    int idQueryExecution;
    long triplePatterns = 0L;
    long queryStartTime = -1L;
    static Model staticModel = ModelFactory.createDefaultModel();

    public QueryEngineExt(Query query) {
        this.query = query;
        this.queryStop = false;
        this.idQueryExecution = ++queryCount;
    }

    public void init() {
        if (this.queryInitialised) {
            return;
        }
        if (this.query.getSource() == null) {
            if (this.query.sourceURL == null) {
                Query.logger.warn("No data for query (no URL, no model)");
                throw new QueryException("No model for query");
            }
            long l = System.currentTimeMillis();
            this.query.setSource(ModelLoader.loadModel(this.query.sourceURL, null));
            this.query.loadTime = System.currentTimeMillis() - l;
        }
        this.queryInitialised = true;
    }

    public QueryResults exec() {
        return this.exec(null);
    }

    public QueryResults exec(ResultBinding resultBinding) {
        this.init();
        final BoundedBuffer boundedBuffer = new BoundedBuffer(5);
        final BoundedBuffer boundedBuffer2 = this.query.constraints.isEmpty() ? boundedBuffer : new BoundedBuffer(5);
        final ResultBinding resultBinding2 = resultBinding;
        this.queryStartTime = System.currentTimeMillis();
        new Thread("Triples-" + this.idQueryExecution){

            public void run() {
                QueryEngineExt.this.execTriples(boundedBuffer, resultBinding2);
            }
        }.start();
        if (boundedBuffer2 != boundedBuffer) {
            new Thread("Constraints-" + this.idQueryExecution){

                public void run() {
                    QueryEngineExt.this.execConstraints(boundedBuffer, boundedBuffer2);
                }
            }.start();
        } else {
            Query.logger.debug("No constraint pipe stage");
        }
        ResultsIterator resultsIterator = new ResultsIterator(boundedBuffer2);
        return new QueryResultsStream(this.query, this, resultsIterator);
    }

    public void abort() {
        if (!this.queryStop) {
            this.queryStop = true;
        }
    }

    public void close() {
        if (!this.queryStop) {
            this.queryStop = true;
        }
    }

    private void execConstraints(BoundedBuffer boundedBuffer, BoundedBuffer boundedBuffer2) {
        int n = 0;
        int n2 = 0;
        try {
            Object object;
            while (!this.queryStop && (object = boundedBuffer.take()) != this.endOfPipeMarker) {
                ++n;
                ResultBinding resultBinding = (ResultBinding)object;
                boolean bl = true;
                Iterator iterator = this.query.constraints.iterator();
                while (iterator.hasNext()) {
                    Constraint constraint = (Constraint)iterator.next();
                    if (constraint.isSatisfied(this.query, resultBinding)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                ++n2;
                boundedBuffer2.put(resultBinding);
            }
            boundedBuffer2.put(this.endOfPipeMarker);
            return;
        }
        catch (InterruptedException interruptedException) {
            QSys.unhandledException(interruptedException, "QueryEngineExt", "execConstraints");
            return;
        }
    }

    private void execTriples(BoundedBuffer boundedBuffer, ResultBinding resultBinding) {
        ArrayList<TriplePattern> arrayList = new ArrayList<TriplePattern>();
        Iterator iterator = this.query.triplePatterns.iterator();
        while (iterator.hasNext()) {
            Triple triple = (Triple)iterator.next();
            TriplePattern triplePattern = this.convertToTriplePattern(triple);
            arrayList.add(triplePattern);
        }
        try {
            this.execTriplesWorker(boundedBuffer, resultBinding, arrayList, 0);
            boundedBuffer.put(this.endOfPipeMarker);
        }
        catch (InterruptedException interruptedException) {
            QSys.unhandledException(interruptedException, "QueryEngineExt", "execTriples");
        }
    }

    private void execTriplesWorker(BoundedBuffer boundedBuffer, ResultBinding resultBinding, List list, int n) {
        Query.logger.debug("QueryEngineExt.execTriplesWorker: Triple matching: " + (n + 1) + " of " + this.query.triplePatterns.size());
        Query.logger.debug("QueryEngineExt.execTriplesWorker: Triple matching: " + (resultBinding == null ? "<<null ResultBinding>>" : resultBinding.toString()));
        if (this.queryStop) {
            return;
        }
        if (n > this.query.triplePatterns.size() - 1) {
            try {
                if (resultBinding != null) {
                    boundedBuffer.put(resultBinding);
                }
            }
            catch (InterruptedException interruptedException) {
                QSys.unhandledException(interruptedException, "QueryEngineExt", "execTriplesWorker");
            }
            return;
        }
        ++this.triplePatterns;
        int n2 = 0;
        TriplePattern triplePattern = (TriplePattern)list.get(n);
        Iterator iterator = triplePattern.match(this, this.query.source, resultBinding);
        if (iterator != null) {
            while (iterator.hasNext()) {
                ResultBinding resultBinding2 = (ResultBinding)iterator.next();
                Query.logger.debug("Env: " + resultBinding2);
                if (resultBinding2 == null) continue;
                ++n2;
                this.execTriplesWorker(boundedBuffer, resultBinding2, list, n + 1);
            }
        }
    }

    private TriplePattern convertToTriplePattern(Triple triple) {
        Slot slot = new Slot();
        Slot slot2 = new Slot();
        Slot slot3 = new Slot();
        this.convertToSlot(triple.getSubject(), slot);
        this.convertToSlot(triple.getPredicate(), slot2);
        this.convertToSlot(triple.getObject(), slot3);
        TriplePattern triplePattern = new TriplePattern(slot, slot2, slot3);
        return triplePattern;
    }

    private void convertToSlot(Node node, Slot slot) {
        if (node.isVariable()) {
            String string = node.getName();
            Q_Var q_Var = new Q_Var(-1);
            q_Var.setVarName(string);
            slot.set(q_Var);
            return;
        }
        if (node.isBlank()) {
            throw new RDQL_InternalErrorException("Blank node found coverting to old style QueryEngine");
        }
        if (node.isLiteral()) {
            LiteralImpl literalImpl = new LiteralImpl((Node)((Node_Literal)node), staticModel);
            slot.set(literalImpl);
            return;
        }
        if (node.isURI()) {
            ParsedLiteral parsedLiteral = new ParsedLiteral();
            parsedLiteral.setURI(node.getURI());
            slot.set(parsedLiteral);
            return;
        }
        System.err.println("Error: Slot not set: node is a " + node.getClass().getName());
    }

    class ResultsIterator
    implements Iterator {
        BoundedBuffer pipe;
        Object nextThing;

        ResultsIterator(BoundedBuffer boundedBuffer) {
            this.pipe = boundedBuffer;
            this.nextThing = null;
        }

        public boolean hasNext() {
            try {
                boolean bl;
                if (QueryEngineExt.this.queryStop) {
                    return false;
                }
                if (this.nextThing == null) {
                    this.nextThing = this.pipe.take();
                }
                boolean bl2 = bl = this.nextThing != QueryEngineExt.this.endOfPipeMarker;
                if (QueryEngineExt.this.query.executeTime == -1L) {
                    QueryEngineExt.this.query.executeTime = System.currentTimeMillis() - QueryEngineExt.this.queryStartTime;
                }
                return bl;
            }
            catch (InterruptedException interruptedException) {
                QSys.unhandledException(interruptedException, "ResultsIterator", "hasNext");
                return false;
            }
        }

        public Object next() {
            if (!this.hasNext()) {
                return null;
            }
            Object object = this.nextThing;
            this.nextThing = null;
            return object;
        }

        public void remove() {
            throw new UnsupportedOperationException("ResultsIterator.remove");
        }
    }
}

