/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashMap;
import junit.framework.TestSuite;

public class TestStatements
extends ModelTestBase {
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$test$TestStatements;

    public TestStatements(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$rdf$model$test$TestStatements == null ? (class$com$hp$hpl$jena$rdf$model$test$TestStatements = TestStatements.class$("com.hp.hpl.jena.rdf.model.test.TestStatements")) : class$com$hp$hpl$jena$rdf$model$test$TestStatements);
    }

    public void testStuff() {
        Model model = ModelFactory.createDefaultModel();
        Model model2 = ModelFactory.createDefaultModel();
        Resource resource = model.createResource();
        Property property = model.createProperty("");
        Statement statement = model2.createStatement(resource, property, resource);
        TestStatements.assertEquals("subject preserved", resource, statement.getSubject());
        TestStatements.assertEquals("object preserved", resource, statement.getObject());
    }

    public void testOtherStuff() {
        Model model = ModelFactory.createDefaultModel();
        Model model2 = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("jena:S");
        Resource resource2 = model.createResource("jena:R");
        Property property = model.createProperty("jena:P");
        Resource resource3 = model.createResource("jena:O");
        model.add(resource, property, resource3);
        model2.add(resource, property, resource3);
        TestStatements.assertTrue("X1", model.isIsomorphicWith(model2));
        model.add(resource2, RDF.subject, resource);
        model2.add(resource2, RDF.predicate, property);
        TestStatements.assertFalse("X2", model.isIsomorphicWith(model2));
        model.add(resource2, RDF.predicate, property);
        model2.add(resource2, RDF.subject, resource);
        TestStatements.assertTrue("X3", model.isIsomorphicWith(model2));
        model.add(resource2, RDF.object, resource3);
        model2.add(resource2, RDF.type, RDF.Statement);
        TestStatements.assertFalse("X4", model.isIsomorphicWith(model2));
        model.add(resource2, RDF.type, RDF.Statement);
        model2.add(resource2, RDF.object, resource3);
        TestStatements.assertTrue("X5", model.isIsomorphicWith(model2));
    }

    public void testSet() {
        Model model = ModelFactory.createDefaultModel();
        Model model2 = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("jena:S");
        Resource resource2 = model.createResource("jena:R");
        Property property = model.createProperty("jena:P");
        Resource resource3 = model.createResource("jena:O");
        Statement statement = model.createStatement(resource, property, resource3);
        Statement statement2 = model.createStatement(resource, property, resource3);
        TestStatements.assertEquals(statement, statement2);
        statement.changeObject(resource);
        HashMap<Statement, String> hashMap = new HashMap<Statement, String>();
        hashMap.put(statement2, "pontisbright");
        statement2.changeObject(resource);
    }

    public void testPortingBlankNodes() {
        Model model = ModelFactory.createDefaultModel();
        Model model2 = ModelFactory.createDefaultModel();
        Resource resource = model.createResource();
        Resource resource2 = (Resource)resource.inModel(model2);
        TestStatements.assertTrue("moved resource should still be blank", resource2.isAnon());
        TestStatements.assertEquals("move resource should equal original", resource, resource2);
    }

    public void testStatementPrintsType() {
        Literal literal;
        Property property;
        Model model = ModelFactory.createDefaultModel();
        String string = "fake:URI";
        Resource resource = model.createResource();
        Statement statement = model.createStatement(resource, property = TestStatements.property(model, "PP"), literal = model.createTypedLiteral("42", string));
        TestStatements.assertTrue(statement.toString().indexOf(string) > 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

