/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSimpleSelector
extends TestCase {
    Model model = null;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$test$TestSimpleSelector;

    public TestSimpleSelector(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$rdf$model$test$TestSimpleSelector == null ? (class$com$hp$hpl$jena$rdf$model$test$TestSimpleSelector = TestSimpleSelector.class$("com.hp.hpl.jena.rdf.model.test.TestSimpleSelector")) : class$com$hp$hpl$jena$rdf$model$test$TestSimpleSelector);
    }

    protected void setUp() throws Exception {
        this.model = ModelFactory.createDefaultModel();
        this.model.createResource().addProperty(RDF.type, RDFS.Resource).addProperty(RDFS.label, "foo").addProperty(RDF.value, "123");
        this.model.createResource().addProperty(RDF.type, RDFS.Resource).addProperty(RDFS.label, "bar").addProperty(RDF.value, "123");
    }

    protected void tearDown() throws Exception {
        this.model = null;
    }

    public void testSimpleIsSimple() {
        TestSimpleSelector.assertTrue(new SimpleSelector(null, null, (RDFNode)null).isSimple());
    }

    public void testSimpleSubclassIsntSimple() {
        TestSimpleSelector.assertFalse(new SimpleSelector(null, null, (RDFNode)null){}.isSimple());
    }

    public void testAll() {
        StmtIterator stmtIterator = this.model.listStatements(new SimpleSelector(null, null, (RDFNode)null));
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            stmtIterator.next();
        }
        TestSimpleSelector.assertEquals(6, n);
    }

    public void testFindProperty() {
        StmtIterator stmtIterator = this.model.listStatements(new SimpleSelector(null, RDFS.label, (RDFNode)null));
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            Statement statement = stmtIterator.nextStatement();
            TestSimpleSelector.assertEquals(RDFS.label, statement.getPredicate());
        }
        TestSimpleSelector.assertEquals(2, n);
    }

    public void testFindObject() {
        StmtIterator stmtIterator = this.model.listStatements(new SimpleSelector(null, null, RDFS.Resource));
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            Statement statement = stmtIterator.nextStatement();
            TestSimpleSelector.assertEquals(RDFS.Resource, statement.getObject());
        }
        TestSimpleSelector.assertEquals(2, n);
    }

    public void testFindSubject() {
        StmtIterator stmtIterator = this.model.listStatements(new SimpleSelector(null, null, RDFS.Resource));
        TestSimpleSelector.assertTrue(stmtIterator.hasNext());
        Resource resource = stmtIterator.nextStatement().getSubject();
        stmtIterator = this.model.listStatements(new SimpleSelector(resource, null, (RDFNode)null));
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            Statement statement = stmtIterator.nextStatement();
            TestSimpleSelector.assertEquals(resource, statement.getSubject());
        }
        TestSimpleSelector.assertEquals(3, n);
    }

    public void testFindPropertyAndObject() {
        StmtIterator stmtIterator = this.model.listStatements(new SimpleSelector(null, RDF.value, 123L));
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            Statement statement = stmtIterator.nextStatement();
            TestSimpleSelector.assertEquals(RDF.value, statement.getPredicate());
            TestSimpleSelector.assertEquals(123, statement.getInt());
        }
        TestSimpleSelector.assertEquals(2, n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

