/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.Command;

public abstract class AbstractTestModel
extends ModelTestBase {
    private Model model;

    public AbstractTestModel(String string) {
        super(string);
    }

    public abstract Model getModel();

    public void setUp() {
        this.model = this.getModel();
    }

    public void tearDown() {
        this.model.close();
    }

    public void testTransactions() {
        Command command = null;
        if (this.model.supportsTransactions()) {
            this.model.executeInTransaction(command);
        }
    }

    public void testCreateResourceFromNode() {
        RDFNode rDFNode = this.model.getRDFNode(Node.create("spoo:S"));
        AbstractTestModel.assertTrue(rDFNode instanceof Resource);
        AbstractTestModel.assertEquals("spoo:S", ((Resource)rDFNode).getURI());
    }

    public void testCreateLiteralFromNode() {
        RDFNode rDFNode = this.model.getRDFNode(Node.create("42"));
        AbstractTestModel.assertTrue(rDFNode instanceof Literal);
        AbstractTestModel.assertEquals("42", ((Literal)rDFNode).getLexicalForm());
    }

    public void testCreateBlankFromNode() {
        RDFNode rDFNode = this.model.getRDFNode(Node.create("_Blank"));
        AbstractTestModel.assertTrue(rDFNode instanceof Resource);
        AbstractTestModel.assertEquals(new AnonId("_Blank"), ((Resource)rDFNode).getId());
    }

    public void testIsEmpty() {
        Statement statement = AbstractTestModel.statement(this.model, "model rdf:type nonEmpty");
        Statement statement2 = AbstractTestModel.statement(this.model, "pinky rdf:type Pig");
        AbstractTestModel.assertTrue(this.model.isEmpty());
        this.model.add(statement);
        AbstractTestModel.assertFalse(this.model.isEmpty());
        this.model.add(statement2);
        AbstractTestModel.assertFalse(this.model.isEmpty());
        this.model.remove(statement);
        AbstractTestModel.assertFalse(this.model.isEmpty());
        this.model.remove(statement2);
        AbstractTestModel.assertTrue(this.model.isEmpty());
    }

    public void testContainsResource() {
        AbstractTestModel.modelAdd(this.model, "x R y; _a P _b");
        AbstractTestModel.assertTrue(this.model.containsResource(AbstractTestModel.resource(this.model, "x")));
        AbstractTestModel.assertTrue(this.model.containsResource(AbstractTestModel.resource(this.model, "R")));
        AbstractTestModel.assertTrue(this.model.containsResource(AbstractTestModel.resource(this.model, "y")));
        AbstractTestModel.assertTrue(this.model.containsResource(AbstractTestModel.resource(this.model, "_a")));
        AbstractTestModel.assertTrue(this.model.containsResource(AbstractTestModel.resource(this.model, "P")));
        AbstractTestModel.assertTrue(this.model.containsResource(AbstractTestModel.resource(this.model, "_b")));
        AbstractTestModel.assertFalse(this.model.containsResource(AbstractTestModel.resource(this.model, "i")));
        AbstractTestModel.assertFalse(this.model.containsResource(AbstractTestModel.resource(this.model, "_j")));
    }

    public void testGetProperty() {
        AbstractTestModel.modelAdd(this.model, "x P a; x P b; x R c");
        Resource resource = AbstractTestModel.resource(this.model, "x");
        AbstractTestModel.assertEquals(AbstractTestModel.resource(this.model, "c"), resource.getProperty(AbstractTestModel.property(this.model, "R")).getObject());
        RDFNode rDFNode = resource.getProperty(AbstractTestModel.property(this.model, "P")).getObject();
        AbstractTestModel.assertTrue(rDFNode.equals(AbstractTestModel.resource(this.model, "a")) || rDFNode.equals(AbstractTestModel.resource(this.model, "b")));
        AbstractTestModel.assertNull(resource.getProperty(AbstractTestModel.property(this.model, "noSuchPropertyHere")));
    }
}

