/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.shared.InvalidPropertyURIException;
import com.hp.hpl.jena.vocabulary.RDF;
import org.apache.log4j.Logger;

public class PropertyImpl
extends ResourceImpl
implements Property {
    public static final Implementation factory = new Implementation(){

        public boolean canWrap(Node node, EnhGraph enhGraph) {
            return node.isURI();
        }

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            return new PropertyImpl(node, enhGraph);
        }
    };
    protected static Logger logger = Logger.getLogger(class$com$hp$hpl$jena$rdf$model$impl$PropertyImpl == null ? (class$com$hp$hpl$jena$rdf$model$impl$PropertyImpl = PropertyImpl.class$("com.hp.hpl.jena.rdf.model.impl.PropertyImpl")) : class$com$hp$hpl$jena$rdf$model$impl$PropertyImpl);
    protected int ordinal = 0;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$impl$PropertyImpl;

    public PropertyImpl(String string) {
        super(string);
        this.checkLocalName();
        this.checkOrdinal();
    }

    public RDFNode inModel(Model model) {
        return this.getModel() == model ? this : model.createProperty(this.getURI());
    }

    private void checkLocalName() {
        String string = this.getLocalName();
        if (string == null || string.equals("")) {
            throw new InvalidPropertyURIException(this.getURI());
        }
    }

    public PropertyImpl(String string, String string2) {
        super(string, string2);
        this.checkLocalName();
        this.checkOrdinal();
    }

    public PropertyImpl(String string, Model model) {
        super(string, model);
        this.checkOrdinal();
    }

    public PropertyImpl(String string, String string2, Model model) {
        super(string, string2, model);
        this.checkOrdinal();
    }

    public PropertyImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
        this.checkOrdinal();
    }

    public PropertyImpl(String string, String string2, int n, Model model) {
        super(string, string2, model);
        this.checkLocalName();
        this.ordinal = n;
    }

    public boolean isProperty() {
        return true;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    protected void checkOrdinal() {
        String string = this.getNameSpace();
        String string2 = this.getLocalName();
        if (string2.length() > 0 && string2.charAt(0) == '_' && string.equals(RDF.getURI()) && string.equals(RDF.getURI()) && string2.length() > 1) {
            for (int i = 1; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (c >= '0' && c <= '9') continue;
                return;
            }
            try {
                this.ordinal = Integer.parseInt(string2.substring(1));
            }
            catch (NumberFormatException numberFormatException) {
                logger.error("checkOrdinal fails on " + string2, numberFormatException);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

