/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.IStream;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.SyntaxError;
import com.hp.hpl.jena.shared.UnknownPropertyException;
import com.hp.hpl.jena.util.FileUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class NTripleReader
implements RDFReader {
    static final Logger log = Logger.getLogger(class$com$hp$hpl$jena$rdf$model$impl$NTripleReader == null ? (class$com$hp$hpl$jena$rdf$model$impl$NTripleReader = NTripleReader.class$("com.hp.hpl.jena.rdf.model.impl.NTripleReader")) : class$com$hp$hpl$jena$rdf$model$impl$NTripleReader);
    private Model model = null;
    private Hashtable anons = new Hashtable();
    private IStream in = null;
    private boolean inErr = false;
    private int errCount = 0;
    private static final int sbLength = 200;
    private RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();
    private String base;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$impl$NTripleReader;

    NTripleReader() {
    }

    public void read(Model model, InputStream inputStream, String string) {
        this.read(model, FileUtils.asUTF8(inputStream), string);
    }

    public void read(Model model, Reader reader, String string) {
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        this.model = model;
        this.base = string == null ? "" : string + ": ";
        this.in = new IStream(reader);
        this.readRDF();
        if (this.errCount != 0) {
            throw new SyntaxError("unknown");
        }
    }

    public void read(Model model, String string) {
        try {
            this.read(model, new InputStreamReader(new URL(string).openStream()), string);
        }
        catch (Exception exception) {
            throw new JenaException(exception);
        }
        finally {
            if (this.errCount != 0) {
                throw new SyntaxError("unknown");
            }
        }
    }

    public Object setProperty(String string, Object object) {
        this.errorHandler.error(new UnknownPropertyException(string));
        return null;
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler rDFErrorHandler) {
        RDFErrorHandler rDFErrorHandler2 = this.errorHandler;
        this.errorHandler = rDFErrorHandler;
        return rDFErrorHandler2;
    }

    protected void readRDF() {
        Property property = null;
        while (!this.in.eof()) {
            while (!this.in.eof()) {
                this.inErr = false;
                this.skipWhiteSpace();
                if (this.in.eof()) {
                    return;
                }
                Resource resource = this.readResource();
                if (this.inErr) break;
                this.skipWhiteSpace();
                try {
                    property = this.model.createProperty(this.readResource().getURI());
                }
                catch (Exception exception) {
                    this.errorHandler.fatalError(exception);
                }
                if (this.inErr) break;
                this.skipWhiteSpace();
                RDFNode rDFNode = this.readNode();
                if (this.inErr) break;
                this.skipWhiteSpace();
                if (this.badEOF() || !this.expect(".")) break;
                try {
                    this.model.add(resource, property, rDFNode);
                }
                catch (Exception exception) {
                    this.errorHandler.fatalError(exception);
                }
            }
            if (!this.inErr) continue;
            ++this.errCount;
            while (!this.in.eof() && this.in.readChar() != '\n') {
            }
        }
    }

    public Resource readResource() {
        char c = this.in.readChar();
        if (this.badEOF()) {
            return null;
        }
        if (c == '_') {
            if (!this.expect(":")) {
                return null;
            }
            String string = this.readName();
            if (string == null) {
                this.syntaxError("expected bNode label");
                return null;
            }
            return this.lookupResource(string);
        }
        if (c == '<') {
            String string = this.readURI();
            if (string == null) {
                this.inErr = true;
                return null;
            }
            c = this.in.readChar();
            if (c != '>') {
                this.syntaxError("expected '>'");
                return null;
            }
            return this.model.createResource(string);
        }
        this.syntaxError("unexpected input");
        return null;
    }

    public RDFNode readNode() {
        this.skipWhiteSpace();
        switch (this.in.nextChar()) {
            case '\"': {
                return this.readLiteral(false);
            }
            case 'x': {
                return this.readLiteral(true);
            }
            case '<': 
            case '_': {
                return this.readResource();
            }
        }
        this.syntaxError("unexpected input");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Literal readLiteral(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(200);
        if (bl) {
            this.deprecated("Use ^^rdf:XMLLiteral not xml\"literals\", .");
            if (!this.expect("xml")) {
                return null;
            }
        }
        if (!this.expect("\"")) {
            return null;
        }
        while (true) {
            int n;
            block22: {
                block23: {
                    char c;
                    block25: {
                        block24: {
                            n = this.in.readChar();
                            if (this.badEOF()) {
                                return null;
                            }
                            if (n != 92) break block23;
                            c = this.in.readChar();
                            if (this.in.eof()) {
                                this.inErr = true;
                                return null;
                            }
                            if (c != 'n') break block24;
                            n = 10;
                            break block22;
                        }
                        if (c != 'r') break block25;
                        n = 13;
                        break block22;
                    }
                    if (c == 't') {
                        n = 9;
                        break block22;
                    } else if (c == '\\' || c == '\"') {
                        n = c;
                        break block22;
                    } else {
                        if (c != 'u') {
                            this.syntaxError("illegal escape sequence '" + c + "'");
                            return null;
                        }
                        n = this.readUnicode4Escape();
                        if (this.inErr) {
                            return null;
                        }
                    }
                    break block22;
                }
                if (n == 34) {
                    String string;
                    if ('@' == this.in.nextChar()) {
                        this.expect("@");
                        string = this.readLang();
                    } else if ('-' == this.in.nextChar()) {
                        this.expect("-");
                        this.deprecated("Language tags should be introduced with @ not -.");
                        string = this.readLang();
                    } else {
                        string = "";
                    }
                    if (bl) {
                        return this.model.createLiteral(stringBuffer.toString(), bl);
                    }
                    if ('^' != this.in.nextChar()) {
                        return this.model.createLiteral(stringBuffer.toString(), string);
                    }
                    String string2 = null;
                    if (!this.expect("^^<")) {
                        this.syntaxError("ill-formed datatype");
                        return null;
                    }
                    string2 = this.readURI();
                    if (string2 == null || !this.expect(">")) {
                        return null;
                    }
                    if (string.length() > 0) {
                        this.deprecated("Language tags are not permitted on typed literals.");
                    }
                    return this.model.createTypedLiteral(stringBuffer.toString(), string2);
                }
            }
            stringBuffer = stringBuffer.append((char)n);
        }
    }

    private char readUnicode4Escape() {
        char[] cArray = new char[]{this.in.readChar(), this.in.readChar(), this.in.readChar(), this.in.readChar()};
        if (this.badEOF()) {
            return '\u0000';
        }
        try {
            return (char)Integer.parseInt(new String(cArray), 16);
        }
        catch (NumberFormatException numberFormatException) {
            this.syntaxError("bad unicode escape sequence");
            return '\u0000';
        }
    }

    private void deprecated(String string) {
        this.errorHandler.warning(new SyntaxError(this.syntaxErrorMessage("Deprecation warning", string, this.in.getLinepos(), this.in.getCharpos())));
    }

    private void syntaxError(String string) {
        this.errorHandler.error(new SyntaxError(this.syntaxErrorMessage("Syntax error", string, this.in.getLinepos(), this.in.getCharpos())));
        this.inErr = true;
    }

    private String readLang() {
        StringBuffer stringBuffer = new StringBuffer(15);
        char c;
        while (!Character.isWhitespace(c = this.in.nextChar()) && c != '.' && c != '^') {
            stringBuffer = stringBuffer.append(this.in.readChar());
        }
        return stringBuffer.toString();
    }

    private boolean badEOF() {
        if (this.in.eof()) {
            this.syntaxError("premature end of file");
        }
        return this.inErr;
    }

    protected String readURI() {
        StringBuffer stringBuffer = new StringBuffer(200);
        while (this.in.nextChar() != '>') {
            char c = this.in.readChar();
            if (c == '\\') {
                this.expect("u");
                c = this.readUnicode4Escape();
            }
            if (this.badEOF()) {
                return null;
            }
            stringBuffer = stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    protected String readName() {
        StringBuffer stringBuffer = new StringBuffer(200);
        while (!Character.isWhitespace(this.in.nextChar())) {
            stringBuffer = stringBuffer.append(this.in.readChar());
            if (!this.badEOF()) continue;
            return null;
        }
        return stringBuffer.toString();
    }

    private boolean expect(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (this.badEOF()) {
                return false;
            }
            char c2 = this.in.readChar();
            if (c2 == c) continue;
            this.syntaxError("expected \"" + string + "\"");
            return false;
        }
        return true;
    }

    protected void skipWhiteSpace() {
        while (Character.isWhitespace(this.in.nextChar()) || this.in.nextChar() == '#') {
            char c = this.in.readChar();
            if (this.in.eof()) {
                return;
            }
            if (c != '#') continue;
            while (c != '\n') {
                c = this.in.readChar();
                if (!this.in.eof()) continue;
                return;
            }
        }
    }

    protected Resource lookupResource(String string) {
        Resource resource = (Resource)this.anons.get(string);
        if (resource == null) {
            resource = this.model.createResource();
            this.anons.put(string, resource);
        }
        return resource;
    }

    protected String syntaxErrorMessage(String string, String string2, int n, int n2) {
        return this.base + string + " at line " + n + " position " + n2 + ": " + string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

