/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Container;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ContNodeIteratorFactoryImpl;
import com.hp.hpl.jena.rdf.model.impl.ContainerI;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.NodeIteratorFactory;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.shared.AssertionFailureException;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Vector;

public class ContainerImpl
extends ResourceImpl
implements Container,
ContainerI {
    static NodeIteratorFactory iteratorFactory = new ContNodeIteratorFactoryImpl();

    public ContainerImpl(Model model) {
        super(model);
    }

    public ContainerImpl(String string, Model model) {
        super(string, model);
    }

    public ContainerImpl(Resource resource, Model model) {
        super(resource.asNode(), model);
    }

    public ContainerImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
    }

    protected ContainerImpl(Resource resource) {
        this(resource, resource.getModel());
    }

    private boolean is(Resource resource) {
        return this.hasProperty(RDF.type, resource);
    }

    public boolean isAlt() {
        return this.is(RDF.Alt);
    }

    public boolean isBag() {
        return this.is(RDF.Bag);
    }

    public boolean isSeq() {
        return this.is(RDF.Seq);
    }

    public Container add(RDFNode rDFNode) {
        int n = this.size();
        this.addProperty(RDF.li(n + 1), rDFNode);
        return this;
    }

    public Container add(boolean bl) {
        return this.add(String.valueOf(bl));
    }

    public Container add(long l) {
        return this.add(String.valueOf(l));
    }

    public Container add(char c) {
        return this.add(String.valueOf(c));
    }

    public Container add(float f) {
        return this.add(String.valueOf(f));
    }

    public Container add(double d) {
        return this.add(String.valueOf(d));
    }

    public Container add(Object object) {
        return this.add(String.valueOf(object));
    }

    public Container add(String string) {
        return this.add(string, "");
    }

    public Container add(String string, String string2) {
        return this.add(this.literal(string, string2));
    }

    public boolean contains(RDFNode rDFNode) {
        return this.containerContains(rDFNode);
    }

    public boolean contains(boolean bl) {
        return this.contains(String.valueOf(bl));
    }

    public boolean contains(long l) {
        return this.contains(String.valueOf(l));
    }

    public boolean contains(char c) {
        return this.contains(String.valueOf(c));
    }

    public boolean contains(float f) {
        return this.contains(String.valueOf(f));
    }

    public boolean contains(double d) {
        return this.contains(String.valueOf(d));
    }

    public boolean contains(Object object) {
        return this.contains(String.valueOf(object));
    }

    public boolean contains(String string) {
        return this.contains(string, "");
    }

    public boolean contains(String string, String string2) {
        return this.contains(this.literal(string, string2));
    }

    private Literal literal(String string, String string2) {
        return new LiteralImpl(Node.createLiteral(string, string2, false), this.getModel());
    }

    public NodeIterator iterator() {
        return this.listContainerMembers(iteratorFactory);
    }

    public int size() {
        int n = 0;
        StmtIterator stmtIterator = this.listProperties();
        while (stmtIterator.hasNext()) {
            if (stmtIterator.nextStatement().getPredicate().getOrdinal() == 0) continue;
            ++n;
        }
        stmtIterator.close();
        return n;
    }

    public Container remove(Statement statement) {
        int n = this.size();
        Statement statement2 = null;
        if (statement.getPredicate().getOrdinal() == n) {
            this.getModel().remove(statement);
        } else {
            statement2 = this.getModel().getRequiredProperty(this, RDF.li(n));
            statement.changeObject(statement2.getObject());
            this.getModel().remove(statement2);
        }
        if (this.size() != n - 1) {
            throw new AssertionFailureException("container size");
        }
        return this;
    }

    public Container remove(int n, RDFNode rDFNode) {
        this.remove(this.getModel().createStatement((Resource)this, RDF.li(n), rDFNode));
        return this;
    }

    public NodeIterator listContainerMembers(NodeIteratorFactory nodeIteratorFactory) {
        StmtIterator stmtIterator = this.listProperties();
        Vector<Statement> vector = new Vector<Statement>();
        int n = 0;
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            int n2 = statement.getPredicate().getOrdinal();
            if (n2 == 0) continue;
            if (n2 > n) {
                n = n2;
                vector.setSize(n2);
            }
            vector.setElementAt(statement, n2 - 1);
        }
        stmtIterator.close();
        return nodeIteratorFactory.createIterator(vector.iterator(), vector, this);
    }

    public int containerIndexOf(RDFNode rDFNode) {
        int n = 0;
        StmtIterator stmtIterator = this.listProperties();
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            int n2 = statement.getPredicate().getOrdinal();
            if (n2 == 0 || !rDFNode.equals(statement.getObject())) continue;
            n = n2;
            break;
        }
        stmtIterator.close();
        return n;
    }

    public boolean containerContains(RDFNode rDFNode) {
        return this.containerIndexOf(rDFNode) != 0;
    }
}

