/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.tidy;

import com.hp.hpl.jena.ontology.tidy.Grammar;
import com.hp.hpl.jena.ontology.tidy.Q;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

class CategorySet
implements Comparable {
    private static final int[] cycles = new int[]{3, 5, 4};
    static final Q cyclicSets = new Q(){

        boolean test(int[] nArray) {
            return this.intersect(cycles, nArray);
        }
    };
    static final Q untypedSets = new Q(){

        boolean test(int[] nArray) {
            return this.member(2, nArray);
        }
    };
    static final Q disjointWithSets = new Q(){

        boolean test(int[] nArray) {
            return nArray[0] != 1 && this.intersect(Grammar.disjointWithX, nArray);
        }
    };
    private static final int[] orphanTypes = new int[]{113, 135};
    static final Q orphanSets = new Q(){

        boolean test(int[] nArray) {
            return nArray[0] == 1 && this.intersect(orphanTypes, nArray);
        }
    };
    static final Q dlOrphanSets = new Q(){

        boolean test(int[] nArray) {
            return nArray[0] == 1 && (this.intersect(Grammar.restrictionsX, nArray) || this.intersect(Grammar.descriptionsX, nArray));
        }
    };
    static final Q cyclicOrphanSets = new Q(){

        boolean test(int[] nArray) {
            return nArray[0] == 1 && this.member(19, nArray) && this.intersect(cycles, nArray);
        }
    };
    static final Q structuredOne = new Q(){

        boolean test(int[] nArray) {
            return this.member(21, nArray) || this.member(101, nArray) || this.intersect(Grammar.descriptionsX, nArray);
        }
    };
    static final Q structuredTwo = new Q(){

        boolean test(int[] nArray) {
            return this.intersect(Grammar.listsX, nArray) || this.intersect(Grammar.restrictionsX, nArray);
        }
    };
    private static Q[] various = new Q[]{cyclicSets, untypedSets, structuredOne, structuredTwo, disjointWithSets};
    private static Q[] orphaned = new Q[]{orphanSets, dlOrphanSets, cyclicOrphanSets};
    private static final SortedSet sorted = new TreeSet();
    private static final Vector unsorted = new Vector();
    private int[] cats;
    private int id;

    private CategorySet(int[] nArray) {
        this.cats = nArray;
    }

    public int compareTo(Object object) {
        CategorySet categorySet = (CategorySet)object;
        int n = this.cats.length - categorySet.cats.length;
        for (int i = 0; n == 0 && i < this.cats.length; ++i) {
            n = this.cats[i] - categorySet.cats[i];
        }
        return n;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.cats.length; ++i) {
            n ^= this.cats[i] << i % 4;
        }
        return n;
    }

    static synchronized int find(int[] nArray, boolean bl) {
        int n;
        CategorySet categorySet;
        CategorySet categorySet2;
        SortedSet<CategorySet> sortedSet;
        if (!bl) {
            Arrays.sort(nArray);
        }
        if (!(sortedSet = sorted.tailSet(categorySet2 = new CategorySet(nArray))).isEmpty() && (categorySet = sortedSet.first()).equals(categorySet2)) {
            return categorySet.id;
        }
        categorySet2.id = unsorted.size();
        unsorted.add(categorySet2);
        sorted.add(categorySet2);
        for (n = 0; n < various.length; ++n) {
            various[n].testAdd(categorySet2.id, nArray);
        }
        if (nArray[0] == 1) {
            for (n = 0; n < orphaned.length; ++n) {
                orphaned[n].testAdd(categorySet2.id, nArray);
            }
        }
        return categorySet2.id;
    }

    static int[] getSet(int n) {
        return ((CategorySet)CategorySet.unsorted.elementAt((int)n)).cats;
    }
}

