/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.path.impl.test;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.path.Path;
import com.hp.hpl.jena.ontology.path.PathException;
import com.hp.hpl.jena.ontology.path.PathExpr;
import com.hp.hpl.jena.ontology.path.PathFactory;
import com.hp.hpl.jena.ontology.path.PathIterator;
import com.hp.hpl.jena.ontology.path.PathSet;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import junit.framework.TestCase;

public class TestPath
extends TestCase {
    protected static final String NS = "http://test/path#";
    protected static Object[][] s_stmts = new Object[][]{{"a", "p", "b"}, {"a", "q", "c"}, {"b", "q", "d0"}, {"b", "p", "d1"}, {"b", "p", "d2"}, {"d1", "q", "e1"}, {"d1", "q", "e2"}, {"e", "q", "e"}, {"e", "p", "e"}, {"f0", "q", "f1"}, {"f0", "q", "f2"}, {"f1", "q", "f4"}, {"f2", "q", "f4"}, {"f2", "q", "f3"}};
    protected OntModel m_model = ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#");
    protected Property m_p;
    protected Property m_q;
    protected Resource m_a;
    protected Resource m_b;
    protected Resource m_c;
    protected Resource m_e;

    public TestPath(String string) {
        super(string);
    }

    public void setUp() {
        for (int i = 0; i < s_stmts.length; ++i) {
            Resource resource = this.m_model.getResource(NS + (String)s_stmts[i][0]);
            Property property = this.m_model.getProperty(NS + (String)s_stmts[i][1]);
            Resource resource2 = this.m_model.getResource(NS + (String)s_stmts[i][2]);
            this.m_model.add(resource, property, resource2);
        }
        this.m_p = this.m_model.getProperty("http://test/path#p");
        this.m_q = this.m_model.getProperty("http://test/path#q");
        this.m_a = this.m_model.getResource("http://test/path#a");
        this.m_b = this.m_model.getResource("http://test/path#b");
        this.m_c = this.m_model.getResource("http://test/path#c");
        this.m_e = this.m_model.getResource("http://test/path#e");
    }

    public void tearDown() {
    }

    public void testNamedUnitPath() {
        PathExpr pathExpr = PathFactory.unit(this.m_p);
        PathSet pathSet = pathExpr.asPathSet(this.m_a);
        TestPath.assertEquals("Unit path set over p from a should have size 1", 1, pathSet.size());
        TestPath.assertTrue("Path set should not be empty", !pathSet.isEmpty());
        PathIterator pathIterator = pathSet.paths();
        TestPath.assertTrue("Should be at least one path over p from a", pathIterator.hasNext());
        pathIterator.next();
        TestPath.assertTrue("Should be only one path over p from a", !pathIterator.hasNext());
        TestPath.assertEquals("Value should be b", this.m_b, pathSet.getValue());
        TestPath.assertTrue("should have value b", pathSet.hasValue(this.m_b));
        Path path = pathSet.paths().nextPath();
        TestPath.assertEquals("unit path should have length 1", 1, path.length());
        TestPath.assertTrue("should contain 'a p b' ", this.m_model.contains(this.m_a, this.m_p, this.m_b));
        pathSet.removeAll();
        TestPath.assertTrue("should not contain 'a p b' ", !this.m_model.contains(this.m_a, this.m_p, this.m_b));
        pathSet = pathExpr.asPathSet(this.m_a);
        TestPath.assertTrue("Path set should now be empty", pathSet.isEmpty());
        boolean bl = false;
        try {
            pathSet.getValue();
        }
        catch (PathException pathException) {
            bl = true;
        }
        TestPath.assertTrue("Getting value from empty path should raise exception", bl);
    }

    public void testAnyUnitPath() {
        PathExpr pathExpr = PathFactory.unit();
        PathSet pathSet = pathExpr.asPathSet(this.m_a);
        TestPath.assertEquals("Unit path set over p from a should have size 2", 2, pathSet.size());
        TestPath.assertTrue("Path set should not be empty", !pathSet.isEmpty());
        PathIterator pathIterator = pathSet.paths();
        TestPath.assertTrue("Should be at least one path over p from a", pathIterator.hasNext());
        pathIterator.next();
        TestPath.assertTrue("Should be at least two paths over p from a", pathIterator.hasNext());
        pathIterator.next();
        TestPath.assertTrue("Should be only two paths over p from a", !pathIterator.hasNext());
        TestPath.assertTrue("should have value b", pathSet.hasValue(this.m_b));
        TestPath.assertTrue("should have value c", pathSet.hasValue(this.m_c));
        Path path = pathSet.paths().nextPath();
        TestPath.assertEquals("unit path should have length 1", 1, path.length());
        TestPath.assertTrue("should contain 'a p b' ", this.m_model.contains(this.m_a, this.m_p, this.m_b));
        TestPath.assertTrue("should contain 'a p b' ", this.m_model.contains(this.m_a, this.m_q, this.m_c));
        pathSet.removeAll();
        TestPath.assertTrue("should not contain 'a p b' ", !this.m_model.contains(this.m_a, this.m_p, this.m_b));
        TestPath.assertTrue("should not contain 'a p b' ", !this.m_model.contains(this.m_a, this.m_q, this.m_c));
        pathSet = pathExpr.asPathSet(this.m_a);
        TestPath.assertTrue("Path set should now be empty", pathSet.isEmpty());
    }

    public void testComposeUnitPath() {
        PathExpr pathExpr = PathFactory.compose(this.m_p, this.m_q);
        PathSet pathSet = pathExpr.asPathSet(this.m_a);
        TestPath.assertTrue("p o q from node a should not be empty", !pathSet.isEmpty());
        TestPath.assertEquals("p o q from node a should have size 1", 1, pathSet.size());
        PathSet pathSet2 = pathExpr.asPathSet(this.m_b);
        TestPath.assertTrue("p o q from node b should not be empty", !pathSet2.isEmpty());
        TestPath.assertEquals("p o q from node b should have size 2", 2, pathSet2.size());
        Resource resource = this.m_model.getResource("http://test/path#e2");
        TestPath.assertTrue("p o q from node b should have e2 as a value", pathSet2.hasValue(resource));
        PathSet pathSet3 = pathExpr.asPathSet(this.m_e);
        TestPath.assertTrue("p o q from node e should not be empty", !pathSet3.isEmpty());
        TestPath.assertEquals("p o q from node e should have size 1", 1, pathSet3.size());
    }

    public void testComposeComplexPath() {
        PathExpr pathExpr = PathFactory.compose(this.m_p, this.m_p);
        PathExpr pathExpr2 = PathFactory.compose(pathExpr, this.m_q);
        TestPath.assertEquals("ppq size should be 2", 2, pathExpr2.asPathSet(this.m_a).size());
        Resource resource = this.m_model.getResource("http://test/path#e2");
        TestPath.assertTrue("p o p o q should have e2 as value", pathExpr2.asPathSet(this.m_a).hasValue(resource));
    }

    public void testClosurePath() {
        PathExpr pathExpr = PathFactory.closure(this.m_q);
        TestPath.assertEquals("q* from a should have size 1", 1, pathExpr.asPathSet(this.m_a).size());
        Resource resource = this.m_model.getResource("http://test/path#f0");
        TestPath.assertEquals("q* from f0 should have size 5", 5, pathExpr.asPathSet(resource).size());
        Resource resource2 = this.m_model.getResource("http://test/path#e");
        TestPath.assertEquals("q* from e should be size 1", 1, pathExpr.asPathSet(resource2).size());
        int n = 0;
        PathIterator pathIterator = PathFactory.closure(this.m_q, false).evaluate(resource2);
        for (n = 0; n < 100; ++n) {
            TestPath.assertTrue("Should be more on the path", pathIterator.hasNext());
            TestPath.assertEquals("Path length not correct", n + 1, pathIterator.nextPath().length());
        }
        TestPath.assertEquals("Did not complete iteration", 100, n);
    }
}

