/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.ontology.impl.test.OntTestBase;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class TestProperty
extends OntTestBase {
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntResource;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntClass;

    public static TestSuite suite() {
        return new TestProperty("TestProperty");
    }

    public TestProperty(String string) {
        super(string);
    }

    public OntTestBase.OntTestCase[] getTests() {
        return new OntTestBase.OntTestCase[]{new OntTestBase.OntTestCase("OntProperty.super-property", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntProperty ontProperty = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntProperty ontProperty2 = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#q");
                OntProperty ontProperty3 = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#r");
                ontProperty.addSuperProperty(ontProperty2);
                1.assertEquals("Cardinality should be 1", 1, ontProperty.getCardinality(profile.SUB_PROPERTY_OF()));
                1.assertEquals("p have super-prop q", ontProperty2, ontProperty.getSuperProperty());
                ontProperty.addSuperProperty(ontProperty3);
                1.assertEquals("Cardinality should be 2", 2, ontProperty.getCardinality(profile.SUB_PROPERTY_OF()));
                this.iteratorTest(ontProperty.listSuperProperties(), new Object[]{ontProperty2, ontProperty3});
                ontProperty.setSuperProperty(ontProperty3);
                1.assertEquals("Cardinality should be 1", 1, ontProperty.getCardinality(profile.SUB_PROPERTY_OF()));
                1.assertEquals("p shuold have super-prop r", ontProperty3, ontProperty.getSuperProperty());
                ontProperty.removeSuperProperty(ontProperty2);
                1.assertEquals("Cardinality should be 1", 1, ontProperty.getCardinality(profile.SUB_PROPERTY_OF()));
                ontProperty.removeSuperProperty(ontProperty3);
                1.assertEquals("Cardinality should be 0", 0, ontProperty.getCardinality(profile.SUB_PROPERTY_OF()));
            }
        }, new OntTestBase.OntTestCase("OntProperty.sub-property", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntProperty ontProperty = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntProperty ontProperty2 = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#q");
                OntProperty ontProperty3 = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#r");
                ontProperty.addSubProperty(ontProperty2);
                2.assertEquals("Cardinality should be 1", 1, ontProperty2.getCardinality(profile.SUB_PROPERTY_OF()));
                2.assertEquals("p have sub-prop q", ontProperty2, ontProperty.getSubProperty());
                ontProperty.addSubProperty(ontProperty3);
                2.assertEquals("Cardinality should be 2", 2, ontProperty2.getCardinality(profile.SUB_PROPERTY_OF()) + ontProperty3.getCardinality(profile.SUB_PROPERTY_OF()));
                this.iteratorTest(ontProperty.listSubProperties(), new Object[]{ontProperty2, ontProperty3});
                this.iteratorTest(ontProperty2.listSuperProperties(), new Object[]{ontProperty});
                this.iteratorTest(ontProperty3.listSuperProperties(), new Object[]{ontProperty});
                ontProperty.setSubProperty(ontProperty3);
                2.assertEquals("Cardinality should be 1", 1, ontProperty2.getCardinality(profile.SUB_PROPERTY_OF()) + ontProperty3.getCardinality(profile.SUB_PROPERTY_OF()));
                2.assertEquals("p should have sub-prop r", ontProperty3, ontProperty.getSubProperty());
                ontProperty.removeSubProperty(ontProperty2);
                2.assertTrue("Should have sub-prop r", ontProperty.hasSubProperty(ontProperty3, false));
                ontProperty.removeSubProperty(ontProperty3);
                2.assertTrue("Should not have sub-prop r", !ontProperty.hasSubProperty(ontProperty3, false));
            }
        }, new OntTestBase.OntTestCase("OntProperty.domain", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntProperty ontProperty = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntResource ontResource = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestProperty.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource ontResource2 = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestProperty.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                ontProperty.addDomain(ontResource);
                3.assertEquals("Cardinality should be 1", 1, ontProperty.getCardinality(profile.DOMAIN()));
                3.assertEquals("p have domain a", ontResource, ontProperty.getDomain());
                ontProperty.addDomain(ontResource2);
                3.assertEquals("Cardinality should be 2", 2, ontProperty.getCardinality(profile.DOMAIN()));
                this.iteratorTest(ontProperty.listDomain(), new Object[]{ontResource, ontResource2});
                ontProperty.setDomain(ontResource2);
                3.assertEquals("Cardinality should be 1", 1, ontProperty.getCardinality(profile.DOMAIN()));
                3.assertEquals("p should have domain b", ontResource2, ontProperty.getDomain());
                ontProperty.removeDomain(ontResource);
                3.assertEquals("Cardinality should be 1", 1, ontProperty.getCardinality(profile.DOMAIN()));
                ontProperty.removeDomain(ontResource2);
                3.assertEquals("Cardinality should be 0", 0, ontProperty.getCardinality(profile.DOMAIN()));
            }
        }, new OntTestBase.OntTestCase("OntProperty.range", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntProperty ontProperty = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntResource ontResource = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestProperty.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource ontResource2 = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestProperty.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                ontProperty.addRange(ontResource);
                4.assertEquals("Cardinality should be 1", 1, ontProperty.getCardinality(profile.RANGE()));
                4.assertEquals("p have range a", ontResource, ontProperty.getRange());
                ontProperty.addRange(ontResource2);
                4.assertEquals("Cardinality should be 2", 2, ontProperty.getCardinality(profile.RANGE()));
                this.iteratorTest(ontProperty.listRange(), new Object[]{ontResource, ontResource2});
                ontProperty.setRange(ontResource2);
                4.assertEquals("Cardinality should be 1", 1, ontProperty.getCardinality(profile.RANGE()));
                4.assertEquals("p should have range b", ontResource2, ontProperty.getRange());
                ontProperty.removeRange(ontResource);
                4.assertEquals("Cardinality should be 1", 1, ontProperty.getCardinality(profile.RANGE()));
                ontProperty.removeRange(ontResource2);
                4.assertEquals("Cardinality should be 0", 0, ontProperty.getCardinality(profile.RANGE()));
            }
        }, new OntTestBase.OntTestCase("OntProperty.equivalentProperty", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                ObjectProperty objectProperty2 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                ObjectProperty objectProperty3 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
                objectProperty.addEquivalentProperty(objectProperty2);
                5.assertEquals("Cardinality should be 1", 1, objectProperty.getCardinality(profile.EQUIVALENT_PROPERTY()));
                5.assertEquals("p have equivalentProperty q", objectProperty2, objectProperty.getEquivalentProperty());
                objectProperty.addEquivalentProperty(objectProperty3);
                5.assertEquals("Cardinality should be 2", 2, objectProperty.getCardinality(profile.EQUIVALENT_PROPERTY()));
                this.iteratorTest(objectProperty.listEquivalentProperties(), new Object[]{objectProperty2, objectProperty3});
                objectProperty.setEquivalentProperty(objectProperty3);
                5.assertEquals("Cardinality should be 1", 1, objectProperty.getCardinality(profile.EQUIVALENT_PROPERTY()));
                5.assertEquals("p should have equivalentProperty r", objectProperty3, objectProperty.getEquivalentProperty());
                objectProperty.removeEquivalentProperty(objectProperty2);
                5.assertEquals("Cardinality should be 1", 1, objectProperty.getCardinality(profile.EQUIVALENT_PROPERTY()));
                objectProperty.removeEquivalentProperty(objectProperty3);
                5.assertEquals("Cardinality should be 0", 0, objectProperty.getCardinality(profile.EQUIVALENT_PROPERTY()));
            }
        }, new OntTestBase.OntTestCase("OntProperty.inverseOf", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                ObjectProperty objectProperty2 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                ObjectProperty objectProperty3 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
                objectProperty.addInverseOf(objectProperty2);
                6.assertEquals("Cardinality should be 1", 1, objectProperty.getCardinality(profile.INVERSE_OF()));
                6.assertEquals("p should have inverse q", objectProperty2, objectProperty.getInverseOf());
                objectProperty.addInverseOf(objectProperty3);
                6.assertEquals("Cardinality should be 2", 2, objectProperty.getCardinality(profile.INVERSE_OF()));
                this.iteratorTest(objectProperty.listInverseOf(), new Object[]{objectProperty2, objectProperty3});
                objectProperty.setInverseOf(objectProperty3);
                6.assertEquals("Cardinality should be 1", 1, objectProperty.getCardinality(profile.INVERSE_OF()));
                6.assertEquals("p should have inverse r", objectProperty3, objectProperty.getInverseOf());
                objectProperty.removeInverseProperty(objectProperty2);
                6.assertEquals("Cardinality should be 1", 1, objectProperty.getCardinality(profile.INVERSE_OF()));
                objectProperty.removeInverseProperty(objectProperty3);
                6.assertEquals("Cardinality should be 0", 0, objectProperty.getCardinality(profile.INVERSE_OF()));
            }
        }, new OntTestBase.OntTestCase("OntProperty.subproperty.fromFile", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                String string = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String string2 = "file:testing/ontology/" + string + "/Property/test.rdf";
                ontModel.read(string2);
                OntProperty ontProperty = (OntProperty)ontModel.getProperty("http://jena.hpl.hp.com/testing/ontology#", "p").as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                OntProperty ontProperty2 = (OntProperty)ontModel.getProperty("http://jena.hpl.hp.com/testing/ontology#", "q").as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                this.iteratorTest(ontProperty.listSuperProperties(), new Object[]{ontProperty2});
                this.iteratorTest(ontProperty2.listSubProperties(), new Object[]{ontProperty});
            }
        }, new OntTestBase.OntTestCase("OntProperty.domain.fromFile", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                String string = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String string2 = "file:testing/ontology/" + string + "/Property/test.rdf";
                ontModel.read(string2);
                OntProperty ontProperty = (OntProperty)ontModel.getProperty("http://jena.hpl.hp.com/testing/ontology#", "p").as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                OntClass ontClass = (OntClass)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#ClassA").as(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = TestProperty.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass);
                8.assertTrue("p should have domain A", ontProperty.hasDomain(ontClass));
            }
        }, new OntTestBase.OntTestCase("OntProperty.range.fromFile", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                String string = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String string2 = "file:testing/ontology/" + string + "/Property/test.rdf";
                ontModel.read(string2);
                OntProperty ontProperty = (OntProperty)ontModel.getProperty("http://jena.hpl.hp.com/testing/ontology#", "p").as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                OntClass ontClass = (OntClass)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#ClassB").as(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = TestProperty.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass);
                9.assertTrue("p should have domain B", ontProperty.hasRange(ontClass));
            }
        }, new OntTestBase.OntTestCase("OntProperty.equivalentProeprty.fromFile", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                String string = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String string2 = "file:testing/ontology/" + string + "/Property/test.rdf";
                ontModel.read(string2);
                OntProperty ontProperty = (OntProperty)ontModel.getProperty("http://jena.hpl.hp.com/testing/ontology#", "p").as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                OntProperty ontProperty2 = (OntProperty)ontModel.getProperty("http://jena.hpl.hp.com/testing/ontology#", "r").as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                10.assertTrue("p should have equiv prop r", ontProperty.hasEquivalentProperty(ontProperty2));
            }
        }, new OntTestBase.OntTestCase("OntProperty.inversePropertyOf.fromFile", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                String string = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String string2 = "file:testing/ontology/" + string + "/Property/test.rdf";
                ontModel.read(string2);
                OntProperty ontProperty = (OntProperty)ontModel.getProperty("http://jena.hpl.hp.com/testing/ontology#", "p").as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                OntProperty ontProperty2 = (OntProperty)ontModel.getProperty("http://jena.hpl.hp.com/testing/ontology#", "s").as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                11.assertTrue("p should have inv prop s", ontProperty.isInverseOf(ontProperty2));
            }
        }, new OntTestBase.OntTestCase("OntProperty.isFunctionalProperty dt", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                DatatypeProperty datatypeProperty = ontModel.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
                12.assertTrue("isFunctionalProperty not correct", datatypeProperty.isFunctionalProperty());
                12.assertTrue("isDatatypeProperty not correct", datatypeProperty.isDatatypeProperty());
                12.assertTrue("isObjectProperty not correct", !datatypeProperty.isObjectProperty());
                12.assertTrue("isTransitiveProperty not correct", !datatypeProperty.isTransitiveProperty());
                12.assertTrue("isInverseFunctionalProperty not correct", !datatypeProperty.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    12.assertTrue("isSymmetricProperty not correct", !datatypeProperty.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.isFunctionalProperty object", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
                13.assertTrue("isFunctionalProperty not correct", objectProperty.isFunctionalProperty());
                13.assertTrue("isDatatypeProperty not correct", !objectProperty.isDatatypeProperty());
                13.assertTrue("isObjectProperty not correct", objectProperty.isObjectProperty());
                13.assertTrue("isTransitiveProperty not correct", !objectProperty.isTransitiveProperty());
                13.assertTrue("isInverseFunctionalProperty not correct", !objectProperty.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    13.assertTrue("isSymmetricProperty not correct", !objectProperty.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.isDatatypeProperty", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                DatatypeProperty datatypeProperty = ontModel.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
                14.assertTrue("isFunctionalProperty not correct", !datatypeProperty.isFunctionalProperty());
                14.assertTrue("isDatatypeProperty not correct", datatypeProperty.isDatatypeProperty());
                14.assertTrue("isObjectProperty not correct", !datatypeProperty.isObjectProperty());
                14.assertTrue("isTransitiveProperty not correct", !datatypeProperty.isTransitiveProperty());
                14.assertTrue("isInverseFunctionalProperty not correct", !datatypeProperty.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    14.assertTrue("isSymmetricProperty not correct", !datatypeProperty.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.isObjectProperty", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
                15.assertTrue("isFunctionalProperty not correct", !objectProperty.isFunctionalProperty());
                15.assertTrue("isDatatypeProperty not correct", !objectProperty.isDatatypeProperty());
                15.assertTrue("isObjectProperty not correct", objectProperty.isObjectProperty());
                15.assertTrue("isTransitiveProperty not correct", !objectProperty.isTransitiveProperty());
                15.assertTrue("isInverseFunctionalProperty not correct", !objectProperty.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    15.assertTrue("isSymmetricProperty not correct", !objectProperty.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.isTransitiveProperty", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                TransitiveProperty transitiveProperty = ontModel.createTransitiveProperty("http://jena.hpl.hp.com/testing/ontology#p");
                16.assertTrue("isFunctionalProperty not correct", !transitiveProperty.isFunctionalProperty());
                16.assertTrue("isDatatypeProperty not correct", !transitiveProperty.isDatatypeProperty());
                16.assertTrue("isObjectProperty not correct", !transitiveProperty.isObjectProperty());
                16.assertTrue("isTransitiveProperty not correct", transitiveProperty.isTransitiveProperty());
                16.assertTrue("isInverseFunctionalProperty not correct", !transitiveProperty.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    16.assertTrue("isSymmetricProperty not correct", !transitiveProperty.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.isInverseFunctionalProperty", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                InverseFunctionalProperty inverseFunctionalProperty = ontModel.createInverseFunctionalProperty("http://jena.hpl.hp.com/testing/ontology#p");
                17.assertTrue("isFunctionalProperty not correct", !inverseFunctionalProperty.isFunctionalProperty());
                17.assertTrue("isDatatypeProperty not correct", !inverseFunctionalProperty.isDatatypeProperty());
                17.assertTrue("isObjectProperty not correct", !inverseFunctionalProperty.isObjectProperty());
                17.assertTrue("isTransitiveProperty not correct", !inverseFunctionalProperty.isTransitiveProperty());
                17.assertTrue("isInverseFunctionalProperty not correct", inverseFunctionalProperty.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    17.assertTrue("isSymmetricProperty not correct", !inverseFunctionalProperty.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.isSymmetricProperty", true, true, false, false){

            public void ontTest(OntModel ontModel) throws Exception {
                SymmetricProperty symmetricProperty = ontModel.createSymmetricProperty("http://jena.hpl.hp.com/testing/ontology#p");
                18.assertTrue("isFunctionalProperty not correct", !symmetricProperty.isFunctionalProperty());
                18.assertTrue("isDatatypeProperty not correct", !symmetricProperty.isDatatypeProperty());
                18.assertTrue("isObjectProperty not correct", !symmetricProperty.isObjectProperty());
                18.assertTrue("isTransitiveProperty not correct", !symmetricProperty.isTransitiveProperty());
                18.assertTrue("isInverseFunctionalProperty not correct", !symmetricProperty.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    18.assertTrue("isSymmetricProperty not correct", symmetricProperty.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.convertToFunctionalProperty", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Property property = ontModel.createProperty("http://jena.hpl.hp.com/testing/ontology#", "p");
                property.addProperty(RDF.type, RDF.Property);
                OntProperty ontProperty = (OntProperty)property.as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                19.assertTrue("isFunctionalProperty not correct", !ontProperty.isFunctionalProperty());
                19.assertTrue("isDatatypeProperty not correct", !ontProperty.isDatatypeProperty());
                19.assertTrue("isObjectProperty not correct", !ontProperty.isObjectProperty());
                19.assertTrue("isTransitiveProperty not correct", !ontProperty.isTransitiveProperty());
                19.assertTrue("isInverseFunctionalProperty not correct", !ontProperty.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    19.assertTrue("isSymmetricProperty not correct", !ontProperty.isSymmetricProperty());
                }
                ontProperty = ontProperty.convertToFunctionalProperty();
                19.assertTrue("isFunctionalProperty not correct", ontProperty.isFunctionalProperty());
                19.assertTrue("isDatatypeProperty not correct", !ontProperty.isDatatypeProperty());
                19.assertTrue("isObjectProperty not correct", !ontProperty.isObjectProperty());
                19.assertTrue("isTransitiveProperty not correct", !ontProperty.isTransitiveProperty());
                19.assertTrue("isInverseFunctionalProperty not correct", !ontProperty.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    19.assertTrue("isSymmetricProperty not correct", !ontProperty.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.convertToDatatypeProperty", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Property property = ontModel.createProperty("http://jena.hpl.hp.com/testing/ontology#", "p");
                property.addProperty(RDF.type, RDF.Property);
                OntProperty ontProperty = (OntProperty)property.as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                20.assertTrue("isFunctionalProperty not correct", !ontProperty.isFunctionalProperty());
                20.assertTrue("isDatatypeProperty not correct", !ontProperty.isDatatypeProperty());
                20.assertTrue("isObjectProperty not correct", !ontProperty.isObjectProperty());
                20.assertTrue("isTransitiveProperty not correct", !ontProperty.isTransitiveProperty());
                20.assertTrue("isInverseFunctionalProperty not correct", !ontProperty.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    20.assertTrue("isSymmetricProperty not correct", !ontProperty.isSymmetricProperty());
                }
                20.assertTrue("isFunctionalProperty not correct", !(ontProperty = ontProperty.convertToDatatypeProperty()).isFunctionalProperty());
                20.assertTrue("isDatatypeProperty not correct", ontProperty.isDatatypeProperty());
                20.assertTrue("isObjectProperty not correct", !ontProperty.isObjectProperty());
                20.assertTrue("isTransitiveProperty not correct", !ontProperty.isTransitiveProperty());
                20.assertTrue("isInverseFunctionalProperty not correct", !ontProperty.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    20.assertTrue("isSymmetricProperty not correct", !ontProperty.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.convertToObjectProperty", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Property property = ontModel.createProperty("http://jena.hpl.hp.com/testing/ontology#", "p");
                property.addProperty(RDF.type, RDF.Property);
                OntProperty ontProperty = (OntProperty)property.as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                21.assertTrue("isFunctionalProperty not correct", !ontProperty.isFunctionalProperty());
                21.assertTrue("isDatatypeProperty not correct", !ontProperty.isDatatypeProperty());
                21.assertTrue("isObjectProperty not correct", !ontProperty.isObjectProperty());
                21.assertTrue("isTransitiveProperty not correct", !ontProperty.isTransitiveProperty());
                21.assertTrue("isInverseFunctionalProperty not correct", !ontProperty.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    21.assertTrue("isSymmetricProperty not correct", !ontProperty.isSymmetricProperty());
                }
                21.assertTrue("isFunctionalProperty not correct", !(ontProperty = ontProperty.convertToObjectProperty()).isFunctionalProperty());
                21.assertTrue("isDatatypeProperty not correct", !ontProperty.isDatatypeProperty());
                21.assertTrue("isObjectProperty not correct", ontProperty.isObjectProperty());
                21.assertTrue("isTransitiveProperty not correct", !ontProperty.isTransitiveProperty());
                21.assertTrue("isInverseFunctionalProperty not correct", !ontProperty.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    21.assertTrue("isSymmetricProperty not correct", !ontProperty.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.convertToTransitiveProperty", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Property property = ontModel.createProperty("http://jena.hpl.hp.com/testing/ontology#", "p");
                property.addProperty(RDF.type, RDF.Property);
                OntProperty ontProperty = (OntProperty)property.as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                22.assertTrue("isFunctionalProperty not correct", !ontProperty.isFunctionalProperty());
                22.assertTrue("isDatatypeProperty not correct", !ontProperty.isDatatypeProperty());
                22.assertTrue("isObjectProperty not correct", !ontProperty.isObjectProperty());
                22.assertTrue("isTransitiveProperty not correct", !ontProperty.isTransitiveProperty());
                22.assertTrue("isInverseFunctionalProperty not correct", !ontProperty.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    22.assertTrue("isSymmetricProperty not correct", !ontProperty.isSymmetricProperty());
                }
                22.assertTrue("isFunctionalProperty not correct", !(ontProperty = ontProperty.convertToTransitiveProperty()).isFunctionalProperty());
                22.assertTrue("isDatatypeProperty not correct", !ontProperty.isDatatypeProperty());
                22.assertTrue("isObjectProperty not correct", !ontProperty.isObjectProperty());
                22.assertTrue("isTransitiveProperty not correct", ontProperty.isTransitiveProperty());
                22.assertTrue("isInverseFunctionalProperty not correct", !ontProperty.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    22.assertTrue("isSymmetricProperty not correct", !ontProperty.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.convertToInverseFunctionalProperty", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Property property = ontModel.createProperty("http://jena.hpl.hp.com/testing/ontology#", "p");
                property.addProperty(RDF.type, RDF.Property);
                OntProperty ontProperty = (OntProperty)property.as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                23.assertTrue("isFunctionalProperty not correct", !ontProperty.isFunctionalProperty());
                23.assertTrue("isDatatypeProperty not correct", !ontProperty.isDatatypeProperty());
                23.assertTrue("isObjectProperty not correct", !ontProperty.isObjectProperty());
                23.assertTrue("isTransitiveProperty not correct", !ontProperty.isTransitiveProperty());
                23.assertTrue("isInverseFunctionalProperty not correct", !ontProperty.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    23.assertTrue("isSymmetricProperty not correct", !ontProperty.isSymmetricProperty());
                }
                23.assertTrue("isFunctionalProperty not correct", !(ontProperty = ontProperty.convertToInverseFunctionalProperty()).isFunctionalProperty());
                23.assertTrue("isDatatypeProperty not correct", !ontProperty.isDatatypeProperty());
                23.assertTrue("isObjectProperty not correct", !ontProperty.isObjectProperty());
                23.assertTrue("isTransitiveProperty not correct", !ontProperty.isTransitiveProperty());
                23.assertTrue("isInverseFunctionalProperty not correct", ontProperty.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    23.assertTrue("isSymmetricProperty not correct", !ontProperty.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.convertToSymmetricProperty", true, true, false, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Property property = ontModel.createProperty("http://jena.hpl.hp.com/testing/ontology#", "p");
                property.addProperty(RDF.type, RDF.Property);
                OntProperty ontProperty = (OntProperty)property.as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                24.assertTrue("isFunctionalProperty not correct", !ontProperty.isFunctionalProperty());
                24.assertTrue("isDatatypeProperty not correct", !ontProperty.isDatatypeProperty());
                24.assertTrue("isObjectProperty not correct", !ontProperty.isObjectProperty());
                24.assertTrue("isTransitiveProperty not correct", !ontProperty.isTransitiveProperty());
                24.assertTrue("isInverseFunctionalProperty not correct", !ontProperty.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    24.assertTrue("isSymmetricProperty not correct", !ontProperty.isSymmetricProperty());
                }
                24.assertTrue("isFunctionalProperty not correct", !(ontProperty = ontProperty.convertToSymmetricProperty()).isFunctionalProperty());
                24.assertTrue("isDatatypeProperty not correct", !ontProperty.isDatatypeProperty());
                24.assertTrue("isObjectProperty not correct", !ontProperty.isObjectProperty());
                24.assertTrue("isTransitiveProperty not correct", !ontProperty.isTransitiveProperty());
                24.assertTrue("isInverseFunctionalProperty not correct", !ontProperty.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    24.assertTrue("isSymmetricProperty not correct", ontProperty.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.inverse", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                ObjectProperty objectProperty2 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                ObjectProperty objectProperty3 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
                25.assertFalse("No inverse of p", objectProperty.hasInverse());
                objectProperty2.addInverseOf(objectProperty);
                25.assertTrue("Inverse of p", objectProperty.hasInverse());
                25.assertEquals("inverse of p ", objectProperty2, objectProperty.getInverse());
                objectProperty3.addInverseOf(objectProperty);
                this.iteratorTest(objectProperty.listInverse(), new Object[]{objectProperty2, objectProperty3});
            }
        }};
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

