/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.ComplementClass;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.io.StringWriter;

public class TestOntModel
extends ModelTestBase {
    public static final String BASE = "http://www.hp.com/test";
    public static final String NS = "http://www.hp.com/test#";
    public static final String DOC = "<rdf:RDF   xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"   xmlns:owl=\"http://www.w3.org/2002/07/owl#\"   xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\">  <owl:Class rdf:about=\"http://www.hp.com/test#D\">    <rdfs:subClassOf>      <owl:Class rdf:about=\"http://www.hp.com/test#B\"/>    </rdfs:subClassOf>  </owl:Class>  <owl:Class rdf:about=\"http://www.hp.com/test#B\">    <rdfs:subClassOf rdf:resource=\"http://www.hp.com/test#A\"       rdf:type=\"http://www.w3.org/2002/07/owl#Class\"/>  </owl:Class>  <owl:Class rdf:about=\"http://www.hp.com/test#C\">    <rdfs:subClassOf rdf:resource=\"http://www.hp.com/test#B\"/>  </owl:Class>  <owl:ObjectProperty rdf:about=\"http://www.hp.com/test#p\">    <rdfs:domain rdf:resource=\"http://www.hp.com/test#A\"/>    <rdfs:range rdf:resource=\"http://www.hp.com/test#B\"/>    <rdfs:range rdf:resource=\"http://www.hp.com/test#C\"/>  </owl:ObjectProperty></rdf:RDF>";

    public TestOntModel(String string) {
        super(string);
    }

    public void testWriteOutputStream() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        OntClass ontClass = ontModel.createClass("http://www.hp.com/test#A");
        OntClass ontClass2 = ontModel.createClass("http://www.hp.com/test#B");
        OntClass ontClass3 = ontModel.createClass("http://www.hp.com/test#C");
        OntClass ontClass4 = ontModel.createClass("http://www.hp.com/test#D");
        ontClass.addSubClass(ontClass2);
        ontClass2.addSubClass(ontClass3);
        ontClass2.addSubClass(ontClass4);
        ObjectProperty objectProperty = ontModel.createObjectProperty("http://www.hp.com/test#p");
        objectProperty.addDomain(ontClass);
        objectProperty.addRange(ontClass2);
        objectProperty.addRange(ontClass3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ontModel.write(byteArrayOutputStream);
        String string = byteArrayOutputStream.toString();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        Model model = ModelFactory.createDefaultModel();
        model.read(byteArrayInputStream, BASE);
        Model model2 = ModelFactory.createDefaultModel();
        model2.read(new ByteArrayInputStream(DOC.getBytes()), BASE);
        TestOntModel.assertTrue("InputStream write/read cycle failed (1)", model.isIsomorphicWith(ontModel.getBaseModel()));
        TestOntModel.assertTrue("InputStream write/read cycle failed (2)", model2.isIsomorphicWith(ontModel.getBaseModel()));
    }

    public void testGetBaseModelPrefixes() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.setNsPrefix("bill", "http://bill.and.ben/flowerpot#");
        ontModel.setNsPrefix("grue", "ftp://grue.and.bleen/2000#");
        TestOntModel.assertEquals(ontModel.getNsPrefixMap(), ontModel.getBaseModel().getNsPrefixMap());
    }

    public void testWritesPrefixes() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.setNsPrefix("spoo", "http://spoo.spoo.com/spoo#");
        ontModel.add(TestOntModel.statement(ontModel, "ping http://spoo.spoo.com/spoo#pang pilly"));
        ontModel.add(TestOntModel.statement(ontModel, "gg http://www.daml.org/2001/03/daml+oil#hh ii"));
        StringWriter stringWriter = new StringWriter();
        ontModel.write(stringWriter);
        String string = stringWriter.getBuffer().toString();
        TestOntModel.assertTrue(string.indexOf("xmlns:spoo=\"http://spoo.spoo.com/spoo#\"") > 0);
        TestOntModel.assertTrue(string.indexOf("xmlns:daml=\"http://www.daml.org/2001/03/daml+oil#\"") > 0);
    }

    public void testWriteWriter() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        OntClass ontClass = ontModel.createClass("http://www.hp.com/test#A");
        OntClass ontClass2 = ontModel.createClass("http://www.hp.com/test#B");
        OntClass ontClass3 = ontModel.createClass("http://www.hp.com/test#C");
        OntClass ontClass4 = ontModel.createClass("http://www.hp.com/test#D");
        ontClass.addSubClass(ontClass2);
        ontClass2.addSubClass(ontClass3);
        ontClass2.addSubClass(ontClass4);
        ObjectProperty objectProperty = ontModel.createObjectProperty("http://www.hp.com/test#p");
        objectProperty.addDomain(ontClass);
        objectProperty.addRange(ontClass2);
        objectProperty.addRange(ontClass3);
        StringWriter stringWriter = new StringWriter();
        ontModel.write(stringWriter);
        String string = stringWriter.toString();
        Model model = ModelFactory.createDefaultModel();
        model.read(new StringReader(string), BASE);
        Model model2 = ModelFactory.createDefaultModel();
        model2.read(new StringReader(DOC), BASE);
        TestOntModel.assertTrue("Writer write/read cycle failed (1)", model.isIsomorphicWith(ontModel.getBaseModel()));
        TestOntModel.assertTrue("Writer write/read cycle failed (2)", model2.isIsomorphicWith(ontModel.getBaseModel()));
    }

    public void testGetOntology() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        Ontology ontology = ontModel.createOntology("http://www.hp.com/test#s");
        TestOntModel.assertEquals("Result of get s", ontology, ontModel.getOntology("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", ontModel.getOntology("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", ontModel.getOntology("http://www.hp.com/test#r"));
    }

    public void testGetIndividual() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        OntClass ontClass = ontModel.createClass("http://www.hp.com/test#c");
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        Individual individual = ontModel.createIndividual("http://www.hp.com/test#s", ontClass);
        TestOntModel.assertEquals("Result of get s", individual, ontModel.getIndividual("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", ontModel.getIndividual("http://www.hp.com/test#q"));
    }

    public void testGetOntProperty() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        OntProperty ontProperty = ontModel.createOntProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals("Result of get s", ontProperty, ontModel.getOntProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", ontModel.getOntProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", ontModel.getOntProperty("http://www.hp.com/test#r"));
    }

    public void testGetObjectProperty() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        ObjectProperty objectProperty = ontModel.createObjectProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals("Result of get s", objectProperty, ontModel.getObjectProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", ontModel.getObjectProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", ontModel.getObjectProperty("http://www.hp.com/test#r"));
    }

    public void testGetTransitiveProperty() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        TransitiveProperty transitiveProperty = ontModel.createTransitiveProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals("Result of get s", transitiveProperty, ontModel.getTransitiveProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", ontModel.getTransitiveProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", ontModel.getTransitiveProperty("http://www.hp.com/test#r"));
    }

    public void testGetSymmetricProperty() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        SymmetricProperty symmetricProperty = ontModel.createSymmetricProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals("Result of get s", symmetricProperty, ontModel.getSymmetricProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", ontModel.getSymmetricProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", ontModel.getSymmetricProperty("http://www.hp.com/test#r"));
    }

    public void testGetInverseFunctionalProperty() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        InverseFunctionalProperty inverseFunctionalProperty = ontModel.createInverseFunctionalProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals("Result of get s", inverseFunctionalProperty, ontModel.getInverseFunctionalProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", ontModel.getInverseFunctionalProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", ontModel.getInverseFunctionalProperty("http://www.hp.com/test#r"));
    }

    public void testGetDatatypeProperty() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        DatatypeProperty datatypeProperty = ontModel.createDatatypeProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals("Result of get s", datatypeProperty, ontModel.getDatatypeProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", ontModel.getDatatypeProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", ontModel.getDatatypeProperty("http://www.hp.com/test#r"));
    }

    public void testGetAnnotationProperty() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        AnnotationProperty annotationProperty = ontModel.createAnnotationProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals("Result of get s", annotationProperty, ontModel.getAnnotationProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", ontModel.getAnnotationProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", ontModel.getAnnotationProperty("http://www.hp.com/test#r"));
    }

    public void testGetOntClass() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        Resource resource2 = ontModel.getResource("http://www.hp.com/test#r0");
        ontModel.add(resource, RDF.type, resource2);
        OntClass ontClass = ontModel.createClass("http://www.hp.com/test#s");
        TestOntModel.assertEquals("Result of get s", ontClass, ontModel.getOntClass("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", ontModel.getOntClass("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", ontModel.getOntClass("http://www.hp.com/test#r"));
    }

    public void testGetComplementClass() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        OntClass ontClass = ontModel.createClass("http://www.hp.com/test#c");
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        ComplementClass complementClass = ontModel.createComplementClass("http://www.hp.com/test#s", ontClass);
        TestOntModel.assertEquals("Result of get s", complementClass, ontModel.getComplementClass("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", ontModel.getComplementClass("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", ontModel.getComplementClass("http://www.hp.com/test#r"));
    }

    public void testGetEnumeratedClass() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        RDFList rDFList = ontModel.createList();
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        EnumeratedClass enumeratedClass = ontModel.createEnumeratedClass("http://www.hp.com/test#s", rDFList);
        TestOntModel.assertEquals("Result of get s", enumeratedClass, ontModel.getEnumeratedClass("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", ontModel.getEnumeratedClass("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", ontModel.getEnumeratedClass("http://www.hp.com/test#r"));
    }

    public void testGetUnionClass() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        RDFList rDFList = ontModel.createList();
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        UnionClass unionClass = ontModel.createUnionClass("http://www.hp.com/test#s", rDFList);
        TestOntModel.assertEquals("Result of get s", unionClass, ontModel.getUnionClass("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", ontModel.getUnionClass("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", ontModel.getUnionClass("http://www.hp.com/test#r"));
    }

    public void testGetIntersectionClass() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        RDFList rDFList = ontModel.createList();
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        IntersectionClass intersectionClass = ontModel.createIntersectionClass("http://www.hp.com/test#s", rDFList);
        TestOntModel.assertEquals("Result of get s", intersectionClass, ontModel.getIntersectionClass("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", ontModel.getIntersectionClass("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", ontModel.getIntersectionClass("http://www.hp.com/test#r"));
    }

    public void testGetRestriction() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Property property = ontModel.createProperty("http://www.hp.com/test#p");
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        Restriction restriction = ontModel.createRestriction("http://www.hp.com/test#s", property);
        TestOntModel.assertEquals("Result of get s", restriction, ontModel.getRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", ontModel.getRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", ontModel.getRestriction("http://www.hp.com/test#r"));
    }

    public void testGetHasValueRestriction() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Property property = ontModel.createProperty("http://www.hp.com/test#p");
        OntClass ontClass = ontModel.createClass("http://www.hp.com/test#c");
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        HasValueRestriction hasValueRestriction = ontModel.createHasValueRestriction("http://www.hp.com/test#s", property, ontClass);
        TestOntModel.assertEquals("Result of get s", hasValueRestriction, ontModel.getHasValueRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", ontModel.getHasValueRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", ontModel.getHasValueRestriction("http://www.hp.com/test#r"));
    }

    public void testGetSomeValuesFromRestriction() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Property property = ontModel.createProperty("http://www.hp.com/test#p");
        OntClass ontClass = ontModel.createClass("http://www.hp.com/test#c");
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        SomeValuesFromRestriction someValuesFromRestriction = ontModel.createSomeValuesFromRestriction("http://www.hp.com/test#s", property, ontClass);
        TestOntModel.assertEquals("Result of get s", someValuesFromRestriction, ontModel.getSomeValuesFromRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", ontModel.getSomeValuesFromRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", ontModel.getSomeValuesFromRestriction("http://www.hp.com/test#r"));
    }

    public void testGetAllValuesFromRestriction() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Property property = ontModel.createProperty("http://www.hp.com/test#p");
        OntClass ontClass = ontModel.createClass("http://www.hp.com/test#c");
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        AllValuesFromRestriction allValuesFromRestriction = ontModel.createAllValuesFromRestriction("http://www.hp.com/test#s", property, ontClass);
        TestOntModel.assertEquals("Result of get s", allValuesFromRestriction, ontModel.getAllValuesFromRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", ontModel.getAllValuesFromRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", ontModel.getAllValuesFromRestriction("http://www.hp.com/test#r"));
    }

    public void testGetCardinalityRestriction() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Property property = ontModel.createProperty("http://www.hp.com/test#p");
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        CardinalityRestriction cardinalityRestriction = ontModel.createCardinalityRestriction("http://www.hp.com/test#s", property, 1);
        TestOntModel.assertEquals("Result of get s", cardinalityRestriction, ontModel.getCardinalityRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", ontModel.getCardinalityRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", ontModel.getCardinalityRestriction("http://www.hp.com/test#r"));
    }

    public void testGetMinCardinalityRestriction() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Property property = ontModel.createProperty("http://www.hp.com/test#p");
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        MinCardinalityRestriction minCardinalityRestriction = ontModel.createMinCardinalityRestriction("http://www.hp.com/test#s", property, 1);
        TestOntModel.assertEquals("Result of get s", minCardinalityRestriction, ontModel.getMinCardinalityRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", ontModel.getMinCardinalityRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", ontModel.getMinCardinalityRestriction("http://www.hp.com/test#r"));
    }

    public void testGetMaxCardinalityRestriction() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Property property = ontModel.createProperty("http://www.hp.com/test#p");
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        MaxCardinalityRestriction maxCardinalityRestriction = ontModel.createMaxCardinalityRestriction("http://www.hp.com/test#s", property, 1);
        TestOntModel.assertEquals("Result of get s", maxCardinalityRestriction, ontModel.getMaxCardinalityRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", ontModel.getMaxCardinalityRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", ontModel.getMaxCardinalityRestriction("http://www.hp.com/test#r"));
    }

    public void testBulkAddWorks() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        OntModel ontModel2 = ModelFactory.createOntologyModel();
        ontModel.add(ontModel2);
    }
}

