/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.test.OntTestBase;
import junit.framework.TestSuite;

public class TestIndividual
extends OntTestBase {
    public static TestSuite suite() {
        return new TestIndividual("TestIndividual");
    }

    public TestIndividual(String string) {
        super(string);
    }

    public OntTestBase.OntTestCase[] getTests() {
        return new OntTestBase.OntTestCase[]{new OntTestBase.OntTestCase("Individual.sameIndividualAs", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                Individual individual = ontModel.createIndividual(ontClass);
                Individual individual2 = ontModel.createIndividual(ontClass);
                Individual individual3 = ontModel.createIndividual(ontClass);
                individual.addSameIndividualAs(individual2);
                1.assertEquals("Cardinality should be 1", 1, individual.getCardinality(profile.SAME_INDIVIDUAL_AS()));
                1.assertEquals("x should be the same as y", individual2, individual.getSameIndividualAs());
                1.assertTrue("x should be the same as y", individual.isSameIndividualAs(individual2));
                individual.addSameIndividualAs(individual3);
                1.assertEquals("Cardinality should be 2", 2, individual.getCardinality(profile.SAME_INDIVIDUAL_AS()));
                this.iteratorTest(individual.listSameIndividualAs(), new Object[]{individual3, individual2});
                individual.setSameIndividualAs(individual3);
                1.assertEquals("Cardinality should be 1", 1, individual.getCardinality(profile.SAME_INDIVIDUAL_AS()));
                1.assertEquals("x should be same indiv. as z", individual3, individual.getSameIndividualAs());
                individual.removeSameIndividualAs(individual2);
                1.assertEquals("Cardinality should be 1", 1, individual.getCardinality(profile.SAME_INDIVIDUAL_AS()));
                individual.removeSameIndividualAs(individual3);
                1.assertEquals("Cardinality should be 0", 0, individual.getCardinality(profile.SAME_INDIVIDUAL_AS()));
            }
        }};
    }
}

