/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.ComplementClass;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.Resource;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCreate
extends TestCase {
    public static final String BASE = "http://jena.hpl.hp.com/testing/ontology";
    public static final String NS = "http://jena.hpl.hp.com/testing/ontology#";
    protected static CreateTestCase[] testCases = new CreateTestCase[]{new CreateTestCase("OWL create ontology", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createOntology(TestCreate.BASE);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof Ontology;
        }
    }, new CreateTestCase("DAML create ontology", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createOntology(TestCreate.BASE);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof Ontology;
        }
    }, new CreateTestCase("OWL create class", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#C"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof OntClass;
        }
    }, new CreateTestCase("OWL create anon complement class", "http://www.w3.org/2002/07/owl#", null){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createComplementClass(null, ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A"));
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof OntClass && ontResource instanceof ComplementClass;
        }
    }, new CreateTestCase("OWL create anon enumeration class", "http://www.w3.org/2002/07/owl#", null){

        public OntResource doCreate(OntModel ontModel) {
            OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
            Individual individual = ontModel.createIndividual(ontClass);
            Individual individual2 = ontModel.createIndividual(ontClass);
            Individual individual3 = ontModel.createIndividual(ontClass);
            RDFList rDFList = ontModel.createList(new OntResource[]{individual, individual2, individual3});
            return ontModel.createEnumeratedClass(null, rDFList);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof OntClass && ontResource instanceof EnumeratedClass;
        }
    }, new CreateTestCase("OWL create anon union class", "http://www.w3.org/2002/07/owl#", null){

        public OntResource doCreate(OntModel ontModel) {
            OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
            Individual individual = ontModel.createIndividual(ontClass);
            Individual individual2 = ontModel.createIndividual(ontClass);
            Individual individual3 = ontModel.createIndividual(ontClass);
            RDFList rDFList = ontModel.createList(new OntResource[]{individual, individual2, individual3});
            return ontModel.createUnionClass(null, rDFList);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof OntClass && ontResource instanceof UnionClass;
        }
    }, new CreateTestCase("OWL create anon intersection class", "http://www.w3.org/2002/07/owl#", null){

        public OntResource doCreate(OntModel ontModel) {
            OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
            Individual individual = ontModel.createIndividual(ontClass);
            Individual individual2 = ontModel.createIndividual(ontClass);
            Individual individual3 = ontModel.createIndividual(ontClass);
            RDFList rDFList = ontModel.createList(new OntResource[]{individual, individual2, individual3});
            return ontModel.createIntersectionClass(null, rDFList);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof OntClass && ontResource instanceof IntersectionClass;
        }
    }, new CreateTestCase("OWL create class", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#C"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof OntClass;
        }
    }, new CreateTestCase("DAML create class", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#C"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof OntClass;
        }
    }, new CreateTestCase("DAML create anon class", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createClass();
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof OntClass;
        }
    }, new CreateTestCase("DAML create anon complement class", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createComplementClass(null, ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A"));
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof OntClass && ontResource instanceof ComplementClass;
        }
    }, new CreateTestCase("DAML create anon enumeration class", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel ontModel) {
            OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
            Individual individual = ontModel.createIndividual(ontClass);
            Individual individual2 = ontModel.createIndividual(ontClass);
            Individual individual3 = ontModel.createIndividual(ontClass);
            RDFList rDFList = ontModel.createList(new OntResource[]{individual, individual2, individual3});
            return ontModel.createEnumeratedClass(null, rDFList);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof OntClass && ontResource instanceof EnumeratedClass;
        }
    }, new CreateTestCase("DAML create anon union class", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel ontModel) {
            OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
            Individual individual = ontModel.createIndividual(ontClass);
            Individual individual2 = ontModel.createIndividual(ontClass);
            Individual individual3 = ontModel.createIndividual(ontClass);
            RDFList rDFList = ontModel.createList(new OntResource[]{individual, individual2, individual3});
            return ontModel.createUnionClass(null, rDFList);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof OntClass && ontResource instanceof UnionClass;
        }
    }, new CreateTestCase("DAML create anon intersection class", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel ontModel) {
            OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
            Individual individual = ontModel.createIndividual(ontClass);
            Individual individual2 = ontModel.createIndividual(ontClass);
            Individual individual3 = ontModel.createIndividual(ontClass);
            RDFList rDFList = ontModel.createList(new OntResource[]{individual, individual2, individual3});
            return ontModel.createIntersectionClass(null, rDFList);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof OntClass && ontResource instanceof IntersectionClass;
        }
    }, new CreateTestCase("OWL create individual", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#a"){

        public OntResource doCreate(OntModel ontModel) {
            OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
            return ontModel.createIndividual("http://jena.hpl.hp.com/testing/ontology#a", ontClass);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof Individual;
        }
    }, new CreateTestCase("OWL create anon individual", "http://www.w3.org/2002/07/owl#", null){

        public OntResource doCreate(OntModel ontModel) {
            OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
            return ontModel.createIndividual(ontClass);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof Individual;
        }
    }, new CreateTestCase("DAML create individual", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#a"){

        public OntResource doCreate(OntModel ontModel) {
            OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
            return ontModel.createIndividual("http://jena.hpl.hp.com/testing/ontology#a", ontClass);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof Individual;
        }
    }, new CreateTestCase("DAML create anon individual", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel ontModel) {
            OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
            return ontModel.createIndividual(ontClass);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof Individual;
        }
    }, new CreateTestCase("OWL create object property", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof ObjectProperty;
        }
    }, new CreateTestCase("OWL create object property non-F", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof ObjectProperty && !ontResource.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("OWL create object property F", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof ObjectProperty && ontResource.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("OWL create transitive property", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createTransitiveProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof ObjectProperty && ontResource instanceof TransitiveProperty;
        }
    }, new CreateTestCase("OWL create transitive property non-F", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createTransitiveProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof ObjectProperty && ontResource instanceof TransitiveProperty && !ontResource.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("OWL create transitive property F", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createTransitiveProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof ObjectProperty && ontResource instanceof TransitiveProperty && ontResource.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("OWL create symmetric property", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createSymmetricProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof ObjectProperty && ontResource instanceof SymmetricProperty;
        }
    }, new CreateTestCase("OWL create symmetric property non-F", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createSymmetricProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof ObjectProperty && ontResource instanceof SymmetricProperty && !ontResource.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("OWL create symmetric property F", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createSymmetricProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof ObjectProperty && ontResource instanceof SymmetricProperty && ontResource.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("OWL create inverse functional property", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createInverseFunctionalProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof ObjectProperty && ontResource instanceof InverseFunctionalProperty;
        }
    }, new CreateTestCase("OWL create inverse functional property non-F", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createInverseFunctionalProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof ObjectProperty && ontResource instanceof InverseFunctionalProperty && !ontResource.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("OWL create inverse functional property F", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createInverseFunctionalProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof ObjectProperty && ontResource instanceof InverseFunctionalProperty && ontResource.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("OWL create datatype property", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof DatatypeProperty;
        }
    }, new CreateTestCase("OWL create datatype property non-F", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof DatatypeProperty && !ontResource.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("OWL create datatype property F", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof DatatypeProperty && ontResource.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("OWL create annotation property", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createAnnotationProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof AnnotationProperty;
        }
    }, new CreateTestCase("DAML create object property", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof ObjectProperty;
        }
    }, new CreateTestCase("DAML create object property non-F", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof ObjectProperty && !ontResource.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("DAML create object property F", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof ObjectProperty && ontResource.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("DAML create transitive property", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createTransitiveProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof ObjectProperty && ontResource instanceof TransitiveProperty;
        }
    }, new CreateTestCase("DAML create transitive property non-F", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createTransitiveProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof ObjectProperty && ontResource instanceof TransitiveProperty && !ontResource.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("DAML create transitive property F", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createTransitiveProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof ObjectProperty && ontResource instanceof TransitiveProperty && ontResource.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("DAML create inverse functional property", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createInverseFunctionalProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof ObjectProperty && ontResource instanceof InverseFunctionalProperty;
        }
    }, new CreateTestCase("DAML create inverse functional property non-F", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createInverseFunctionalProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof ObjectProperty && ontResource instanceof InverseFunctionalProperty && !ontResource.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("DAML create inverse functional property F", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createInverseFunctionalProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof ObjectProperty && ontResource instanceof InverseFunctionalProperty && ontResource.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("DAML create datatype property", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof DatatypeProperty;
        }
    }, new CreateTestCase("DAML create datatype property non-F", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof DatatypeProperty && !ontResource.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("DAML create datatype property F", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof DatatypeProperty && ontResource.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("OWL create allDifferent", "http://www.w3.org/2002/07/owl#", null){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createAllDifferent();
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof AllDifferent;
        }
    }, new CreateTestCase("OWL create restriction", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#C"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createRestriction("http://jena.hpl.hp.com/testing/ontology#C", null);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof Restriction;
        }
    }, new CreateTestCase("OWL create anon restriction", "http://www.w3.org/2002/07/owl#", null){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createRestriction(null);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof Restriction;
        }
    }, new CreateTestCase("OWL create has value restriction", "http://www.w3.org/2002/07/owl#", null){

        public OntResource doCreate(OntModel ontModel) {
            ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
            Resource resource = ontModel.createResource("http://jena.hpl.hp.com/testing/ontology#x");
            return ontModel.createHasValueRestriction(null, objectProperty, resource);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof HasValueRestriction;
        }
    }, new CreateTestCase("OWL create has value restriction (literal)", "http://www.w3.org/2002/07/owl#", null){

        public OntResource doCreate(OntModel ontModel) {
            DatatypeProperty datatypeProperty = ontModel.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p");
            Literal literal = ontModel.createTypedLiteral(new Integer(42));
            return ontModel.createHasValueRestriction(null, datatypeProperty, literal);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof HasValueRestriction;
        }
    }, new CreateTestCase("OWL create all values from restriction", "http://www.w3.org/2002/07/owl#", null){

        public OntResource doCreate(OntModel ontModel) {
            ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
            OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
            return ontModel.createAllValuesFromRestriction(null, objectProperty, ontClass);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof AllValuesFromRestriction;
        }
    }, new CreateTestCase("OWL create some values from restriction", "http://www.w3.org/2002/07/owl#", null){

        public OntResource doCreate(OntModel ontModel) {
            ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
            OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
            return ontModel.createSomeValuesFromRestriction(null, objectProperty, ontClass);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof SomeValuesFromRestriction;
        }
    }, new CreateTestCase("OWL create cardinality restriction", "http://www.w3.org/2002/07/owl#", null){

        public OntResource doCreate(OntModel ontModel) {
            ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
            return ontModel.createCardinalityRestriction(null, objectProperty, 17);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof CardinalityRestriction;
        }
    }, new CreateTestCase("OWL create min cardinality restriction", "http://www.w3.org/2002/07/owl#", null){

        public OntResource doCreate(OntModel ontModel) {
            ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
            return ontModel.createMinCardinalityRestriction(null, objectProperty, 1);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof MinCardinalityRestriction;
        }
    }, new CreateTestCase("OWL create max cardinality restriction", "http://www.w3.org/2002/07/owl#", null){

        public OntResource doCreate(OntModel ontModel) {
            ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
            return ontModel.createMaxCardinalityRestriction(null, objectProperty, 4);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof MaxCardinalityRestriction;
        }
    }, new CreateTestCase("DAML create restriction", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#C"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createRestriction("http://jena.hpl.hp.com/testing/ontology#C", null);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof Restriction;
        }
    }, new CreateTestCase("DAML create anon restriction", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createRestriction(null);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof Restriction;
        }
    }, new CreateTestCase("DAML create has value restriction", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel ontModel) {
            ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
            Resource resource = ontModel.createResource("http://jena.hpl.hp.com/testing/ontology#x");
            return ontModel.createHasValueRestriction(null, objectProperty, resource);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof HasValueRestriction;
        }
    }, new CreateTestCase("DAML create has value restriction (literal)", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel ontModel) {
            DatatypeProperty datatypeProperty = ontModel.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p");
            Literal literal = ontModel.createTypedLiteral(new Integer(42));
            return ontModel.createHasValueRestriction(null, datatypeProperty, literal);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof HasValueRestriction;
        }
    }, new CreateTestCase("DAML create all values from restriction", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel ontModel) {
            ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
            OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
            return ontModel.createAllValuesFromRestriction(null, objectProperty, ontClass);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof AllValuesFromRestriction;
        }
    }, new CreateTestCase("DAML create some values from restriction", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel ontModel) {
            ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
            OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
            return ontModel.createSomeValuesFromRestriction(null, objectProperty, ontClass);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof SomeValuesFromRestriction;
        }
    }, new CreateTestCase("DAML create cardinality restriction", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel ontModel) {
            ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
            return ontModel.createCardinalityRestriction(null, objectProperty, 17);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof CardinalityRestriction;
        }
    }, new CreateTestCase("DAML create min cardinality restriction", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel ontModel) {
            ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
            return ontModel.createMinCardinalityRestriction(null, objectProperty, 1);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof MinCardinalityRestriction;
        }
    }, new CreateTestCase("DAML create max cardinality restriction", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel ontModel) {
            ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
            return ontModel.createMaxCardinalityRestriction(null, objectProperty, 4);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof MaxCardinalityRestriction;
        }
    }};
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$FunctionalProperty;

    public TestCreate(String string) {
        super(string);
    }

    protected String getTestName() {
        return "TestCreate";
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite("TestCreate");
        for (int i = 0; i < testCases.length; ++i) {
            testSuite.addTest(testCases[i]);
        }
        return testSuite;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class CreateTestCase
    extends TestCase {
        protected String m_lang;
        protected String m_uri;

        public CreateTestCase(String string, String string2, String string3) {
            super(string);
            this.m_lang = string2;
            this.m_uri = string3;
        }

        public void runTest() {
            OntModel ontModel = ModelFactory.createOntologyModel(this.m_lang);
            OntResource ontResource = this.doCreate(ontModel);
            CreateTestCase.assertNotNull("Result of creation step should not be null", ontResource);
            if (this.m_uri == null) {
                CreateTestCase.assertTrue("Created resource should be anonymous", ontResource.isAnon());
            } else {
                CreateTestCase.assertEquals("Created resource has wrong uri", this.m_uri, ontResource.getURI());
            }
            CreateTestCase.assertTrue("Result test failed", this.test(ontResource));
        }

        public OntResource doCreate(OntModel ontModel) {
            return null;
        }

        public boolean test(OntResource ontResource) {
            return true;
        }
    }
}

