/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.ComplementClass;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.ontology.impl.test.OntTestBase;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.ArrayList;
import junit.framework.TestSuite;

public class TestClassExpression
extends OntTestBase {
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntResource;

    public static TestSuite suite() {
        return new TestClassExpression("TestClassExpression");
    }

    public TestClassExpression(String string) {
        super(string);
    }

    public OntTestBase.OntTestCase[] getTests() {
        return new OntTestBase.OntTestCase[]{new OntTestBase.OntTestCase("OntClass.super-class", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass3 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                ontClass.addSuperClass(ontClass2);
                1.assertEquals("Cardinality should be 1", 1, ontClass.getCardinality(profile.SUB_CLASS_OF()));
                1.assertEquals("A should have super-class B", ontClass2, ontClass.getSuperClass());
                ontClass.addSuperClass(ontClass3);
                1.assertEquals("Cardinality should be 2", 2, ontClass.getCardinality(profile.SUB_CLASS_OF()));
                this.iteratorTest(ontClass.listSuperClasses(), new Object[]{ontClass3, ontClass2});
                ontClass.setSuperClass(ontClass3);
                1.assertEquals("Cardinality should be 1", 1, ontClass.getCardinality(profile.SUB_CLASS_OF()));
                1.assertEquals("A shuold have super-class C", ontClass3, ontClass.getSuperClass());
                1.assertTrue("A shuold not have super-class B", !ontClass.hasSuperClass(ontClass2, false));
                ontClass.removeSuperClass(ontClass2);
                1.assertEquals("Cardinality should be 1", 1, ontClass.getCardinality(profile.SUB_CLASS_OF()));
                ontClass.removeSuperClass(ontClass3);
                1.assertEquals("Cardinality should be 0", 0, ontClass.getCardinality(profile.SUB_CLASS_OF()));
            }
        }, new OntTestBase.OntTestCase("OntClass.sub-class", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass3 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                ontClass.addSubClass(ontClass2);
                2.assertEquals("Cardinality should be 1", 1, ontClass2.getCardinality(profile.SUB_CLASS_OF()));
                2.assertEquals("A should have sub-class B", ontClass2, ontClass.getSubClass());
                ontClass.addSubClass(ontClass3);
                2.assertEquals("Cardinality should be 2", 2, ontClass2.getCardinality(profile.SUB_CLASS_OF()) + ontClass3.getCardinality(profile.SUB_CLASS_OF()));
                this.iteratorTest(ontClass.listSubClasses(), new Object[]{ontClass3, ontClass2});
                ontClass.setSubClass(ontClass3);
                2.assertEquals("Cardinality should be 1", 1, ontClass2.getCardinality(profile.SUB_CLASS_OF()) + ontClass3.getCardinality(profile.SUB_CLASS_OF()));
                2.assertEquals("A shuold have sub-class C", ontClass3, ontClass.getSubClass());
                2.assertTrue("A shuold not have sub-class B", !ontClass.hasSubClass(ontClass2, false));
                ontClass.removeSubClass(ontClass2);
                2.assertTrue("A should have sub-class C", ontClass.hasSubClass(ontClass3, false));
                ontClass.removeSubClass(ontClass3);
                2.assertTrue("A should not have sub-class C", !ontClass.hasSubClass(ontClass3, false));
            }
        }, new OntTestBase.OntTestCase("OntClass.equivalentClass", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass3 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                ontClass.addEquivalentClass(ontClass2);
                3.assertEquals("Cardinality should be 1", 1, ontClass.getCardinality(profile.EQUIVALENT_CLASS()));
                3.assertEquals("A have equivalentClass B", ontClass2, ontClass.getEquivalentClass());
                ontClass.addEquivalentClass(ontClass3);
                3.assertEquals("Cardinality should be 2", 2, ontClass.getCardinality(profile.EQUIVALENT_CLASS()));
                this.iteratorTest(ontClass.listEquivalentClasses(), new Object[]{ontClass3, ontClass2});
                ontClass.setEquivalentClass(ontClass3);
                3.assertEquals("Cardinality should be 1", 1, ontClass.getCardinality(profile.EQUIVALENT_CLASS()));
                3.assertEquals("A should have equivalentClass C", ontClass3, ontClass.getEquivalentClass());
                3.assertTrue("A should not have equivalentClass B", !ontClass.hasEquivalentClass(ontClass2));
                ontClass.removeEquivalentClass(ontClass2);
                3.assertEquals("Cardinality should be 1", 1, ontClass.getCardinality(profile.EQUIVALENT_CLASS()));
                ontClass.removeEquivalentClass(ontClass3);
                3.assertEquals("Cardinality should be 0", 0, ontClass.getCardinality(profile.EQUIVALENT_CLASS()));
            }
        }, new OntTestBase.OntTestCase("OntClass.disjointWith", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass3 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                ontClass.addDisjointWith(ontClass2);
                4.assertEquals("Cardinality should be 1", 1, ontClass.getCardinality(profile.DISJOINT_WITH()));
                4.assertEquals("A have be disjoint with B", ontClass2, ontClass.getDisjointWith());
                ontClass.addDisjointWith(ontClass3);
                4.assertEquals("Cardinality should be 2", 2, ontClass.getCardinality(profile.DISJOINT_WITH()));
                this.iteratorTest(ontClass.listDisjointWith(), new Object[]{ontClass3, ontClass2});
                ontClass.setDisjointWith(ontClass3);
                4.assertEquals("Cardinality should be 1", 1, ontClass.getCardinality(profile.DISJOINT_WITH()));
                4.assertEquals("A should be disjoint with C", ontClass3, ontClass.getDisjointWith());
                4.assertTrue("A should not be disjoint with B", !ontClass.isDisjointWith(ontClass2));
                ontClass.removeDisjointWith(ontClass2);
                4.assertEquals("Cardinality should be 1", 1, ontClass.getCardinality(profile.DISJOINT_WITH()));
                ontClass.removeDisjointWith(ontClass3);
                4.assertEquals("Cardinality should be 0", 0, ontClass.getCardinality(profile.DISJOINT_WITH()));
            }
        }, new OntTestBase.OntTestCase("EnumeratedClass.oneOf", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                EnumeratedClass enumeratedClass = ontModel.createEnumeratedClass("http://jena.hpl.hp.com/testing/ontology#A", null);
                OntResource ontResource = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestClassExpression.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource ontResource2 = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestClassExpression.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                enumeratedClass.addOneOf(ontResource);
                5.assertEquals("Cardinality should be 1", 1, enumeratedClass.getCardinality(profile.ONE_OF()));
                5.assertEquals("Size should be 1", 1, enumeratedClass.getOneOf().size());
                5.assertTrue("A should have a as enumerated member", enumeratedClass.getOneOf().contains(ontResource));
                enumeratedClass.addOneOf(ontResource2);
                5.assertEquals("Cardinality should be 1", 1, enumeratedClass.getCardinality(profile.ONE_OF()));
                5.assertEquals("Size should be 2", 2, enumeratedClass.getOneOf().size());
                this.iteratorTest(enumeratedClass.listOneOf(), new Object[]{ontResource, ontResource2});
                enumeratedClass.setOneOf(ontModel.createList(new RDFNode[]{ontResource2}));
                5.assertEquals("Cardinality should be 1", 1, enumeratedClass.getCardinality(profile.ONE_OF()));
                5.assertEquals("Size should be 1", 1, enumeratedClass.getOneOf().size());
                5.assertTrue("A should have b in the enum", enumeratedClass.hasOneOf(ontResource2));
                5.assertTrue("A should not have a in the enum", !enumeratedClass.hasOneOf(ontResource));
                enumeratedClass.removeOneOf(ontResource);
                5.assertTrue("Should have b as an enum value", enumeratedClass.hasOneOf(ontResource2));
                enumeratedClass.removeOneOf(ontResource2);
                5.assertTrue("Should not have b as an enum value", !enumeratedClass.hasOneOf(ontResource2));
            }
        }, new OntTestBase.OntTestCase("IntersectionClass.intersectionOf", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                IntersectionClass intersectionClass = ontModel.createIntersectionClass("http://jena.hpl.hp.com/testing/ontology#A", null);
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                intersectionClass.addOperand(ontClass);
                6.assertEquals("Cardinality should be 1", 1, intersectionClass.getCardinality(profile.INTERSECTION_OF()));
                6.assertEquals("Size should be 1", 1, intersectionClass.getOperands().size());
                6.assertTrue("A should have a as intersection member", intersectionClass.getOperands().contains(ontClass));
                intersectionClass.addOperand(ontClass2);
                6.assertEquals("Cardinality should be 1", 1, intersectionClass.getCardinality(profile.INTERSECTION_OF()));
                6.assertEquals("Size should be 2", 2, intersectionClass.getOperands().size());
                this.iteratorTest(intersectionClass.listOperands(), new Object[]{ontClass, ontClass2});
                ExtendedIterator extendedIterator = intersectionClass.listOperands();
                6.assertTrue("Argument should be an OntClass", extendedIterator.next() instanceof OntClass);
                extendedIterator.close();
                intersectionClass.setOperands(ontModel.createList(new RDFNode[]{ontClass2}));
                6.assertEquals("Cardinality should be 1", 1, intersectionClass.getCardinality(profile.INTERSECTION_OF()));
                6.assertEquals("Size should be 1", 1, intersectionClass.getOperands().size());
                6.assertTrue("A should have C in the intersection", intersectionClass.hasOperand(ontClass2));
                6.assertTrue("A should not have B in the intersection", !intersectionClass.hasOperand(ontClass));
                intersectionClass.removeOperand(ontClass);
                6.assertTrue("Should have C as an operand", intersectionClass.hasOperand(ontClass2));
                intersectionClass.removeOperand(ontClass2);
                6.assertTrue("Should not have C as an operand", !intersectionClass.hasOperand(ontClass2));
            }
        }, new OntTestBase.OntTestCase("UnionClass.unionOf", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                UnionClass unionClass = ontModel.createUnionClass("http://jena.hpl.hp.com/testing/ontology#A", null);
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                unionClass.addOperand(ontClass);
                7.assertEquals("Cardinality should be 1", 1, unionClass.getCardinality(profile.UNION_OF()));
                7.assertEquals("Size should be 1", 1, unionClass.getOperands().size());
                7.assertTrue("A should have a as union member", unionClass.getOperands().contains(ontClass));
                unionClass.addOperand(ontClass2);
                7.assertEquals("Cardinality should be 1", 1, unionClass.getCardinality(profile.UNION_OF()));
                7.assertEquals("Size should be 2", 2, unionClass.getOperands().size());
                this.iteratorTest(unionClass.listOperands(), new Object[]{ontClass, ontClass2});
                ExtendedIterator extendedIterator = unionClass.listOperands();
                7.assertTrue("Argument should be an OntClass", extendedIterator.next() instanceof OntClass);
                extendedIterator.close();
                unionClass.setOperands(ontModel.createList(new RDFNode[]{ontClass2}));
                7.assertEquals("Cardinality should be 1", 1, unionClass.getCardinality(profile.UNION_OF()));
                7.assertEquals("Size should be 1", 1, unionClass.getOperands().size());
                7.assertTrue("A should have C in the union", unionClass.hasOperand(ontClass2));
                7.assertTrue("A should not have B in the union", !unionClass.hasOperand(ontClass));
                unionClass.removeOperand(ontClass);
                7.assertTrue("Should have C as an operand", unionClass.hasOperand(ontClass2));
                unionClass.removeOperand(ontClass2);
                7.assertTrue("Should not have C as an operand", !unionClass.hasOperand(ontClass2));
            }
        }, new OntTestBase.OntTestCase("ComplementClass.complementOf", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                ComplementClass complementClass = ontModel.createComplementClass("http://jena.hpl.hp.com/testing/ontology#A", null);
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                boolean bl = false;
                try {
                    complementClass.addOperand(ontClass);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    bl = true;
                }
                8.assertTrue("Should fail to add to a complement", bl);
                bl = false;
                try {
                    complementClass.addOperands(new ArrayList().iterator());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    bl = true;
                }
                8.assertTrue("Should fail to add to a complement", bl);
                bl = false;
                try {
                    complementClass.setOperands(ontModel.createList(new RDFNode[]{ontClass2}));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    bl = true;
                }
                8.assertTrue("Should fail to set a list to a complement", bl);
                complementClass.setOperand(ontClass);
                8.assertEquals("Cardinality should be 1", 1, complementClass.getCardinality(profile.COMPLEMENT_OF()));
                8.assertEquals("Complement should be B", ontClass, complementClass.getOperand());
                this.iteratorTest(complementClass.listOperands(), new Object[]{ontClass});
                complementClass.setOperand(ontClass2);
                8.assertEquals("Cardinality should be 1", 1, complementClass.getCardinality(profile.COMPLEMENT_OF()));
                8.assertTrue("A should have C in the complement", complementClass.hasOperand(ontClass2));
                8.assertTrue("A should not have B in the complement", !complementClass.hasOperand(ontClass));
                complementClass.removeOperand(ontClass);
                8.assertTrue("Should have C as an operand", complementClass.hasOperand(ontClass2));
                complementClass.removeOperand(ontClass2);
                8.assertTrue("Should not have C as an operand", !complementClass.hasOperand(ontClass2));
            }
        }, new OntTestBase.OntTestCase("Restriction.onProperty", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                ObjectProperty objectProperty2 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                AllValuesFromRestriction allValuesFromRestriction = ontModel.createAllValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", objectProperty, ontClass);
                9.assertEquals("Restriction should be on property p", objectProperty, allValuesFromRestriction.getOnProperty());
                9.assertTrue("Restriction should be on property p", allValuesFromRestriction.onProperty(objectProperty));
                9.assertTrue("Restriction should not be on property q", !allValuesFromRestriction.onProperty(objectProperty2));
                9.assertEquals("cardinality should be 1 ", 1, allValuesFromRestriction.getCardinality(profile.ON_PROPERTY()));
                allValuesFromRestriction.setOnProperty(objectProperty2);
                9.assertEquals("Restriction should be on property q", objectProperty2, allValuesFromRestriction.getOnProperty());
                9.assertTrue("Restriction should not be on property p", !allValuesFromRestriction.onProperty(objectProperty));
                9.assertTrue("Restriction should not on property q", allValuesFromRestriction.onProperty(objectProperty2));
                9.assertEquals("cardinality should be 1 ", 1, allValuesFromRestriction.getCardinality(profile.ON_PROPERTY()));
                allValuesFromRestriction.removeOnProperty(objectProperty);
                9.assertTrue("Should have q as on property", allValuesFromRestriction.onProperty(objectProperty2));
                allValuesFromRestriction.removeOnProperty(objectProperty2);
                9.assertTrue("Should not have q as on property", !allValuesFromRestriction.onProperty(objectProperty2));
            }
        }, new OntTestBase.OntTestCase("AllValuesFromRestriction.allValuesFrom", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                AllValuesFromRestriction allValuesFromRestriction = ontModel.createAllValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", objectProperty, ontClass);
                10.assertEquals("Restriction should be all values from B", ontClass, allValuesFromRestriction.getAllValuesFrom());
                10.assertTrue("Restriction should be all values from B", allValuesFromRestriction.hasAllValuesFrom(ontClass));
                10.assertTrue("Restriction should not be all values from C", !allValuesFromRestriction.hasAllValuesFrom(ontClass2));
                10.assertEquals("cardinality should be 1 ", 1, allValuesFromRestriction.getCardinality(profile.ALL_VALUES_FROM()));
                allValuesFromRestriction.setAllValuesFrom(ontClass2);
                10.assertEquals("Restriction should be all values from C", ontClass2, allValuesFromRestriction.getAllValuesFrom());
                10.assertTrue("Restriction should not be all values from B", !allValuesFromRestriction.hasAllValuesFrom(ontClass));
                10.assertTrue("Restriction should be all values from C", allValuesFromRestriction.hasAllValuesFrom(ontClass2));
                10.assertEquals("cardinality should be 1 ", 1, allValuesFromRestriction.getCardinality(profile.ALL_VALUES_FROM()));
                allValuesFromRestriction.removeAllValuesFrom(ontClass2);
                10.assertTrue("Restriction should not be some values from C", !allValuesFromRestriction.hasAllValuesFrom(ontClass2));
                10.assertEquals("cardinality should be 0 ", 0, allValuesFromRestriction.getCardinality(profile.ALL_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("AllValuesFromRestriction.allValuesFrom.datatype", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                AllValuesFromRestriction allValuesFromRestriction = ontModel.createAllValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", objectProperty, XSD.gDay);
                11.assertEquals("Restriction should be all values from gDay", XSD.gDay, allValuesFromRestriction.getAllValuesFrom());
                11.assertTrue("Restriction should be all values from gDay", allValuesFromRestriction.hasAllValuesFrom(XSD.gDay));
                11.assertTrue("Restriction should not be all values from decimal", !allValuesFromRestriction.hasAllValuesFrom(XSD.decimal));
                11.assertEquals("cardinality should be 1 ", 1, allValuesFromRestriction.getCardinality(profile.ALL_VALUES_FROM()));
                allValuesFromRestriction.setAllValuesFrom(XSD.gMonth);
                11.assertEquals("Restriction should be all values from gMonth", XSD.gMonth, allValuesFromRestriction.getAllValuesFrom());
                11.assertTrue("Restriction should not be all values from gDay", !allValuesFromRestriction.hasAllValuesFrom(XSD.gDay));
                11.assertTrue("Restriction should be all values from gMonth", allValuesFromRestriction.hasAllValuesFrom(XSD.gMonth));
                11.assertEquals("cardinality should be 1 ", 1, allValuesFromRestriction.getCardinality(profile.ALL_VALUES_FROM()));
                allValuesFromRestriction.removeAllValuesFrom(XSD.gMonth);
                11.assertTrue("Restriction should not be some values from gMonth", !allValuesFromRestriction.hasAllValuesFrom(XSD.gMonth));
                11.assertEquals("cardinality should be 0 ", 0, allValuesFromRestriction.getCardinality(profile.ALL_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("AllValuesFromRestriction.allValuesFrom.literal", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                AllValuesFromRestriction allValuesFromRestriction = ontModel.createAllValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", objectProperty, RDFS.Literal);
                12.assertEquals("Restriction should be all values from literal", RDFS.Literal, allValuesFromRestriction.getAllValuesFrom());
                12.assertTrue("Restriction should be all values from literal", allValuesFromRestriction.hasAllValuesFrom(RDFS.Literal));
                12.assertTrue("Restriction should not be all values from decimal", !allValuesFromRestriction.hasAllValuesFrom(XSD.decimal));
                12.assertEquals("cardinality should be 1 ", 1, allValuesFromRestriction.getCardinality(profile.ALL_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("AllValuesFromRestriction.allValuesFrom.datarange", true, false, false, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                Literal literal = ontModel.createLiteral(1L);
                Literal literal2 = ontModel.createLiteral(2L);
                DataRange dataRange = ontModel.createDataRange(ontModel.createList(new RDFNode[]{literal, literal2}));
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                AllValuesFromRestriction allValuesFromRestriction = ontModel.createAllValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", objectProperty, dataRange);
                13.assertEquals("Restriction should be all values from dr", dataRange, allValuesFromRestriction.getAllValuesFrom());
                13.assertTrue("value should be a datarange", allValuesFromRestriction.getAllValuesFrom() instanceof DataRange);
                13.assertTrue("Restriction should be all values from dr", allValuesFromRestriction.hasAllValuesFrom(dataRange));
                13.assertTrue("Restriction should not be all values from decimal", !allValuesFromRestriction.hasAllValuesFrom(XSD.decimal));
                13.assertEquals("cardinality should be 1 ", 1, allValuesFromRestriction.getCardinality(profile.ALL_VALUES_FROM()));
                allValuesFromRestriction.removeAllValuesFrom(dataRange);
                13.assertTrue("Restriction should not be some values from gMonth", !allValuesFromRestriction.hasAllValuesFrom(dataRange));
                13.assertEquals("cardinality should be 0 ", 0, allValuesFromRestriction.getCardinality(profile.ALL_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("HasValueRestriction.hasValue", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual individual = ontModel.createIndividual(ontClass);
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                Individual individual2 = ontModel.createIndividual(ontClass2);
                HasValueRestriction hasValueRestriction = ontModel.createHasValueRestriction("http://jena.hpl.hp.com/testing/ontology#A", objectProperty, individual);
                14.assertEquals("Restriction should be has value b", individual, hasValueRestriction.getHasValue());
                14.assertTrue("Restriction should be to have value b", hasValueRestriction.hasValue(individual));
                14.assertTrue("Restriction should not be have value c", !hasValueRestriction.hasValue(individual2));
                14.assertEquals("cardinality should be 1 ", 1, hasValueRestriction.getCardinality(profile.HAS_VALUE()));
                hasValueRestriction.setHasValue(individual2);
                14.assertEquals("Restriction should be has value c", individual2, hasValueRestriction.getHasValue());
                14.assertTrue("Restriction should not be to have value b", !hasValueRestriction.hasValue(individual));
                14.assertTrue("Restriction should not be have value c", hasValueRestriction.hasValue(individual2));
                14.assertEquals("cardinality should be 1 ", 1, hasValueRestriction.getCardinality(profile.HAS_VALUE()));
                hasValueRestriction.removeHasValue(individual2);
                14.assertTrue("Restriction should not be to have value b", !hasValueRestriction.hasValue(individual));
                14.assertTrue("Restriction should not be have value c", !hasValueRestriction.hasValue(individual2));
                14.assertEquals("cardinality should be 0 ", 0, hasValueRestriction.getCardinality(profile.HAS_VALUE()));
            }
        }, new OntTestBase.OntTestCase("SomeValuesFromRestriction.someValuesFrom", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                SomeValuesFromRestriction someValuesFromRestriction = ontModel.createSomeValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", objectProperty, ontClass);
                15.assertEquals("Restriction should be some values from B", ontClass, someValuesFromRestriction.getSomeValuesFrom());
                15.assertTrue("Restriction should be some values from B", someValuesFromRestriction.hasSomeValuesFrom(ontClass));
                15.assertTrue("Restriction should not be some values from C", !someValuesFromRestriction.hasSomeValuesFrom(ontClass2));
                15.assertEquals("cardinality should be 1 ", 1, someValuesFromRestriction.getCardinality(profile.SOME_VALUES_FROM()));
                someValuesFromRestriction.setSomeValuesFrom(ontClass2);
                15.assertEquals("Restriction should be some values from C", ontClass2, someValuesFromRestriction.getSomeValuesFrom());
                15.assertTrue("Restriction should not be some values from B", !someValuesFromRestriction.hasSomeValuesFrom(ontClass));
                15.assertTrue("Restriction should be some values from C", someValuesFromRestriction.hasSomeValuesFrom(ontClass2));
                15.assertEquals("cardinality should be 1 ", 1, someValuesFromRestriction.getCardinality(profile.SOME_VALUES_FROM()));
                someValuesFromRestriction.removeSomeValuesFrom(ontClass2);
                15.assertTrue("Restriction should not be some values from C", !someValuesFromRestriction.hasSomeValuesFrom(ontClass2));
                15.assertEquals("cardinality should be 0 ", 0, someValuesFromRestriction.getCardinality(profile.SOME_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("SomeValuesFromRestriction.SomeValuesFrom.datatype", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                SomeValuesFromRestriction someValuesFromRestriction = ontModel.createSomeValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", objectProperty, XSD.gDay);
                16.assertEquals("Restriction should be some values from gDay", XSD.gDay, someValuesFromRestriction.getSomeValuesFrom());
                16.assertTrue("Restriction should be some values from gDay", someValuesFromRestriction.hasSomeValuesFrom(XSD.gDay));
                16.assertTrue("Restriction should not be some values from decimal", !someValuesFromRestriction.hasSomeValuesFrom(XSD.decimal));
                16.assertEquals("cardinality should be 1 ", 1, someValuesFromRestriction.getCardinality(profile.SOME_VALUES_FROM()));
                someValuesFromRestriction.setSomeValuesFrom(XSD.gMonth);
                16.assertEquals("Restriction should be some values from gMonth", XSD.gMonth, someValuesFromRestriction.getSomeValuesFrom());
                16.assertTrue("Restriction should not be some values from gDay", !someValuesFromRestriction.hasSomeValuesFrom(XSD.gDay));
                16.assertTrue("Restriction should be some values from gMonth", someValuesFromRestriction.hasSomeValuesFrom(XSD.gMonth));
                16.assertEquals("cardinality should be 1 ", 1, someValuesFromRestriction.getCardinality(profile.SOME_VALUES_FROM()));
                someValuesFromRestriction.removeSomeValuesFrom(XSD.gMonth);
                16.assertTrue("Restriction should not be some values from gMonth", !someValuesFromRestriction.hasSomeValuesFrom(XSD.gMonth));
                16.assertEquals("cardinality should be 0 ", 0, someValuesFromRestriction.getCardinality(profile.SOME_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("SomeValuesFromRestriction.SomeValuesFrom.literal", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                SomeValuesFromRestriction someValuesFromRestriction = ontModel.createSomeValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", objectProperty, RDFS.Literal);
                17.assertEquals("Restriction should be some values from literal", RDFS.Literal, someValuesFromRestriction.getSomeValuesFrom());
                17.assertTrue("Restriction should be some values from literal", someValuesFromRestriction.hasSomeValuesFrom(RDFS.Literal));
                17.assertTrue("Restriction should not be some values from decimal", !someValuesFromRestriction.hasSomeValuesFrom(XSD.decimal));
                17.assertEquals("cardinality should be 1 ", 1, someValuesFromRestriction.getCardinality(profile.SOME_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("SomeValuesFromRestriction.SomeValuesFrom.datarange", true, false, false, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                Literal literal = ontModel.createLiteral(1L);
                Literal literal2 = ontModel.createLiteral(2L);
                DataRange dataRange = ontModel.createDataRange(ontModel.createList(new RDFNode[]{literal, literal2}));
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                SomeValuesFromRestriction someValuesFromRestriction = ontModel.createSomeValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", objectProperty, dataRange);
                18.assertEquals("Restriction should be some values from dr", dataRange, someValuesFromRestriction.getSomeValuesFrom());
                18.assertTrue("value should be a datarange", someValuesFromRestriction.getSomeValuesFrom() instanceof DataRange);
                18.assertTrue("Restriction should be some values from dr", someValuesFromRestriction.hasSomeValuesFrom(dataRange));
                18.assertTrue("Restriction should not be some values from decimal", !someValuesFromRestriction.hasSomeValuesFrom(XSD.decimal));
                18.assertEquals("cardinality should be 1 ", 1, someValuesFromRestriction.getCardinality(profile.SOME_VALUES_FROM()));
                someValuesFromRestriction.removeSomeValuesFrom(dataRange);
                18.assertTrue("Restriction should not be some values from gMonth", !someValuesFromRestriction.hasSomeValuesFrom(dataRange));
                18.assertEquals("cardinality should be 0 ", 0, someValuesFromRestriction.getCardinality(profile.SOME_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("CardinalityRestriction.cardinality", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                CardinalityRestriction cardinalityRestriction = ontModel.createCardinalityRestriction("http://jena.hpl.hp.com/testing/ontology#A", objectProperty, 3);
                19.assertEquals("Restriction should be cardinality 3", 3, cardinalityRestriction.getCardinality());
                19.assertTrue("Restriction should be cardinality 3", cardinalityRestriction.hasCardinality(3));
                19.assertTrue("Restriction should not be cardinality 2", !cardinalityRestriction.hasCardinality(2));
                19.assertEquals("cardinality should be 1 ", 1, cardinalityRestriction.getCardinality(profile.CARDINALITY()));
                cardinalityRestriction.setCardinality(2);
                19.assertEquals("Restriction should be cardinality 2", 2, cardinalityRestriction.getCardinality());
                19.assertTrue("Restriction should not be cardinality 3", !cardinalityRestriction.hasCardinality(3));
                19.assertTrue("Restriction should be cardinality 2", cardinalityRestriction.hasCardinality(2));
                19.assertEquals("cardinality should be 1 ", 1, cardinalityRestriction.getCardinality(profile.CARDINALITY()));
                cardinalityRestriction.removeCardinality(2);
                19.assertTrue("Restriction should not be cardinality 3", !cardinalityRestriction.hasCardinality(3));
                19.assertTrue("Restriction should not be cardinality 2", !cardinalityRestriction.hasCardinality(2));
                19.assertEquals("cardinality should be 0 ", 0, cardinalityRestriction.getCardinality(profile.CARDINALITY()));
            }
        }, new OntTestBase.OntTestCase("MinCardinalityRestriction.minCardinality", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                MinCardinalityRestriction minCardinalityRestriction = ontModel.createMinCardinalityRestriction("http://jena.hpl.hp.com/testing/ontology#A", objectProperty, 3);
                20.assertEquals("Restriction should be min cardinality 3", 3, minCardinalityRestriction.getMinCardinality());
                20.assertTrue("Restriction should be min cardinality 3", minCardinalityRestriction.hasMinCardinality(3));
                20.assertTrue("Restriction should not be min cardinality 2", !minCardinalityRestriction.hasMinCardinality(2));
                20.assertEquals("cardinality should be 1 ", 1, minCardinalityRestriction.getCardinality(profile.MIN_CARDINALITY()));
                minCardinalityRestriction.setMinCardinality(2);
                20.assertEquals("Restriction should be min cardinality 2", 2, minCardinalityRestriction.getMinCardinality());
                20.assertTrue("Restriction should not be min cardinality 3", !minCardinalityRestriction.hasMinCardinality(3));
                20.assertTrue("Restriction should be min cardinality 2", minCardinalityRestriction.hasMinCardinality(2));
                20.assertEquals("cardinality should be 1 ", 1, minCardinalityRestriction.getCardinality(profile.MIN_CARDINALITY()));
                minCardinalityRestriction.removeMinCardinality(2);
                20.assertTrue("Restriction should not be cardinality 3", !minCardinalityRestriction.hasMinCardinality(3));
                20.assertTrue("Restriction should not be cardinality 2", !minCardinalityRestriction.hasMinCardinality(2));
                20.assertEquals("cardinality should be 0 ", 0, minCardinalityRestriction.getCardinality(profile.MIN_CARDINALITY()));
            }
        }, new OntTestBase.OntTestCase("MaxCardinalityRestriction.maxCardinality", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                MaxCardinalityRestriction maxCardinalityRestriction = ontModel.createMaxCardinalityRestriction("http://jena.hpl.hp.com/testing/ontology#A", objectProperty, 3);
                21.assertEquals("Restriction should be max cardinality 3", 3, maxCardinalityRestriction.getMaxCardinality());
                21.assertTrue("Restriction should be max cardinality 3", maxCardinalityRestriction.hasMaxCardinality(3));
                21.assertTrue("Restriction should not be max cardinality 2", !maxCardinalityRestriction.hasMaxCardinality(2));
                21.assertEquals("cardinality should be 1 ", 1, maxCardinalityRestriction.getCardinality(profile.MAX_CARDINALITY()));
                maxCardinalityRestriction.setMaxCardinality(2);
                21.assertEquals("Restriction should be max cardinality 2", 2, maxCardinalityRestriction.getMaxCardinality());
                21.assertTrue("Restriction should not be max cardinality 3", !maxCardinalityRestriction.hasMaxCardinality(3));
                21.assertTrue("Restriction should be max cardinality 2", maxCardinalityRestriction.hasMaxCardinality(2));
                21.assertEquals("cardinality should be 1 ", 1, maxCardinalityRestriction.getCardinality(profile.MAX_CARDINALITY()));
                maxCardinalityRestriction.removeMaxCardinality(2);
                21.assertTrue("Restriction should not be cardinality 3", !maxCardinalityRestriction.hasMaxCardinality(3));
                21.assertTrue("Restriction should not be cardinality 2", !maxCardinalityRestriction.hasMaxCardinality(2));
                21.assertEquals("cardinality should be 0 ", 0, maxCardinalityRestriction.getCardinality(profile.MAX_CARDINALITY()));
            }
        }, new OntTestBase.OntTestCase("OntClass.subclass.fromFile", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                String string = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String string2 = "file:testing/ontology/" + string + "/ClassExpression/test.rdf";
                ontModel.read(string2);
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#ClassA");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#ClassB");
                this.iteratorTest(ontClass.listSuperClasses(), new Object[]{ontClass2});
                this.iteratorTest(ontClass2.listSubClasses(), new Object[]{ontClass});
            }
        }, new OntTestBase.OntTestCase("OntClass.equivalentClass.fromFile", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                String string = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String string2 = "file:testing/ontology/" + string + "/ClassExpression/test.rdf";
                ontModel.read(string2);
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#ClassA");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#ClassC");
                23.assertTrue("A should be equiv to C", ontClass.hasEquivalentClass(ontClass2));
            }
        }, new OntTestBase.OntTestCase("OntClass.disjoint.fromFile", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                String string = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String string2 = "file:testing/ontology/" + string + "/ClassExpression/test.rdf";
                ontModel.read(string2);
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#ClassA");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#ClassD");
                24.assertTrue("A should be disjoint with D", ontClass.isDisjointWith(ontClass2));
            }
        }, new OntTestBase.OntTestCase("OntClass.isEnumeratedClass", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual individual = ontModel.createIndividual("http://jena.hpl.hp.com/testing/ontology#x", ontClass);
                Individual individual2 = ontModel.createIndividual("http://jena.hpl.hp.com/testing/ontology#y", ontClass);
                EnumeratedClass enumeratedClass = ontModel.createEnumeratedClass("http://jena.hpl.hp.com/testing/ontology#A", ontModel.createList(new RDFNode[]{individual, individual2}));
                25.assertTrue("enumerated class test not correct", enumeratedClass.isEnumeratedClass());
                25.assertTrue("intersection class test not correct", !enumeratedClass.isIntersectionClass());
                25.assertTrue("union class test not correct", !enumeratedClass.isUnionClass());
                25.assertTrue("complement class test not correct", !enumeratedClass.isComplementClass());
                25.assertTrue("restriction test not correct", !enumeratedClass.isRestriction());
            }
        }, new OntTestBase.OntTestCase("OntClass.isIntersectionClass", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                IntersectionClass intersectionClass = ontModel.createIntersectionClass("http://jena.hpl.hp.com/testing/ontology#A", ontModel.createList(new RDFNode[]{ontClass, ontClass2}));
                26.assertTrue("enumerated class test not correct", this.m_owlLiteLang || !intersectionClass.isEnumeratedClass());
                26.assertTrue("intersection class test not correct", intersectionClass.isIntersectionClass());
                26.assertTrue("union class test not correct", this.m_owlLiteLang || !intersectionClass.isUnionClass());
                26.assertTrue("complement class test not correct", this.m_owlLiteLang || !intersectionClass.isComplementClass());
                26.assertTrue("restriction test not correct", !intersectionClass.isRestriction());
            }
        }, new OntTestBase.OntTestCase("OntClass.isUnionClass", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                UnionClass unionClass = ontModel.createUnionClass("http://jena.hpl.hp.com/testing/ontology#A", ontModel.createList(new RDFNode[]{ontClass, ontClass2}));
                27.assertTrue("enumerated class test not correct", !unionClass.isEnumeratedClass());
                27.assertTrue("intersection class test not correct", !unionClass.isIntersectionClass());
                27.assertTrue("union class test not correct", unionClass.isUnionClass());
                27.assertTrue("complement class test not correct", !unionClass.isComplementClass());
                27.assertTrue("restriction test not correct", !unionClass.isRestriction());
            }
        }, new OntTestBase.OntTestCase("OntClass.isComplementClass", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                ComplementClass complementClass = ontModel.createComplementClass("http://jena.hpl.hp.com/testing/ontology#A", ontClass);
                28.assertTrue("enumerated class test not correct", !complementClass.isEnumeratedClass());
                28.assertTrue("intersection class test not correct", !complementClass.isIntersectionClass());
                28.assertTrue("union class test not correct", !complementClass.isUnionClass());
                28.assertTrue("complement class test not correct", complementClass.isComplementClass());
                28.assertTrue("restriction test not correct", !complementClass.isRestriction());
            }
        }, new OntTestBase.OntTestCase("OntClass.isRestriction", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Restriction restriction = ontModel.createRestriction(null);
                29.assertTrue("enumerated class test not correct", this.m_owlLiteLang || !restriction.isEnumeratedClass());
                29.assertTrue("intersection class test not correct", !restriction.isIntersectionClass());
                29.assertTrue("union class test not correct", this.m_owlLiteLang || !restriction.isUnionClass());
                29.assertTrue("complement class test not correct", this.m_owlLiteLang || !restriction.isComplementClass());
                29.assertTrue("restriction test not correct", restriction.isRestriction());
            }
        }, new OntTestBase.OntTestCase("OntClass.toEnumeratedClass", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                30.assertTrue("enumerated class test not correct", !ontClass.isEnumeratedClass());
                30.assertTrue("intersection class test not correct", !ontClass.isIntersectionClass());
                30.assertTrue("union class test not correct", !ontClass.isUnionClass());
                30.assertTrue("complement class test not correct", !ontClass.isComplementClass());
                30.assertTrue("restriction test not correct", !ontClass.isRestriction());
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual individual = ontModel.createIndividual("http://jena.hpl.hp.com/testing/ontology#x", ontClass2);
                Individual individual2 = ontModel.createIndividual("http://jena.hpl.hp.com/testing/ontology#y", ontClass2);
                ontClass = ontClass.convertToEnumeratedClass(ontModel.createList(new RDFNode[]{individual, individual2}));
                30.assertTrue("enumerated class test not correct", ontClass.isEnumeratedClass());
                30.assertTrue("intersection class test not correct", !ontClass.isIntersectionClass());
                30.assertTrue("union class test not correct", !ontClass.isUnionClass());
                30.assertTrue("complement class test not correct", !ontClass.isComplementClass());
                30.assertTrue("restriction test not correct", !ontClass.isRestriction());
            }
        }, new OntTestBase.OntTestCase("OntClass.toIntersectionClass", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                31.assertTrue("enumerated class test not correct", this.m_owlLiteLang || !ontClass.isEnumeratedClass());
                31.assertTrue("intersection class test not correct", !ontClass.isIntersectionClass());
                31.assertTrue("union class test not correct", this.m_owlLiteLang || !ontClass.isUnionClass());
                31.assertTrue("complement class test not correct", this.m_owlLiteLang || !ontClass.isComplementClass());
                31.assertTrue("restriction test not correct", !ontClass.isRestriction());
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass3 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                ontClass = ontClass.convertToIntersectionClass(ontModel.createList(new RDFNode[]{ontClass2, ontClass3}));
                31.assertTrue("enumerated class test not correct", this.m_owlLiteLang || !ontClass.isEnumeratedClass());
                31.assertTrue("intersection class test not correct", ontClass.isIntersectionClass());
                31.assertTrue("union class test not correct", this.m_owlLiteLang || !ontClass.isUnionClass());
                31.assertTrue("complement class test not correct", this.m_owlLiteLang || !ontClass.isComplementClass());
                31.assertTrue("restriction test not correct", !ontClass.isRestriction());
            }
        }, new OntTestBase.OntTestCase("OntClass.toUnionClass", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                32.assertTrue("enumerated class test not correct", !ontClass.isEnumeratedClass());
                32.assertTrue("intersection class test not correct", !ontClass.isIntersectionClass());
                32.assertTrue("union class test not correct", !ontClass.isUnionClass());
                32.assertTrue("complement class test not correct", !ontClass.isComplementClass());
                32.assertTrue("restriction test not correct", !ontClass.isRestriction());
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass3 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                ontClass = ontClass.convertToUnionClass(ontModel.createList(new RDFNode[]{ontClass2, ontClass3}));
                32.assertTrue("enumerated class test not correct", this.m_owlLiteLang || !ontClass.isEnumeratedClass());
                32.assertTrue("intersection class test not correct", !ontClass.isIntersectionClass());
                32.assertTrue("union class test not correct", this.m_owlLiteLang || ontClass.isUnionClass());
                32.assertTrue("complement class test not correct", this.m_owlLiteLang || !ontClass.isComplementClass());
                32.assertTrue("restriction test not correct", !ontClass.isRestriction());
            }
        }, new OntTestBase.OntTestCase("OntClass.toComplementClass", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                33.assertTrue("enumerated class test not correct", !ontClass.isEnumeratedClass());
                33.assertTrue("intersection class test not correct", !ontClass.isIntersectionClass());
                33.assertTrue("union class test not correct", !ontClass.isUnionClass());
                33.assertTrue("complement class test not correct", !ontClass.isComplementClass());
                33.assertTrue("restriction test not correct", !ontClass.isRestriction());
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                ontClass = ontClass.convertToComplementClass(ontClass2);
                33.assertTrue("enumerated class test not correct", this.m_owlLiteLang || !ontClass.isEnumeratedClass());
                33.assertTrue("intersection class test not correct", !ontClass.isIntersectionClass());
                33.assertTrue("union class test not correct", this.m_owlLiteLang || !ontClass.isUnionClass());
                33.assertTrue("complement class test not correct", this.m_owlLiteLang || ontClass.isComplementClass());
                33.assertTrue("restriction test not correct", !ontClass.isRestriction());
            }
        }, new OntTestBase.OntTestCase("OntClass.toRestriction", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                34.assertTrue("enumerated class test not correct", this.m_owlLiteLang || !ontClass.isEnumeratedClass());
                34.assertTrue("intersection class test not correct", !ontClass.isIntersectionClass());
                34.assertTrue("union class test not correct", this.m_owlLiteLang || !ontClass.isUnionClass());
                34.assertTrue("complement class test not correct", this.m_owlLiteLang || !ontClass.isComplementClass());
                34.assertTrue("restriction test not correct", !ontClass.isRestriction());
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                ontClass = ontClass.convertToRestriction(objectProperty);
                34.assertTrue("enumerated class test not correct", this.m_owlLiteLang || !ontClass.isEnumeratedClass());
                34.assertTrue("intersection class test not correct", !ontClass.isIntersectionClass());
                34.assertTrue("union class test not correct", this.m_owlLiteLang || !ontClass.isUnionClass());
                34.assertTrue("complement class test not correct", this.m_owlLiteLang || !ontClass.isComplementClass());
                34.assertTrue("restriction test not correct", ontClass.isRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.isAllValuesFrom", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                AllValuesFromRestriction allValuesFromRestriction = ontModel.createAllValuesFromRestriction(null, objectProperty, ontClass);
                35.assertTrue("all values from test not correct", allValuesFromRestriction.isAllValuesFromRestriction());
                35.assertTrue("some values from test not correct", !allValuesFromRestriction.isSomeValuesFromRestriction());
                35.assertTrue("has value test not correct", this.m_owlLiteLang || !allValuesFromRestriction.isHasValueRestriction());
                35.assertTrue("cardinality test not correct", !allValuesFromRestriction.isCardinalityRestriction());
                35.assertTrue("min cardinality test not correct", !allValuesFromRestriction.isMinCardinalityRestriction());
                35.assertTrue("max cardinality test not correct", !allValuesFromRestriction.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.isSomeValuesFrom", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                SomeValuesFromRestriction someValuesFromRestriction = ontModel.createSomeValuesFromRestriction(null, objectProperty, ontClass);
                36.assertTrue("all values from test not correct", !someValuesFromRestriction.isAllValuesFromRestriction());
                36.assertTrue("some values from test not correct", someValuesFromRestriction.isSomeValuesFromRestriction());
                36.assertTrue("has value test not correct", this.m_owlLiteLang || !someValuesFromRestriction.isHasValueRestriction());
                36.assertTrue("cardinality test not correct", !someValuesFromRestriction.isCardinalityRestriction());
                36.assertTrue("min cardinality test not correct", !someValuesFromRestriction.isMinCardinalityRestriction());
                36.assertTrue("max cardinality test not correct", !someValuesFromRestriction.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.isHasValue", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual individual = ontModel.createIndividual(ontClass);
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                HasValueRestriction hasValueRestriction = ontModel.createHasValueRestriction(null, objectProperty, individual);
                37.assertTrue("all values from test not correct", !hasValueRestriction.isAllValuesFromRestriction());
                37.assertTrue("some values from test not correct", !hasValueRestriction.isSomeValuesFromRestriction());
                37.assertTrue("has value test not correct", this.m_owlLiteLang || hasValueRestriction.isHasValueRestriction());
                37.assertTrue("cardinality test not correct", !hasValueRestriction.isCardinalityRestriction());
                37.assertTrue("min cardinality test not correct", !hasValueRestriction.isMinCardinalityRestriction());
                37.assertTrue("max cardinality test not correct", !hasValueRestriction.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.isCardinality", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                CardinalityRestriction cardinalityRestriction = ontModel.createCardinalityRestriction(null, objectProperty, 3);
                38.assertTrue("all values from test not correct", !cardinalityRestriction.isAllValuesFromRestriction());
                38.assertTrue("some values from test not correct", !cardinalityRestriction.isSomeValuesFromRestriction());
                38.assertTrue("has value test not correct", this.m_owlLiteLang || !cardinalityRestriction.isHasValueRestriction());
                38.assertTrue("cardinality test not correct", cardinalityRestriction.isCardinalityRestriction());
                38.assertTrue("min cardinality test not correct", !cardinalityRestriction.isMinCardinalityRestriction());
                38.assertTrue("max cardinality test not correct", !cardinalityRestriction.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.isMinCardinality", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                MinCardinalityRestriction minCardinalityRestriction = ontModel.createMinCardinalityRestriction(null, objectProperty, 1);
                39.assertTrue("all values from test not correct", !minCardinalityRestriction.isAllValuesFromRestriction());
                39.assertTrue("some values from test not correct", !minCardinalityRestriction.isSomeValuesFromRestriction());
                39.assertTrue("has value test not correct", this.m_owlLiteLang || !minCardinalityRestriction.isHasValueRestriction());
                39.assertTrue("cardinality test not correct", !minCardinalityRestriction.isCardinalityRestriction());
                39.assertTrue("min cardinality test not correct", minCardinalityRestriction.isMinCardinalityRestriction());
                39.assertTrue("max cardinality test not correct", !minCardinalityRestriction.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.isMaxCardinality", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                MaxCardinalityRestriction maxCardinalityRestriction = ontModel.createMaxCardinalityRestriction(null, objectProperty, 5);
                40.assertTrue("all values from test not correct", !maxCardinalityRestriction.isAllValuesFromRestriction());
                40.assertTrue("some values from test not correct", !maxCardinalityRestriction.isSomeValuesFromRestriction());
                40.assertTrue("has value test not correct", this.m_owlLiteLang || !maxCardinalityRestriction.isHasValueRestriction());
                40.assertTrue("cardinality test not correct", !maxCardinalityRestriction.isCardinalityRestriction());
                40.assertTrue("min cardinality test not correct", !maxCardinalityRestriction.isMinCardinalityRestriction());
                40.assertTrue("max cardinality test not correct", maxCardinalityRestriction.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.convertToAllValuesFrom", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                Restriction restriction = ontModel.createRestriction(objectProperty);
                41.assertTrue("all values from test not correct", !restriction.isAllValuesFromRestriction());
                41.assertTrue("some values from test not correct", !restriction.isSomeValuesFromRestriction());
                41.assertTrue("has value test not correct", this.m_owlLiteLang || !restriction.isHasValueRestriction());
                41.assertTrue("cardinality test not correct", !restriction.isCardinalityRestriction());
                41.assertTrue("min cardinality test not correct", !restriction.isMinCardinalityRestriction());
                41.assertTrue("max cardinality test not correct", !restriction.isMaxCardinalityRestriction());
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                restriction = restriction.convertToAllValuesFromRestriction(ontClass);
                41.assertTrue("all values from test not correct", restriction.isAllValuesFromRestriction());
                41.assertTrue("some values from test not correct", !restriction.isSomeValuesFromRestriction());
                41.assertTrue("has value test not correct", this.m_owlLiteLang || !restriction.isHasValueRestriction());
                41.assertTrue("cardinality test not correct", !restriction.isCardinalityRestriction());
                41.assertTrue("min cardinality test not correct", !restriction.isMinCardinalityRestriction());
                41.assertTrue("max cardinality test not correct", !restriction.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.convertToSomeValuesFrom", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                Restriction restriction = ontModel.createRestriction(objectProperty);
                42.assertTrue("all values from test not correct", !restriction.isAllValuesFromRestriction());
                42.assertTrue("some values from test not correct", !restriction.isSomeValuesFromRestriction());
                42.assertTrue("has value test not correct", this.m_owlLiteLang || !restriction.isHasValueRestriction());
                42.assertTrue("cardinality test not correct", !restriction.isCardinalityRestriction());
                42.assertTrue("min cardinality test not correct", !restriction.isMinCardinalityRestriction());
                42.assertTrue("max cardinality test not correct", !restriction.isMaxCardinalityRestriction());
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                restriction = restriction.convertToSomeValuesFromRestriction(ontClass);
                42.assertTrue("all values from test not correct", !restriction.isAllValuesFromRestriction());
                42.assertTrue("some values from test not correct", restriction.isSomeValuesFromRestriction());
                42.assertTrue("has value test not correct", this.m_owlLiteLang || !restriction.isHasValueRestriction());
                42.assertTrue("cardinality test not correct", !restriction.isCardinalityRestriction());
                42.assertTrue("min cardinality test not correct", !restriction.isMinCardinalityRestriction());
                42.assertTrue("max cardinality test not correct", !restriction.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.convertToHasValue", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                Restriction restriction = ontModel.createRestriction(objectProperty);
                43.assertTrue("all values from test not correct", !restriction.isAllValuesFromRestriction());
                43.assertTrue("some values from test not correct", !restriction.isSomeValuesFromRestriction());
                43.assertTrue("has value test not correct", this.m_owlLiteLang || !restriction.isHasValueRestriction());
                43.assertTrue("cardinality test not correct", !restriction.isCardinalityRestriction());
                43.assertTrue("min cardinality test not correct", !restriction.isMinCardinalityRestriction());
                43.assertTrue("max cardinality test not correct", !restriction.isMaxCardinalityRestriction());
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual individual = ontModel.createIndividual(ontClass);
                restriction = restriction.convertToHasValueRestriction(individual);
                43.assertTrue("all values from test not correct", !restriction.isAllValuesFromRestriction());
                43.assertTrue("some values from test not correct", !restriction.isSomeValuesFromRestriction());
                43.assertTrue("has value test not correct", this.m_owlLiteLang || restriction.isHasValueRestriction());
                43.assertTrue("cardinality test not correct", !restriction.isCardinalityRestriction());
                43.assertTrue("min cardinality test not correct", !restriction.isMinCardinalityRestriction());
                43.assertTrue("max cardinality test not correct", !restriction.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.convertCardinality", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                Restriction restriction = ontModel.createRestriction(objectProperty);
                44.assertTrue("all values from test not correct", !restriction.isAllValuesFromRestriction());
                44.assertTrue("some values from test not correct", !restriction.isSomeValuesFromRestriction());
                44.assertTrue("has value test not correct", this.m_owlLiteLang || !restriction.isHasValueRestriction());
                44.assertTrue("cardinality test not correct", !restriction.isCardinalityRestriction());
                44.assertTrue("min cardinality test not correct", !restriction.isMinCardinalityRestriction());
                44.assertTrue("max cardinality test not correct", !restriction.isMaxCardinalityRestriction());
                restriction = restriction.convertToCardinalityRestriction(3);
                44.assertTrue("all values from test not correct", !restriction.isAllValuesFromRestriction());
                44.assertTrue("some values from test not correct", !restriction.isSomeValuesFromRestriction());
                44.assertTrue("has value test not correct", this.m_owlLiteLang || !restriction.isHasValueRestriction());
                44.assertTrue("cardinality test not correct", restriction.isCardinalityRestriction());
                44.assertTrue("min cardinality test not correct", !restriction.isMinCardinalityRestriction());
                44.assertTrue("max cardinality test not correct", !restriction.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.convertMinCardinality", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                Restriction restriction = ontModel.createRestriction(objectProperty);
                45.assertTrue("all values from test not correct", !restriction.isAllValuesFromRestriction());
                45.assertTrue("some values from test not correct", !restriction.isSomeValuesFromRestriction());
                45.assertTrue("has value test not correct", this.m_owlLiteLang || !restriction.isHasValueRestriction());
                45.assertTrue("cardinality test not correct", !restriction.isCardinalityRestriction());
                45.assertTrue("min cardinality test not correct", !restriction.isMinCardinalityRestriction());
                45.assertTrue("max cardinality test not correct", !restriction.isMaxCardinalityRestriction());
                restriction = restriction.convertToMinCardinalityRestriction(3);
                45.assertTrue("all values from test not correct", !restriction.isAllValuesFromRestriction());
                45.assertTrue("some values from test not correct", !restriction.isSomeValuesFromRestriction());
                45.assertTrue("has value test not correct", this.m_owlLiteLang || !restriction.isHasValueRestriction());
                45.assertTrue("cardinality test not correct", !restriction.isCardinalityRestriction());
                45.assertTrue("min cardinality test not correct", restriction.isMinCardinalityRestriction());
                45.assertTrue("max cardinality test not correct", !restriction.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.convertMaxCardinality", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                Restriction restriction = ontModel.createRestriction(objectProperty);
                46.assertTrue("all values from test not correct", !restriction.isAllValuesFromRestriction());
                46.assertTrue("some values from test not correct", !restriction.isSomeValuesFromRestriction());
                46.assertTrue("has value test not correct", this.m_owlLiteLang || !restriction.isHasValueRestriction());
                46.assertTrue("cardinality test not correct", !restriction.isCardinalityRestriction());
                46.assertTrue("min cardinality test not correct", !restriction.isMinCardinalityRestriction());
                46.assertTrue("max cardinality test not correct", !restriction.isMaxCardinalityRestriction());
                restriction = restriction.convertToMaxCardinalityRestriction(3);
                46.assertTrue("all values from test not correct", !restriction.isAllValuesFromRestriction());
                46.assertTrue("some values from test not correct", !restriction.isSomeValuesFromRestriction());
                46.assertTrue("has value test not correct", this.m_owlLiteLang || !restriction.isHasValueRestriction());
                46.assertTrue("cardinality test not correct", !restriction.isCardinalityRestriction());
                46.assertTrue("min cardinality test not correct", !restriction.isMinCardinalityRestriction());
                46.assertTrue("max cardinality test not correct", restriction.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("OntClass.listInstances", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual individual = ontModel.createIndividual(ontClass);
                Individual individual2 = ontModel.createIndividual("http://jena.hpl.hp.com/testing/ontology#a1", ontClass);
                Individual individual3 = ontModel.createIndividual(ontClass2);
                ontModel.createIndividual("http://jena.hpl.hp.com/testing/ontology#b1", ontClass2);
                individual3.addRDFType(ontClass);
                this.iteratorTest(ontClass.listInstances(), new Object[]{individual, individual2, individual3});
            }
        }, new OntTestBase.OntTestCase("OntClass.listDefinedProperties", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                OntProperty ontProperty = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntProperty ontProperty2 = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#q");
                OntProperty ontProperty3 = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#r");
                OntProperty ontProperty4 = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#s");
                ontProperty.setDomain(ontClass);
                ontProperty2.setDomain(ontClass);
                ontProperty4.setDomain(ontClass2);
                if (this.m_rdfsLang) {
                    this.iteratorTest(ontClass.listDeclaredProperties(), new Object[]{ontProperty, ontProperty2});
                } else {
                    Restriction restriction = ontModel.createRestriction(ontProperty3);
                    ontClass2.addSuperClass(restriction);
                    this.iteratorTest(ontClass.listDeclaredProperties(), new Object[]{ontProperty, ontProperty2});
                    this.iteratorTest(restriction.listDeclaredProperties(), new Object[]{ontProperty3});
                }
            }
        }, new OntTestBase.OntTestCase("OntClass.listDefinedProperties.notAll", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                ontClass2.addSuperClass(ontClass);
                OntProperty ontProperty = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntProperty ontProperty2 = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#q");
                OntProperty ontProperty3 = ontModel.createOntProperty("http://jena.hpl.hp.com/testing/ontology#s");
                ontProperty.setDomain(ontClass);
                ontProperty2.setDomain(ontClass);
                ontProperty3.setDomain(ontClass2);
                this.iteratorTest(ontClass2.listDeclaredProperties(true), new Object[]{ontProperty, ontProperty2, ontProperty3});
                this.iteratorTest(ontClass2.listDeclaredProperties(false), new Object[]{ontProperty3});
                49.assertTrue("declared property should be an ont prop", ontClass2.listDeclaredProperties(true).next() instanceof OntProperty);
                49.assertTrue("declared property should be an ont prop", ontClass2.listDeclaredProperties(false).next() instanceof OntProperty);
            }
        }, new OntTestBase.OntTestCase("DataRange.oneOf", true, false, false, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Literal literal = ontModel.createTypedLiteral(42);
                Literal literal2 = ontModel.createTypedLiteral(true);
                Literal literal3 = ontModel.createTypedLiteral("life");
                RDFList rDFList = ontModel.createList(new RDFNode[]{literal, literal2});
                DataRange dataRange = ontModel.createDataRange(rDFList);
                50.assertTrue("datarange should contain x", dataRange.hasOneOf(literal));
                50.assertTrue("datarange should contain y", dataRange.hasOneOf(literal2));
                50.assertFalse("datarange should not contain z", dataRange.hasOneOf(literal3));
                dataRange.removeOneOf(literal3);
                50.assertTrue("datarange should contain x", dataRange.hasOneOf(literal));
                50.assertTrue("datarange should contain y", dataRange.hasOneOf(literal2));
                50.assertFalse("datarange should not contain z", dataRange.hasOneOf(literal3));
                dataRange.removeOneOf(literal);
                50.assertFalse("datarange should not contain x", dataRange.hasOneOf(literal));
                50.assertTrue("datarange should contain y", dataRange.hasOneOf(literal2));
                50.assertFalse("datarange should not contain z", dataRange.hasOneOf(literal3));
                dataRange.addOneOf(literal3);
                50.assertEquals("datarange should be size 2", 2, dataRange.getOneOf().size());
                this.iteratorTest(dataRange.listOneOf(), new Object[]{literal2, literal3});
                dataRange.setOneOf(ontModel.createList(new RDFNode[]{literal}));
                this.iteratorTest(dataRange.listOneOf(), new Object[]{literal});
            }
        }};
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

