/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.impl.SimpleTransactionHandler;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import junit.framework.TestCase;

public class TestBugReports
extends TestCase {
    public static String NS = "http://example.org/test#";
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntClass;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Individual;

    public TestBugReports(String string) {
        super(string);
    }

    public void test_mra_01() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM, null, null);
        String string = "http://somewhere/myDictionaries/1.0#";
        String string2 = "http://www.daml.org/2001/03/daml+oil#";
        ontModel.setNsPrefix("DAML", string2);
        String string3 = string + "C1";
        OntClass ontClass = ontModel.createClass(string3);
        DatatypeProperty datatypeProperty = ontModel.createDatatypeProperty(string + "P1");
        datatypeProperty.setDomain(ontClass);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ontModel.write(byteArrayOutputStream, "RDF/XML-ABBREV", string);
    }

    public void test_hk_01() {
        String string = "http://jena.hpl.hp.com/test#";
        String string2 = "<rdf:RDF   xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"   xmlns:owl=\"http://www.w3.org/2002/07/owl#\">  <owl:Ontology rdf:about=\"\">    <owl:imports rdf:resource=\"http://www.w3.org/2002/07/owl\" />  </owl:Ontology></rdf:RDF>";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, null);
        ontModel.read(new ByteArrayInputStream(string2.getBytes()), string);
        Resource resource = ontModel.getResource(OWL.Class.getURI());
        OntClass ontClass = (OntClass)resource.as(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = TestBugReports.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass);
        TestBugReports.assertNotNull("OntClass c should not be null", ontClass);
    }

    public void test_hk_02() {
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_MEM);
        ontModelSpec.setReasoner(null);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.createAllDifferent();
        TestBugReports.assertTrue(ontModel.listAllDifferent().hasNext());
        AllDifferent allDifferent = (AllDifferent)ontModel.listAllDifferent().next();
        TestBugReports.assertFalse(allDifferent.listDistinctMembers().hasNext());
    }

    public void test_hk_03() {
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_MEM);
        ontModelSpec.setReasoner(null);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ObjectProperty objectProperty = ontModel.createObjectProperty("http://www.aldi.de#property");
        ontModel.createMinCardinalityRestriction(null, objectProperty, 42);
    }

    public void test_hk_04() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.getDocumentManager().addAltEntry("http://jena.hpl.hp.com/testing/ontology/relativenames", "file:testing/ontology/relativenames.rdf");
        ontModel.read("http://jena.hpl.hp.com/testing/ontology/relativenames");
        TestBugReports.assertTrue("#A should be a class", ontModel.getResource("http://jena.hpl.hp.com/testing/ontology/relativenames#A").canAs(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = TestBugReports.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass));
        TestBugReports.assertFalse("file: #A should not be a class", ontModel.getResource("file:testing/ontology/relativenames.rdf#A").canAs(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = TestBugReports.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass));
    }

    public void test_fc_01() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ObjectProperty objectProperty = ontModel.createObjectProperty(NS + "p");
        Restriction restriction = ontModel.createRestriction(objectProperty);
        HasValueRestriction hasValueRestriction = restriction.convertToHasValueRestriction(ontModel.createLiteral(1L));
        RDFNode rDFNode = hasValueRestriction.getHasValue();
        TestBugReports.assertFalse("Should not be able to convert literal to individual", rDFNode.canAs(class$com$hp$hpl$jena$ontology$Individual == null ? (class$com$hp$hpl$jena$ontology$Individual = TestBugReports.class$("com.hp.hpl.jena.ontology.Individual")) : class$com$hp$hpl$jena$ontology$Individual));
    }

    public void test_ck_01() {
        GraphMem graphMem = new GraphMem(){
            TransactionHandler m_t;
            {
                this.m_t = new MockTransactionHandler();
            }

            public TransactionHandler getTransactionHandler() {
                return this.m_t;
            }
        };
        Model model = ModelFactory.createModelForGraph(graphMem);
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_LITE_MEM, model);
        TestBugReports.assertFalse("Transaction not started yet", ((MockTransactionHandler)ontModel.getGraph().getTransactionHandler()).m_inTransaction);
        ontModel.begin();
        TestBugReports.assertTrue("Transaction started", ((MockTransactionHandler)ontModel.getGraph().getTransactionHandler()).m_inTransaction);
        ontModel.abort();
        TestBugReports.assertFalse("Transaction aborted", ((MockTransactionHandler)ontModel.getGraph().getTransactionHandler()).m_inTransaction);
        TestBugReports.assertTrue("Transaction aborted", ((MockTransactionHandler)ontModel.getGraph().getTransactionHandler()).m_aborted);
        ontModel.begin();
        TestBugReports.assertTrue("Transaction started", ((MockTransactionHandler)ontModel.getGraph().getTransactionHandler()).m_inTransaction);
        ontModel.commit();
        TestBugReports.assertFalse("Transaction committed", ((MockTransactionHandler)ontModel.getGraph().getTransactionHandler()).m_inTransaction);
        TestBugReports.assertTrue("Transaction committed", ((MockTransactionHandler)ontModel.getGraph().getTransactionHandler()).m_committed);
    }

    public void test_ck_02() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ObjectProperty objectProperty = ontModel.createObjectProperty("p");
        OntClass ontClass = ontModel.createClass("A");
        OntModel ontModel2 = ModelFactory.createOntologyModel();
        Individual individual = ontModel2.createIndividual("uri1", ontClass);
        Individual individual2 = ontModel2.createIndividual("uri2", ontClass);
        ontModel2.createStatement((Resource)individual, (Property)objectProperty, individual2);
    }

    public void test_ck_03() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM, null);
        OntModel ontModel2 = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM_RULE_INF, null);
        Individual individual = ontModel.createIndividual("http://mytest#i1", ontModel.getProfile().CLASS());
        OntProperty ontProperty = ontModel.createOntProperty("http://mytest#");
        Individual individual2 = ontModel.createIndividual("http://mytest#i2", ontModel.getProfile().CLASS());
        OntProperty ontProperty2 = ontModel.createOntProperty("http://mytest#prob");
        Statement statement = ontModel.createStatement((Resource)individual, (Property)ontProperty, individual2);
        ontModel.add(statement);
        statement.createReifiedStatement().addProperty((Property)ontProperty2, 0.9);
        TestBugReports.assertTrue("st should be reified", statement.isReified());
        Statement statement2 = ontModel2.createStatement((Resource)individual, (Property)ontProperty, individual2);
        ontModel2.add(statement2);
        statement2.createReifiedStatement().addProperty((Property)ontProperty2, 0.3);
        TestBugReports.assertTrue("st2 should be reified", statement2.isReified());
        individual.addProperty((Property)ontProperty2, 0.3);
        individual.removeAll(ontProperty2).addProperty((Property)ontProperty2, 0.3);
        Individual individual3 = ontModel2.createIndividual("http://mytest#i1", ontModel.getProfile().CLASS());
        individual.addProperty((Property)ontProperty2, 0.3);
        individual.removeAll(ontProperty2);
        individual3.addProperty((Property)ontProperty2, 0.3);
        individual3.removeAll(ontProperty2);
    }

    public void test_sjooseng_01() {
        String string = "<rdf:RDF xmlns:daml='http://www.daml.org/2001/03/daml+oil#'    xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#' >    <daml:Class rdf:about='http://localhost:8080/kc2c#C1'>        <daml:subClassOf>            <daml:Restriction>                <daml:onProperty rdf:resource='http://localhost:8080/kc2c#p1'/>                <daml:hasClass>                    <daml:Class>                        <daml:oneOf rdf:parseType=\"daml:collection\">                            <daml:Thing rdf:about='http://localhost:8080/kc2c#i1'/>                            <daml:Thing rdf:about='http://localhost:8080/kc2c#i2'/>                        </daml:oneOf>                    </daml:Class>                </daml:hasClass>            </daml:Restriction>        </daml:subClassOf>    </daml:Class>    <daml:ObjectProperty rdf:about='http://localhost:8080/kc2c#p1'>        <rdfs:label>p1</rdfs:label>    </daml:ObjectProperty></rdf:RDF>";
        OntModel ontModel = ModelFactory.createOntologyModel("http://www.daml.org/2001/03/daml+oil#");
        ontModel.read(new ByteArrayInputStream(string.getBytes()), "http://localhost:8080/kc2c");
        OntClass ontClass = ontModel.getOntClass("http://localhost:8080/kc2c#C1");
        boolean bl = false;
        ExtendedIterator extendedIterator = ontClass.listSuperClasses(false);
        while (extendedIterator.hasNext()) {
            SomeValuesFromRestriction someValuesFromRestriction;
            OntClass ontClass2;
            Restriction restriction;
            OntClass ontClass3 = (OntClass)extendedIterator.next();
            if (!ontClass3.isRestriction() || !(restriction = ontClass3.asRestriction()).isSomeValuesFromRestriction() || !(ontClass2 = (OntClass)(someValuesFromRestriction = restriction.asSomeValuesFromRestriction()).getSomeValuesFrom()).isEnumeratedClass()) continue;
            EnumeratedClass enumeratedClass = ontClass2.asEnumeratedClass();
            TestBugReports.assertEquals("Enumeration size should be 2", 2, enumeratedClass.getOneOf().size());
            bl = true;
        }
        TestBugReports.assertTrue(bl);
    }

    public void test_afs_01() {
        String string = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'   xmlns:owl=\"http://www.w3.org/2002/07/owl#\">    <owl:Class rdf:about='http://example.org/foo#A'>   </owl:Class></rdf:RDF>";
        String string2 = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'    xmlns:owl=\"http://www.w3.org/2002/07/owl#\">    <rdf:Description rdf:about='http://example.org/foo#x'>    <rdf:type rdf:resource='http://example.org/foo#A' />   </rdf:Description></rdf:RDF>";
        Model model = ModelFactory.createDefaultModel();
        model.read(new ByteArrayInputStream(string.getBytes()), "http://example.org/foo");
        Model model2 = ModelFactory.createDefaultModel();
        model2.read(new ByteArrayInputStream(string2.getBytes()), "http://example.org/foo");
        Reasoner reasoner = ReasonerRegistry.getOWLReasoner();
        reasoner = reasoner.bindSchema(model);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_MEM_RULE_INF);
        ontModelSpec.setReasoner(reasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, model2);
        ArrayList arrayList = new ArrayList();
        ExtendedIterator extendedIterator = ontModel.listIndividuals();
        while (extendedIterator.hasNext()) {
            arrayList.add(extendedIterator.next());
        }
        TestBugReports.assertTrue("x should be an individual", arrayList.contains(ontModel.getResource("http://example.org/foo#x")));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MockTransactionHandler
    extends SimpleTransactionHandler {
        boolean m_inTransaction = false;
        boolean m_aborted = false;
        boolean m_committed = false;

        MockTransactionHandler() {
        }

        public void begin() {
            this.m_inTransaction = true;
        }

        public void abort() {
            this.m_inTransaction = false;
            this.m_aborted = true;
        }

        public void commit() {
            this.m_inTransaction = false;
            this.m_committed = true;
        }
    }
}

