/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl.test;

import com.hp.hpl.jena.ontology.daml.DAMLClass;
import com.hp.hpl.jena.ontology.daml.DAMLDatatypeProperty;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.DAMLObjectProperty;
import com.hp.hpl.jena.ontology.daml.DAMLProperty;
import com.hp.hpl.jena.ontology.daml.impl.test.DAMLTestBase;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import junit.framework.TestSuite;

public class TestDAMLProperty
extends DAMLTestBase {
    public static TestSuite suite() {
        return new TestDAMLProperty("TestDAMLProperty");
    }

    public TestDAMLProperty(String string) {
        super(string);
    }

    public DAMLTestBase.OntTestCase[] getTests() {
        return new DAMLTestBase.OntTestCase[]{new DAMLTestBase.OntTestCase("DAMLProperty.unique"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLProperty dAMLProperty = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                1.assertFalse("unique", dAMLProperty.isUnique());
                dAMLProperty.setIsUnique(true);
                1.assertTrue("unique", dAMLProperty.isUnique());
            }
        }, new DAMLTestBase.OntTestCase("DAMLProperty.prop_domain"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLProperty dAMLProperty = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                2.assertEquals("prop_domain property", DAML_OIL.domain, dAMLProperty.prop_domain().getProperty());
                2.assertEquals("domain cardinality", 0, dAMLProperty.prop_domain().count());
                dAMLProperty.prop_domain().add(dAMLClass);
                2.assertEquals("domain cardinality", 1, dAMLProperty.prop_domain().count());
                dAMLProperty.prop_domain().add(dAMLClass2);
                2.assertEquals("domain cardinality", 2, dAMLProperty.prop_domain().count());
                this.iteratorTest(dAMLProperty.prop_domain().getAll(), new Object[]{dAMLClass, dAMLClass2});
                dAMLProperty.prop_domain().remove(dAMLClass2);
                2.assertEquals("domain cardinality", 1, dAMLProperty.prop_domain().count());
                this.iteratorTest(dAMLProperty.prop_domain().getAll(), new Object[]{dAMLClass});
                2.assertTrue("hasValue", dAMLProperty.prop_domain().hasValue(dAMLClass));
                2.assertTrue("hasValue", !dAMLProperty.prop_domain().hasValue(dAMLClass2));
            }
        }, new DAMLTestBase.OntTestCase("DAMLProperty.prop_range"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLProperty dAMLProperty = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                3.assertEquals("prop_range property", DAML_OIL.range, dAMLProperty.prop_range().getProperty());
                3.assertEquals("range cardinality", 0, dAMLProperty.prop_range().count());
                dAMLProperty.prop_range().add(dAMLClass);
                3.assertEquals("range cardinality", 1, dAMLProperty.prop_range().count());
                dAMLProperty.prop_range().add(dAMLClass2);
                3.assertEquals("range cardinality", 2, dAMLProperty.prop_range().count());
                this.iteratorTest(dAMLProperty.prop_range().getAll(), new Object[]{dAMLClass, dAMLClass2});
                dAMLProperty.prop_range().remove(dAMLClass2);
                3.assertEquals("range cardinality", 1, dAMLProperty.prop_range().count());
                this.iteratorTest(dAMLProperty.prop_range().getAll(), new Object[]{dAMLClass});
                3.assertTrue("hasValue", dAMLProperty.prop_range().hasValue(dAMLClass));
                3.assertTrue("hasValue", !dAMLProperty.prop_range().hasValue(dAMLClass2));
            }
        }, new DAMLTestBase.OntTestCase("DAMLProperty.prop_subPropertyOf"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLProperty dAMLProperty = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLProperty dAMLProperty2 = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#q");
                DAMLProperty dAMLProperty3 = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#r");
                4.assertEquals("prop_subPropertyOf property", DAML_OIL.subPropertyOf, dAMLProperty.prop_subPropertyOf().getProperty());
                4.assertEquals("subPropertyOf cardinality", 0, dAMLProperty.prop_subPropertyOf().count());
                dAMLProperty.prop_subPropertyOf().add(dAMLProperty2);
                4.assertEquals("subPropertyOf cardinality", 1, dAMLProperty.prop_subPropertyOf().count());
                dAMLProperty.prop_subPropertyOf().add(dAMLProperty3);
                4.assertEquals("subPropertyOf cardinality", 2, dAMLProperty.prop_subPropertyOf().count());
                this.iteratorTest(dAMLProperty.prop_subPropertyOf().getAll(), new Object[]{dAMLProperty2, dAMLProperty3});
                dAMLProperty.prop_subPropertyOf().remove(dAMLProperty3);
                4.assertEquals("subPropertyOf cardinality", 1, dAMLProperty.prop_subPropertyOf().count());
                this.iteratorTest(dAMLProperty.prop_subPropertyOf().getAll(), new Object[]{dAMLProperty2});
                4.assertTrue("hasValue", dAMLProperty.prop_subPropertyOf().hasValue(dAMLProperty2));
                4.assertTrue("hasValue", !dAMLProperty.prop_subPropertyOf().hasValue(dAMLProperty3));
            }
        }, new DAMLTestBase.OntTestCase("DAMLProperty.getSubProperties"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLProperty dAMLProperty = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLProperty dAMLProperty2 = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#q");
                DAMLProperty dAMLProperty3 = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#r");
                dAMLProperty3.prop_subPropertyOf().add(dAMLProperty2);
                dAMLProperty2.prop_subPropertyOf().add(dAMLProperty);
                5.assertEquals("subPropertyOf p", dAMLProperty2, dAMLProperty.getSubProperty());
                this.iteratorTest(dAMLProperty.getSubProperties(), new Object[]{dAMLProperty2});
                this.iteratorTest(dAMLProperty.getSubProperties(false), new Object[]{dAMLProperty2});
                this.iteratorTest(dAMLProperty.getSubProperties(true), new Object[]{dAMLProperty2});
                dAMLProperty3.prop_subPropertyOf().add(dAMLProperty);
                this.iteratorTest(dAMLProperty.getSubProperties(), new Object[]{dAMLProperty2, dAMLProperty3});
                this.iteratorTest(dAMLProperty.getSubProperties(false), new Object[]{dAMLProperty2});
                this.iteratorTest(dAMLProperty.getSubProperties(true), new Object[]{dAMLProperty2, dAMLProperty3});
            }
        }, new DAMLTestBase.OntTestCase("DAMLProperty.getSuperProperties"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLProperty dAMLProperty = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLProperty dAMLProperty2 = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#q");
                DAMLProperty dAMLProperty3 = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#r");
                dAMLProperty.prop_subPropertyOf().add(dAMLProperty2);
                dAMLProperty2.prop_subPropertyOf().add(dAMLProperty3);
                6.assertEquals("superPropertyOf p", dAMLProperty2, dAMLProperty.getSuperProperty());
                this.iteratorTest(dAMLProperty.getSuperProperties(), new Object[]{dAMLProperty2});
                this.iteratorTest(dAMLProperty.getSuperProperties(false), new Object[]{dAMLProperty2});
                this.iteratorTest(dAMLProperty.getSuperProperties(true), new Object[]{dAMLProperty2});
                dAMLProperty.prop_subPropertyOf().add(dAMLProperty3);
                this.iteratorTest(dAMLProperty.getSuperProperties(), new Object[]{dAMLProperty2, dAMLProperty3});
                this.iteratorTest(dAMLProperty.getSuperProperties(false), new Object[]{dAMLProperty2});
                this.iteratorTest(dAMLProperty.getSuperProperties(true), new Object[]{dAMLProperty2, dAMLProperty3});
            }
        }, new DAMLTestBase.OntTestCase("DAMLProperty.getSameProperties"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLProperty dAMLProperty = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLProperty dAMLProperty2 = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#q");
                DAMLProperty dAMLProperty3 = dAMLModel.createDAMLProperty("http://jena.hpl.hp.com/testing/ontology#r");
                dAMLProperty.prop_samePropertyAs().add(dAMLProperty2);
                dAMLProperty2.prop_samePropertyAs().add(dAMLProperty3);
                this.iteratorTest(dAMLProperty.getSameProperties(), new Object[]{dAMLProperty2});
                dAMLProperty.prop_samePropertyAs().add(dAMLProperty3);
                this.iteratorTest(dAMLProperty.getSameProperties(), new Object[]{dAMLProperty2, dAMLProperty3});
            }
        }, new DAMLTestBase.OntTestCase("Datatype property"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLDatatypeProperty dAMLDatatypeProperty = dAMLModel.createDAMLDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p");
                8.assertNotNull(dAMLDatatypeProperty);
            }
        }, new DAMLTestBase.OntTestCase("unambiguous property"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLObjectProperty dAMLObjectProperty = dAMLModel.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                9.assertFalse("p not unambiguous", dAMLObjectProperty.isUnambiguous());
                dAMLObjectProperty.setIsUnambiguous(true);
                9.assertTrue("p not unambiguous", dAMLObjectProperty.isUnambiguous());
                dAMLObjectProperty.setIsUnambiguous(false);
                9.assertFalse("p not unambiguous", dAMLObjectProperty.isUnambiguous());
            }
        }, new DAMLTestBase.OntTestCase("Transitive property"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLObjectProperty dAMLObjectProperty = dAMLModel.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                10.assertFalse("p not Transitive", dAMLObjectProperty.isTransitive());
                dAMLObjectProperty.setIsTransitive(true);
                10.assertTrue("p not Transitive", dAMLObjectProperty.isTransitive());
                dAMLObjectProperty.setIsTransitive(false);
                10.assertFalse("p not Transitive", dAMLObjectProperty.isTransitive());
            }
        }, new DAMLTestBase.OntTestCase("DAMLObjectProperty.prop_inverseOf"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLObjectProperty dAMLObjectProperty = dAMLModel.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLObjectProperty dAMLObjectProperty2 = dAMLModel.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                dAMLObjectProperty.prop_inverseOf().add(dAMLObjectProperty2);
                11.assertEquals("inverse", dAMLObjectProperty2, dAMLObjectProperty.prop_inverseOf().get());
            }
        }};
    }
}

