/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl.test;

import com.hp.hpl.jena.ontology.daml.DAMLClass;
import com.hp.hpl.jena.ontology.daml.DAMLList;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.impl.test.DAMLTestBase;
import com.hp.hpl.jena.rdf.model.RDFNode;
import junit.framework.TestSuite;

public class TestDAMLList
extends DAMLTestBase {
    public static TestSuite suite() {
        return new TestDAMLList("TestDAMLList");
    }

    public TestDAMLList(String string) {
        super(string);
    }

    public DAMLTestBase.OntTestCase[] getTests() {
        return new DAMLTestBase.OntTestCase[]{new DAMLTestBase.OntTestCase("DAMLList.getAll"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass3 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList dAMLList = dAMLModel.createDAMLList(new RDFNode[]{dAMLClass, dAMLClass2, dAMLClass3});
                this.iteratorTest(dAMLList.getAll(), new Object[]{dAMLClass, dAMLClass2, dAMLClass3});
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.getFirst"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass3 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList dAMLList = dAMLModel.createDAMLList(new RDFNode[]{dAMLClass, dAMLClass2, dAMLClass3});
                2.assertEquals("DAMLList.getFirst()", dAMLClass, dAMLList.getFirst());
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.cons"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass3 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList dAMLList = dAMLModel.createDAMLList(new RDFNode[]{dAMLClass2, dAMLClass3});
                DAMLList dAMLList2 = dAMLList.cons(dAMLClass);
                this.iteratorTest(dAMLList2.getAll(), new Object[]{dAMLClass, dAMLClass2, dAMLClass3});
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.getRest"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass3 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList dAMLList = dAMLModel.createDAMLList(new RDFNode[]{dAMLClass, dAMLClass2, dAMLClass3});
                this.iteratorTest(dAMLList.getRest().getAll(), new Object[]{dAMLClass2, dAMLClass3});
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.getCount"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass3 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList dAMLList = dAMLModel.createDAMLList(new RDFNode[]{dAMLClass, dAMLClass2, dAMLClass3});
                5.assertEquals("count", 3, dAMLList.getCount());
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.setFirst"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass3 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList dAMLList = dAMLModel.createDAMLList(new RDFNode[]{dAMLClass2, dAMLClass2, dAMLClass3});
                dAMLList.setFirst(dAMLClass);
                this.iteratorTest(dAMLList.getAll(), new Object[]{dAMLClass, dAMLClass2, dAMLClass3});
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.setRest"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass3 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList dAMLList = dAMLModel.createDAMLList(new RDFNode[]{dAMLClass});
                DAMLList dAMLList2 = dAMLModel.createDAMLList(new RDFNode[]{dAMLClass2, dAMLClass3});
                dAMLList.setRest(dAMLList2);
                this.iteratorTest(dAMLList.getAll(), new Object[]{dAMLClass, dAMLClass2, dAMLClass3});
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.setRestNil"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass3 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList dAMLList = dAMLModel.createDAMLList(new RDFNode[]{dAMLClass, dAMLClass2, dAMLClass3});
                dAMLList.getRest().setRestNil();
                this.iteratorTest(dAMLList.getAll(), new Object[]{dAMLClass, dAMLClass2});
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.nil"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLList dAMLList = dAMLModel.createDAMLList();
                9.assertTrue("nil is nil", dAMLList.isNil(dAMLList.getNil()));
                9.assertFalse("A is not nil", dAMLList.isNil(dAMLClass));
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.findLast"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass3 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList dAMLList = dAMLModel.createDAMLList(new RDFNode[]{dAMLClass, dAMLClass2, dAMLClass3});
                this.iteratorTest(dAMLList.findLast().getAll(), new Object[]{dAMLClass3});
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.getItem"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass3 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList dAMLList = dAMLModel.createDAMLList(new RDFNode[]{dAMLClass, dAMLClass2, dAMLClass3});
                11.assertEquals("A", dAMLClass, dAMLList.getItem(0));
                11.assertEquals("B", dAMLClass2, dAMLList.getItem(1));
                11.assertEquals("C", dAMLClass3, dAMLList.getItem(2));
            }
        }};
    }
}

