/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl.test;

import com.hp.hpl.jena.ontology.daml.DAMLClass;
import com.hp.hpl.jena.ontology.daml.DAMLInstance;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.DAMLObjectProperty;
import com.hp.hpl.jena.ontology.daml.DAMLRestriction;
import com.hp.hpl.jena.ontology.daml.impl.test.DAMLTestBase;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import junit.framework.TestSuite;

public class TestDAMLClass
extends DAMLTestBase {
    public static TestSuite suite() {
        return new TestDAMLClass("TestDAMLClass");
    }

    public TestDAMLClass(String string) {
        super(string);
    }

    public DAMLTestBase.OntTestCase[] getTests() {
        return new DAMLTestBase.OntTestCase[]{new DAMLTestBase.OntTestCase("DAMLClass.prop_subClassOf"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass3 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                1.assertEquals("prop_subClassOf property", DAML_OIL.subClassOf, dAMLClass.prop_subClassOf().getProperty());
                1.assertEquals("sub-class cardinality", 0, dAMLClass.prop_subClassOf().count());
                dAMLClass.prop_subClassOf().add(dAMLClass2);
                this.iteratorTest(dAMLClass.prop_subClassOf().getAll(), new Object[]{dAMLClass, dAMLClass2});
                1.assertEquals("sub-class cardinality", 2, dAMLClass.prop_subClassOf().count());
                dAMLClass.prop_subClassOf().add(dAMLClass3);
                1.assertEquals("sub-class cardinality", 3, dAMLClass.prop_subClassOf().count());
                this.iteratorTest(dAMLClass.prop_subClassOf().getAll(), new Object[]{dAMLClass, dAMLClass2, dAMLClass3});
                dAMLClass.prop_subClassOf().remove(dAMLClass3);
                1.assertEquals("sub-class cardinality", 2, dAMLClass.prop_subClassOf().count());
                this.iteratorTest(dAMLClass.prop_subClassOf().getAll(), new Object[]{dAMLClass, dAMLClass2});
                1.assertTrue("hasValue", dAMLClass.prop_subClassOf().hasValue(dAMLClass2));
                1.assertTrue("hasValue", !dAMLClass.prop_subClassOf().hasValue(dAMLClass3));
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.prop_disjointWith"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass3 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                2.assertEquals("prop_disjointwith property", DAML_OIL.disjointWith, dAMLClass.prop_disjointWith().getProperty());
                2.assertEquals("disjointWith cardinality", 0, dAMLClass.prop_disjointWith().count());
                dAMLClass.prop_disjointWith().add(dAMLClass2);
                2.assertEquals("disjointwith cardinality", 1, dAMLClass.prop_disjointWith().count());
                dAMLClass.prop_disjointWith().add(dAMLClass3);
                2.assertEquals("disjointWith cardinality", 2, dAMLClass.prop_disjointWith().count());
                this.iteratorTest(dAMLClass.prop_disjointWith().getAll(), new Object[]{dAMLClass2, dAMLClass3});
                dAMLClass.prop_disjointWith().remove(dAMLClass3);
                2.assertEquals("disjointwith cardinality", 1, dAMLClass.prop_disjointWith().count());
                this.iteratorTest(dAMLClass.prop_disjointWith().getAll(), new Object[]{dAMLClass2});
                2.assertTrue("hasValue", dAMLClass.prop_disjointWith().hasValue(dAMLClass2));
                2.assertTrue("hasValue", !dAMLClass.prop_disjointWith().hasValue(dAMLClass3));
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.prop_sameClassAs"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass3 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                3.assertEquals("prop_sameClassAs property", DAML_OIL.sameClassAs, dAMLClass.prop_sameClassAs().getProperty());
                3.assertEquals("sameClassAs cardinality", 0, dAMLClass.prop_sameClassAs().count());
                dAMLClass.prop_sameClassAs().add(dAMLClass2);
                3.assertEquals("sameClassAs cardinality", 1, dAMLClass.prop_sameClassAs().count());
                dAMLClass.prop_sameClassAs().add(dAMLClass3);
                3.assertEquals("sameClassAs cardinality", 2, dAMLClass.prop_sameClassAs().count());
                this.iteratorTest(dAMLClass.prop_sameClassAs().getAll(), new Object[]{dAMLClass2, dAMLClass3});
                dAMLClass.prop_sameClassAs().remove(dAMLClass3);
                3.assertEquals("sameClassAs cardinality", 1, dAMLClass.prop_sameClassAs().count());
                this.iteratorTest(dAMLClass.prop_sameClassAs().getAll(), new Object[]{dAMLClass2});
                3.assertTrue("hasValue", dAMLClass.prop_sameClassAs().hasValue(dAMLClass2));
                3.assertTrue("hasValue", !dAMLClass.prop_sameClassAs().hasValue(dAMLClass3));
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.prop_complementOf"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass3 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                4.assertEquals("prop_complementOf property", DAML_OIL.complementOf, dAMLClass.prop_complementOf().getProperty());
                4.assertEquals("complementOf cardinality", 0, dAMLClass.prop_complementOf().count());
                dAMLClass.prop_complementOf().add(dAMLClass2);
                4.assertEquals("complementOf cardinality", 1, dAMLClass.prop_complementOf().count());
                dAMLClass.prop_complementOf().add(dAMLClass3);
                4.assertEquals("complementOf cardinality", 2, dAMLClass.prop_complementOf().count());
                this.iteratorTest(dAMLClass.prop_complementOf().getAll(), new Object[]{dAMLClass2, dAMLClass3});
                dAMLClass.prop_complementOf().remove(dAMLClass3);
                4.assertEquals("complementOf cardinality", 1, dAMLClass.prop_complementOf().count());
                this.iteratorTest(dAMLClass.prop_complementOf().getAll(), new Object[]{dAMLClass2});
                4.assertTrue("hasValue", dAMLClass.prop_complementOf().hasValue(dAMLClass2));
                4.assertTrue("hasValue", !dAMLClass.prop_complementOf().hasValue(dAMLClass3));
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.getSubClasses"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass3 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                dAMLClass3.prop_subClassOf().add(dAMLClass2);
                dAMLClass2.prop_subClassOf().add(dAMLClass);
                5.assertEquals("subClassOf A", dAMLClass2, dAMLClass.getSubClass());
                this.iteratorTest(dAMLClass.getSubClasses(), new Object[]{dAMLClass2, dAMLClass3});
                this.iteratorTest(dAMLClass.getSubClasses(false), new Object[]{dAMLClass2});
                this.iteratorTest(dAMLClass.getSubClasses(true), new Object[]{dAMLClass2, dAMLClass3});
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.getSuperClasses"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass3 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                dAMLClass.prop_subClassOf().add(dAMLClass2);
                dAMLClass2.prop_subClassOf().add(dAMLClass3);
                6.assertEquals("subClassOf A", dAMLClass2, dAMLClass.getSuperClass());
                this.iteratorTest(dAMLClass.getSuperClasses(), new Object[]{dAMLClass2, dAMLClass3});
                this.iteratorTest(dAMLClass.getSuperClasses(false), new Object[]{dAMLClass2});
                this.iteratorTest(dAMLClass.getSuperClasses(true), new Object[]{dAMLClass2, dAMLClass3});
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.getSameClasses"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass3 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                dAMLClass.prop_sameClassAs().add(dAMLClass2);
                dAMLClass2.prop_sameClassAs().add(dAMLClass3);
                this.iteratorTest(dAMLClass.getSameClasses(), new Object[]{dAMLClass2});
                dAMLClass.prop_sameClassAs().add(dAMLClass3);
                this.iteratorTest(dAMLClass.getSameClasses(), new Object[]{dAMLClass2, dAMLClass3});
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.getInstances"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLInstance dAMLInstance = dAMLModel.createDAMLInstance(dAMLClass, "http://jena.hpl.hp.com/testing/ontology#a");
                DAMLInstance dAMLInstance2 = dAMLModel.createDAMLInstance(dAMLClass, "http://jena.hpl.hp.com/testing/ontology#b");
                DAMLInstance dAMLInstance3 = dAMLModel.createDAMLInstance(dAMLClass, "http://jena.hpl.hp.com/testing/ontology#c");
                this.iteratorTest(dAMLClass.getInstances(), new Object[]{dAMLInstance, dAMLInstance2, dAMLInstance3});
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.disjointUnionOf"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass3 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLClass dAMLClass4 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#D");
                9.assertEquals("prop_disjointUnionOf property", DAML_OIL.disjointUnionOf, dAMLClass.prop_disjointUnionOf().getProperty());
                9.assertEquals("disjointUnionOf cardinality", 0, dAMLClass.prop_disjointUnionOf().count());
                dAMLClass.prop_disjointUnionOf().add(dAMLModel.createDAMLList(new RDFNode[]{dAMLClass2, dAMLClass3}));
                9.assertEquals("disjointUnionOf cardinality", 1, dAMLClass.prop_disjointUnionOf().count());
                this.iteratorTest(dAMLClass.prop_disjointUnionOf().getList().getAll(), new Object[]{dAMLClass2, dAMLClass3});
                dAMLClass.prop_disjointUnionOf().getList().add(dAMLClass4);
                this.iteratorTest(dAMLClass.prop_disjointUnionOf().getList().getAll(), new Object[]{dAMLClass2, dAMLClass3, dAMLClass4});
                9.assertTrue("contains", dAMLClass.prop_disjointUnionOf().getList().contains(dAMLClass4));
                9.assertTrue("contains", dAMLClass.prop_disjointUnionOf().getList().contains(dAMLClass2));
                9.assertTrue("contains", dAMLClass.prop_disjointUnionOf().getList().contains(dAMLClass3));
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.unionOf"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass3 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLClass dAMLClass4 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#D");
                10.assertEquals("prop_unionOf property", DAML_OIL.unionOf, dAMLClass.prop_unionOf().getProperty());
                10.assertEquals("unionOf cardinality", 0, dAMLClass.prop_unionOf().count());
                dAMLClass.prop_unionOf().add(dAMLModel.createDAMLList(new RDFNode[]{dAMLClass2, dAMLClass3}));
                10.assertEquals("unionOf cardinality", 1, dAMLClass.prop_unionOf().count());
                this.iteratorTest(dAMLClass.prop_unionOf().getList().getAll(), new Object[]{dAMLClass2, dAMLClass3});
                dAMLClass.prop_unionOf().getList().add(dAMLClass4);
                this.iteratorTest(dAMLClass.prop_unionOf().getList().getAll(), new Object[]{dAMLClass2, dAMLClass3, dAMLClass4});
                10.assertTrue("contains", dAMLClass.prop_unionOf().getList().contains(dAMLClass4));
                10.assertTrue("contains", dAMLClass.prop_unionOf().getList().contains(dAMLClass2));
                10.assertTrue("contains", dAMLClass.prop_unionOf().getList().contains(dAMLClass3));
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.intersectionOf"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass3 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLClass dAMLClass4 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#D");
                11.assertEquals("prop_intersectionOf property", DAML_OIL.intersectionOf, dAMLClass.prop_intersectionOf().getProperty());
                11.assertEquals("intersectionOf cardinality", 0, dAMLClass.prop_intersectionOf().count());
                dAMLClass.prop_intersectionOf().add(dAMLModel.createDAMLList(new RDFNode[]{dAMLClass2, dAMLClass3}));
                11.assertEquals("intersectionOf cardinality", 1, dAMLClass.prop_intersectionOf().count());
                this.iteratorTest(dAMLClass.prop_intersectionOf().getList().getAll(), new Object[]{dAMLClass2, dAMLClass3});
                dAMLClass.prop_intersectionOf().getList().add(dAMLClass4);
                this.iteratorTest(dAMLClass.prop_intersectionOf().getList().getAll(), new Object[]{dAMLClass2, dAMLClass3, dAMLClass4});
                11.assertTrue("contains", dAMLClass.prop_intersectionOf().getList().contains(dAMLClass4));
                11.assertTrue("contains", dAMLClass.prop_intersectionOf().getList().contains(dAMLClass2));
                11.assertTrue("contains", dAMLClass.prop_intersectionOf().getList().contains(dAMLClass3));
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.oneOf"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass dAMLClass3 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLClass dAMLClass4 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#D");
                12.assertEquals("prop_oneOf property", DAML_OIL.oneOf, dAMLClass.prop_oneOf().getProperty());
                12.assertEquals("oneOf cardinality", 0, dAMLClass.prop_oneOf().count());
                dAMLClass.prop_oneOf().add(dAMLModel.createDAMLList(new RDFNode[]{dAMLClass2, dAMLClass3}));
                12.assertEquals("oneOf cardinality", 1, dAMLClass.prop_oneOf().count());
                this.iteratorTest(dAMLClass.prop_oneOf().getList().getAll(), new Object[]{dAMLClass2, dAMLClass3});
                dAMLClass.prop_oneOf().getList().add(dAMLClass4);
                this.iteratorTest(dAMLClass.prop_oneOf().getList().getAll(), new Object[]{dAMLClass2, dAMLClass3, dAMLClass4});
                12.assertTrue("contains", dAMLClass.prop_oneOf().getList().contains(dAMLClass4));
                12.assertTrue("contains", dAMLClass.prop_oneOf().getList().contains(dAMLClass2));
                12.assertTrue("contains", dAMLClass.prop_oneOf().getList().contains(dAMLClass3));
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.getDefinedProperties"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass dAMLClass2 = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                dAMLClass2.prop_subClassOf().add(dAMLClass);
                DAMLObjectProperty dAMLObjectProperty = dAMLModel.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLObjectProperty dAMLObjectProperty2 = dAMLModel.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                DAMLObjectProperty dAMLObjectProperty3 = dAMLModel.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
                dAMLObjectProperty.prop_domain().add(dAMLClass2);
                dAMLObjectProperty2.prop_domain().add(dAMLClass2);
                dAMLObjectProperty3.prop_domain().add(dAMLClass);
                this.iteratorTest(dAMLClass.getDefinedProperties(), new Object[]{dAMLObjectProperty3});
                this.iteratorTest(dAMLClass2.getDefinedProperties(), new Object[]{dAMLObjectProperty, dAMLObjectProperty2, dAMLObjectProperty3});
            }
        }, new DAMLTestBase.OntTestCase("DAMLRestriction.prop_onProperty"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLRestriction dAMLRestriction = dAMLModel.createDAMLRestriction("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLObjectProperty dAMLObjectProperty = dAMLModel.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                14.assertEquals("prop_onProperty property", DAML_OIL.onProperty, dAMLRestriction.prop_onProperty().getProperty());
                14.assertEquals("onProperty cardinality", 0, dAMLRestriction.prop_onProperty().count());
                dAMLRestriction.prop_onProperty().add(dAMLObjectProperty);
                14.assertEquals("onProperty cardinality", 1, dAMLRestriction.prop_onProperty().count());
                this.iteratorTest(dAMLRestriction.prop_onProperty().getAll(), new Object[]{dAMLObjectProperty});
            }
        }, new DAMLTestBase.OntTestCase("DAMLRestriction.prop_toClass"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLRestriction dAMLRestriction = dAMLModel.createDAMLRestriction("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                15.assertEquals("prop_toClass property", DAML_OIL.toClass, dAMLRestriction.prop_toClass().getProperty());
                15.assertEquals("toClass cardinality", 0, dAMLRestriction.prop_toClass().count());
                dAMLRestriction.prop_toClass().add(dAMLClass);
                15.assertEquals("toClass cardinality", 1, dAMLRestriction.prop_toClass().count());
                this.iteratorTest(dAMLRestriction.prop_toClass().getAll(), new Object[]{dAMLClass});
            }
        }, new DAMLTestBase.OntTestCase("DAMLRestriction.prop_hasClass"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLRestriction dAMLRestriction = dAMLModel.createDAMLRestriction("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass dAMLClass = dAMLModel.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                16.assertEquals("prop_hasClass property", DAML_OIL.hasClass, dAMLRestriction.prop_hasClass().getProperty());
                16.assertEquals("hasClass cardinality", 0, dAMLRestriction.prop_hasClass().count());
                dAMLRestriction.prop_hasClass().add(dAMLClass);
                16.assertEquals("hasClass cardinality", 1, dAMLRestriction.prop_hasClass().count());
                this.iteratorTest(dAMLRestriction.prop_hasClass().getAll(), new Object[]{dAMLClass});
            }
        }, new DAMLTestBase.OntTestCase("DAMLRestriction.prop_cardinality"){

            public void doTest(DAMLModel dAMLModel) throws Exception {
                DAMLRestriction dAMLRestriction = dAMLModel.createDAMLRestriction("http://jena.hpl.hp.com/testing/ontology#A");
                17.assertEquals("prop_cardinality property", DAML_OIL.cardinality, dAMLRestriction.prop_cardinality().getProperty());
                17.assertEquals("cardinality cardinality", 0, dAMLRestriction.prop_cardinality().count());
                dAMLRestriction.prop_cardinality().addInt(1);
                17.assertEquals("cardinality cardinality", 1, dAMLRestriction.prop_cardinality().count());
                17.assertEquals("cardinality", 1, dAMLRestriction.prop_cardinality().getInt());
            }
        }};
    }
}

