/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3.test;

import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.n3.N3JenaReader;
import com.hp.hpl.jena.n3.test.N3ExternalTestsCom;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.util.ModelLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import junit.framework.TestCase;

public class N3JenaReaderTests
extends N3ExternalTestsCom {
    public static boolean VERBOSE = false;
    static final String NL = System.getProperty("line.separator", "\n");

    public N3JenaReaderTests() {
        this("n3-reader-tests");
    }

    public N3JenaReaderTests(String string) {
        super("N3 Jena Reader tests", string);
    }

    protected void makeTest(String string, String string2) {
        String string3 = string;
        if (this.basedir != null) {
            string = this.basedir + "/" + string;
        }
        if (this.basedir != null && string2 != null && !string2.equals("")) {
            string2 = this.basedir + "/" + string2;
        }
        this.addTest(new Test(string3, string, string2));
    }

    private static void print(Writer writer, String string) {
        try {
            writer.write(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void println(Writer writer, String string) {
        try {
            writer.write(string);
            writer.write(NL);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void println(Writer writer) {
        try {
            writer.write(NL);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void flush(Writer writer) {
        try {
            writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static class Test
    extends TestCase {
        RDFReader reader = null;
        String basename = null;
        String n3File = null;
        String resultsFile = null;
        Model dModel = null;
        Model rModel = null;
        Reader rData = null;

        Test(String string, String string2, String string3) {
            super("N3 Jena Reader test: " + string);
            this.n3File = string2;
            this.resultsFile = string3;
            try {
                this.rData = N3ExternalTestsCom.makeReader(new FileInputStream(this.n3File));
                this.dModel = new ModelMem();
                if (this.resultsFile != null && !this.resultsFile.equals("")) {
                    this.rModel = ModelLoader.loadModel(this.resultsFile, null);
                    if (this.rModel == null) {
                        System.err.println("Failed to find results file " + this.resultsFile);
                    }
                }
                this.reader = new N3JenaReader();
                int n = this.n3File.lastIndexOf(File.pathSeparatorChar);
                if (n == -1) {
                    n = this.n3File.lastIndexOf(47);
                }
                String string4 = this.n3File.substring(n + 1);
                this.basename = "file:///base/" + string4;
            }
            catch (IOException iOException) {
                System.err.println("IO Exception: " + iOException);
            }
        }

        protected void runTest() throws Throwable {
            Writer writer;
            this.reader.read(this.dModel, this.rData, this.basename);
            if (VERBOSE) {
                writer = N3ExternalTestsCom.makeWriter(System.out);
                BufferedReader bufferedReader = N3ExternalTestsCom.makeReader(new FileInputStream(this.n3File));
                N3JenaReaderTests.println(writer, "+++++++ " + this.getName());
                String string = bufferedReader.readLine();
                while (string != null) {
                    N3JenaReaderTests.println(writer, string);
                    string = bufferedReader.readLine();
                }
                N3JenaReaderTests.println(writer, "+++++++");
                this.dModel.write(writer, "N-TRIPLE");
                N3JenaReaderTests.println(writer, "+++++++");
                N3JenaReaderTests.flush(writer);
            }
            if (this.rModel != null && !this.dModel.isIsomorphicWith(this.rModel)) {
                writer = N3ExternalTestsCom.makeWriter(System.out);
                N3JenaReaderTests.println(writer, "+++++++ " + super.getName());
                N3JenaReaderTests.println(writer, "---- Created");
                this.dModel.write(writer, "N-TRIPLE");
                N3JenaReaderTests.println(writer, "---- Expected ");
                this.rModel.write(writer, "N-TRIPLE");
                N3JenaReaderTests.println(writer, "+++++++" + super.getName());
                N3JenaReaderTests.flush(writer);
                Test.assertTrue("Model compare failed: " + super.getName(), false);
            }
        }
    }
}

