/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3.test;

import com.hp.hpl.jena.n3.N3EventPrinter;
import com.hp.hpl.jena.n3.N3Parser;
import com.hp.hpl.jena.n3.N3ParserEventHandler;
import com.hp.hpl.jena.n3.NullN3EventHandler;
import java.io.PrintWriter;
import java.io.StringReader;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class N3InternalTests
extends TestSuite {
    public static final String QUOTE3 = "\"\"\"";
    public static boolean VERBOSE = false;
    PrintWriter pw = null;

    public static TestSuite suite() {
        return new N3InternalTests();
    }

    N3InternalTests() {
        super("N3 Parser Syntactic tests");
        if (VERBOSE) {
            this.pw = new PrintWriter(System.out);
        }
        this.addTest(new Test("a:subj a:prop a:d ."));
        this.addTest(new Test("a:subj a:prop a:d . "));
        this.addTest(new Test("a:subj a:prop a:d."));
        this.addTest(new Test("a:subj a:prop a:d. "));
        this.addTest(new Test("rdf: rdf:type :_."));
        this.addTest(new Test("@prefix start: <somewhere>."));
        this.addTest(new Test("<http://here/subj> <http://here/prep> <http://here/obj>."));
        this.addTest(new Test("a:subj\ta:prop\ta:d.\t"));
        this.addTest(new Test("       a:subj\ta:prop\ta:d.     "));
        this.addTest(new Test("a:subj a:prop a:d.  "));
        this.addTest(new Test(""));
        this.addTest(new Test(" #Comment"));
        this.addTest(new Test("a:subj a:prop a:d.  # Comment"));
        this.addTest(new Test("a:subj a:prop a:d.# Comment"));
        this.addTest(new Test("a:subj a:prop 'string1'."));
        this.addTest(new Test("a:subj a:prop \"string2\"."));
        this.addTest(new Test("a:subj a:prop '''string3'''."));
        this.addTest(new Test("a:subj a:prop \"\"\"string3\"\"\"."));
        this.addTest(new Test("a:subj a:prop 'string1'^^x:dt."));
        this.addTest(new Test("a:subj a:prop 'string1'^^<uriref>."));
        this.addTest(new Test("a: :p 2."));
        this.addTest(new Test("a: :p +2."));
        this.addTest(new Test("a: :p -2 ."));
        this.addTest(new Test("a: :p 2e6."));
        this.addTest(new Test("a: :p 2e-6."));
        this.addTest(new Test("a: :p -2e-6."));
        this.addTest(new Test("a: :p 2.0e-6."));
        this.addTest(new Test("a: :p 2.0."));
        this.addTest(new Test("a: _: 2:."));
        this.addTest(new Test("2.9 9:p 2.0."));
        this.addTest(new Test("_:a :2 :_2 ."));
        this.addTest(new Test("2.0 :p 2.0."));
        this.addTest(new Test("a:subj 'prop'^^<uriref> 'string'."));
        this.addTest(new Test("a:subj a:prop 'string1'^^'stringDT'."));
        this.addTest(new Test("a:subj a:prop1 ?x ^^ x:dt."));
        this.addTest(new Test("a:subj a:prop2 ?x ^^ ?x."));
        this.addTest(new Test("a:subj a:prop \"\\'string2\\'\"."));
        this.addTest(new Test("a:subj a:prop \"\\\"string2\\\"\"."));
        this.addTest(new Test("a:subj a:prop '\\'string1\\''."));
        this.addTest(new Test("a:subj a:prop '\\\"string1\\\"'."));
        this.addTest(new Test("a:q21 a:prop \"\"\"start\"finish\"\"\"."));
        this.addTest(new Test("a:q22 a:prop \"\"\"start\"\"finish\"\"\"."));
        this.addTest(new Test("a:q2e3 a:prop \"\"\"start\\\"\\\"\\\"finish\"\"\"."));
        this.addTest(new Test("a:q13 a:prop \"\"\"start'''finish\"\"\"."));
        this.addTest(new Test("a:q11 a:prop '''start'finish'''."));
        this.addTest(new Test("a:q12 a:prop '''start''finish'''."));
        this.addTest(new Test("a:q12 a:prop '''start\\'\\'\\'finish'''."));
        this.addTest(new Test("a:q23 a:prop '''start\"\"\"finish'''."));
        this.addTest(new Test("this a:prop x:y ."));
        this.addTest(new Test("a:subj  a   x:y ."));
        this.addTest(new Test("a:subj  =   x:y ."));
        this.addTest(new Test("a:subj  =>  x:y ."));
        this.addTest(new Test("a:subj  <=  x:y ."));
        this.addTest(new Test("a:subj  >- x:y -> 'value' ."));
        this.addTest(new Test("a:subj  >- x:y -> 'value1', 'value2' ."));
        this.addTest(new Test("a:subj <a>  x:y ."));
        this.addTest(new Test("<this>  a   x:y ."));
        this.addTest(new Test("@prefix has: <uri>."));
        this.addTest(new Test("has:s a:a :of."));
        this.addTest(new Test("<>   has a:prop  x:y ."));
        this.addTest(new Test("x:v  is a:prop of  <>."));
        this.addTest(new Test("x:v  is a:prop of  a:s1, a:s2."));
        this.addTest(new Test("<>   a:prop  x:y ."));
        this.addTest(new Test("<#>  a:prop  x:y ."));
        this.addTest(new Test("a:subj a:prop a:d, a:e."));
        this.addTest(new Test("a:subj a:prop a:d, '123'."));
        this.addTest(new Test("a:subj a:prop '123', a:e."));
        this.addTest(new Test("a:subj a:p1 a:v1 ;  a:p2 a:v2 ."));
        this.addTest(new Test("a:subj a:p1 a:v1, a:v2 ;  a:p2 a:v2 ; a:p3 'v4' ,'v5' ."));
        this.addTest(new Test("[a:prop a:val]."));
        this.addTest(new Test("[] a:prop a:val."));
        this.addTest(new Test("[] a:prop []."));
        this.addTest(new Test("{:x :y :z} => {:x :y :z}."));
        this.addTest(new Test("{:x :y :z} => {:x :y :z . }."));
        this.addTest(new Test("{:x :y :z. } => {:x :y :z}."));
        this.addTest(new Test("?who ?knows ?what ."));
        this.addTest(new Test("{?who ?knows ?what} => {'somesort' 'of' 'logic'}."));
        this.addTest(new Test("{ this a \"string2\". } => { this a 'string1'} ."));
        this.addTest(new Test("{ @prefix : <a> } => { this a 'string1'} ."));
        this.addTest(new Test("{ @prefix : <a> . a:x <b> 'c'} => { this a 'string1'} ."));
        this.addTest(new Test("() ."));
        this.addTest(new Test("<here> <list> ()."));
        this.addTest(new Test(" ( a:i1 a:i2 a:i3 ) a daml:list."));
        this.addTest(new Test(":x!:y <prop> []."));
        this.addTest(new Test(":x!:y!:z <prop> []."));
        this.addTest(new Test(":x^:y <prop> []."));
        this.addTest(new Test(":x^:y^:z <prop> []."));
        this.addTest(new Test("[] <prop> :x!:y^:z."));
        this.addTest(new Test("[] :x^:y!:z []."));
        this.addTest(new Test(":x.:y <prop> []."));
        this.addTest(new Test(":x.:y.:z <prop> []."));
        this.addTest(new Test("[] <prop> :a.:c."));
        this.addTest(new Test("<thing>.:y  <prop> []."));
        this.addTest(new Test("x:x.<thing>.:y  <prop> []."));
        this.addTest(new Test("<thing>.:y^:z  <prop> []."));
        this.addTest(new Test(":y.<thing>.:z  <prop> []."));
        this.addTest(new Test("<thing> :px.:py.:pz [] . "));
        this.addTest(new Test("<thing> :px!:py!:pz [] . "));
        this.addTest(new Test("{ :a.:b.:c . }."));
        this.addTest(new Test("{ :a.:b.<c>.}."));
        this.addTest(new Test("_:anon :- [a:p a:v] ."));
        this.addTest(new Test("<uri> :- [a:p [ a:p a:v] ] ."));
        this.addTest(new Test("_:anon :- (\"1\") ."));
        this.addTest(new Test("_:anon :- { ?a ?b ?c } ."));
        this.addTest(new Test("a:subj a:prop '123'^^xsd:integer ."));
        this.addTest(new Test("a:subj a:prop '123'^^<uri> ."));
        this.addTest(new Test("a:subj a:prop '<tag>text</tag>'^^rdf:XMLLiteral ."));
        this.addTest(new Test("a:subj a:prop 'text'@en ."));
        this.addTest(new Test("a:subj a:prop 'text'^^a:lang@en ."));
        this.addTest(new Test("a:subj a:prop 'text'@en^^a:lang ."));
        this.addTest(new Test("a:subj a:prop '<tag>text</tag>'@fr^^rdf:XMLLiteral ."));
        this.addTest(new Test("a:subj a:prop '<tag>text</tag>'^^rdf:XMLLiteral@fr ."));
        this.addTest(new Test("a:subj a:prop ?x^^xsd:integer ."));
        this.addTest(new Test("a:subj a:prop '123'^^?x ."));
        this.addTest(new Test("a:subj a:prop ?x^^?y ."));
    }

    class Test
    extends TestCase {
        N3ParserEventHandler handler;
        String testString;

        Test(String string) {
            super("N3 Internal test: " + (string != null ? string.replace(',', '_') : "<skipped test>"));
            this.testString = string;
            this.handler = VERBOSE ? new N3EventPrinter(N3InternalTests.this.pw) : new NullN3EventHandler();
        }

        protected void runTest() throws Throwable {
            if (this.testString == null) {
                if (N3InternalTests.this.pw != null) {
                    N3InternalTests.this.pw.println("Skipped test");
                }
                return;
            }
            if (N3InternalTests.this.pw != null) {
                N3InternalTests.this.pw.println("Input: " + this.testString);
            }
            N3Parser n3Parser = new N3Parser(new StringReader(this.testString), this.handler);
            n3Parser.parse();
            if (N3InternalTests.this.pw != null) {
                N3InternalTests.this.pw.println();
                N3InternalTests.this.pw.flush();
            }
        }
    }
}

