/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3;

import com.hp.hpl.jena.n3.IndentedWriter;
import com.hp.hpl.jena.n3.N3JenaWriter;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.XSD;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class N3JenaWriterCommon
implements RDFWriter {
    static Logger logger = Logger.getLogger((class$com$hp$hpl$jena$n3$N3JenaWriterCommon == null ? (class$com$hp$hpl$jena$n3$N3JenaWriterCommon = N3JenaWriterCommon.class$("com.hp.hpl.jena.n3.N3JenaWriterCommon")) : class$com$hp$hpl$jena$n3$N3JenaWriterCommon).getName());
    static final boolean doAbbreviatedBaseURIref = true;
    boolean alwaysAllocateBNodeLabel = false;
    RDFErrorHandler errorHandler = null;
    Map writerPropertyMap = new HashMap();
    static final String NS_W3_log = "http://www.w3.org/2000/10/swap/log#";
    Map prefixMap = new HashMap();
    Map bNodesMap = null;
    int bNodeCounter = 0;
    static Map wellKnownPropsMap = new HashMap();
    IndentedWriter out = null;
    String baseURIref = null;
    String baseURIrefHash = null;
    static int minGap;
    static final String minGapStr;
    static int indentProperty;
    static int widePropertyLen;
    static int propertyCol;
    static int propertyWidth;
    static int indentObject;
    static int subjectColumn;
    static int shortSubject;
    static /* synthetic */ Class class$com$hp$hpl$jena$n3$N3JenaWriterCommon;

    public RDFErrorHandler setErrorHandler(RDFErrorHandler rDFErrorHandler) {
        RDFErrorHandler rDFErrorHandler2 = this.errorHandler;
        this.errorHandler = rDFErrorHandler;
        return rDFErrorHandler2;
    }

    public Object setProperty(String string, Object object) {
        Object v = this.writerPropertyMap.get(string);
        this.writerPropertyMap.put(string, object);
        return v;
    }

    public void write(Model model, Writer writer, String string) {
        if (!(writer instanceof BufferedWriter)) {
            writer = new BufferedWriter(writer);
        }
        this.out = new IndentedWriter(writer);
        if (string != null) {
            this.baseURIref = string;
            if (!string.endsWith("#")) {
                this.baseURIrefHash = this.baseURIref + "#";
            }
        }
        this.processModel(model);
    }

    public synchronized void write(Model model, OutputStream outputStream, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            this.write(model, bufferedWriter, string);
            try {
                ((Writer)bufferedWriter).flush();
            }
            catch (IOException iOException) {}
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("Failed to create UTF-8 writer");
        }
    }

    protected void startWriting() {
    }

    protected void finishWriting() {
    }

    protected void prepare(Model model) {
    }

    protected void processModel(Model model) {
        this.prefixMap = model.getNsPrefixMap();
        Model model2 = ModelFactory.withHiddenStatements(model);
        this.bNodesMap = new HashMap();
        String string = (String)this.prefixMap.get("");
        if (string == null && this.baseURIrefHash != null) {
            this.prefixMap.put("", this.baseURIrefHash);
        }
        Iterator iterator = this.prefixMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.indexOf(46) == -1) continue;
            iterator.remove();
        }
        this.startWriting();
        this.prepare(model2);
        this.writeHeader(model2);
        this.writePrefixes(model2);
        if (this.prefixMap.size() != 0) {
            this.out.println();
        }
        this.writeModel(model2);
        this.finishWriting();
        this.bNodesMap = null;
    }

    protected void writeModel(Model model) {
        boolean bl = true;
        ResIterator resIterator = model.listSubjects();
        while (resIterator.hasNext()) {
            Resource resource = resIterator.nextResource();
            if (this.skipThisSubject(resource)) {
                if (!N3JenaWriter.DEBUG) continue;
                this.out.println("# Skipping: " + this.formatResource(resource));
                continue;
            }
            if (bl) {
                bl = false;
            } else {
                this.out.println();
            }
            this.writeOneGraphNode(resource);
        }
        resIterator.close();
    }

    protected void writeOneGraphNode(Resource resource) {
        this.out.incIndent(indentProperty);
        this.writeSubject(resource);
        this.writePropertiesForSubject(resource);
        this.out.decIndent(indentProperty);
        this.out.println(" .");
    }

    protected void writePropertiesForSubject(Resource resource) {
        ClosableIterator closableIterator = this.preparePropertiesForSubject(resource);
        while (closableIterator.hasNext()) {
            Property property = (Property)closableIterator.next();
            this.writeObjectList(resource, property);
            if (!closableIterator.hasNext()) continue;
            this.out.println(" ;");
        }
        closableIterator.close();
    }

    protected boolean skipThisSubject(Resource resource) {
        return false;
    }

    protected void writeSubject(Resource resource) {
        String string = this.formatResource(resource);
        this.out.print(string);
        if (string.length() < shortSubject) {
            this.out.print(N3JenaWriterCommon.pad(subjectColumn - string.length()));
        } else {
            this.out.println();
        }
    }

    protected void writeHeader(Model model) {
        if (this.baseURIref != null) {
            this.out.println("# Base: " + this.baseURIref);
        }
    }

    protected void writePrefixes(Model model) {
        Iterator iterator = this.prefixMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.prefixMap.get(string);
            if (string.equals("")) {
                if (string2.equals(this.baseURIrefHash)) {
                    string2 = "#";
                }
                if (string2.equals(this.baseURIref)) {
                    string2 = "";
                }
            }
            String string3 = "@prefix " + string + ": ";
            this.out.print(string3);
            this.out.print(N3JenaWriterCommon.pad(16 - string3.length()));
            this.out.println(" <" + string2 + "> .");
        }
    }

    protected void writeObjectList(Resource resource, Property property) {
        String string = null;
        string = wellKnownPropsMap.containsKey(property.getURI()) ? (String)wellKnownPropsMap.get(property.getURI()) : this.formatResource(property);
        StmtIterator stmtIterator = resource.listProperties(property);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            String string2 = this.formatNode(statement.getObject());
            this.out.print(string);
            this.out.incIndent(indentObject);
            if (string.length() < widePropertyLen) {
                int n = propertyCol - string.length();
                if (n < minGap) {
                    n = minGap;
                }
                this.out.print(N3JenaWriterCommon.pad(n));
            } else {
                this.out.println();
            }
            this.out.print(string2);
            this.out.decIndent(indentObject);
            if (!stmtIterator.hasNext()) continue;
            this.out.println(" ;");
        }
        stmtIterator.close();
    }

    protected String formatNode(RDFNode rDFNode) {
        if (rDFNode instanceof Literal) {
            return this.formatLiteral((Literal)rDFNode);
        }
        return this.formatResource((Resource)rDFNode);
    }

    protected void writeObject(RDFNode rDFNode) {
        if (rDFNode instanceof Literal) {
            this.writeLiteral((Literal)rDFNode);
            return;
        }
        Resource resource = (Resource)rDFNode;
        this.out.print(this.formatResource(resource));
    }

    protected void writeLiteral(Literal literal) {
        this.out.print(this.formatLiteral(literal));
    }

    protected ClosableIterator preparePropertiesForSubject(Resource resource) {
        HashSet<Property> hashSet = new HashSet<Property>();
        StmtIterator stmtIterator = resource.listProperties();
        while (stmtIterator.hasNext()) {
            hashSet.add(stmtIterator.nextStatement().getPredicate());
        }
        stmtIterator.close();
        return WrappedIterator.create(hashSet.iterator());
    }

    protected String formatResource(Resource resource) {
        if (resource.isAnon()) {
            if (!this.alwaysAllocateBNodeLabel) {
                StmtIterator stmtIterator = resource.getModel().listStatements(null, null, resource);
                if (!stmtIterator.hasNext()) {
                    stmtIterator.close();
                    return "[]";
                }
                stmtIterator.close();
            }
            if (!this.bNodesMap.containsKey(resource)) {
                this.bNodesMap.put(resource, "_:b" + ++this.bNodeCounter);
            }
            return (String)this.bNodesMap.get(resource);
        }
        if (((Object)resource).equals(RDF.nil)) {
            return "()";
        }
        return this.formatURI(resource.getURI());
    }

    protected String formatProperty(Property property) {
        String string = property.getURI();
        if (wellKnownPropsMap.containsKey(string)) {
            return (String)wellKnownPropsMap.get(string);
        }
        return this.formatURI(string);
    }

    protected String formatURI(String string) {
        String string2 = "";
        String string3 = null;
        if (string.equals(this.baseURIref)) {
            return "<>";
        }
        Object object = this.prefixMap.keySet().iterator();
        while (object.hasNext()) {
            String string4 = (String)object.next();
            String string5 = (String)this.prefixMap.get(string4);
            if (!string.startsWith(string5) || string2.length() >= string5.length()) continue;
            string3 = string4;
            string2 = string5;
        }
        if (string3 != null) {
            object = string.substring(string2.length());
            boolean bl = true;
            block4: for (int i = 0; i < ((String)object).length(); ++i) {
                char c = ((String)object).charAt(i);
                switch (c) {
                    case '.': 
                    case ':': 
                    case '=': 
                    case '?': {
                        bl = false;
                        continue block4;
                    }
                }
            }
            if (bl) {
                return string3 + ":" + (String)object;
            }
        }
        return "<" + string + ">";
    }

    protected String formatLiteral(Literal literal) {
        String string = literal.getDatatypeURI();
        String string2 = literal.getLanguage();
        String string3 = literal.getLexicalForm();
        if (string != null) {
            if (string.equals(XSD.integer.getURI())) {
                return string3;
            }
            if (string.equals(XSD.xdouble.getURI())) {
                if (string3.indexOf(46) >= 0) {
                    return string3;
                }
                if (string3.indexOf(101) >= 0) {
                    return string3;
                }
            }
        }
        int n = 0;
        int n2 = -1;
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = "\"";
        if (string3.indexOf("\n") != -1 || string3.indexOf("\r") != -1 || string3.indexOf("\f") != -1) {
            string4 = "\"\"\"";
        }
        stringBuffer.append(string4);
        while (true) {
            if ((n2 = string3.indexOf(34, n)) == -1) break;
            stringBuffer.append(string3.substring(n, n2));
            stringBuffer.append("\\\"");
            n = n2 + 1;
        }
        stringBuffer.append(string3.substring(n));
        stringBuffer.append(string4);
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append("@");
            stringBuffer.append(string2);
        }
        if (string != null) {
            stringBuffer.append("^^");
            stringBuffer.append(this.formatURI(string));
        }
        return stringBuffer.toString();
    }

    protected static String pad(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    protected int countProperties(Resource resource) {
        int n = 0;
        StmtIterator stmtIterator = resource.listProperties();
        while (stmtIterator.hasNext()) {
            stmtIterator.nextStatement();
            ++n;
        }
        stmtIterator.close();
        return n;
    }

    protected int countProperties(Resource resource, Property property) {
        int n = 0;
        StmtIterator stmtIterator = resource.listProperties(property);
        while (stmtIterator.hasNext()) {
            stmtIterator.nextStatement();
            ++n;
        }
        stmtIterator.close();
        return n;
    }

    protected int countArcsTo(Resource resource) {
        return this.countArcsTo(null, resource);
    }

    protected int countArcsTo(Property property, Resource resource) {
        int n = 0;
        StmtIterator stmtIterator = resource.getModel().listStatements(null, property, resource);
        while (stmtIterator.hasNext()) {
            stmtIterator.nextStatement();
            ++n;
        }
        stmtIterator.close();
        return n;
    }

    protected Iterator rdfListIterator(Resource resource) {
        ArrayList<RDFNode> arrayList = new ArrayList<RDFNode>();
        while (!((Object)resource).equals(RDF.nil)) {
            StmtIterator stmtIterator = resource.getModel().listStatements(resource, RDF.first, (RDFNode)null);
            arrayList.add(stmtIterator.nextStatement().getObject());
            if (stmtIterator.hasNext()) {
                throw new JenaException("N3: Multi valued list item");
            }
            stmtIterator = resource.getModel().listStatements(resource, RDF.rest, (RDFNode)null);
            resource = (Resource)stmtIterator.nextStatement().getObject();
            if (!stmtIterator.hasNext()) continue;
            throw new JenaException("N3: List has two tails");
        }
        return arrayList.iterator();
    }

    protected static String getStringValue(String string, String string2) {
        string = "http://jena.hpl.hp.com/n3/properties/" + string;
        String string3 = System.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    protected static boolean getBooleanValue(String string, boolean bl) {
        string = "http://jena.hpl.hp.com/n3/properties/" + string;
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        if (string2.equalsIgnoreCase("true")) {
            return true;
        }
        return string2.equals("1");
    }

    protected static int getIntValue(String string, int n) {
        string = "http://jena.hpl.hp.com/n3/properties/" + string;
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn("Format error for property: " + string);
            return n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        wellKnownPropsMap.put("http://www.w3.org/2000/10/swap/log#implies", "=>");
        wellKnownPropsMap.put(OWL.sameAs.getURI(), "=");
        wellKnownPropsMap.put(RDF.type.getURI(), "a");
        minGap = N3JenaWriterCommon.getIntValue("minGap", 1);
        minGapStr = N3JenaWriterCommon.pad(minGap);
        indentProperty = N3JenaWriterCommon.getIntValue("indentProperty", 6);
        widePropertyLen = N3JenaWriterCommon.getIntValue("widePropertyLen", 20);
        propertyCol = N3JenaWriterCommon.getIntValue("propertyColumn", 8);
        propertyWidth = propertyCol - minGap;
        indentObject = propertyCol;
        subjectColumn = N3JenaWriterCommon.getIntValue("subjectColumn", indentProperty);
        shortSubject = subjectColumn - minGap;
    }
}

