/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.test.JenaTestBase;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class GraphTestBase
extends JenaTestBase {
    private static int counter = 0;
    private static String temp = GraphTestBase.constructTempDirectory();

    public GraphTestBase(String string) {
        super(string);
    }

    public static Node node(String string) {
        return Node.create(string);
    }

    public static Model modelFor(Graph graph) {
        return ModelFactory.createModelForGraph(graph);
    }

    public static Set iteratorToSet(Iterator iterator) {
        return GraphUtil.iteratorToSet(iterator);
    }

    public static List iteratorToList(Iterator iterator) {
        return GraphUtil.iteratorToList(iterator);
    }

    public Set nodeSet(String string) {
        HashSet<Node> hashSet = new HashSet<Node>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(GraphTestBase.node(stringTokenizer.nextToken()));
        }
        return hashSet;
    }

    public static Triple triple(String string) {
        return Triple.create(string);
    }

    public static Triple[] tripleArray(String string) {
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(GraphTestBase.triple(stringTokenizer.nextToken()));
        }
        return arrayList.toArray(new Triple[arrayList.size()]);
    }

    public static Node[] nodes(String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(GraphTestBase.node(stringTokenizer.nextToken()));
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    public static Graph graphAdd(Graph graph, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            graph.add(GraphTestBase.triple(stringTokenizer.nextToken()));
        }
        return graph;
    }

    public static Graph graphWith(String string) {
        return GraphTestBase.graphAdd(new GraphMem(), string);
    }

    public static void assertEqualsTemplate(String string, Graph graph, String string2) {
        GraphTestBase.assertTrue(string, graph.isIsomorphicWith(GraphTestBase.graphWith(string2)));
    }

    public static void assertEquals(String string, Graph graph, Graph graph2) {
        if (!graph.isIsomorphicWith(graph2)) {
            GraphTestBase.fail(string + ": wanted " + graph + " but got " + graph2);
        }
    }

    public static void assertContains(String string, String string2, Graph graph) {
        GraphTestBase.assertTrue(string + " must contain " + string2, graph.contains(GraphTestBase.triple(string2)));
    }

    public static void assertContainsAll(String string, Graph graph, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            GraphTestBase.assertContains(string, stringTokenizer.nextToken(), graph);
        }
    }

    public void assertOmits(String string, Graph graph, String string2) {
        GraphTestBase.assertFalse(string + " must not contain " + string2, graph.contains(GraphTestBase.triple(string2)));
    }

    public void assertOmitsAll(String string, Graph graph, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            this.assertOmits(string, graph, stringTokenizer.nextToken());
        }
    }

    public static boolean contains(Graph graph, String string) {
        return graph.contains(GraphTestBase.triple(string));
    }

    public void testContains(Graph graph, Triple[] tripleArray) {
        for (int i = 0; i < tripleArray.length; ++i) {
            GraphTestBase.assertTrue("contains " + tripleArray[i], graph.contains(tripleArray[i]));
        }
    }

    public void testContains(Graph graph, List list) {
        for (int i = 0; i < list.size(); ++i) {
            GraphTestBase.assertTrue(graph.contains((Triple)list.get(i)));
        }
    }

    public void testContains(Graph graph, Iterator iterator) {
        while (iterator.hasNext()) {
            GraphTestBase.assertTrue(graph.contains((Triple)iterator.next()));
        }
    }

    public void testContains(Graph graph, Graph graph2) {
        this.testContains(graph, GraphUtil.findAll(graph2));
    }

    public void testOmits(Graph graph, Triple[] tripleArray) {
        for (int i = 0; i < tripleArray.length; ++i) {
            GraphTestBase.assertFalse("", graph.contains(tripleArray[i]));
        }
    }

    public void testOmits(Graph graph, List list) {
        for (int i = 0; i < list.size(); ++i) {
            GraphTestBase.assertFalse("", graph.contains((Triple)list.get(i)));
        }
    }

    public void testOmits(Graph graph, Iterator iterator) {
        while (iterator.hasNext()) {
            GraphTestBase.assertFalse("", graph.contains((Triple)iterator.next()));
        }
    }

    public void testOmits(Graph graph, Graph graph2) {
        this.testOmits(graph, GraphUtil.findAll(graph2));
    }

    public static void show(String string, Graph graph) {
        ExtendedIterator extendedIterator = GraphUtil.findAll(graph);
        System.out.println(string);
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            System.out.println("  " + triple.getSubject() + " @" + triple.getPredicate() + " " + triple.getObject());
        }
    }

    public static File tempFileName(String string, String string2) {
        File file = new File(GraphTestBase.getTempDirectory(), string + GraphTestBase.randomNumber() + string2);
        if (file.exists()) {
            return GraphTestBase.tempFileName(string, string2);
        }
        file.deleteOnExit();
        return file;
    }

    private static int randomNumber() {
        return ++counter;
    }

    public static String getTempDirectory() {
        return temp;
    }

    private static String constructTempDirectory() {
        try {
            File file = File.createTempFile("xxx", ".none");
            file.delete();
            return file.getParent();
        }
        catch (IOException iOException) {
            throw new JenaException(iOException);
        }
    }
}

