/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.shared.AlreadyReifiedException;
import com.hp.hpl.jena.shared.CannotReifyException;
import com.hp.hpl.jena.vocabulary.RDF;

public abstract class AbstractTestReifier
extends GraphTestBase {
    public AbstractTestReifier(String string) {
        super(string);
    }

    public abstract Graph getGraph();

    public abstract Graph getGraph(Reifier.Style var1);

    protected final Graph getGraphWith(String string) {
        Graph graph = this.getGraph();
        AbstractTestReifier.graphAdd(graph, string);
        return graph;
    }

    public void testEmptyReifiers() {
        AbstractTestReifier.assertEquals("no reified triples", 0, this.getGraphWith("x R y").getReifier().getHiddenTriples().size());
        AbstractTestReifier.assertEquals("no reified triples", 0, this.getGraphWith("x R y; p S q").getReifier().getHiddenTriples().size());
    }

    public void testSameReifier() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        graph.add(AbstractTestReifier.triple("x R y"));
        AbstractTestReifier.assertTrue("same reifier", reifier == graph.getReifier());
    }

    public void testParent() {
        Graph graph = this.getGraph();
        Graph graph2 = this.getGraph();
        AbstractTestReifier.assertTrue("correct reifier (G)", graph == graph.getReifier().getParentGraph());
        AbstractTestReifier.assertTrue("correct reifier (H)", graph2 == graph2.getReifier().getParentGraph());
    }

    public void testIntercept() {
        Graph graph = this.getGraph(Reifier.Convenient);
        Reifier reifier = graph.getReifier();
        Node node = AbstractTestReifier.node("sub");
        Node node2 = AbstractTestReifier.node("obj");
        Node node3 = AbstractTestReifier.node("http://example.org/type");
        AbstractTestReifier.assertFalse("reifier must not intercept quadlet", reifier.handledAdd(new Triple(node, RDF.Nodes.type, node3)));
        AbstractTestReifier.assertFalse("reifier must not intercept quadlet", reifier.handledAdd(new Triple(node, node, RDF.Nodes.subject)));
        AbstractTestReifier.assertFalse("reifier must not intercept quadlet", reifier.handledAdd(new Triple(node, node, RDF.Nodes.type)));
        AbstractTestReifier.assertTrue("reifier must intercept quadlet", reifier.handledAdd(new Triple(node, RDF.Nodes.predicate, node2)));
        AbstractTestReifier.assertTrue("reifier must intercept quadlet", reifier.handledAdd(new Triple(node, RDF.Nodes.type, RDF.Nodes.Statement)));
    }

    public void testStandard() {
        Graph graph = this.getGraph(Reifier.Standard);
        AbstractTestReifier.assertFalse(graph.getReifier().hasTriple(AbstractTestReifier.triple("s p o")));
        graph.add(Triple.create("x rdf:subject s"));
        AbstractTestReifier.assertEquals(1, graph.size());
        graph.add(Triple.create("x rdf:predicate p"));
        AbstractTestReifier.assertEquals(2, graph.size());
        graph.add(Triple.create("x rdf:object o"));
        AbstractTestReifier.assertEquals(3, graph.size());
        graph.add(Triple.create("x rdf:type rdf:Statement"));
        AbstractTestReifier.assertEquals(4, graph.size());
        AbstractTestReifier.assertTrue(graph.getReifier().hasTriple(AbstractTestReifier.triple("s p o")));
    }

    public void testStandardExplode() {
        Graph graph = this.getGraph(Reifier.Standard);
        graph.getReifier().reifyAs(AbstractTestReifier.node("a"), AbstractTestReifier.triple("p Q r"));
        Graph graph2 = Factory.createDefaultGraph(Reifier.Minimal);
        AbstractTestReifier.graphAdd(graph2, "a rdf:type rdf:Statement; a rdf:subject p; a rdf:predicate Q; a rdf:object r");
        AbstractTestReifier.assertEquals(4, graph.size());
        AbstractTestReifier.assertEquals("", graph2, graph);
    }

    public void testMinimalExplode() {
        Graph graph = this.getGraph(Reifier.Minimal);
        graph.getReifier().reifyAs(AbstractTestReifier.node("a"), AbstractTestReifier.triple("p Q r"));
        AbstractTestReifier.assertEquals(0, graph.size());
    }

    public void testHiddenTriples() {
        Graph graph = this.getGraph(Reifier.Convenient);
        Reifier reifier = graph.getReifier();
        Node node = AbstractTestReifier.node("SSS");
        Node node2 = AbstractTestReifier.node("PPP");
        graph.add(new Triple(node, RDF.Nodes.predicate, node2));
        AbstractTestReifier.assertEquals("graph must still be empty", 0, graph.size());
        AbstractTestReifier.assertEquals("reifier must have the triple", 1, reifier.getHiddenTriples().size());
        AbstractTestReifier.assertContains("xxx", "SSS rdf:predicate PPP", reifier.getHiddenTriples());
        graph.add(new Triple(node, RDF.Nodes.subject, node));
        AbstractTestReifier.assertContains("xxx", "SSS rdf:subject SSS", reifier.getHiddenTriples());
    }

    public void testRetrieveTriplesByNode() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Node node = Node.createAnon();
        Node node2 = Node.createAnon();
        reifier.reifyAs(node, AbstractTestReifier.triple("x R y"));
        AbstractTestReifier.assertEquals("gets correct triple", AbstractTestReifier.triple("x R y"), reifier.getTriple(node));
        reifier.reifyAs(node2, AbstractTestReifier.triple("p S q"));
        AbstractTestReifier.assertDiffer("the anon nodes must be distinct", node, node2);
        AbstractTestReifier.assertEquals("gets correct triple", AbstractTestReifier.triple("p S q"), reifier.getTriple(node2));
        AbstractTestReifier.assertTrue("node is known bound", reifier.hasTriple(node2));
        AbstractTestReifier.assertTrue("node is known bound", reifier.hasTriple(node));
        AbstractTestReifier.assertFalse("node is known unbound", reifier.hasTriple(Node.createURI("any:thing")));
    }

    public void testRetrieveTriplesByTriple() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Triple triple = AbstractTestReifier.triple("x R y");
        Triple triple2 = AbstractTestReifier.triple("y R x");
        Node node = AbstractTestReifier.node("someNode");
        reifier.reifyAs(node, triple);
        AbstractTestReifier.assertTrue("R must have T", reifier.hasTriple(triple));
        AbstractTestReifier.assertFalse("R must not have T2", reifier.hasTriple(triple2));
    }

    public void testReifyAs() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Node node = Node.createURI("some:uri");
        AbstractTestReifier.assertEquals("node used", node, reifier.reifyAs(node, AbstractTestReifier.triple("x R y")));
        AbstractTestReifier.assertEquals("retrieves correctly", AbstractTestReifier.triple("x R y"), reifier.getTriple(node));
    }

    public void testAllNodes() {
        Reifier reifier = this.getGraph().getReifier();
        reifier.reifyAs(AbstractTestReifier.node("x"), AbstractTestReifier.triple("cows eat grass"));
        reifier.reifyAs(AbstractTestReifier.node("y"), AbstractTestReifier.triple("pigs can fly"));
        reifier.reifyAs(AbstractTestReifier.node("z"), AbstractTestReifier.triple("dogs may bark"));
        AbstractTestReifier.assertEquals("", this.nodeSet("z y x"), AbstractTestReifier.iteratorToSet(reifier.allNodes()));
    }

    public void testRemoveByNode() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Node node = AbstractTestReifier.node("x");
        Node node2 = AbstractTestReifier.node("y");
        reifier.reifyAs(node, AbstractTestReifier.triple("x R a"));
        reifier.reifyAs(node2, AbstractTestReifier.triple("y R a"));
        reifier.remove(node, AbstractTestReifier.triple("x R a"));
        AbstractTestReifier.assertFalse("triple X has gone", reifier.hasTriple(node));
        AbstractTestReifier.assertEquals("triple Y still there", AbstractTestReifier.triple("y R a"), reifier.getTriple(node2));
    }

    public void testException() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Node node = AbstractTestReifier.node("x");
        reifier.reifyAs(node, AbstractTestReifier.triple("x R y"));
        reifier.reifyAs(node, AbstractTestReifier.triple("x R y"));
        try {
            reifier.reifyAs(node, AbstractTestReifier.triple("x R z"));
            AbstractTestReifier.fail("did not detect already reified node");
        }
        catch (AlreadyReifiedException alreadyReifiedException) {
            // empty catch block
        }
    }

    public void testKevinCaseA() {
        Graph graph = this.getGraph(Reifier.Standard);
        Node node = AbstractTestReifier.node("x");
        Node node2 = AbstractTestReifier.node("a");
        Node node3 = AbstractTestReifier.node("b");
        Node node4 = AbstractTestReifier.node("c");
        graph.add(new Triple(node, RDF.Nodes.type, RDF.Nodes.Statement));
        graph.getReifier().reifyAs(node, new Triple(node2, node3, node4));
    }

    public void testKevinCaseB() {
        Graph graph = this.getGraph(Reifier.Standard);
        Node node = AbstractTestReifier.node("x");
        Node node2 = AbstractTestReifier.node("y");
        Node node3 = AbstractTestReifier.node("a");
        Node node4 = AbstractTestReifier.node("b");
        Node node5 = AbstractTestReifier.node("c");
        graph.add(new Triple(node, RDF.Nodes.subject, node2));
        try {
            graph.getReifier().reifyAs(node, new Triple(node3, node4, node5));
            AbstractTestReifier.fail("X already has subject Y: cannot make it a");
        }
        catch (CannotReifyException cannotReifyException) {
            // empty catch block
        }
    }

    public void testDynamicHiddenTriples() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Graph graph2 = reifier.getHiddenTriples();
        Graph graph3 = AbstractTestReifier.graphWith("x rdf:type rdf:Statement; x rdf:subject a; x rdf:predicate B; x rdf:object c");
        AbstractTestReifier.assertEquals("", AbstractTestReifier.graphWith(""), graph2);
        reifier.reifyAs(AbstractTestReifier.node("x"), AbstractTestReifier.triple("a B c"));
        AbstractTestReifier.assertEquals("", graph3, graph2);
    }
}

