/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.Intersection;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.rdf.model.Model;
import junit.framework.TestSuite;

public class TestIntersection
extends GraphTestBase {
    static /* synthetic */ Class class$com$hp$hpl$jena$graph$compose$test$TestIntersection;

    public TestIntersection(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$graph$compose$test$TestIntersection == null ? (class$com$hp$hpl$jena$graph$compose$test$TestIntersection = TestIntersection.class$("com.hp.hpl.jena.graph.compose.test.TestIntersection")) : class$com$hp$hpl$jena$graph$compose$test$TestIntersection);
    }

    public void testIntersection() {
        Graph graph = TestIntersection.graphWith("x R y; p R q");
        Graph graph2 = TestIntersection.graphWith("r A s; x R y");
        Intersection intersection = new Intersection(graph, graph2);
        TestIntersection.assertContains("Intersection", "x R y", intersection);
        this.assertOmits("Intersection", intersection, "p R q");
        this.assertOmits("Intersection", intersection, "r A s");
        if (intersection.size() != 1) {
            TestIntersection.fail("oops: size of intersection is not 1");
        }
        intersection.add(TestIntersection.triple("cats eat cheese"));
        TestIntersection.assertContains("Intersection.L", "cats eat cheese", graph);
        TestIntersection.assertContains("Intersection.R", "cats eat cheese", graph2);
        Graph graph3 = TestIntersection.graphWith("a pings b; b pings c; c pings a");
        Graph graph4 = TestIntersection.graphWith("c pings a; b pings c; x captures y");
        Intersection intersection2 = new Intersection(graph3, graph4);
        Model model = TestIntersection.modelFor(intersection2);
        Model model2 = TestIntersection.modelFor(graph3);
        model2.remove(model);
        if (!TestIntersection.modelFor(graph4).isIsomorphicWith(TestIntersection.modelFor(TestIntersection.graphWith("c pings a; b pings c; x captures y")))) {
            TestIntersection.show("oops: R has changed", graph4);
            TestIntersection.fail("");
        }
        if (!model2.isIsomorphicWith(TestIntersection.modelFor(TestIntersection.graphWith("a pings b")))) {
            TestIntersection.show("oops: L is", graph3);
            TestIntersection.fail("oops: mL should be `a pings b`");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

