/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.test.TestConnection;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.test.AbstractTestPrefixMapping;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestSuite;

public class TestPrefixMapping
extends AbstractTestPrefixMapping {
    private List models = null;
    private IDBConnection theConnection = null;
    private static int count = 0;
    static /* synthetic */ Class class$com$hp$hpl$jena$db$test$TestPrefixMapping;

    public TestPrefixMapping(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$db$test$TestPrefixMapping == null ? (class$com$hp$hpl$jena$db$test$TestPrefixMapping = TestPrefixMapping.class$("com.hp.hpl.jena.db.test.TestPrefixMapping")) : class$com$hp$hpl$jena$db$test$TestPrefixMapping);
    }

    public void setUp() {
        this.theConnection = TestConnection.makeAndCleanTestConnection();
        this.models = new ArrayList();
    }

    public void tearDown() {
        Iterator iterator = this.models.iterator();
        while (iterator.hasNext()) {
            Model model = (Model)iterator.next();
            model.close();
        }
        try {
            this.theConnection.close();
        }
        catch (Exception exception) {
            throw new JenaException(exception);
        }
    }

    private String getModelName() {
        return "test" + count++;
    }

    private Model getModel() {
        ModelRDB modelRDB = ModelRDB.createModel(this.theConnection, this.getModelName());
        this.models.add(modelRDB);
        return modelRDB;
    }

    public PrefixMapping getMapping() {
        Model model = this.getModel();
        return model.getGraph().getPrefixMapping();
    }

    public void testPrefixesPersist() {
        String string = "prefix-testing-model";
        ModelRDB modelRDB = ModelRDB.createModel(this.theConnection, string);
        modelRDB.setNsPrefix("hello", "eh:/someURI");
        modelRDB.setNsPrefix("bingo", "eh:/otherURI");
        modelRDB.setNsPrefix("yendi", "eh:/otherURI");
        modelRDB.close();
        ModelRDB modelRDB2 = ModelRDB.open(this.theConnection, string);
        TestPrefixMapping.assertEquals("eh:/someURI", modelRDB2.getNsPrefixURI("hello"));
        TestPrefixMapping.assertEquals("eh:/otherURI", modelRDB2.getNsPrefixURI("yendi"));
        TestPrefixMapping.assertEquals(null, modelRDB2.getNsPrefixURI("bingo"));
        modelRDB2.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

