/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.impl.IRDBDriver;
import com.hp.hpl.jena.db.test.TestConnection;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.DB;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestMultiModel
extends TestCase {
    String DefModel = "DEFAULT";
    Model model = null;
    ModelRDB dmod1 = null;
    ModelRDB dmod2 = null;
    ModelRDB nmod1 = null;
    ModelRDB nmod2 = null;
    IDBConnection conn = null;
    IRDBDriver dbDriver;
    static /* synthetic */ Class class$com$hp$hpl$jena$db$test$TestMultiModel;

    public TestMultiModel(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$db$test$TestMultiModel == null ? (class$com$hp$hpl$jena$db$test$TestMultiModel = TestMultiModel.class$("com.hp.hpl.jena.db.test.TestMultiModel")) : class$com$hp$hpl$jena$db$test$TestMultiModel);
    }

    protected void setUp() throws Exception {
        this.conn = TestConnection.makeAndCleanTestConnection();
        this.dbDriver = this.conn.getDriver();
        this.model = ModelRDB.createModel(this.conn);
        this.conn.getDriver().setStoreWithModel(this.DefModel);
        this.dmod1 = ModelRDB.createModel(this.conn, "Def_Model_1");
        this.conn.getDriver().setStoreWithModel("Def_Model_1");
        this.dmod2 = ModelRDB.createModel(this.conn, "Def_Model_2");
        this.conn.getDriver().setStoreWithModel(null);
        this.nmod1 = ModelRDB.createModel(this.conn, "Named_Model_1");
        this.conn.getDriver().setStoreWithModel("Named_Model_1");
        this.nmod2 = ModelRDB.createModel(this.conn, "Named_Model_2");
    }

    protected void tearDown() throws Exception {
        this.dmod1.close();
        this.dmod2.close();
        this.nmod1.close();
        this.nmod2.close();
        this.conn.cleanDB();
        this.conn.close();
        this.conn = null;
    }

    public void addToDBGraphProp(Model model, Property property, String string) {
        StmtIterator stmtIterator = model.listStatements(new SimpleSelector(null, DB.graphName, (RDFNode)null));
        TestMultiModel.assertTrue(stmtIterator.hasNext());
        Statement statement = stmtIterator.nextStatement();
        TestMultiModel.assertTrue(!stmtIterator.hasNext());
        Resource resource = statement.getSubject();
        Literal literal = model.createLiteral(string);
        Statement statement2 = model.createStatement(resource, property, literal);
        model.add(statement2);
        TestMultiModel.assertTrue(model.contains(statement2));
    }

    private void addOnModel(Model model, Statement statement) {
        model.add(statement);
        TestMultiModel.assertTrue(model.contains(statement));
        model.add(statement);
        TestMultiModel.assertTrue(model.contains(statement));
    }

    private void rmvOnModel(Model model, Statement statement) {
        TestMultiModel.assertTrue(model.contains(statement));
        model.remove(statement);
        TestMultiModel.assertTrue(!model.contains(statement));
        model.add(statement);
        TestMultiModel.assertTrue(model.contains(statement));
        model.remove(statement);
        TestMultiModel.assertTrue(!model.contains(statement));
    }

    private void addRemove(Statement statement) {
        this.addOnModel(this.model, statement);
        this.addOnModel(this.dmod1, statement);
        this.addOnModel(this.dmod2, statement);
        this.addOnModel(this.nmod1, statement);
        this.addOnModel(this.nmod2, statement);
        this.rmvOnModel(this.nmod2, statement);
        this.rmvOnModel(this.nmod1, statement);
        this.rmvOnModel(this.dmod2, statement);
        this.rmvOnModel(this.dmod1, statement);
        this.rmvOnModel(this.model, statement);
    }

    public void testAddRemoveURI() {
        Resource resource = this.model.createResource("test#subject");
        Property property = this.model.createProperty("test#predicate");
        Resource resource2 = this.model.createResource("test#object");
        this.addRemove(this.model.createStatement(resource, property, resource2));
    }

    public void testAddRemoveLiteral() {
        Resource resource = this.model.createResource("test#subject");
        Property property = this.model.createProperty("test#predicate");
        Literal literal = this.model.createLiteral("testLiteral");
        this.addRemove(this.model.createStatement(resource, property, literal));
    }

    public void testSetLongObjectLenFailure() {
        try {
            int n = this.dbDriver.getLongObjectLength();
            this.dbDriver.setLongObjectLength(n / 2);
            TestMultiModel.assertTrue(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testLongObjectLen() {
        Statement statement;
        Literal literal;
        long l = this.dbDriver.getLongObjectLength();
        TestMultiModel.assertTrue(l > 0L && l < 100000L);
        String string = ".";
        StringBuffer stringBuffer = new StringBuffer(1024 + (int)l);
        long l2 = l - 32L;
        long l3 = l + 32L;
        TestMultiModel.assertTrue(l2 > 0L);
        Resource resource = this.model.createResource("test#subject");
        Property property = this.model.createProperty("test#predicate");
        while ((long)stringBuffer.length() < l2) {
            stringBuffer.append(string);
        }
        long l4 = this.model.size();
        while ((long)stringBuffer.length() < l3) {
            literal = this.model.createLiteral(stringBuffer.toString());
            statement = this.model.createStatement(resource, property, literal);
            this.model.add(statement);
            TestMultiModel.assertTrue(this.model.contains(statement));
            TestMultiModel.assertTrue(statement.getObject().equals(literal));
            stringBuffer.append(string);
        }
        TestMultiModel.assertTrue(this.model.size() == l4 + l3 - l2);
        while ((long)stringBuffer.length() > l2) {
            stringBuffer.deleteCharAt(0);
            literal = this.model.createLiteral(stringBuffer.toString());
            statement = this.model.createStatement(resource, property, literal);
            TestMultiModel.assertTrue(this.model.contains(statement));
            this.model.remove(statement);
            TestMultiModel.assertTrue(!this.model.contains(statement));
        }
        TestMultiModel.assertTrue(this.model.size() == l4);
    }

    public void testSetLongObjectLen() {
        int n = this.dbDriver.getLongObjectLength();
        try {
            this.tearDown();
            this.conn = TestConnection.makeTestConnection();
            this.dbDriver = this.conn.getDriver();
            n = this.dbDriver.getLongObjectLength();
            this.dbDriver.setLongObjectLength(n / 2);
            this.model = ModelRDB.createModel(this.conn);
        }
        catch (Exception exception) {
            TestMultiModel.assertTrue(false);
        }
        this.testLongObjectLen();
        this.model.close();
        try {
            this.conn.close();
            this.conn = TestConnection.makeTestConnection();
            this.dbDriver = this.conn.getDriver();
            TestMultiModel.assertTrue(n == this.dbDriver.getLongObjectLength());
            this.model = ModelRDB.open(this.conn);
            TestMultiModel.assertTrue(n / 2 == this.dbDriver.getLongObjectLength());
        }
        catch (Exception exception) {
            TestMultiModel.assertTrue(false);
        }
    }

    public void testAddRemoveHugeLiteral() {
        String string = "This is a huge string that repeats.";
        StringBuffer stringBuffer = new StringBuffer(4096);
        while (stringBuffer.length() < 4000) {
            stringBuffer.append(string);
        }
        Resource resource = this.model.createResource("test#subject");
        Property property = this.model.createProperty("test#predicate");
        Literal literal = this.model.createLiteral(stringBuffer.toString());
        this.addRemove(this.model.createStatement(resource, property, literal));
    }

    public void testAddRemoveDatatype() {
        Resource resource = this.model.createResource("test#subject");
        Property property = this.model.createProperty("test#predicate");
        Literal literal = this.model.createTypedLiteral("stringType");
        this.addRemove(this.model.createStatement(resource, property, literal));
    }

    public void testAddRemoveHugeDatatype() {
        String string = "This is a huge string that repeats.";
        StringBuffer stringBuffer = new StringBuffer(4096);
        while (stringBuffer.length() < 4000) {
            stringBuffer.append(string);
        }
        Resource resource = this.model.createResource("test#subject");
        Property property = this.model.createProperty("test#predicate");
        Literal literal = this.model.createTypedLiteral(stringBuffer.toString());
        this.addRemove(this.model.createStatement(resource, property, literal));
    }

    public void testAddRemoveBNode() {
        Resource resource = this.model.createResource();
        Property property = this.model.createProperty("test#predicate");
        Resource resource2 = this.model.createResource();
        this.addRemove(this.model.createStatement(resource, property, resource2));
    }

    public void testBNodeIdentityPreservation() {
        Resource resource = this.model.createResource();
        Property property = this.model.createProperty("test#predicate");
        Resource resource2 = this.model.createResource();
        Statement statement = this.model.createStatement(resource, property, resource2);
        Statement statement2 = this.model.createStatement(resource2, property, resource);
        this.model.add(statement);
        this.addRemove(statement2);
        TestMultiModel.assertTrue(this.model.contains(statement));
        this.model.remove(statement);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

