/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.DBConnection;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.IRDBDriver;
import com.hp.hpl.jena.db.test.TestPackage;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.vocabulary.DB;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestConnection
extends TestCase {
    String DefModel = "DEFAULT";
    static /* synthetic */ Class class$com$hp$hpl$jena$db$test$TestConnection;

    public TestConnection(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$db$test$TestConnection == null ? (class$com$hp$hpl$jena$db$test$TestConnection = TestConnection.class$("com.hp.hpl.jena.db.test.TestConnection")) : class$com$hp$hpl$jena$db$test$TestConnection);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testNoClass() throws Exception {
    }

    public void testNoConnection() throws Exception {
    }

    private static void loadClass() {
        try {
            Class.forName(TestPackage.M_DBDRIVER_CLASS);
        }
        catch (Exception exception) {
            throw new JenaException(exception);
        }
    }

    public static IDBConnection makeTestConnection() {
        TestConnection.loadClass();
        return new DBConnection(TestPackage.M_DB_URL, TestPackage.M_DB_USER, TestPackage.M_DB_PASSWD, TestPackage.M_DB);
    }

    public static IDBConnection makeAndCleanTestConnection() {
        IDBConnection iDBConnection = TestConnection.makeTestConnection();
        try {
            iDBConnection.cleanDB();
        }
        catch (Exception exception) {
            throw new JenaException(exception);
        }
        return iDBConnection;
    }

    public void testDBConnect() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeTestConnection();
        iDBConnection.close();
    }

    public void testConstructDefaultModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        modelRDB.remove();
        iDBConnection.close();
    }

    public void testConstructAndOpenDefaultModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        modelRDB.close();
        ModelRDB modelRDB2 = ModelRDB.open(iDBConnection);
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testConstructNamedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName");
        modelRDB.remove();
        iDBConnection.close();
    }

    public void testBadNamedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = null;
        try {
            modelRDB = ModelRDB.createModel(iDBConnection, this.DefModel);
            TestConnection.assertTrue(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        iDBConnection.close();
    }

    public void testBadNamedFactoryModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelMaker modelMaker = ModelFactory.createModelRDBMaker(iDBConnection);
        Model model = null;
        try {
            model = modelMaker.createModel(this.DefModel);
            TestConnection.assertTrue(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        iDBConnection.close();
    }

    public void testReconstructDefaultModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        modelRDB.remove();
        ModelRDB modelRDB2 = ModelRDB.createModel(iDBConnection);
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testReconstructNamedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName");
        modelRDB.remove();
        ModelRDB modelRDB2 = ModelRDB.createModel(iDBConnection, "myName");
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testConstructAndOpenNamedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName");
        modelRDB.close();
        ModelRDB modelRDB2 = ModelRDB.open(iDBConnection, "myName");
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testConstructParamaterizedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, ModelRDB.getDefaultModelProperties(iDBConnection));
        modelRDB.remove();
        iDBConnection.close();
    }

    public void testConstructAndOpenParamaterizedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, ModelRDB.getDefaultModelProperties(iDBConnection));
        modelRDB.close();
        ModelRDB modelRDB2 = ModelRDB.open(iDBConnection);
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testConstructNamedParamaterizedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName", ModelRDB.getDefaultModelProperties(iDBConnection));
        modelRDB.remove();
        iDBConnection.close();
    }

    public void testConstructAndOpenNamedParamaterizedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName", ModelRDB.getDefaultModelProperties(iDBConnection));
        modelRDB.close();
        ModelRDB modelRDB2 = ModelRDB.open(iDBConnection, "myName");
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testOpenNamedNonExistentModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeTestConnection();
        try {
            ModelRDB modelRDB = ModelRDB.open(iDBConnection, "myName");
            modelRDB.remove();
            iDBConnection.close();
            TestConnection.assertTrue("Successfully opened non-existent model", false);
        }
        catch (RDFRDBException rDFRDBException) {
            iDBConnection.close();
        }
    }

    public void testOpenUnnamedNonExistentModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeTestConnection();
        try {
            iDBConnection.cleanDB();
            ModelRDB modelRDB = ModelRDB.open(iDBConnection);
            modelRDB.remove();
            iDBConnection.close();
            TestConnection.assertTrue("Successfully opened unnamed non-existent model", false);
        }
        catch (RDFRDBException rDFRDBException) {
            iDBConnection.close();
        }
    }

    public void testCreateExistingModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName", ModelRDB.getDefaultModelProperties(iDBConnection));
        try {
            ModelRDB modelRDB2 = ModelRDB.createModel(iDBConnection, "myName", ModelRDB.getDefaultModelProperties(iDBConnection));
            modelRDB.remove();
            modelRDB2.remove();
            iDBConnection.close();
            TestConnection.assertTrue("Successfully created pre-existing model", false);
        }
        catch (RDFRDBException rDFRDBException) {
            modelRDB.remove();
            iDBConnection.close();
        }
    }

    public void addToDBGraphProp(Model model, Property property, String string) {
        StmtIterator stmtIterator = model.listStatements(new SimpleSelector(null, DB.graphName, (RDFNode)null));
        TestConnection.assertTrue(stmtIterator.hasNext());
        Statement statement = stmtIterator.nextStatement();
        TestConnection.assertTrue(!stmtIterator.hasNext());
        Resource resource = statement.getSubject();
        Literal literal = model.createLiteral(string);
        Statement statement2 = model.createStatement(resource, property, literal);
        model.add(statement2);
        TestConnection.assertTrue(model.contains(statement2));
    }

    public void testConstructDefSchemaModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        iDBConnection.getDriver().setStoreWithModel("");
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        modelRDB.remove();
        iDBConnection.close();
    }

    public void testConstructBadSchemaModel() throws Exception {
        ModelRDB modelRDB;
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        iDBConnection.getDriver().setStoreWithModel(this.DefModel);
        try {
            modelRDB = ModelRDB.createModel(iDBConnection);
            modelRDB.remove();
            TestConnection.assertFalse("Created model with non-existent schema", true);
        }
        catch (RDFRDBException rDFRDBException) {
            // empty catch block
        }
        iDBConnection.getDriver().setStoreWithModel("MODEL_DOES_NOT_EXIST");
        try {
            modelRDB = ModelRDB.createModel(iDBConnection);
            modelRDB.remove();
            TestConnection.assertFalse("Created model with non-existent schema", true);
        }
        catch (RDFRDBException rDFRDBException) {
            // empty catch block
        }
        iDBConnection.close();
    }

    public void testConstructNamedModelDefSchema() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        iDBConnection.getDriver().setStoreWithModel(null);
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName");
        modelRDB.remove();
        iDBConnection.close();
    }

    public void testConstructNamedModelDefSchema1() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        iDBConnection.getDriver().setStoreWithModel(this.DefModel);
        ModelRDB modelRDB2 = ModelRDB.createModel(iDBConnection, "myName");
        modelRDB.remove();
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testConstructNamedModelDefSchema2() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        iDBConnection.getDriver().setStoreWithModel(null);
        ModelRDB modelRDB2 = ModelRDB.createModel(iDBConnection, "myName");
        modelRDB.remove();
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testConstructNamedModelSchema() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "model1");
        iDBConnection.getDriver().setStoreWithModel("model1");
        ModelRDB modelRDB2 = ModelRDB.createModel(iDBConnection, "model2");
        modelRDB.remove();
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testNamedPrefixedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        IRDBDriver iRDBDriver = iDBConnection.getDriver();
        iRDBDriver.setTableNamePrefix("foo_");
        iDBConnection.cleanDB();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName");
        modelRDB.remove();
        iDBConnection.cleanDB();
        iDBConnection.close();
    }

    public void testNamedPrefixedPersists() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeTestConnection();
        IRDBDriver iRDBDriver = iDBConnection.getDriver();
        String string = "foo_";
        iRDBDriver.setTableNamePrefix(string);
        iDBConnection.cleanDB();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName");
        modelRDB.close();
        iDBConnection.close();
        iDBConnection = TestConnection.makeTestConnection();
        iRDBDriver = iDBConnection.getDriver();
        iRDBDriver.setTableNamePrefix(string);
        modelRDB = ModelRDB.open(iDBConnection, "myName");
        TestConnection.assertTrue(iRDBDriver.getTableNamePrefix().equalsIgnoreCase(string));
        iDBConnection.cleanDB();
    }

    public void testNamedPrefixFailure() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        IRDBDriver iRDBDriver = iDBConnection.getDriver();
        String string = "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        try {
            iRDBDriver.setTableNamePrefix(string);
            TestConnection.assertTrue(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        try {
            iRDBDriver.setTableNamePrefix("foo_");
            TestConnection.assertTrue(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        modelRDB.close();
        iDBConnection.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

