/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.query.BindingQueryPlan;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.List;
import java.util.StringTokenizer;
import junit.framework.TestSuite;

public abstract class AbstractTestQuery1
extends GraphTestBase {
    protected String[] statementList = new String[]{"Pname\tPcard\tO1", "Psex\tPcard\tO1", "Pdept\tPcardmax\tO5", "Pmgr\tPcardmax\tO1", "Ptitle\tPcardmax\tO5", "Pname\tPrange\tOliteral", "Psex\tPrange\tOliteral", "Pdept\tPrange\tOliteral", "Pmgr\tPrange\tOresource", "Ptitle\tPrange\tOliteral", "S1\t\tPname\tOmm", "S1\t\tPsex\tOmale", "S1\t\tPdept\tOjena", "S1\t\tPdept\tOapp", "S1\t\tPmgr\tUS4", "S1\t\tPtitle\tOboss", "S2\t\tPname\tObb", "S2\t\tPsex\tOmale", "S2\t\tPdept\tOgenesis", "S2\t\tPdept\tOapp", "S2\t\tPmgr\tUS4", "S2\t\tPtitle\tOboss", "S3\t\tPname\tOjb", "S3\t\tPsex\tOfemale", "S3\t\tPdept\tOapp", "S3\t\tPmgr\tUS1", "S3\t\tPtitle\tOboss", "S4\t\tPname\tOdick", "S4\t\tPsex\tOmale", "S4\t\tPmgr\tOshane", "S4\t\tPtitle\tObigboss", "S5\t\tPname\tOkers", "S5\t\tPsex\tOmale", "S5\t\tPdept\tOjena", "S5\t\tPdept\tOrdql", "S5\t\tPmgr\tUS1", "S5\t\tPtitle\tOgrunt", "S6\t\tPname\tOjjc", "S6\t\tPsex\tOmale", "S6\t\tPdept\tOjena", "S6\t\tPdept\tOrdf", "S6\t\tPdept\tOowl", "S6\t\tPmgr\tUS1", "S6\t\tPtitle\tOgrunt", "S7\t\tPname\tOder", "S7\t\tPsex\tOmale", "S7\t\tPdept\tOjena", "S7\t\tPdept\tOrdf", "S7\t\tPdept\tOowl", "S7\t\tPmgr\tUS1", "S7\t\tPtitle\tOgrunt", "S7\t\tPtitle\tOboss", "S8\t\tPname\tObmk", "S8\t\tPsex\tOmale", "S8\t\tPdept\tOjena", "S8\t\tPdept\tOrdf", "S8\t\tPmgr\tUS1", "S8\t\tPtitle\tOgrunt", "S8\t\tPtitle\tOboss", "S9\t\tPname\tOas", "S9\t\tPsex\tOmale", "S9\t\tPdept\tOjena", "S9\t\tPdept\tOrdf", "S9\t\tPdept\tOrdql", "S9\t\tPmgr\tUS1", "S9\t\tPtitle\tOgrunt", "S10\t\tPname\tOian", "S10\t\tPsex\tOmale", "S10\t\tPdept\tOjena", "S10\t\tPdept\tOowl", "S10\t\tPmgr\tUS1", "S10\t\tPtitle\tOgrunt", "S11\t\tPname\tOsteveb", "S11\t\tPsex\tOmale", "S11\t\tPdept\tOapp", "S11\t\tPmgr\tUS3", "S11\t\tPtitle\tOgrunt", "S12\t\tPname\tOstevec", "S12\t\tPsex\tOmale", "S12\t\tPdept\tOapp", "S12\t\tPmgr\tUS3", "S12\t\tPtitle\tOgrunt", "S13\t\tPname\tOcs", "S13\t\tPsex\tOmale", "S13\t\tPdept\tOjena", "S13\t\tPdept\tOgenesis", "S13\t\tPmgr\tUS2", "S13\t\tPtitle\tOgrunt", "S14\t\tPname\tOhk", "S14\t\tPsex\tOfemale", "S14\t\tPdept\tOapp", "S14\t\tPdept\tOgenesis", "S14\t\tPmgr\tUS2", "S14\t\tPtitle\tOgrunt", "S15\t\tPname\tOks", "S15\t\tPsex\tOmale", "S15\t\tPdept\tOapp", "S15\t\tPdept\tOgenesis", "S15\t\tPmgr\tUS2", "S16\t\tPname\tOwkw", "S16\t\tPsex\tOmale", "S16\t\tPdept\tOjena", "S16\t\tPdept\tOapp", "S16\t\tPmgr\tUS2", "S16\t\tPtitle\tOgrunt", "N1\t\tS1\t\tPname\tOmm", "N2\t\tS1\t\tPsex\tOmale", "N3\t\tS1\t\tPdept\tOjena", "N4\t\tS1\t\tPdept\tOapp", "N5\t\tS1\t\tPmgr\tUS4", "N6\t\tS1\t\tPtitle\tOboss", "N7\t\tS2\t\tPname\tObb", "N8\t\tS2\t\tPsex\tOmale", "N9\t\tS2\t\tPdept\tOgenesis", "N10\tS2\t\tPdept\tOapp", "N11\tS2\t\tPmgr\tUS4", "N12\tS2\t\tPtitle\tOboss", "N13\tS3\t\tPname\tOjb", "N14\tS3\t\tPsex\tOfemale", "N15\tS3\t\tPdept\tOapp", "N16\tS3\t\tPmgr\tUS1", "N17\tS3\t\tPtitle\tOboss", "N18\tS4\t\tPname\tOdick", "N19\tS4\t\tPsex\tOmale", "N20\tS4\t\tPmgr\tOshane", "N21\tS4\t\tPtitle\tObigboss", "N22\tS5\t\tPname\tOkers", "N23\tS5\t\tPsex\tOmale", "N24\tS5\t\tPdept\tOjena", "N25\tS5\t\tPdept\tOrdql", "N26\tS5\t\tPmgr\tUS1", "N27\tS5\t\tPtitle\tOgrunt"};
    protected String longpfx = null;
    static int stmtCnt = 0;
    static /* synthetic */ Class class$com$hp$hpl$jena$db$test$AbstractTestQuery1;

    public AbstractTestQuery1(String string) {
        super(string);
    }

    public abstract Graph getGraph();

    public abstract Graph getGraph(Reifier.Style var1);

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$db$test$AbstractTestQuery1 == null ? (class$com$hp$hpl$jena$db$test$AbstractTestQuery1 = AbstractTestQuery1.class$("com.hp.hpl.jena.db.test.AbstractTestQuery1")) : class$com$hp$hpl$jena$db$test$AbstractTestQuery1);
    }

    public void setUp() {
    }

    protected void tearDown() throws Exception {
    }

    protected String longPrefix() {
        if (this.longpfx == null) {
            String string = ".";
            for (int i = 0; i < 255; ++i) {
                string = string + ".";
            }
            this.longpfx = string;
        }
        return this.longpfx;
    }

    protected Node makeResource(String string) {
        boolean bl;
        boolean bl2 = bl = string.charAt(1) == 'L';
        if (bl) {
            string = this.longPrefix() + string.substring(1);
        }
        return Node.createURI(string);
    }

    protected Node makeObject(String string) {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = string.charAt(0) == 'U';
        if (bl2) {
            return this.makeResource(string.substring(1));
        }
        boolean bl4 = bl = string.charAt(1) == 'L';
        if (bl) {
            string = this.longPrefix() + string.substring(1);
        }
        return Node.createLiteral(new LiteralLabel(string));
    }

    protected void loadGraph(Graph graph) {
        Node node = null;
        for (int i = 0; i < this.statementList.length; ++i) {
            boolean bl;
            StringTokenizer stringTokenizer = new StringTokenizer(this.statementList[i]);
            String string = stringTokenizer.nextToken();
            if (string.charAt(0) == 'N') {
                bl = true;
                node = this.makeResource(string);
                string = stringTokenizer.nextToken();
            } else {
                bl = false;
            }
            Node node2 = this.makeResource(string);
            Node node3 = this.makeResource(stringTokenizer.nextToken());
            Node node4 = this.makeObject(stringTokenizer.nextToken());
            Triple triple = new Triple(node2, node3, node4);
            if (bl) {
                graph.getReifier().reifyAs(node, triple);
            } else {
                graph.add(triple);
            }
            ++stmtCnt;
        }
    }

    protected int queryResultCount(ExtendedIterator extendedIterator) {
        int n = 0;
        while (extendedIterator.hasNext()) {
            ++n;
            List list = (List)extendedIterator.next();
            int n2 = list.size();
        }
        return n;
    }

    public void testBinding1() {
        Graph graph = this.getGraph(Reifier.Standard);
        Graph graph2 = this.getGraph(Reifier.Convenient);
        this.loadGraph(graph);
        this.loadGraph(graph2);
        Node node = AbstractTestQuery1.node("?v1");
        Node node2 = AbstractTestQuery1.node("?v2");
        Node node3 = AbstractTestQuery1.node("?v3");
        Node node4 = AbstractTestQuery1.node("?v4");
        Node node5 = AbstractTestQuery1.node("?v5");
        Node node6 = this.makeResource("Ptitle");
        Node node7 = this.makeResource("Psex");
        Node node8 = this.makeResource("Pname");
        Node node9 = this.makeResource("Pmgr");
        Node node10 = this.makeResource("Pcard");
        Node node11 = this.makeResource("Pcardmax");
        Node node12 = this.makeResource("Prange");
        Node node13 = this.makeResource("Pdept");
        Node node14 = this.makeResource("S1");
        Node node15 = this.makeObject("Ogrunt");
        Node node16 = this.makeObject("Ofemale");
        Node node17 = this.makeObject("Omale");
        Node node18 = this.makeObject("Obigboss");
        Node node19 = this.makeObject("Oboss");
        Node node20 = this.makeObject("Oshane");
        Node node21 = this.makeObject("Oliteral");
        Node node22 = this.makeObject("Oresource");
        Node node23 = this.makeObject("Oapp");
        Node node24 = this.makeObject("Ogenesis");
        Node node25 = this.makeObject("O1");
        Query query = new Query();
        query.addMatch(node, node6, node15);
        query.addMatch(node, node7, node16);
        query.addMatch(node, node8, node3);
        BindingQueryPlan bindingQueryPlan = graph.queryHandler().prepareBindings(query, new Node[]{node, node3});
        ExtendedIterator extendedIterator = bindingQueryPlan.executeBindings();
        AbstractTestQuery1.assertEquals("female grunts", 1, this.queryResultCount(extendedIterator));
        extendedIterator.close();
        query = new Query();
        query.addMatch(node, node6, node15);
        query.addMatch(node, node7, node16);
        query.addMatch(node, node9, node2);
        query.addMatch(node2, node8, node3);
        bindingQueryPlan = graph.queryHandler().prepareBindings(query, new Node[]{node, node3});
        extendedIterator = bindingQueryPlan.executeBindings();
        AbstractTestQuery1.assertEquals("mgrs of female grunts", 1, this.queryResultCount(extendedIterator));
        extendedIterator.close();
        query = new Query();
        query.addMatch(node, node6, node15);
        query.addMatch(node, node7, node16);
        query.addMatch(node, node9, node2);
        query.addMatch(node2, node7, node16);
        query.addMatch(node, node8, node3);
        bindingQueryPlan = graph.queryHandler().prepareBindings(query, new Node[]{node, node3});
        extendedIterator = bindingQueryPlan.executeBindings();
        AbstractTestQuery1.assertEquals("female grunts with female mgrs", 0, this.queryResultCount(extendedIterator));
        extendedIterator.close();
        query = new Query();
        query.addMatch(node, node6, node18);
        query.addMatch(node, node9, node20);
        query.addMatch(node, node2, node3);
        bindingQueryPlan = graph.queryHandler().prepareBindings(query, new Node[]{node, node2, node3});
        extendedIterator = bindingQueryPlan.executeBindings();
        AbstractTestQuery1.assertEquals("all properties of the bigboss", 4, this.queryResultCount(extendedIterator));
        extendedIterator.close();
        query = new Query();
        query.addMatch(node, node6, node15);
        query.addMatch(node, node7, node16);
        query.addMatch(node, node9, node2);
        query.addMatch(node2, node7, node17);
        query.addMatch(node, node3, node4);
        bindingQueryPlan = graph.queryHandler().prepareBindings(query, new Node[]{node, node3, node4});
        extendedIterator = bindingQueryPlan.executeBindings();
        AbstractTestQuery1.assertEquals("all properties of female grunts with male mgrs", 6, this.queryResultCount(extendedIterator));
        extendedIterator.close();
        query = new Query();
        query.addMatch(node, node6, node18);
        query.addMatch(node, node9, node20);
        query.addMatch(node2, node10, node25);
        query.addMatch(node2, node12, node21);
        query.addMatch(node, node2, node3);
        bindingQueryPlan = graph.queryHandler().prepareBindings(query, new Node[]{node2, node3});
        extendedIterator = bindingQueryPlan.executeBindings();
        AbstractTestQuery1.assertEquals("single-valued, literal properties of the bigboss", 2, this.queryResultCount(extendedIterator));
        extendedIterator.close();
        query = new Query();
        query.addMatch(node, node11, node25);
        query.addMatch(node, node12, node22);
        query.addMatch(node14, node, node2);
        query.addMatch(node2, node8, node3);
        query.addMatch(node2, node7, node4);
        bindingQueryPlan = graph.queryHandler().prepareBindings(query, new Node[]{node2, node3, node4});
        extendedIterator = bindingQueryPlan.executeBindings();
        AbstractTestQuery1.assertEquals("name, gender of referenced people", 1, this.queryResultCount(extendedIterator));
        extendedIterator.close();
        query = new Query();
        query.addMatch(node, RDF.Nodes.subject, node2);
        query.addMatch(node, RDF.Nodes.predicate, node3);
        query.addMatch(node, RDF.Nodes.object, node4);
        bindingQueryPlan = graph.queryHandler().prepareBindings(query, new Node[]{node2, node3, node4});
        extendedIterator = bindingQueryPlan.executeBindings();
        AbstractTestQuery1.assertEquals("number of reified statements", 27, this.queryResultCount(extendedIterator));
        extendedIterator.close();
        bindingQueryPlan = graph2.queryHandler().prepareBindings(query, new Node[]{node2, node3, node4});
        extendedIterator = bindingQueryPlan.executeBindings();
        AbstractTestQuery1.assertEquals("number of reified statements", 0, this.queryResultCount(extendedIterator));
        extendedIterator.close();
        query = new Query();
        query.addMatch(node, RDF.Nodes.subject, node2);
        query.addMatch(node, RDF.Nodes.predicate, node6);
        query.addMatch(node, RDF.Nodes.object, node18);
        query.addMatch(node3, RDF.Nodes.subject, node2);
        query.addMatch(node3, RDF.Nodes.predicate, node4);
        bindingQueryPlan = graph.queryHandler().prepareBindings(query, new Node[]{node2, node3});
        extendedIterator = bindingQueryPlan.executeBindings();
        AbstractTestQuery1.assertEquals("number of reified statements", 4, this.queryResultCount(extendedIterator));
        extendedIterator.close();
        query = new Query();
        query.addMatch(node, RDF.Nodes.subject, node2);
        query.addMatch(node, RDF.Nodes.predicate, node6);
        query.addMatch(node, RDF.Nodes.object, node18);
        query.addMatch(node3, RDF.Nodes.subject, node2);
        query.addMatch(node3, node4, node5);
        bindingQueryPlan = graph.queryHandler().prepareBindings(query, new Node[]{node3});
        extendedIterator = bindingQueryPlan.executeBindings();
        AbstractTestQuery1.assertEquals("number of reified statements", 16, this.queryResultCount(extendedIterator));
        extendedIterator.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

