/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.IDBID;
import com.hp.hpl.jena.db.impl.IPSet;
import com.hp.hpl.jena.db.impl.ResultSetIterator;
import com.hp.hpl.jena.db.impl.SQLCache;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class ResultSetTripleIterator
extends ResultSetIterator {
    protected IDBID m_graphID;
    protected IPSet m_pset;
    protected Triple m_triple;
    protected boolean m_isReif;
    protected Node m_stmtURI;
    protected boolean m_hasType;
    protected static Logger logger = Logger.getLogger(class$com$hp$hpl$jena$db$impl$ResultSetTripleIterator == null ? (class$com$hp$hpl$jena$db$impl$ResultSetTripleIterator = ResultSetTripleIterator.class$("com.hp.hpl.jena.db.impl.ResultSetTripleIterator")) : class$com$hp$hpl$jena$db$impl$ResultSetTripleIterator);
    static /* synthetic */ Class class$com$hp$hpl$jena$db$impl$ResultSetTripleIterator;

    public ResultSetTripleIterator(IPSet iPSet, IDBID iDBID) {
        this.m_pset = iPSet;
        this.setGraphID(iDBID);
        this.m_isReif = false;
    }

    public ResultSetTripleIterator(IPSet iPSet, boolean bl, IDBID iDBID) {
        this.m_pset = iPSet;
        this.setGraphID(iDBID);
        this.m_isReif = bl;
    }

    public void setGraphID(IDBID iDBID) {
        this.m_graphID = iDBID;
    }

    public void reset(ResultSet resultSet, PreparedStatement preparedStatement, SQLCache sQLCache, String string) {
        super.reset(resultSet, preparedStatement, sQLCache, string);
        this.m_triple = null;
    }

    protected void extractRow() throws SQLException {
        boolean bl = true;
        ResultSet resultSet = this.m_resultSet;
        String string = resultSet.getString(1);
        String string2 = resultSet.getString(2);
        String string3 = resultSet.getString(3);
        if (this.m_isReif) {
            this.m_stmtURI = this.m_pset.driver().RDBStringToNode(resultSet.getString(4));
            this.m_hasType = resultSet.getString(5).equals("T");
        }
        Triple triple = null;
        try {
            triple = this.m_pset.extractTripleFromRowData(string, string2, string3);
        }
        catch (RDFRDBException rDFRDBException) {
            logger.debug("Extracting triple from row encountered exception: ", rDFRDBException);
        }
        this.m_triple = triple;
    }

    protected Object getRow() {
        return this.m_triple;
    }

    protected Node getStmtURI() {
        return this.m_stmtURI;
    }

    protected boolean getHasType() {
        return this.m_hasType;
    }

    protected void deleteRow() {
        try {
            this.m_resultSet.deleteRow();
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal sql error", sQLException);
        }
    }

    public void remove() {
        if (this.m_triple == null) {
            throw new IllegalStateException();
        }
        this.m_pset.deleteTriple(this.m_triple, this.m_graphID);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

