/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.impl.BaseGraphMaker;
import com.hp.hpl.jena.vocabulary.JMS;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class GraphRDBMaker
extends BaseGraphMaker {
    private IDBConnection c;
    private int counter = 0;
    private Set created = new HashSet();
    int reificationStyle;

    public GraphRDBMaker(IDBConnection iDBConnection, Reifier.Style style) {
        super(style);
        this.c = iDBConnection;
        this.reificationStyle = GraphRDB.styleRDB(style);
    }

    public Node getMakerClass() {
        return JMS.RDBMakerSpec.asNode();
    }

    protected void augmentDescription(Graph graph, Node node) {
    }

    public Graph getGraph() {
        return this.consGraph(null, true);
    }

    public Graph createGraph() {
        return this.createGraph("anon_" + this.counter++ + "", false);
    }

    public Graph createGraph(String string, boolean bl) {
        this.created.add(string);
        boolean bl2 = bl || !this.hasGraph(string);
        return this.consGraph(string, bl2);
    }

    public Graph openGraph(String string, boolean bl) {
        boolean bl2 = !this.hasGraph(string) && !bl;
        return this.consGraph(string, bl2);
    }

    private Graph consGraph(String string, boolean bl) {
        Graph graph = this.c.getDefaultModelProperties().getGraph();
        return new GraphRDB(this.c, string, bl ? graph : null, this.reificationStyle, bl);
    }

    public void removeGraph(String string) {
        GraphRDB graphRDB = (GraphRDB)this.openGraph(string, true);
        graphRDB.remove();
        graphRDB.close();
        this.created.remove(string);
    }

    public boolean hasGraph(String string) {
        return this.c.containsModel(string);
    }

    public void removeAll() {
        Iterator iterator = new HashSet(this.created).iterator();
        while (iterator.hasNext()) {
            this.removeGraph((String)iterator.next());
        }
    }

    public void close() {
    }
}

