/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.DBIDInt;
import com.hp.hpl.jena.db.impl.DBProp;
import com.hp.hpl.jena.db.impl.DBPropDatabase;
import com.hp.hpl.jena.db.impl.DBPropGraph;
import com.hp.hpl.jena.db.impl.DBPropLSet;
import com.hp.hpl.jena.db.impl.DBPropPSet;
import com.hp.hpl.jena.db.impl.IPSet;
import com.hp.hpl.jena.db.impl.IRDBDriver;
import com.hp.hpl.jena.db.impl.LRUCache;
import com.hp.hpl.jena.db.impl.SQLCache;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.db.impl.VarIndex;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Node_Variable;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import org.apache.log4j.Logger;
import org.apache.xerces.util.XMLChar;

public abstract class DriverRDB
implements IRDBDriver {
    protected DBPropDatabase m_dbProps;
    protected String m_psetClassName;
    protected String m_psetReifierClassName;
    protected String m_lsetClassName;
    protected String m_lsetReifierClassName;
    protected String DRIVER_NAME;
    protected String DATABASE_TYPE;
    protected int INDEX_KEY_LENGTH;
    protected int INDEX_KEY_LENGTH_MAX;
    protected boolean IS_XACT_DB;
    protected boolean STRINGS_TRIMMED;
    protected String EOS = "";
    protected char EOS_CHAR = (char)58;
    protected int EOS_LEN = 0;
    protected char QUOTE_CHAR = (char)34;
    protected boolean DB_NAMES_TO_UPPER = false;
    protected boolean URI_COMPRESS;
    protected int URI_COMPRESS_LENGTH = 100;
    protected int LONG_OBJECT_LENGTH;
    protected int LONG_OBJECT_LENGTH_MAX;
    protected String ID_SQL_TYPE;
    protected boolean SKIP_DUPLICATE_CHECK;
    protected boolean PRE_ALLOCATE_ID;
    protected String SQL_FILE;
    protected String DEFAULT_SQL_FILE = "etc/generic_generic.sql";
    protected String TABLE_NAME_PREFIX = "jena_";
    protected int TABLE_NAME_LENGTH_MAX;
    protected int JENA_LONGEST_TABLE_NAME_LENGTH = 14;
    protected boolean CACHE_PREPARED_STATEMENTS = true;
    protected String LAYOUT_TYPE = "TripleStore";
    protected String SYSTEM_STMT_TABLE;
    protected String LONG_LIT_TABLE;
    protected String LONG_URI_TABLE;
    protected String PREFIX_TABLE;
    protected String GRAPH_TABLE;
    protected String STORE_WITH_MODEL = null;
    protected final String DEFAULT_PROPS = "JENA_DEFAULT_GRAPH_PROPERTIES";
    protected final int DEFAULT_ID = 0;
    protected final String VERSION = "2.0alpha";
    protected String LAYOUT_VERSION = "2.0";
    protected static Logger logger = Logger.getLogger(class$com$hp$hpl$jena$db$impl$PSet_ReifStore_RDB == null ? (class$com$hp$hpl$jena$db$impl$PSet_ReifStore_RDB = DriverRDB.class$("com.hp.hpl.jena.db.impl.PSet_ReifStore_RDB")) : class$com$hp$hpl$jena$db$impl$PSet_ReifStore_RDB);
    protected SQLCache m_sql = null;
    protected SpecializedGraph m_sysProperties = null;
    protected IDBConnection m_dbcon = null;
    protected LRUCache prefixCache = null;
    public static final int PREFIX_CACHE_SIZE = 50;
    private Boolean m_transactionsSupported;
    protected boolean inTransaction = false;
    protected static String RDBCodeURI = "U";
    protected static String RDBCodeBlank = "B";
    protected static String RDBCodeLiteral = "L";
    protected static String RDBCodeVariable = "V";
    protected static String RDBCodeANY = "A";
    protected static String RDBCodePrefix = "P";
    protected static String RDBCodeValue = "v";
    protected static String RDBCodeRef = "r";
    protected static String RDBCodeDelim = ":";
    protected static char RDBCodeDelimChar = (char)58;
    protected static String RDBCodeInvalid = "X";
    static /* synthetic */ Class class$com$hp$hpl$jena$db$impl$PSet_ReifStore_RDB;
    static /* synthetic */ Class class$com$hp$hpl$jena$db$impl$IPSet;
    static /* synthetic */ Class class$java$lang$Integer;

    public IDBConnection getConnection() {
        return this.m_dbcon;
    }

    public SpecializedGraph getSystemSpecializedGraph() {
        if (this.m_sysProperties != null) {
            return this.m_sysProperties;
        }
        this.setTableNames(this.TABLE_NAME_PREFIX);
        if (!this.isDBFormatOK()) {
            this.cleanDB();
            this.prefixCache = new LRUCache(50);
            return this.formatAndConstructSystemSpecializedGraph();
        }
        this.prefixCache = new LRUCache(50);
        this.getDbInitTablesParams();
        IPSet iPSet = this.createIPSetInstanceFromName(this.m_psetClassName, this.SYSTEM_STMT_TABLE);
        this.m_sysProperties = this.createLSetInstanceFromName(this.m_lsetClassName, iPSet, 0);
        this.m_dbProps = new DBPropDatabase(this.m_sysProperties);
        this.checkEngine(this.m_dbProps);
        this.checkDriverVersion(this.m_dbProps);
        this.checkLayoutVersion(this.m_dbProps);
        String string = this.m_dbProps.getLongObjectLength();
        if (string != null) {
            this.LONG_OBJECT_LENGTH = Integer.parseInt(string);
        }
        if ((string = this.m_dbProps.getIndexKeyLength()) != null) {
            this.INDEX_KEY_LENGTH = Integer.parseInt(string);
        }
        if ((string = this.m_dbProps.getIsTransactionDb()) != null) {
            this.IS_XACT_DB = Boolean.valueOf(string);
        }
        if ((string = this.m_dbProps.getDoCompressURI()) != null) {
            this.URI_COMPRESS = Boolean.valueOf(string);
        }
        if ((string = this.m_dbProps.getCompressURILength()) != null) {
            this.URI_COMPRESS_LENGTH = Integer.parseInt(string);
        }
        if ((string = this.m_dbProps.getTableNamePrefix()) != null) {
            this.TABLE_NAME_PREFIX = string;
        }
        return this.m_sysProperties;
    }

    private void checkEngine(DBProp dBProp) {
        String string = this.m_dbProps.getEngineType();
        if (!string.equals(this.DATABASE_TYPE)) {
            throw new JenaException("Database created with incompatible database type for this version of Jena: " + string);
        }
    }

    private void checkDriverVersion(DBProp dBProp) {
        String string = this.m_dbProps.getDriverVersion();
        if (!string.equals("2.0alpha")) {
            throw new JenaException("Models in the database were created with an incompatible version of Jena: " + string);
        }
    }

    private void checkLayoutVersion(DBProp dBProp) {
        String string = this.m_dbProps.getLayoutVersion();
        if (!string.equals(this.LAYOUT_VERSION)) {
            throw new JenaException("The database layout cannot be processed by this version of Jena: " + string);
        }
    }

    protected SpecializedGraph formatAndConstructSystemSpecializedGraph() {
        Object object;
        try {
            object = this.getDbInitTablesParams();
            this.m_sql.runSQLGroup("initDBtables", (String[])object);
            this.m_sql.runSQLGroup("initDBgenerators");
        }
        catch (SQLException sQLException) {
            logger.warn("Problem formatting database", sQLException);
            throw new RDFRDBException("Failed to format database", sQLException);
        }
        object = this.createIPSetInstanceFromName(this.m_psetClassName, this.SYSTEM_STMT_TABLE);
        this.m_sysProperties = this.createLSetInstanceFromName(this.m_lsetClassName, (IPSet)object, 0);
        this.m_dbProps = new DBPropDatabase(this.m_sysProperties, this.m_dbcon.getDatabaseType(), "2.0alpha", this.LAYOUT_VERSION, String.valueOf(this.LONG_OBJECT_LENGTH), String.valueOf(this.INDEX_KEY_LENGTH), String.valueOf(this.IS_XACT_DB), String.valueOf(this.URI_COMPRESS), String.valueOf(this.URI_COMPRESS_LENGTH), this.TABLE_NAME_PREFIX);
        DBPropGraph dBPropGraph = new DBPropGraph(this.m_sysProperties, "JENA_DEFAULT_GRAPH_PROPERTIES", "generic");
        dBPropGraph.addGraphId(0);
        return this.m_sysProperties;
    }

    abstract String[] getDbInitTablesParams();

    abstract String[] getCreateTableParams(int var1, boolean var2);

    public abstract int graphIdAlloc(String var1);

    public List createSpecializedGraphs(DBPropGraph dBPropGraph) {
        DBProp dBProp;
        String string = dBPropGraph.getName();
        String string2 = null;
        String string3 = null;
        String string4 = this.STORE_WITH_MODEL;
        int n = this.graphIdAlloc(string);
        dBPropGraph.addGraphId(n);
        boolean bl = false;
        if (string4 == null && string.equals("DEFAULT")) {
            bl = true;
            string4 = "JENA_DEFAULT_GRAPH_PROPERTIES";
        }
        if (string4 != null) {
            dBProp = DBPropGraph.findPropGraphByName(this.getSystemSpecializedGraph(), string4);
            if (dBProp != null) {
                string3 = dBProp.getReifTable();
                string2 = dBProp.getStmtTable();
            }
            if (!(string3 != null && string2 != null || bl)) {
                throw new RDFRDBException("Creating graph " + string + ": referenced schema not found: " + string4);
            }
        }
        if (string3 == null || string2 == null) {
            string3 = this.createTable(n, true);
            string2 = this.createTable(n, false);
            if (string3 == null || string2 == null) {
                throw new RDFRDBException("Creating graph " + string + ": cannot create tables");
            }
        }
        dBPropGraph.addStmtTable(string2);
        dBPropGraph.addReifTable(string3);
        dBProp = new DBPropPSet(this.m_sysProperties, this.m_psetReifierClassName, string3);
        DBPropLSet dBPropLSet = new DBPropLSet(this.m_sysProperties, "LSET_" + dBPropGraph.getName() + "_REIFIER", this.m_lsetReifierClassName);
        dBPropLSet.setPSet((DBPropPSet)dBProp);
        dBPropGraph.addLSet(dBPropLSet);
        DBPropPSet dBPropPSet = new DBPropPSet(this.m_sysProperties, this.m_psetClassName, string2);
        DBPropLSet dBPropLSet2 = new DBPropLSet(this.m_sysProperties, "LSET_" + dBPropGraph.getName(), this.m_lsetClassName);
        dBPropLSet2.setPSet(dBPropPSet);
        dBPropGraph.addLSet(dBPropLSet2);
        return this.recreateSpecializedGraphs(dBPropGraph);
    }

    public List recreateSpecializedGraphs(DBPropGraph dBPropGraph) {
        ArrayList<SpecializedGraph> arrayList = new ArrayList<SpecializedGraph>();
        int n = dBPropGraph.getGraphId();
        String[] stringArray = new String[]{this.m_lsetClassName, this.m_lsetReifierClassName};
        for (int i = 0; i < 2; ++i) {
            ExtendedIterator extendedIterator = dBPropGraph.getAllLSets();
            while (extendedIterator.hasNext()) {
                DBPropLSet dBPropLSet = (DBPropLSet)extendedIterator.next();
                if (dBPropLSet.getType().equals(stringArray[i])) continue;
                DBPropPSet dBPropPSet = dBPropLSet.getPset();
                IPSet iPSet = this.createIPSetInstanceFromName(dBPropPSet.getType(), dBPropPSet.getTable());
                arrayList.add(this.createLSetInstanceFromName(dBPropLSet.getType(), iPSet, n));
            }
        }
        return arrayList;
    }

    private IPSet createIPSetInstanceFromName(String string, String string2) {
        IPSet iPSet = null;
        try {
            iPSet = (IPSet)Class.forName(string).newInstance();
            iPSet.setDriver(this);
            iPSet.setSQLType(this.ID_SQL_TYPE);
            iPSet.setSkipDuplicateCheck(this.SKIP_DUPLICATE_CHECK);
            iPSet.setSQLCache(this.m_sql);
            iPSet.setCachePreparedStatements(this.CACHE_PREPARED_STATEMENTS);
            iPSet.setTblName(string2);
        }
        catch (Exception exception) {
            logger.warn("Unable to create IPSet instance ", exception);
        }
        return iPSet;
    }

    private SpecializedGraph createLSetInstanceFromName(String string, IPSet iPSet, int n) {
        SpecializedGraph specializedGraph = null;
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{class$com$hp$hpl$jena$db$impl$IPSet == null ? (class$com$hp$hpl$jena$db$impl$IPSet = DriverRDB.class$("com.hp.hpl.jena.db.impl.IPSet")) : class$com$hp$hpl$jena$db$impl$IPSet, class$java$lang$Integer == null ? (class$java$lang$Integer = DriverRDB.class$("java.lang.Integer")) : class$java$lang$Integer};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{iPSet, new Integer(n)};
            specializedGraph = (SpecializedGraph)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            logger.error("Unable to create instance of SpecializedGraph ", exception);
        }
        return specializedGraph;
    }

    public void removeSpecializedGraphs(DBPropGraph dBPropGraph, List list) {
        Object object;
        int n = dBPropGraph.getGraphId();
        ExtendedIterator extendedIterator = list.iterator();
        while (extendedIterator.hasNext()) {
            object = (SpecializedGraph)extendedIterator.next();
            this.removeSpecializedGraph((SpecializedGraph)object);
        }
        object = dBPropGraph.getStmtTable();
        String string = dBPropGraph.getReifTable();
        this.m_dbProps.removeGraph(dBPropGraph);
        if (n != 0) {
            boolean bl = false;
            boolean bl2 = false;
            extendedIterator = this.m_dbProps.getAllGraphs();
            while (extendedIterator.hasNext()) {
                DBPropGraph dBPropGraph2 = (DBPropGraph)extendedIterator.next();
                if (dBPropGraph2.getStmtTable().equals(object)) {
                    bl = true;
                }
                if (!dBPropGraph2.getReifTable().equals(string)) continue;
                bl2 = true;
            }
            if (!bl) {
                this.deleteTable((String)object);
            }
            if (!bl2) {
                this.deleteTable(string);
            }
            this.graphIdDealloc(n);
        }
    }

    private void removeSpecializedGraph(SpecializedGraph specializedGraph) {
        specializedGraph.clear();
    }

    public void setDatabaseProperties(Graph graph) {
        SpecializedGraph specializedGraph = this.getSystemSpecializedGraph();
        specializedGraph.clear();
        SpecializedGraph.CompletionFlag completionFlag = new SpecializedGraph.CompletionFlag();
        specializedGraph.add(graph, completionFlag);
    }

    public DBPropGraph getDefaultModelProperties() {
        SpecializedGraph specializedGraph = this.getSystemSpecializedGraph();
        DBPropGraph dBPropGraph = DBPropGraph.findPropGraphByName(specializedGraph, "JENA_DEFAULT_GRAPH_PROPERTIES");
        if (dBPropGraph == null) {
            logger.error("No default Model Properties found");
        }
        return dBPropGraph;
    }

    public boolean isDBFormatOK() {
        boolean bl = false;
        try {
            ResultSet resultSet = this.getAllTables();
            bl = resultSet.next();
            resultSet.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public String stringToDBname(String string) {
        String string2 = this.DB_NAMES_TO_UPPER ? string.toUpperCase() : string;
        return string2;
    }

    public void cleanDB() {
        try {
            ResultSet resultSet = this.getAllTables();
            ArrayList<String> arrayList = new ArrayList<String>(10);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString("TABLE_NAME"));
            }
            resultSet.close();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.m_sql.runSQLGroup("dropTable", (String)iterator.next());
            }
            if (this.PRE_ALLOCATE_ID) {
                this.clearSequences();
            }
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal SQL error in driver", sQLException);
        }
        this.m_sysProperties = null;
        if (this.prefixCache != null) {
            this.prefixCache.clear();
        }
        this.prefixCache = null;
    }

    private ResultSet getAllTables() {
        try {
            DatabaseMetaData databaseMetaData = this.m_dbcon.getConnection().getMetaData();
            String[] stringArray = new String[]{"TABLE"};
            String string = this.stringToDBname(this.TABLE_NAME_PREFIX + "%");
            return databaseMetaData.getTables(null, null, string, stringArray);
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal SQL error in driver", sQLException);
        }
    }

    public void clearSequences() {
    }

    public void removeSequence(String string) {
        if (this.sequenceExists(string)) {
            try {
                this.m_sql.runSQLGroup("DropSequence", string);
            }
            catch (Exception exception) {
                logger.warn("Unable to drop sequence " + string, exception);
            }
        }
    }

    public boolean sequenceExists(String string) {
        Object[] objectArray = new Object[]{string};
        ResultSet resultSet = null;
        boolean bl = false;
        try {
            String string2 = "SelectSequenceName";
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string2);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            bl = resultSet.next();
            this.m_sql.returnPreparedSQLStatement(preparedStatement, string2);
        }
        catch (Exception exception) {
            logger.error("Unable to select sequence " + string, exception);
        }
        return bl;
    }

    public List getSequences() {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        Object[] objectArray = new Object[]{};
        Object var3_3 = null;
        try {
            String string = "SelectJenaSequences";
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string, this.TABLE_NAME_PREFIX);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            this.m_sql.returnPreparedSQLStatement(preparedStatement, string);
        }
        catch (Exception exception) {
            logger.error("Unable to select Jena sequences: ", exception);
        }
        return arrayList;
    }

    public void formatDB() throws RDFRDBException {
    }

    public String createTable(int n, boolean bl) {
        String[] stringArray;
        String string = bl ? "createReifStatementTable" : "createStatementTable";
        int n2 = 0;
        while (true) {
            stringArray = this.getCreateTableParams(n, bl);
            try {
                this.m_sql.runSQLGroup(string, stringArray);
            }
            catch (SQLException sQLException) {
                if (++n2 <= 5) continue;
                logger.warn("Problem creating table", sQLException);
                throw new RDFRDBException("Failed to create table: " + stringArray[0], sQLException);
            }
            break;
        }
        return stringArray[0];
    }

    public void deleteTable(String string) {
        String string2 = "dropTable";
        try {
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string2, string);
            preparedStatement.executeUpdate();
            return;
        }
        catch (Exception exception) {
            throw new RDFRDBException("Failed to delete table ", exception);
        }
    }

    private void notSupported(String string) {
        throw new UnsupportedOperationException(string);
    }

    public synchronized void abort() throws RDFRDBException {
        if (this.transactionsSupported()) {
            try {
                if (this.inTransaction) {
                    Connection connection = this.m_sql.getConnection();
                    connection.rollback();
                    connection.commit();
                    connection.setAutoCommit(true);
                    this.inTransaction = false;
                }
            }
            catch (SQLException sQLException) {
                throw new JenaException("Transaction support failed: ", sQLException);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void begin() throws RDFRDBException {
        if (this.transactionsSupported()) {
            try {
                if (this.inTransaction) return;
                Connection connection = this.m_sql.getConnection();
                connection.setTransactionIsolation(2);
                connection.setAutoCommit(false);
                this.inTransaction = true;
                return;
            }
            catch (SQLException sQLException) {
                throw new RDFRDBException("Transaction support failed: ", sQLException);
            }
        } else {
            this.notSupported("begin transaction");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commit() throws RDFRDBException {
        if (this.transactionsSupported()) {
            try {
                if (!this.inTransaction) return;
                Connection connection = this.m_sql.getConnection();
                connection.commit();
                connection.setAutoCommit(true);
                this.inTransaction = false;
                return;
            }
            catch (SQLException sQLException) {
                throw new RDFRDBException("Transaction support failed: ", sQLException);
            }
        } else {
            this.notSupported("commit transaction");
        }
    }

    public String getDatabaseType() {
        return this.DATABASE_TYPE;
    }

    public boolean transactionsSupported() {
        if (this.m_transactionsSupported != null) {
            return this.m_transactionsSupported;
        }
        if (this.m_dbcon != null) {
            try {
                Connection connection = this.m_sql.getConnection();
                if (connection != null) {
                    this.m_transactionsSupported = new Boolean(connection.getMetaData().supportsMultipleTransactions());
                    return this.m_transactionsSupported;
                }
            }
            catch (SQLException sQLException) {
                logger.error("SQL Exception caught ", sQLException);
            }
        }
        return false;
    }

    public void close() throws RDFRDBException {
    }

    public boolean supportsMultipleModels() {
        return true;
    }

    public boolean supportsJenaReification() {
        return false;
    }

    public String nodeToRDBString(Node node, boolean bl) throws RDFRDBException {
        String string = null;
        if (node.isURI()) {
            String string2;
            String string3;
            String string4 = new String(((Node_URI)node).getURI());
            if (string4.startsWith(RDBCodeURI)) {
                throw new RDFRDBException("URI Node looks like a blank node: " + string4);
            }
            int n = 0;
            boolean bl2 = this.URI_COMPRESS ? (n = DriverRDB.dbSplitNamespace(string4)) == string4.length() || n <= this.URI_COMPRESS_LENGTH : true;
            if (bl2) {
                string3 = RDBCodeDelim + RDBCodeDelim;
                string2 = string4;
            } else {
                DBIDInt dBIDInt = this.URItoPrefix(string4, n, bl);
                if (dBIDInt == null) {
                    return string;
                }
                string3 = RDBCodeDelim + dBIDInt.getIntID() + RDBCodeDelim;
                string2 = string4.substring(n);
            }
            int n2 = RDBCodeURI.length() + 1 + string3.length() + this.EOS_LEN;
            boolean bl3 = this.objectIsLong(n2, string2);
            if (bl3) {
                DBIDInt dBIDInt = this.getURIID(string2, bl);
                if (dBIDInt == null) {
                    return string;
                }
                int n4 = dBIDInt.getIntID();
                string = new String(RDBCodeURI + RDBCodeRef + string3 + n4);
            } else {
                string = RDBCodeURI + RDBCodeValue + string3 + string2 + this.EOS;
            }
        } else if (node.isLiteral()) {
            Node_Literal node_Literal = (Node_Literal)node;
            LiteralLabel literalLabel = node_Literal.getLiteral();
            String string5 = literalLabel.getLexicalForm();
            String string6 = literalLabel.language();
            String string7 = literalLabel.getDatatypeURI();
            String string8 = this.litLangTypeToRDBString(string6, string7);
            int n = RDBCodeLiteral.length() + 2 + string8.length() + this.EOS_LEN;
            boolean bl4 = this.objectIsLong(n, string5);
            if (bl4) {
                DBIDInt dBIDInt = this.getLiteralID(node_Literal, bl);
                if (dBIDInt == null) {
                    return string;
                }
                int n5 = dBIDInt.getIntID();
                string = new String(RDBCodeLiteral + RDBCodeRef + RDBCodeDelim + n5);
            } else {
                string = new String(RDBCodeLiteral + RDBCodeValue + RDBCodeDelim + string8 + string5 + this.EOS);
            }
        } else if (node.isBlank()) {
            String string9 = node.getBlankNodeId().toString();
            String string10 = "::";
            int n = RDBCodeBlank.length() + 1 + string10.length() + this.EOS_LEN;
            boolean bl5 = this.objectIsLong(n, string9);
            if (bl5) {
                DBIDInt dBIDInt = this.getBlankID(string9, bl);
                if (dBIDInt == null) {
                    return string;
                }
                int n6 = dBIDInt.getIntID();
                string = new String(RDBCodeBlank + RDBCodeRef + string10 + n6);
            } else {
                string = new String(RDBCodeBlank + RDBCodeValue + string10 + string9 + this.EOS);
            }
        } else if (node.isVariable()) {
            String string11 = ((Node_Variable)node).getName();
            int n = string11.length();
            if (n + 3 + this.EOS_LEN > this.LONG_OBJECT_LENGTH) {
                throw new JenaException("Variable name too long: " + string11);
            }
            string = RDBCodeVariable + RDBCodeValue + RDBCodeDelim + string11 + this.EOS;
        } else if (node.equals(Node.ANY)) {
            string = RDBCodeANY + RDBCodeValue + RDBCodeDelim;
        } else {
            throw new RDFRDBException("Expected Concrete Node, got " + node.toString());
        }
        return string;
    }

    public Node RDBStringToNode(String string) throws RDFRDBException {
        Node node = null;
        int n = string.length();
        if (n < 3) {
            throw new RDFRDBException("Bad RDBString Header: " + string);
        }
        String string2 = string.substring(0, 1);
        String string3 = string.substring(1, 2);
        if (!string3.equals(RDBCodeRef) && !string3.equals(RDBCodeValue) || string.charAt(2) != RDBCodeDelimChar) {
            throw new RDFRDBException("Bad RDBString Header: " + string);
        }
        int n2 = 3;
        if (string2.equals(RDBCodeURI)) {
            String string4;
            ParseInt parseInt = new ParseInt(n2);
            String string5 = "";
            this.RDBStringParseInt(string, parseInt, false);
            if (parseInt.val != null) {
                if (!this.URI_COMPRESS) {
                    throw new RDFRDBException("Bad URI: Prefix Compression Disabled: " + string);
                }
                string5 = this.IDtoPrefix(parseInt.val);
                if (string5 == null) {
                    throw new RDFRDBException("Bad URI Prefix: " + string);
                }
            }
            n2 = parseInt.pos + 1;
            if (string3.equals(RDBCodeRef)) {
                string4 = this.IDtoURI(string.substring(n2));
                if (string4 == null) {
                    throw new RDFRDBException("Bad URI: " + string);
                }
            } else {
                string4 = string.substring(n2, n - this.EOS_LEN);
            }
            node = Node.createURI(string5 + string4);
        } else if (string2.equals(RDBCodeLiteral)) {
            LiteralLabel literalLabel;
            ParseInt parseInt = new ParseInt(n2);
            String string6 = null;
            if (string3.equals(RDBCodeRef)) {
                this.RDBStringParseInt(string, parseInt, true);
                if (parseInt.val != null) {
                    string6 = this.IDtoLiteral(parseInt.val);
                }
                if (string6 == null) {
                    throw new RDFRDBException("Bad Literal Reference: " + string);
                }
            } else {
                string6 = string.substring(n2, n - this.EOS_LEN);
            }
            n = string6.length();
            int n4 = 0;
            int n5 = 0;
            parseInt.pos = 0;
            this.RDBStringParseInt(string6, parseInt, false);
            n4 = parseInt.val == null ? 0 : parseInt.val;
            ++parseInt.pos;
            this.RDBStringParseInt(string6, parseInt, false);
            n5 = parseInt.val == null ? 0 : parseInt.val;
            n2 = parseInt.pos + 1;
            if (n2 + n4 + n5 > n) {
                throw new RDFRDBException("Malformed Literal: " + string6);
            }
            String string7 = string6.substring(n2, n2 + n4);
            String string8 = string6.substring(n2 += n4, n2 + n5);
            String string9 = string6.substring(n2 += n5);
            if (string8 == null || string8.equals("")) {
                literalLabel = new LiteralLabel(string9, string7 == null ? "" : string7);
            } else {
                RDFDatatype rDFDatatype = TypeMapper.getInstance().getSafeTypeByName(string8);
                literalLabel = new LiteralLabel(string9, string7 == null ? "" : string7, rDFDatatype);
            }
            node = Node.createLiteral(literalLabel);
        } else if (string2.equals(RDBCodeBlank)) {
            String string10 = null;
            if (string3.equals(RDBCodeValue)) {
                string10 = string.substring(4, n - this.EOS_LEN);
            } else {
                string10 = this.IDtoBlank(string.substring(4));
                if (string10 == null) {
                    throw new RDFRDBException("Bad URI: " + string);
                }
            }
            node = Node.createAnon(new AnonId(string10));
        } else if (string2.equals(RDBCodeVariable)) {
            String string11 = string.substring(3, n - this.EOS_LEN);
            node = Node.createVariable(string11);
        } else if (string2.equals(RDBCodeANY)) {
            node = Node.ANY;
        } else {
            throw new RDFRDBException("Invalid RDBString Prefix, " + string);
        }
        return node;
    }

    public static int dbSplitNamespace(String string) {
        int n;
        char c;
        int n2 = string.length();
        if (n2 == 0) {
            return 0;
        }
        for (int i = n2 - 1; i >= 1 && XMLChar.isNCName(c = string.charAt(i)); --i) {
        }
        for (n = i + 1; n < n2 && (!XMLChar.isNCNameStart(c = string.charAt(n)) || string.charAt(n - 1) == ':' && string.lastIndexOf(58, n - 2) == -1); ++n) {
        }
        return n;
    }

    protected void RDBStringParseInt(String string, ParseInt parseInt, boolean bl) {
        int n;
        int n2 = n = bl ? string.length() : string.indexOf(RDBCodeDelimChar, parseInt.pos);
        if (n < 0) {
            throw new RDFRDBException("Bad RDB String: " + string);
        }
        String string2 = string.substring(parseInt.pos, n);
        parseInt.pos = n;
        if (string2.equals("")) {
            parseInt.val = null;
        } else {
            try {
                parseInt.val = new Integer(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RDFRDBException("Bad RDB String: " + string);
            }
        }
    }

    DBIDInt URItoPrefix(String string, int n, boolean bl) {
        DBIDInt dBIDInt;
        Object object = this.prefixCache.getByValue(string.substring(0, n));
        if (object == null) {
            RDBLongObject rDBLongObject = this.PrefixToLongObject(string, n);
            dBIDInt = this.getLongObjectID(rDBLongObject, this.PREFIX_TABLE, bl);
            if (dBIDInt != null) {
                this.prefixCache.put(dBIDInt, string.substring(0, n));
            }
        } else {
            dBIDInt = (DBIDInt)object;
        }
        return dBIDInt;
    }

    protected RDBLongObject PrefixToLongObject(String string, int n) {
        RDBLongObject rDBLongObject = new RDBLongObject();
        rDBLongObject.head = RDBCodePrefix + RDBCodeValue + RDBCodeDelim;
        int n2 = rDBLongObject.head.length();
        int n4 = this.INDEX_KEY_LENGTH - (n2 + this.EOS_LEN);
        if (n > n4) {
            rDBLongObject.head = rDBLongObject.head + string.substring(0, n4);
            rDBLongObject.tail = string.substring(n4, n);
            rDBLongObject.hash = this.stringToHash(rDBLongObject.tail);
        } else {
            rDBLongObject.head = rDBLongObject.head + string.substring(0, n);
            rDBLongObject.tail = "";
        }
        rDBLongObject.head = rDBLongObject.head + this.EOS;
        return rDBLongObject;
    }

    public String litLangTypeToRDBString(String string, String string2) throws RDFRDBException {
        String string3 = RDBCodeDelim;
        string3 = (string == null ? "" : Integer.toString(string.length())) + RDBCodeDelim;
        string3 = string3 + (string2 == null ? "" : Integer.toString(string2.length())) + RDBCodeDelim;
        string3 = string3 + (string == null ? "" : string) + (string2 == null ? "" : string2);
        return string3;
    }

    protected boolean objectIsLong(int n, String string) {
        return n + string.length() > this.LONG_OBJECT_LENGTH;
    }

    protected RDBLongObject literalToLongObject(Node_Literal node_Literal) {
        RDBLongObject rDBLongObject = new RDBLongObject();
        LiteralLabel literalLabel = node_Literal.getLiteral();
        String string = literalLabel.language();
        String string2 = literalLabel.getDatatypeURI();
        String string3 = literalLabel.getLexicalForm();
        String string4 = this.litLangTypeToRDBString(string, string2);
        rDBLongObject.head = RDBCodeLiteral + RDBCodeValue + RDBCodeDelim + string4;
        int n = rDBLongObject.head.length();
        int n2 = this.INDEX_KEY_LENGTH - (n + this.EOS_LEN);
        if (string3.length() > n2) {
            rDBLongObject.head = rDBLongObject.head + string3.substring(0, n2);
            rDBLongObject.tail = string3.substring(n2);
            rDBLongObject.hash = this.stringToHash(rDBLongObject.tail);
        } else {
            rDBLongObject.head = rDBLongObject.head + string3;
            rDBLongObject.tail = "";
        }
        rDBLongObject.head = rDBLongObject.head + this.EOS;
        return rDBLongObject;
    }

    protected long stringToHash(String string) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(string.getBytes());
        return cRC32.getValue();
    }

    public DBIDInt getBlankID(String string, boolean bl) throws RDFRDBException {
        RDBLongObject rDBLongObject = this.URIToLongObject(string, RDBCodeBlank);
        return this.getLongObjectID(rDBLongObject, this.LONG_URI_TABLE, bl);
    }

    public DBIDInt getURIID(String string, boolean bl) throws RDFRDBException {
        RDBLongObject rDBLongObject = this.URIToLongObject(string, RDBCodeURI);
        return this.getLongObjectID(rDBLongObject, this.LONG_URI_TABLE, bl);
    }

    protected RDBLongObject URIToLongObject(String string, String string2) {
        RDBLongObject rDBLongObject = new RDBLongObject();
        rDBLongObject.head = string2 + RDBCodeValue + RDBCodeDelim;
        int n = rDBLongObject.head.length();
        int n2 = this.INDEX_KEY_LENGTH - (n + this.EOS_LEN);
        if (string.length() > n2) {
            rDBLongObject.head = rDBLongObject.head + string.substring(0, n2);
            rDBLongObject.tail = string.substring(n2);
            rDBLongObject.hash = this.stringToHash(rDBLongObject.tail);
        } else {
            rDBLongObject.head = rDBLongObject.head + string;
            rDBLongObject.tail = "";
        }
        rDBLongObject.head = rDBLongObject.head + this.EOS;
        return rDBLongObject;
    }

    public DBIDInt getLiteralID(Node_Literal node_Literal, boolean bl) throws RDFRDBException {
        RDBLongObject rDBLongObject = this.literalToLongObject(node_Literal);
        return this.getLongObjectID(rDBLongObject, this.LONG_LIT_TABLE, bl);
    }

    public DBIDInt getLongObjectID(RDBLongObject rDBLongObject, String string, boolean bl) throws RDFRDBException {
        try {
            String string2 = "getLongObjectID";
            if (rDBLongObject.tail.length() > 0) {
                string2 = string2 + "withChkSum";
            }
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string2, string);
            preparedStatement.setString(1, rDBLongObject.head);
            if (rDBLongObject.tail.length() > 0) {
                preparedStatement.setLong(2, rDBLongObject.hash);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            DBIDInt dBIDInt = null;
            if (resultSet.next()) {
                dBIDInt = this.wrapDBID(resultSet.getObject(1));
            } else if (bl) {
                dBIDInt = this.addRDBLongObject(rDBLongObject, string);
            }
            this.m_sql.returnPreparedSQLStatement(preparedStatement, string2);
            return dBIDInt;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to find literal", sQLException);
        }
    }

    public DBIDInt addRDBLongObject(RDBLongObject rDBLongObject, String string) throws RDFRDBException {
        try {
            int n = 1;
            String string2 = "insertLongObject";
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string2, string);
            int n2 = 0;
            if (this.PRE_ALLOCATE_ID) {
                n2 = this.getInsertID(string);
                preparedStatement.setInt(n++, n2);
            }
            preparedStatement.setString(n++, rDBLongObject.head);
            if (rDBLongObject.tail.length() > 0) {
                preparedStatement.setLong(n++, rDBLongObject.hash);
                preparedStatement.setString(n++, rDBLongObject.tail);
            } else {
                preparedStatement.setNull(n++, -5);
                preparedStatement.setNull(n++, 12);
            }
            preparedStatement.executeUpdate();
            if (!this.PRE_ALLOCATE_ID) {
                n2 = this.getInsertID(string);
            }
            return this.wrapDBID(new Integer(n2));
        }
        catch (Exception exception) {
            System.out.println("Problem on long object (l=" + rDBLongObject.head + ") " + exception);
            throw new RDFRDBException("Failed to add long object ", exception);
        }
    }

    protected String IDtoPrefix(int n) {
        DBIDInt dBIDInt = new DBIDInt(n);
        Object object = this.prefixCache.get(dBIDInt);
        if (object != null) {
            return (String)object;
        }
        return this.IDtoString(n, this.PREFIX_TABLE, RDBCodePrefix);
    }

    protected String IDtoBlank(String string) {
        return this.IDtoString(string, this.LONG_URI_TABLE, RDBCodeBlank);
    }

    protected String IDtoURI(String string) {
        return this.IDtoString(string, this.LONG_URI_TABLE, RDBCodeURI);
    }

    protected String IDtoLiteral(int n) {
        return this.IDtoString(n, this.LONG_LIT_TABLE, RDBCodeLiteral);
    }

    protected String IDtoString(String string, String string2, String string3) {
        int n;
        Object var5_4 = null;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RDFRDBException("Invalid Object ID: " + string);
        }
        return this.IDtoString(n, string2, string3);
    }

    protected String IDtoString(int n, String string, String string2) {
        String string3 = null;
        RDBLongObject rDBLongObject = this.IDtoLongObject(n, string);
        if (rDBLongObject == null) {
            throw new RDFRDBException("Invalid Object ID: " + n);
        }
        if (!rDBLongObject.head.substring(0, 3).equals(string2 + RDBCodeValue + RDBCodeDelim)) {
            throw new RDFRDBException("Malformed URI in Database: " + rDBLongObject.head);
        }
        string3 = rDBLongObject.head.substring(3, rDBLongObject.head.length() - this.EOS_LEN);
        if (rDBLongObject.tail != null) {
            string3 = string3 + rDBLongObject.tail;
        }
        return string3;
    }

    protected RDBLongObject IDtoLongObject(int n, String string) {
        RDBLongObject rDBLongObject = null;
        try {
            String string2 = "getLongObject";
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string2, string);
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                rDBLongObject = new RDBLongObject();
                rDBLongObject.head = resultSet.getString(1);
                rDBLongObject.tail = resultSet.getString(2);
            }
            this.m_sql.returnPreparedSQLStatement(preparedStatement, string2);
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to find literal", sQLException);
        }
        return rDBLongObject;
    }

    protected RDBLongObject IDtoLongObject(String string, String string2) {
        int n;
        Object var3_3 = null;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RDFRDBException("Invalid Object ID: " + string);
        }
        return this.IDtoLongObject(n, string2);
    }

    public DBIDInt wrapDBID(Object object) throws RDFRDBException {
        if (object instanceof Number) {
            return new DBIDInt(((Number)object).intValue());
        }
        if (object == null) {
            return null;
        }
        throw new RDFRDBException("Unexpected DB identifier type: " + object);
    }

    public String genSQLReifQualStmt() {
        return "stmt = ?";
    }

    public String genSQLReifQualAnyObj(boolean bl) {
        return "( subj = ? OR prop = ? OR obj = ?" + (bl ? " OR hasType = " + this.QUOTE_CHAR + "T" + this.QUOTE_CHAR + " )" : " )");
    }

    public String genSQLReifQualObj(char c, boolean bl) {
        String string = "";
        if (c == 'T') {
            string = "hasType = " + this.QUOTE_CHAR + "T" + this.QUOTE_CHAR;
        } else {
            String string2 = bl ? " = ?" : " is not null";
            String string3 = null;
            if (c == 'S') {
                string3 = "subj";
            } else if (c == 'P') {
                string3 = "prop";
            } else if (c == 'O') {
                string3 = "obj";
            } else {
                throw new JenaException("Undefined reification property");
            }
            string = string3 + string2;
        }
        return string;
    }

    protected String colidToColname(char c) {
        if (c == 'G') {
            return "GraphID";
        }
        if (c == 'P') {
            return "Prop";
        }
        if (c == 'S') {
            return "Subj";
        }
        if (c == 'O') {
            return "Obj";
        }
        if (c == 'N') {
            return "Stmt";
        }
        if (c == 'T') {
            return "HasType";
        }
        throw new JenaException("Invalid column identifer: '" + c + "'");
    }

    protected String aliasToString(int n) {
        return "A" + n;
    }

    protected String colAliasToString(int n, char c) {
        return this.aliasToString(n) + "." + this.colidToColname(c);
    }

    public String genSQLQualConst(int n, char c, Node node) {
        String string = this.nodeToRDBString(node, false);
        if (string == "") {
            string = RDBCodeInvalid;
        }
        return this.colAliasToString(n, c) + "=" + this.QUOTE_CHAR + string + this.QUOTE_CHAR;
    }

    public String genSQLQualParam(int n, char c) {
        return this.colAliasToString(n, c) + "=?";
    }

    public String genSQLQualGraphId(int n, int n2) {
        return this.colAliasToString(n, 'G') + "=" + n2;
    }

    public String genSQLJoin(int n, char c, int n2, char c2) {
        return this.colAliasToString(n, c) + "=" + this.colAliasToString(n2, c2);
    }

    public String genSQLResList(int[] nArray, VarIndex[] varIndexArray) {
        String string = "";
        int n = 0;
        for (int i = 0; i < varIndexArray.length; ++i) {
            VarIndex varIndex = varIndexArray[i];
            if (varIndex.isArgVar()) continue;
            string = string + (n > 0 ? ", " : "") + this.colAliasToString(varIndex.alias, varIndex.column);
            if (n >= nArray.length) {
                throw new JenaException("Too many result columns");
            }
            nArray[n++] = varIndex.mapIx;
        }
        return string;
    }

    public String genSQLFromList(int n, String string) {
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            string2 = string2 + (i > 0 ? ", " : "") + string + " " + this.aliasToString(i);
        }
        return string2;
    }

    public String genSQLSelectKW() {
        return "Select ";
    }

    public String genSQLFromKW() {
        return "From ";
    }

    public String genSQLWhereKW() {
        return "Where ";
    }

    public String genSQLSelectStmt(String string, String string2, String string3) {
        return this.genSQLSelectKW() + string + " " + this.genSQLFromKW() + string2 + " " + (string3.length() == 0 ? string3 : this.genSQLWhereKW()) + string3;
    }

    protected int getTableCount(int n) {
        try {
            DatabaseMetaData databaseMetaData = this.m_dbcon.getConnection().getMetaData();
            String[] stringArray = new String[]{"TABLE"};
            int n2 = 0;
            String string = this.TABLE_NAME_PREFIX + "g" + Integer.toString(n) + "%";
            string = this.stringToDBname(string);
            ResultSet resultSet = databaseMetaData.getTables(null, null, string, stringArray);
            while (resultSet.next()) {
                ++n2;
            }
            resultSet.close();
            return n2;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal SQL error in driver", sQLException);
        }
    }

    public int getLongObjectLength() {
        return this.LONG_OBJECT_LENGTH;
    }

    public void setLongObjectLength(int n) {
        this.checkDbUninitialized();
        if (n > this.LONG_OBJECT_LENGTH_MAX) {
            throw new JenaException("IndexKeyLength exceeds maximum value for database");
        }
        this.LONG_OBJECT_LENGTH = n;
    }

    public int getIndexKeyLength() {
        return this.INDEX_KEY_LENGTH;
    }

    public void setIndexKeyLength(int n) {
        this.checkDbUninitialized();
        if (n > this.INDEX_KEY_LENGTH_MAX) {
            throw new JenaException("IndexKeyLength exceeds maximum value for database");
        }
        this.INDEX_KEY_LENGTH = n;
    }

    public boolean getIsTransactionDb() {
        return this.IS_XACT_DB;
    }

    public void setIsTransactionDb(boolean bl) {
        this.checkDbUninitialized();
        if (!bl) {
            throw new JenaException("setIsTransactionDb unsupported for this database engine");
        }
    }

    public boolean getDoCompressURI() {
        return this.URI_COMPRESS;
    }

    public void setDoCompressURI(boolean bl) {
        this.checkDbUninitialized();
        this.URI_COMPRESS = bl;
    }

    public int getCompressURILength() {
        return this.URI_COMPRESS_LENGTH;
    }

    public void setCompressURILength(int n) {
        this.checkDbUninitialized();
        this.URI_COMPRESS_LENGTH = n;
    }

    public boolean getDoDuplicateCheck() {
        return !this.SKIP_DUPLICATE_CHECK;
    }

    public void setDoDuplicateCheck(boolean bl) {
        this.SKIP_DUPLICATE_CHECK = !bl;
    }

    protected boolean dbIsOpen() {
        return this.m_sysProperties != null;
    }

    protected void checkDbIsOpen() {
        if (!this.dbIsOpen()) {
            throw new JenaException("Database not open");
        }
    }

    protected void checkDbUninitialized() {
        if (this.dbIsOpen() || this.isDBFormatOK()) {
            throw new JenaException("Database configuration option cannot be set after database is formatted");
        }
    }

    public String getTableNamePrefix() {
        return this.TABLE_NAME_PREFIX;
    }

    public void setTableNamePrefix(String string) {
        if (string.length() + this.JENA_LONGEST_TABLE_NAME_LENGTH > this.TABLE_NAME_LENGTH_MAX) {
            throw new JenaException("TableNamePrefix exceeds maximum length for database: " + this.TABLE_NAME_LENGTH_MAX);
        }
        if (this.dbIsOpen()) {
            throw new JenaException("Table name prefix must be set before opening or connecting to a model.");
        }
        this.setTableNames(string);
    }

    private void setTableNames(String string) {
        this.TABLE_NAME_PREFIX = this.stringToDBname(string);
        this.SYSTEM_STMT_TABLE = this.TABLE_NAME_PREFIX + "sys_stmt";
        this.LONG_LIT_TABLE = this.TABLE_NAME_PREFIX + "long_lit";
        this.LONG_URI_TABLE = this.TABLE_NAME_PREFIX + "long_uri";
        this.PREFIX_TABLE = this.TABLE_NAME_PREFIX + "prefix";
        this.GRAPH_TABLE = this.TABLE_NAME_PREFIX + "graph";
    }

    public String getStoreWithModel() {
        return this.STORE_WITH_MODEL;
    }

    public void setStoreWithModel(String string) {
        String string2 = null;
        if (string != null && !string.equals("")) {
            string2 = string;
        }
        this.STORE_WITH_MODEL = string2;
    }

    public int getCompressCacheSize() {
        this.checkDbIsOpen();
        return this.prefixCache.getLimit();
    }

    public void setCompressCacheSize(int n) {
        this.checkDbIsOpen();
        this.prefixCache.setLimit(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class RDBLongObject {
        String head;
        long hash;
        String tail;

        RDBLongObject() {
        }
    }

    class ParseInt {
        int pos;
        Integer val;

        ParseInt(int n) {
            this.pos = n;
        }
    }
}

