/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ConcurrentReaderHashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    protected final BarrierLock barrierLock = new BarrierLock();
    protected transient Object lastWrite;
    public static int DEFAULT_INITIAL_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected transient Entry[] table;
    protected transient int count;
    protected int threshold;
    protected float loadFactor;
    protected transient Set keySet = null;
    protected transient Set entrySet = null;
    protected transient Collection values = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void recordModification(Object object) {
        BarrierLock barrierLock = this.barrierLock;
        synchronized (barrierLock) {
            this.lastWrite = object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Entry[] getTableForReading() {
        BarrierLock barrierLock = this.barrierLock;
        synchronized (barrierLock) {
            return this.table;
        }
    }

    private int p2capacity(int n) {
        int n2;
        int n4 = n;
        if (n4 > 0x40000000 || n4 < 0) {
            n2 = 0x40000000;
        } else {
            n2 = 4;
            while (n2 < n4) {
                n2 <<= 1;
            }
        }
        return n2;
    }

    private static int hash(Object object) {
        int n = object.hashCode();
        return (n << 7) - n + (n >>> 9) + (n >>> 17);
    }

    protected boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    public ConcurrentReaderHashMap(int n, float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load factor: " + f);
        }
        this.loadFactor = f;
        int n2 = this.p2capacity(n);
        this.table = new Entry[n2];
        this.threshold = (int)((float)n2 * f);
    }

    public ConcurrentReaderHashMap(int n) {
        this(n, 0.75f);
    }

    public ConcurrentReaderHashMap() {
        this(DEFAULT_INITIAL_CAPACITY, 0.75f);
    }

    public ConcurrentReaderHashMap(Map map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(map);
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        Entry entry;
        int n = ConcurrentReaderHashMap.hash(object);
        Entry[] entryArray = this.table;
        int n2 = n & entryArray.length - 1;
        Entry entry2 = entry = entryArray[n2];
        while (true) {
            Object object2;
            if (entry2 == null) {
                object2 = this.getTableForReading();
                if (entryArray == object2 && entry == entryArray[n2]) {
                    return null;
                }
                entryArray = object2;
                n2 = n & entryArray.length - 1;
                entry2 = entry = entryArray[n2];
                continue;
            }
            if (entry2.hash == n && this.eq(object, entry2.key)) {
                object2 = entry2.value;
                if (object2 != null) {
                    return object2;
                }
                ConcurrentReaderHashMap concurrentReaderHashMap = this;
                synchronized (concurrentReaderHashMap) {
                    entryArray = this.table;
                }
                n2 = n & entryArray.length - 1;
                entry2 = entry = entryArray[n2];
                continue;
            }
            entry2 = entry2.next;
        }
    }

    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        Entry entry;
        if (object2 == null) {
            throw new NullPointerException();
        }
        int n = ConcurrentReaderHashMap.hash(object);
        Entry[] entryArray = this.table;
        int n2 = n & entryArray.length - 1;
        Entry entry2 = entry = entryArray[n2];
        while (entry2 != null) {
            if (entry2.hash == n && this.eq(object, entry2.key)) break;
            entry2 = entry2.next;
        }
        ConcurrentReaderHashMap concurrentReaderHashMap = this;
        synchronized (concurrentReaderHashMap) {
            if (entryArray == this.table) {
                if (entry2 == null) {
                    if (entry == entryArray[n2]) {
                        Entry entry3;
                        entryArray[n2] = entry3 = new Entry(n, object, object2, entry);
                        if (++this.count >= this.threshold) {
                            this.rehash();
                        } else {
                            this.recordModification(entry3);
                        }
                        return null;
                    }
                } else {
                    Object object3 = entry2.value;
                    if (entry == entryArray[n2] && object3 != null) {
                        entry2.value = object2;
                        return object3;
                    }
                }
            }
            return this.sput(object, object2, n);
        }
    }

    protected Object sput(Object object, Object object2, int n) {
        Entry entry;
        Entry[] entryArray = this.table;
        int n2 = n & entryArray.length - 1;
        Entry entry2 = entry = entryArray[n2];
        while (true) {
            if (entry2 == null) {
                Entry entry3;
                entryArray[n2] = entry3 = new Entry(n, object, object2, entry);
                if (++this.count >= this.threshold) {
                    this.rehash();
                } else {
                    this.recordModification(entry3);
                }
                return null;
            }
            if (entry2.hash == n && this.eq(object, entry2.key)) {
                Object object3 = entry2.value;
                entry2.value = object2;
                return object3;
            }
            entry2 = entry2.next;
        }
    }

    protected void rehash() {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        if (n >= 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        int n2 = n << 1;
        int n4 = n2 - 1;
        this.threshold = (int)((float)n2 * this.loadFactor);
        Entry[] entryArray2 = new Entry[n2];
        int n5 = 0;
        while (n5 < n) {
            Entry entry = entryArray[n5];
            if (entry != null) {
                int n6 = entry.hash & n4;
                Entry entry2 = entry.next;
                if (entry2 == null) {
                    entryArray2[n6] = entry;
                } else {
                    Entry entry3 = entry;
                    int n7 = n6;
                    Entry entry4 = entry2;
                    while (entry4 != null) {
                        int n8 = entry4.hash & n4;
                        if (n8 != n7) {
                            n7 = n8;
                            entry3 = entry4;
                        }
                        entry4 = entry4.next;
                    }
                    entryArray2[n7] = entry3;
                    Entry entry5 = entry;
                    while (entry5 != entry3) {
                        int n9 = entry5.hash & n4;
                        entryArray2[n9] = new Entry(entry5.hash, entry5.key, entry5.value, entryArray2[n9]);
                        entry5 = entry5.next;
                    }
                }
            }
            ++n5;
        }
        this.table = entryArray2;
        this.recordModification(entryArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object) {
        Entry entry;
        int n = ConcurrentReaderHashMap.hash(object);
        Entry[] entryArray = this.table;
        int n2 = n & entryArray.length - 1;
        Entry entry2 = entry = entryArray[n2];
        entry2 = entry;
        while (entry2 != null) {
            if (entry2.hash == n && this.eq(object, entry2.key)) break;
            entry2 = entry2.next;
        }
        ConcurrentReaderHashMap concurrentReaderHashMap = this;
        synchronized (concurrentReaderHashMap) {
            if (entryArray == this.table) {
                if (entry2 == null) {
                    if (entry == entryArray[n2]) {
                        return null;
                    }
                } else {
                    Object object2 = entry2.value;
                    if (entry == entryArray[n2] && object2 != null) {
                        entry2.value = null;
                        --this.count;
                        Entry entry3 = entry2.next;
                        Entry entry4 = entry;
                        while (entry4 != entry2) {
                            entry3 = new Entry(entry4.hash, entry4.key, entry4.value, entry3);
                            entry4 = entry4.next;
                        }
                        entryArray[n2] = entry3;
                        this.recordModification(entry3);
                        return object2;
                    }
                }
            }
            return this.sremove(object, n);
        }
    }

    protected Object sremove(Object object, int n) {
        Entry entry;
        Entry[] entryArray = this.table;
        int n2 = n & entryArray.length - 1;
        Entry entry2 = entry = entryArray[n2];
        while (entry2 != null) {
            if (entry2.hash == n && this.eq(object, entry2.key)) {
                Object object2 = entry2.value;
                entry2.value = null;
                --this.count;
                Entry entry3 = entry2.next;
                Entry entry4 = entry;
                while (entry4 != entry2) {
                    entry3 = new Entry(entry4.hash, entry4.key, entry4.value, entry3);
                    entry4 = entry4.next;
                }
                entryArray[n2] = entry3;
                this.recordModification(entry3);
                return object2;
            }
            entry2 = entry2.next;
        }
        return null;
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.getTableForReading();
        int n = 0;
        while (n < entryArray.length) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
            ++n;
        }
        return false;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void putAll(Map var1_1) {
        var2_2 = var1_1.size();
        if (var2_2 != 0) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            this.rehash();
lbl5:
            // 2 sources

            ** while (var2_2 >= this.threshold)
        }
lbl6:
        // 1 sources

        var3_3 = var1_1.entrySet().iterator();
        while (var3_3.hasNext()) {
            var4_4 = var3_3.next();
            var5_5 = var4_4.getKey();
            var6_6 = var4_4.getValue();
            this.put((Object)var5_5, (Object)var6_6);
        }
    }

    public synchronized void clear() {
        Entry[] entryArray = this.table;
        int n = 0;
        while (n < entryArray.length) {
            Entry entry = entryArray[n];
            while (entry != null) {
                entry.value = null;
                entry = entry.next;
            }
            entryArray[n] = null;
            ++n;
        }
        this.count = 0;
        this.recordModification(entryArray);
    }

    public synchronized Object clone() {
        try {
            ConcurrentReaderHashMap concurrentReaderHashMap = (ConcurrentReaderHashMap)super.clone();
            concurrentReaderHashMap.keySet = null;
            concurrentReaderHashMap.entrySet = null;
            concurrentReaderHashMap.values = null;
            Entry[] entryArray = this.table;
            Entry[] entryArray2 = concurrentReaderHashMap.table = new Entry[entryArray.length];
            int n = 0;
            while (n < entryArray.length) {
                Entry entry = null;
                Entry entry2 = entryArray[n];
                while (entry2 != null) {
                    entry = new Entry(entry2.hash, entry2.key, entry2.value, entry);
                    entry2 = entry2.next;
                }
                entryArray2[n] = entry;
                ++n;
            }
            return concurrentReaderHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Set keySet() {
        Set set = this.keySet;
        return set != null ? set : (this.keySet = new KeySet());
    }

    public Collection values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new Values());
    }

    public Set entrySet() {
        Set set = this.entrySet;
        return set != null ? set : (this.entrySet = new EntrySet());
    }

    protected synchronized boolean findAndRemoveEntry(Map.Entry entry) {
        Object k = entry.getKey();
        Object object = this.get(k);
        if (object != null && object.equals(entry.getValue())) {
            this.remove(k);
            return true;
        }
        return false;
    }

    public Enumeration keys() {
        return new KeyIterator();
    }

    public Enumeration elements() {
        return new ValueIterator();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.count);
        int n = this.table.length - 1;
        while (n >= 0) {
            Entry entry = this.table[n];
            while (entry != null) {
                objectOutputStream.writeObject(entry.key);
                objectOutputStream.writeObject(entry.value);
                entry = entry.next;
            }
            --n;
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.table = new Entry[n];
        int n2 = objectInputStream.readInt();
        int n4 = 0;
        while (n4 < n2) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            ++n4;
        }
    }

    public synchronized int capacity() {
        return this.table.length;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    protected class ValueIterator
    extends HashIterator {
        protected ValueIterator() {
        }

        protected Object returnValueOfNext() {
            return this.currentValue;
        }
    }

    protected class KeyIterator
    extends HashIterator {
        protected KeyIterator() {
        }

        protected Object returnValueOfNext() {
            return this.currentKey;
        }
    }

    protected class HashIterator
    implements Iterator,
    Enumeration {
        protected final Entry[] tab;
        protected int index;
        protected Entry entry = null;
        protected Object currentKey;
        protected Object currentValue;
        protected Entry lastReturned = null;

        protected HashIterator() {
            this.tab = ConcurrentReaderHashMap.this.getTableForReading();
            this.index = this.tab.length - 1;
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        public Object nextElement() {
            return this.next();
        }

        public boolean hasNext() {
            do {
                if (this.entry != null) {
                    Object object = this.entry.value;
                    if (object != null) {
                        this.currentKey = this.entry.key;
                        this.currentValue = object;
                        return true;
                    }
                    this.entry = this.entry.next;
                }
                while (this.entry == null && this.index >= 0) {
                    this.entry = this.tab[this.index--];
                }
            } while (this.entry != null);
            this.currentValue = null;
            this.currentKey = null;
            return false;
        }

        protected Object returnValueOfNext() {
            return this.entry;
        }

        public Object next() {
            if (this.currentKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object object = this.returnValueOfNext();
            this.lastReturned = this.entry;
            this.currentValue = null;
            this.currentKey = null;
            this.entry = this.entry.next;
            return object;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentReaderHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }

    protected static class Entry
    implements Map.Entry {
        protected final int hash;
        protected final Object key;
        protected final Entry next;
        protected volatile Object value;

        Entry(int n, Object object, Object object2, Entry entry) {
            this.hash = n;
            this.key = object;
            this.next = entry;
            this.value = object2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.key.equals(entry.getKey()) && this.value.equals(entry.getValue());
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new HashIterator();
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object object2 = ConcurrentReaderHashMap.this.get(entry.getKey());
            return object2 != null && object2.equals(entry.getValue());
        }

        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            return ConcurrentReaderHashMap.this.findAndRemoveEntry((Map.Entry)object);
        }

        public int size() {
            return ConcurrentReaderHashMap.this.size();
        }

        public void clear() {
            ConcurrentReaderHashMap.this.clear();
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        public Iterator iterator() {
            return new ValueIterator();
        }

        public int size() {
            return ConcurrentReaderHashMap.this.size();
        }

        public boolean contains(Object object) {
            return ConcurrentReaderHashMap.this.containsValue(object);
        }

        public void clear() {
            ConcurrentReaderHashMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return ConcurrentReaderHashMap.this.size();
        }

        public boolean contains(Object object) {
            return ConcurrentReaderHashMap.this.containsKey(object);
        }

        public boolean remove(Object object) {
            return ConcurrentReaderHashMap.this.remove(object) != null;
        }

        public void clear() {
            ConcurrentReaderHashMap.this.clear();
        }
    }

    protected static class BarrierLock
    implements Serializable {
        protected BarrierLock() {
        }
    }
}

